package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y41b.dao.ErroresDao;

import java.util.List;
import java.util.Properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

import com.ejie.y41b.model.Errores;
import com.ejie.y41b.utils.xlnets.Y41bUtils;

/**
 * ErroresServiceImpl  
 * 
 *  
 */

@Service(value = "erroresService")
public class ErroresServiceImpl implements ErroresService {

	@Autowired()
	private ErroresDao erroresDao;
	@Autowired()
	private Properties appConfiguration;

	/**
	 * Inserts a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Errores add(Errores errores) {
		return this.erroresDao.add(errores);
	}

	/**
	 * Updates a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Errores update(Errores errores) {
		return this.erroresDao.update(errores);
	}

	/**
	 * Finds a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	public Errores find(Errores errores) {
		return (Errores) this.erroresDao.find(errores);
	}

	/**
	 * Finds a List of rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Errores> findAll(Errores errores, Pagination pagination) {
		return (List<Errores>) this.erroresDao.findAll(errores, pagination);
	}

	/**
	 * Counts rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Long
	 */
	public Long findAllCount(Errores errores) {
		return this.erroresDao.findAllCount(errores);
	}

	/**
	 * Finds rows in the Errores table using like.
	 * 
	 * @param filterErrores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	public List<Errores> findAllLike(Errores filterErrores,
			Pagination pagination, Boolean startsWith) throws Exception {

		if (pagination.getSort() != null
				&& pagination.getSort().equals("tipomovimientos.sedesces")) {
			pagination.setSort("tipomovimientossedesces");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("tipomovimientos.sedesceu")) {
			pagination.setSort("tipomovimientossedesceu");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("sificherosipca")) {
			pagination.setSort("sificherosipca");
		}

		List<Errores> listaErrores = this.erroresDao.findAllLike(filterErrores,
				pagination, startsWith);
		Errores errores = null;
		StringBuffer ruta = new StringBuffer("");
		Y31JanoService service = null;
		Document documentItemSesion = Y41bUtils.getInstance()
				.getDocumentItemSesion(
						Boolean.parseBoolean((String) this.appConfiguration
								.get("xlnets.loginApp.isSimulated")));
		service = Y31JanoServiceAbstractFactory.getInstance();
		for (int i = 0; i < listaErrores.size(); i++) {
			errores = listaErrores.get(i);
			// fn77a101_01914_00011,csb192_01914_00011.xml
			ruta.delete(0, ruta.length());
			ruta.append(
					this.appConfiguration.get("PATH_FICHEROS_RECOGIDOS_SIPCA"))
					.append(errores.getSificherosipca());
			try {
				service.info(documentItemSesion, ruta.toString());
				listaErrores.get(i).setExisteFichero("1");
			} catch (Exception e) {
				listaErrores.get(i).setExisteFichero("0");
			}
		}
		return listaErrores;
	}

	/**
	 * Counts rows in the Errores table using like.
	 * 
	 * @param errores
	 *            Errores
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Errores errores, Boolean startsWith) {
		return this.erroresDao.findAllLikeCount(errores, startsWith);
	}

	/**
	 * Deletes a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Errores errores) {
		this.erroresDao.remove(errores);
	}

	/**
	 * Deletes multiple rows in the Errores table.
	 * 
	 * @param erroresList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Errores> erroresList) {
		for (Errores erroresAux : erroresList) {
			this.erroresDao.remove(erroresAux);
		}
	}

}
