package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Errores;

/**
 * ErroresService  
 * 
 *  
 */

public interface ErroresService {

	/**
	 * Inserts a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	Errores add(Errores errores);

	/**
	 * Updates a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	Errores update(Errores errores);

	/**
	 * Finds a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	Errores find(Errores errores);

	/**
	 * Finds a List of rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Errores> findAll(Errores errores, Pagination pagination);

	/**
	 * Counts rows in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return Long
	 */
	Long findAllCount(Errores errores);

	/**
	 * Finds rows in the Errores table using like.
	 * 
	 * @param errores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 * @throws Exception
	 */
	List<Errores> findAllLike(Errores errores, Pagination pagination,
			Boolean startsWith) throws Exception;

	/**
	 * Counts rows in the Errores table using like.
	 * 
	 * @param errores
	 *            Errores
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Errores errores, Boolean startsWith);

	/**
	 * Deletes a single row in the Errores table.
	 * 
	 * @param errores
	 *            Errores
	 * @return
	 */
	void remove(Errores errores);

	/**
	 * Deletes multiple rows in the Errores table.
	 * 
	 * @param erroresList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Errores> erroresList);

}
