/**
 * 
 */
package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EnviosPorRemesaDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.model.Remesa;

/**
 *  
 * 
 */
@Service(value = "enviosPorRemesaService")
public class EnviosPorRemesaServiceImpl implements EnviosPorRemesaService {

	@Autowired
	private EnviosPorRemesaDao enviosPorRemesaDao;

	@Autowired
	private RemesaDao remesaDao;

	/**
	 * Inserts a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public EnviosPorRemesa add(EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao.add(enviosPorRemesa);
	}

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public EnviosPorRemesa update(EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao.update(enviosPorRemesa);
	}

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public EnviosPorRemesa updateSitCorreos(EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao.updateSitCorreos(enviosPorRemesa);
	}

	/**
	 * Finds a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	@Override
	public EnviosPorRemesa findWithoutBlobByEhCodigo(
			EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao
				.findWithoutBlobByEhCodigo(enviosPorRemesa);
	}

	/**
	 * Finds a List of rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Override
	public List<EnviosPorRemesa> findAll(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination) {
		return this.enviosPorRemesaDao.findAll(enviosPorRemesa, pagination);
	}

	/**
	 * Counts rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return Long
	 */
	@Override
	public Long findAllCount(EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao.findAllCount(enviosPorRemesa);
	}

	/**
	 * Finds rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Override
	public List<EnviosPorRemesa> findAllLike(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination, Boolean startsWith) {
		return this.enviosPorRemesaDao.findAllLike(enviosPorRemesa, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Override
	public Long findAllLikeCount(EnviosPorRemesa enviosPorRemesa,
			Boolean startsWith) {
		return this.enviosPorRemesaDao.findAllLikeCount(enviosPorRemesa,
				startsWith);
	}

	/**
	 * Deletes a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EnviosPorRemesa enviosPorRemesa) {
		this.enviosPorRemesaDao.remove(enviosPorRemesa);
	}

	/**
	 * Deletes multiple rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesaList
	 *            List
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<EnviosPorRemesa> enviosPorRemesaList) {
		this.enviosPorRemesaDao.removeMultiple(enviosPorRemesaList);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public EnviosPorRemesa updateError(EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao.updateError(enviosPorRemesa);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public EnviosPorRemesa updateFechaActualizacionEnvioRemesa(
			EnviosPorRemesa enviosPorRemesa) {
		return this.enviosPorRemesaDao
				.updateFechaActualizacionEnvioRemesa(enviosPorRemesa);
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void cerrarRemesa(Remesa remesa) {
		this.remesaDao.cerrarRemesa(remesa);
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void updateFechaActualizacionRemesa(Remesa remesa) {
		this.remesaDao.updateFechaActualizacionRemesa(remesa);
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public Remesa updateEstadoRemesaTransaccional(Remesa remesa,
			String tipoError, boolean grabaDatosRemesaAA66) {
		if (grabaDatosRemesaAA66) {
			remesa.setRmestado(tipoError);
			return this.remesaDao.update(remesa);
		} else {
			return this.remesaDao.updateEstadoRemesaErronea(remesa, tipoError);
		}
	}

}
