/**
 * 
 */
package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.model.Remesa;

/**
 *  
 * 
 */
public interface EnviosPorRemesaService {

	/**
	 * Inserts a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	EnviosPorRemesa add(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	EnviosPorRemesa update(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Updates a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	EnviosPorRemesa updateSitCorreos(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Finds a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return EnviosPorRemesa
	 */
	EnviosPorRemesa findWithoutBlobByEhCodigo(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Finds a List of rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EnviosPorRemesa> findAll(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination);

	/**
	 * Counts rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return Long
	 */
	Long findAllCount(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Finds rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EnviosPorRemesa> findAllLike(EnviosPorRemesa enviosPorRemesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the EnviosPorRemesa table using like.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(EnviosPorRemesa enviosPorRemesa, Boolean startsWith);

	/**
	 * Deletes a single row in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesa
	 *            EnviosPorRemesa
	 * @return
	 */
	void remove(EnviosPorRemesa enviosPorRemesa);

	/**
	 * Deletes multiple rows in the EnviosPorRemesa table.
	 * 
	 * @param enviosPorRemesaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<EnviosPorRemesa> enviosPorRemesaList);

	EnviosPorRemesa updateError(EnviosPorRemesa envioPorRemesa);

	void cerrarRemesa(Remesa remesa);

	Remesa updateEstadoRemesaTransaccional(Remesa remesa, String tipoError,
			boolean grabaDatosRemesaAA66);

	public void updateFechaActualizacionRemesa(Remesa remesa);

	public EnviosPorRemesa updateFechaActualizacionEnvioRemesa(
			EnviosPorRemesa enviosPorRemesa);
}
