package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EnlacesDocumentoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.EnlacesDocumento;

/**
 * EnlacesDocumentoServiceImpl  
 * 
 *  
 */
@Service(value = "enlacesDocumentoService")
public class EnlacesDocumentoServiceImpl implements EnlacesDocumentoService {

	@Autowired
	private EnlacesDocumentoDao enlacesDocumentoDao;

	/**
	 * Inserts a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EnlacesDocumento add(EnlacesDocumento enlacesDocumento) {
		return this.enlacesDocumentoDao.add(enlacesDocumento);
	}

	/**
	 * Updates a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EnlacesDocumento update(EnlacesDocumento enlacesDocumento) {
		return this.enlacesDocumentoDao.update(enlacesDocumento);
	}

	/**
	 * Finds a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return EnlacesDocumento
	 */
	public EnlacesDocumento find(EnlacesDocumento enlacesDocumento) {
		return (EnlacesDocumento) this.enlacesDocumentoDao
				.find(enlacesDocumento);
	}

	/**
	 * Finds a List of rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EnlacesDocumento> findAll(EnlacesDocumento enlacesDocumento,
			Pagination pagination) {
		return (List<EnlacesDocumento>) this.enlacesDocumentoDao.findAll(
				enlacesDocumento, pagination);
	}

	/**
	 * Counts rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return Long
	 */
	public Long findAllCount(EnlacesDocumento enlacesDocumento) {
		return this.enlacesDocumentoDao.findAllCount(enlacesDocumento);
	}

	/**
	 * Finds rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EnlacesDocumento> findAllLike(
			EnlacesDocumento enlacesDocumento, Pagination pagination,
			Boolean startsWith) {
		return (List<EnlacesDocumento>) this.enlacesDocumentoDao.findAllLike(
				enlacesDocumento, pagination, startsWith);
	}

	/**
	 * Counts rows in the EnlacesDocumento table using like.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(EnlacesDocumento enlacesDocumento,
			Boolean startsWith) {
		return this.enlacesDocumentoDao.findAllLikeCount(enlacesDocumento,
				startsWith);
	}

	/**
	 * Deletes a single row in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumento
	 *            EnlacesDocumento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EnlacesDocumento enlacesDocumento) {
		this.enlacesDocumentoDao.remove(enlacesDocumento);
	}

	/**
	 * Deletes multiple rows in the EnlacesDocumento table.
	 * 
	 * @param enlacesDocumentoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<EnlacesDocumento> enlacesDocumentoList) {
		for (EnlacesDocumento enlacesDocumentoAux : enlacesDocumentoList) {
			this.enlacesDocumentoDao.remove(enlacesDocumentoAux);
		}
	}

}
