package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.PeseDao;
import com.ejie.y41b.dao.Peta1Dao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.LocalidaDao;
import com.ejie.y41b.dao.MunicipiDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Localida;
import com.ejie.y41b.model.Municipi;
import com.ejie.y41b.model.Pese;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Peta1;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * EmpperServiceImpl  
 * 
 *  
 */

@Service(value = "empperService")
public class EmpperServiceImpl implements EmpperService {

	@Autowired()
	private EmpperDao empperDao;
	@Autowired()
	private Peta1Dao peta1Dao;
	@Autowired()
	private PeseDao peseDao;
	@Autowired()
	private SolarbDao solArbDao;

	@Autowired()
	private LocalidaDao localidaDao;
	@Autowired()
	private MunicipiDao municipiDao;
	@Autowired()
	private T17ProvinciaDao provinciaDao;
	@Autowired()
	private T17CalleDao calleDao;

	/**
	 * Inserts a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Empper add(Empper empper) {
		this.empperDao.add(empper);
		this.tratarMn(empper);
		return empper;
	}

	/**
	 * Updates a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Empper update(Empper empper) {
		this.empperDao.update(empper);
		this.tratarMn(empper);
		return empper;
	}

	/**
	 * Finds a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Empper
	 */
	public Empper find(Empper empper) {
		Empper empperDetalle = this.empperDao.find(empper);

		if (Y41bUtils.isFilled(empperDetalle.getPecalleId())) {
			empperDetalle.setPecalle(this.calleDao.findCalleConTipoVia(
					new T17Calle(Long.parseLong(empperDetalle.getPecalleId()),
							null)).getDsO());
		}

		empperDetalle.setPedireccionNoCAPV(this
				.componerDireccionNoCAPV(empperDetalle));

		empperDetalle.setPedireccionAntigua(this
				.componerDireccionAntigua(empperDetalle));

		// Volcar en tablas temporales: sectores
		this.peseDao.volcarEmpperSectores(empper);

		return empperDetalle;
	}

	/**
	 * 
	 * @param empper
	 *            Empper
	 * @return String
	 */
	private String componerDireccionNoCAPV(Empper empper) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			if (!Y41bUtils.esNullOCadenaVacia(empper.getPeprovId())) {
				if (!Y41bConstantes.ARABA.equals(empper.getPeprovId())
						&& !Y41bConstantes.BIZKAIA.equals(empper.getPeprovId())
						&& !Y41bConstantes.GIPUZKOA
								.equals(empper.getPeprovId())) {
					if (empper.getPenodir() != null) {
						ardireccionNoCAPV.append(empper.getPenodir());
					}
				}
			}
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}

	/**
	 * 
	 * @param empper
	 *            Empper
	 * @return String
	 */
	private String componerDireccionAntigua(Empper empper) {
		StringBuffer ardireccionNoCAPV = new StringBuffer("");
		try {
			// if (Y41bUtils.esNullOCadenaVacia(empper.getPeprovId())) {
			if (empper.getPenodir() != null) {
				ardireccionNoCAPV.append(empper.getPenodir());
			}
			if (!Y41bUtils.esNullOCadenaVacia(empper.getPecolo())) {
				Localida localida = new Localida();
				localida.setLocodigo(empper.getPecolo());
				localida = this.localidaDao.find(localida);
				if (localida != null) {
					ardireccionNoCAPV.append(" ")
							.append(localida.getLonombre());
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocomu())) {
						Municipi municipi = new Municipi();
						municipi.setMucodigo(localida.getLocomu());
						municipi = this.municipiDao.find(municipi);
						if (municipi != null) {
							ardireccionNoCAPV.append(" ").append(
									municipi.getMunombre());
						}
					}
					if (!Y41bUtils.esNullOCadenaVacia(localida.getLocopv())) {
						T17Provincia provincia = new T17Provincia();
						provincia.setId(localida.getLocopv());
						provincia = this.provinciaDao.find(provincia);
						if (provincia != null) {
							ardireccionNoCAPV.append(" ").append(
									provincia.getDsO());
						}
					}
				}
			}
			// }
		} catch (Exception e) {

		}
		return ardireccionNoCAPV.toString();

	}

	/**
	 * 
	 * @param empper
	 *            Empper
	 */
	private void tratarMn(Empper empper) {
		// Territorios de actuacin: borramos por empper y aadimos la lista
		Peta1 peta1 = new Peta1();
		peta1.setEmpper(empper);
		this.peta1Dao.remove(peta1);
		if (!Y41bUtils.esNullOCadenaVacia(empper.getPeThActAraba())) {
			peta1.setM7cota1(empper.getPeThActAraba());
			peta1.setEmpper(empper);
			// Aadimos los territorios del empper
			this.peta1Dao.add(peta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(empper.getPeThActBizkaia())) {
			peta1.setM7cota1(empper.getPeThActBizkaia());
			peta1.setEmpper(empper);
			// Aadimos los territorios del empper
			this.peta1Dao.add(peta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(empper.getPeThActGipuzkoa())) {
			peta1.setM7cota1(empper.getPeThActGipuzkoa());
			peta1.setEmpper(empper);
			// Aadimos los territorios del empper
			this.peta1Dao.add(peta1);
		}
		// Sectores
		Pese pese = new Pese();
		pese.setEmpper(empper);
		// Borramos de pese por empper
		this.peseDao.removePese(pese);
		// Lista de la temporal
		List<Pese> peses = this.peseDao.findAll(pese, null);
		for (int i = 0; i < peses.size(); i++) {
			pese = peses.get(i);
			// Aadimos los sectores a pese
			this.peseDao.addPese(pese);
			// Eliminamos de la temporal
			this.peseDao.remove(pese);
		}

	}

	/**
	 * Finds a List of rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Empper> findAll(Empper empper, Pagination pagination) {
		if (pagination.getSort() != null
				&& pagination.getSort().equals("establecimiento.esnombre")) {
			pagination.setSort("EstablecimientoESNOMBRE");
		}
		return (List<Empper>) this.empperDao.findAll(empper, pagination);
	}

	/**
	 * Counts rows in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return Long
	 */
	public Long findAllCount(Empper empper) {
		return this.empperDao.findAllCount(empper);
	}

	/**
	 * Finds rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param pagination
	 *            Pagination
	 * @param stpetsWith
	 *            Boolean
	 * @return List
	 */
	public List<Empper> findAllLike(Empper empper, Pagination pagination,
			Boolean stpetsWith) {
		return (List<Empper>) this.empperDao.findAllLike(empper, pagination,
				stpetsWith);
	}

	/**
	 * Counts rows in the Empper table using like.
	 * 
	 * @param empper
	 *            Empper
	 * @param stpetsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Empper empper, Boolean stpetsWith) {
		return this.empperDao.findAllLikeCount(empper, stpetsWith);
	}

	/**
	 * Deletes a single row in the Empper table.
	 * 
	 * @param empper
	 *            Empper
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Empper empper) {
		Solarb solarb = new Solarb();
		solarb.setEmpper(empper);
		long numExpedientesAbiertos = this.solArbDao.findAllCount(solarb);
		if (numExpedientesAbiertos > 0) {
			throw new Y41bUDAException(
					"error.ooee.ExpedientesAbiertosException", true,
					new Exception());
		}
		// Borramos de peta1 por perito
		Peta1 peta1 = new Peta1();
		peta1.setEmpper(empper);
		this.peta1Dao.remove(peta1);

		// Borramos de pese por perito
		Pese pese = new Pese();
		pese.setEmpper(empper);
		this.peseDao.removePese(pese);

		this.borrarTemporales(empper);

		this.empperDao.remove(empper);
	}

	/**
	 * Deletes multiple rows in the Empper table.
	 * 
	 * @param empperList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Empper> empperList) {
		for (Empper empperAux : empperList) {
			this.empperDao.remove(empperAux);
		}
	}

	/**
	 * Borra los registros temporales
	 * 
	 * @param empper
	 *            Empper
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarTemporales(Empper empper) {
		// Sectores
		Pese pese = new Pese();
		pese.setEmpper(empper);
		// Lista de la temporal
		List<Pese> peses = this.peseDao.findAll(pese, null);
		for (int i = 0; i < peses.size(); i++) {
			pese = peses.get(i);
			// Eliminamos de la temporal
			this.peseDao.remove(pese);
		}
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		return this.empperDao.getNewPK();
	}
}
