package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DtsaDao;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Dtsa;

/**
 * DtsaServiceImpl  
 * 
 *  
 */

@Service(value = "dtsaService")
public class DtsaServiceImpl implements DtsaService {

	@Autowired
	private DtsaDao dtsaDao;
	@Autowired
	private ConsumidorDao consumidorDao;

	/**
	 * Inserts a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Dtsa add(Dtsa dtsa) {
		return this.dtsaDao.add(dtsa);
	}

	/**
	 * Updates a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Dtsa update(Dtsa dtsa) {
		return this.dtsaDao.update(dtsa);
	}

	/**
	 * Finds a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	public Dtsa find(Dtsa dtsa) {
		return (Dtsa) this.dtsaDao.find(dtsa);
	}

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Dtsa> findAll(Dtsa dtsa, Pagination pagination) {
		return (List<Dtsa>) this.dtsaDao.findAll(dtsa, pagination);
	}

	/**
	 * Counts rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Long
	 */
	public Long findAllCount(Dtsa dtsa) {
		return this.dtsaDao.findAllCount(dtsa);
	}

	/**
	 * Finds rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Dtsa> findAllLike(Dtsa dtsa, Pagination pagination,
			Boolean startsWith) {
		return (List<Dtsa>) this.dtsaDao.findAllLike(dtsa, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Dtsa dtsa, Boolean startsWith) {
		return this.dtsaDao.findAllLikeCount(dtsa, startsWith);
	}

	/**
	 * Deletes a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Dtsa dtsa) {
		this.dtsaDao.remove(dtsa);
	}

	/**
	 * Deletes multiple rows in the Dtsa table.
	 * 
	 * @param dtsaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Dtsa> dtsaList) {
		for (Dtsa dtsaAux : dtsaList) {
			this.dtsaDao.remove(dtsaAux);
		}
	}

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return List
	 */
	public List<Dtsa> findConsumidorGrid(Dtsa dtsa) {
		List<Dtsa> listaConsumidores = this.dtsaDao.findConsumidorGrid(dtsa);
		if (listaConsumidores != null && listaConsumidores.size() > 0) {
			Consumidor consumidor = null;
			for (int i = 0; i < listaConsumidores.size(); i++) {
				consumidor = listaConsumidores.get(i).getConsumidor();
				consumidor = this.consumidorDao.find(consumidor);
				listaConsumidores.get(i).setConsumidor(consumidor);
			}
		}
		return listaConsumidores;
	}

}
