package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Dtsa;

/**
 * DtsaService  
 * 
 *  
 */

public interface DtsaService {

	/**
	 * Inserts a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	Dtsa add(Dtsa dtsa);

	/**
	 * Updates a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	Dtsa update(Dtsa dtsa);

	/**
	 * Finds a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Dtsa
	 */
	Dtsa find(Dtsa dtsa);

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Dtsa> findAll(Dtsa dtsa, Pagination pagination);

	/**
	 * Counts rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return Long
	 */
	Long findAllCount(Dtsa dtsa);

	/**
	 * Finds rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Dtsa> findAllLike(Dtsa dtsa, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Dtsa table using like.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Dtsa dtsa, Boolean startsWith);

	/**
	 * Deletes a single row in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return
	 */
	void remove(Dtsa dtsa);

	/**
	 * Deletes multiple rows in the Dtsa table.
	 * 
	 * @param dtsaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Dtsa> dtsaList);

	/**
	 * Finds a List of rows in the Dtsa table.
	 * 
	 * @param dtsa
	 *            Dtsa
	 * @return List
	 */
	List<Dtsa> findConsumidorGrid(Dtsa dtsa);

}
