package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DocumentosSolicitudesTelematicasEventosDao;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.SolicitudTelematicaEventos;

import org.springframework.transaction.annotation.Transactional;
import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * SolicitudesTelematicasEventosServiceImpl  
 * 9:38:26.
 * 
 *  
 */

@Service(value = "documentosSolicitudesTelematicasEventosService")
public class DocumentosSolicitudesTelematicasEventosServiceImpl
		implements DocumentosSolicitudesTelematicasEventosService {

	@Autowired
	private DocumentosSolicitudesTelematicasEventosDao documentosSolicitudesTelematicasEventosDao;

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterDocumentoSolicitudTelematicaEventos
	 *            DocumentoSolicitudTelematicaEventos
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoSolicitudTelematicaEventos> findAllDocumentosSTE(
			DocumentoSolicitudTelematicaEventos filterDocumentoSolicitudTelematicaEventos, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("dsNoFile")) {
				pagination.setSort("NO_FILE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("dsNoFile")) {
				pagination.setSort("NO_FILE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("dsCodTipoDoc")) {
				pagination.setSort("COD_TIPODOC");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("dsCodTipoDoc")) {
				pagination.setSort("COD_TIPODOC");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		return this.documentosSolicitudesTelematicasEventosDao
				.findAllDocumentosSTE(filterDocumentoSolicitudTelematicaEventos, pagination);
	}

	/**
	 * Counts rows in the DocumentosSolicitudesTelematicasEventos table.
	 * 
	 * @param filterDocumentoSolicitudTelematicaEventos
	 *            DocumentoSolicitudTelematicaEventos
	 * 
	 * @return Long
	 */
	public Long findAllDocumentosSTECount(
			DocumentoSolicitudTelematicaEventos filterDocumentoSolicitudTelematicaEventos) {

		return this.documentosSolicitudesTelematicasEventosDao
				.findAllDocumentosSTECount(filterDocumentoSolicitudTelematicaEventos);

	}

	/**
	 * Inserts a single row in the DocumentoSolicitud table.
	 * 
	 * @param documentoSolicitud
	 *            DocumentoSolicitud
	 * @return DocumentoSolicitud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoSolicitudTelematicaEventos add(
			DocumentoSolicitudTelematicaEventos documentoSolicitudTelematicaEventos) {
		return this.documentosSolicitudesTelematicasEventosDao.add(documentoSolicitudTelematicaEventos);
	}

	/**
	 * Removes all rows in the DocumentoSolicitudTelematicaEventos from
	 * SolicitudTelematicaEventos.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return
	 */
	public void removeDocumentosSolicitudTelematicaEventos(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		this.documentosSolicitudesTelematicasEventosDao
				.removeDocumentosSolicitudTelematicaEventos(solicitudTelematicaEventos);

	}
}
