package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;

import com.ejie.y41b.dao.DocumentosFirmaArbitrosTempDao;

import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;

/**
 * DocumentosFirmaArbitrosServiceImpl  
 * 
 *  
 */

@Service(value = "documentosFirmaArbitrosTempService")
public class DocumentosFirmaArbitrosTempServiceImpl implements
		DocumentosFirmaArbitrosTempService {

	// private final static Logger logger = LoggerFactory
	// .getLogger(DocumentosFirmaArbitrosServiceImpl.class);

	@Autowired
	private DocumentosFirmaArbitrosTempDao documentosFirmaArbitrosTempDao;

	/**
	 * Inserts a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return DocumentosFirmaArbitrosTemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentosFirmaArbitrosTemp add(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp) {
		return this.documentosFirmaArbitrosTempDao
				.add(documentosFirmaArbitrosTemp);
	}

	/**
	 * Updates a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return DocumentosFirmaArbitrosTemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentosFirmaArbitrosTemp update(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp) {
		return this.documentosFirmaArbitrosTempDao
				.update(documentosFirmaArbitrosTemp);
	}

	/**
	 * Finds a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return DocumentosFirmaArbitrosTemp
	 */
	public DocumentosFirmaArbitrosTemp find(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp) {
		return (DocumentosFirmaArbitrosTemp) this.documentosFirmaArbitrosTempDao
				.find(documentosFirmaArbitrosTemp);
	}

	/**
	 * Finds a List of rows in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentosFirmaArbitrosTemp> findAll(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp,
			Pagination pagination) {
		return (List<DocumentosFirmaArbitrosTemp>) this.documentosFirmaArbitrosTempDao
				.findAll(documentosFirmaArbitrosTemp, pagination);
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return Long
	 */
	public Long findAllCount(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp) {
		return this.documentosFirmaArbitrosTempDao
				.findAllCount(documentosFirmaArbitrosTemp);
	}

	/**
	 * Finds rows in the DocumentosFirmaArbitrosTemp table using like.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocumentosFirmaArbitrosTemp> findAllLike(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp,
			Pagination pagination, Boolean startsWith) {
		return (List<DocumentosFirmaArbitrosTemp>) this.documentosFirmaArbitrosTempDao
				.findAllLike(documentosFirmaArbitrosTemp, pagination,
						startsWith);
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitrosTemp table using like.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp,
			Boolean startsWith) {
		return this.documentosFirmaArbitrosTempDao.findAllLikeCount(
				documentosFirmaArbitrosTemp, startsWith);
	}

	/**
	 * Deletes a single row in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTemp
	 *            DocumentosFirmaArbitrosTemp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTemp) {
		this.documentosFirmaArbitrosTempDao.remove(documentosFirmaArbitrosTemp);
	}

	/**
	 * Deletes multiple rows in the DocumentosFirmaArbitrosTemp table.
	 * 
	 * @param documentosFirmaArbitrosTempList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<DocumentosFirmaArbitrosTemp> documentosFirmaArbitrosTempList) {
		for (DocumentosFirmaArbitrosTemp documentosFirmaArbitrosTempAux : documentosFirmaArbitrosTempList) {
			this.documentosFirmaArbitrosTempDao
					.remove(documentosFirmaArbitrosTempAux);
		}
	}

	@Override
	public List<DocumentosFirmaArbitrosTemp> insertarTemporales(String idTramite) {
		// TODO Auto-generated method stub
		return (List<DocumentosFirmaArbitrosTemp>) this.documentosFirmaArbitrosTempDao
				.insertarTemporales(idTramite);
	}

}
