package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;

import com.ejie.y41b.dao.DocumentosFirmaArbitrosDao;

import com.ejie.y41b.model.DocumentosFirmaArbitros;

/**
 * DocumentosFirmaArbitrosServiceImpl  
 * 
 *  
 */

@Service(value = "documentosFirmaArbitrosService")
public class DocumentosFirmaArbitrosServiceImpl implements
		DocumentosFirmaArbitrosService {

	// private final static Logger logger = LoggerFactory
	// .getLogger(DocumentosFirmaArbitrosServiceImpl.class);

	@Autowired
	private DocumentosFirmaArbitrosDao documentosFirmaArbitrosDao;

	/**
	 * Inserts a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentosFirmaArbitros add(
			DocumentosFirmaArbitros documentosFirmaArbitros) {
		return this.documentosFirmaArbitrosDao.add(documentosFirmaArbitros);
	}

	/**
	 * Updates a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentosFirmaArbitros update(
			DocumentosFirmaArbitros documentosFirmaArbitros) {
		return this.documentosFirmaArbitrosDao.update(documentosFirmaArbitros);
	}

	/**
	 * Finds a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	public DocumentosFirmaArbitros find(
			DocumentosFirmaArbitros documentosFirmaArbitros) {
		return (DocumentosFirmaArbitros) this.documentosFirmaArbitrosDao
				.find(documentosFirmaArbitros);
	}

	/**
	 * Finds a List of rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentosFirmaArbitros> findAll(
			DocumentosFirmaArbitros documentosFirmaArbitros,
			Pagination pagination) {
		return (List<DocumentosFirmaArbitros>) this.documentosFirmaArbitrosDao
				.findAll(documentosFirmaArbitros, pagination);
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return Long
	 */
	public Long findAllCount(DocumentosFirmaArbitros documentosFirmaArbitros) {
		return this.documentosFirmaArbitrosDao
				.findAllCount(documentosFirmaArbitros);
	}

	/**
	 * Finds rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocumentosFirmaArbitros> findAllLike(
			DocumentosFirmaArbitros documentosFirmaArbitros,
			Pagination pagination, Boolean startsWith) {
		return (List<DocumentosFirmaArbitros>) this.documentosFirmaArbitrosDao
				.findAllLike(documentosFirmaArbitros, pagination, startsWith);
	}

	/**
	 * Counts rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			DocumentosFirmaArbitros documentosFirmaArbitros, Boolean startsWith) {
		return this.documentosFirmaArbitrosDao.findAllLikeCount(
				documentosFirmaArbitros, startsWith);
	}

	/**
	 * Deletes a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitros
	 *            DocumentosFirmaArbitros
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DocumentosFirmaArbitros documentosFirmaArbitros) {
		this.documentosFirmaArbitrosDao.remove(documentosFirmaArbitros);
	}

	/**
	 * Deletes multiple rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param documentosFirmaArbitrosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<DocumentosFirmaArbitros> documentosFirmaArbitrosList) {
		for (DocumentosFirmaArbitros documentosFirmaArbitrosAux : documentosFirmaArbitrosList) {
			this.documentosFirmaArbitrosDao.remove(documentosFirmaArbitrosAux);
		}
	}

}
