package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocumentosFirmaArbitros;

/**
 * BandejaFirmaService  
 * 
 *  
 */

public interface DocumentosFirmaArbitrosService {

	/**
	 * Inserts a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	DocumentosFirmaArbitros add(DocumentosFirmaArbitros bandejaFirma);

	/**
	 * Updates a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	DocumentosFirmaArbitros update(DocumentosFirmaArbitros bandejaFirma);

	/**
	 * Finds a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @return DocumentosFirmaArbitros
	 */
	DocumentosFirmaArbitros find(DocumentosFirmaArbitros bandejaFirma);

	/**
	 * Finds a List of rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentosFirmaArbitros> findAll(DocumentosFirmaArbitros bandejaFirma,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @return Long
	 */
	Long findAllCount(DocumentosFirmaArbitros bandejaFirma);

	/**
	 * Finds rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocumentosFirmaArbitros> findAllLike(
			DocumentosFirmaArbitros bandejaFirma, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the DocumentosFirmaArbitros table using like.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DocumentosFirmaArbitros bandejaFirma,
			Boolean startsWith);

	/**
	 * Deletes a single row in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirma
	 *            DocumentosFirmaArbitros
	 * @return
	 */
	void remove(DocumentosFirmaArbitros bandejaFirma);

	/**
	 * Deletes multiple rows in the DocumentosFirmaArbitros table.
	 * 
	 * @param bandejaFirmaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<DocumentosFirmaArbitros> bandejaFirmaList);

}
