package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DocumentosAsientoRegistralDao;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DocumentoAsientoRegistral;

/**
 * DocumentosAsientoRegistralServiceImpl  
 * 
 *  
 */

@Service(value = "documentosAsientoRegistralService")
public class DocumentosAsientoRegistralServiceImpl implements DocumentosAsientoRegistralService {

	@Autowired
	private DocumentosAsientoRegistralDao documentosAsientoRegistralDao;

	/**
	 * Finds a List of rows in the AsientoRegistral table.
	 * 
	 * @param filterDocumentosAsientoRegistral
	 *            DocumentosAsientoRegistral
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoAsientoRegistral> findAllDocumentosAR(
			DocumentoAsientoRegistral filterDocumentoAsientoRegistral, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("oidDokusi")) {
				pagination.setSort("OID_DOKUSI");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("oidDokusi")) {
				pagination.setSort("OID_DOKUSI");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		return this.documentosAsientoRegistralDao.findAllDocumentosAR(filterDocumentoAsientoRegistral, pagination);
	}

	/**
	 * Counts rows in the DocumentosAsientoRegistral table.
	 * 
	 * @param filterDocumentosAsientoRegistral
	 *            DocumentosAsientoRegistral
	 * 
	 * @return Long
	 */
	public Long findAllDocumentosARCount(DocumentoAsientoRegistral filterDocumentoAsientoRegistral) {

		return this.documentosAsientoRegistralDao.findAllDocumentosARCount(filterDocumentoAsientoRegistral);

	}

	/**
	 * Inserts a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentosAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentosAsientoRegistral
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoAsientoRegistral add(DocumentoAsientoRegistral documentoAsientoRegistral) {
		return this.documentosAsientoRegistralDao.add(documentoAsientoRegistral);
	}

	/**
	 * Removes all rows in the DocumentoAsientoRegistral from
	 * SolicitudTelematicaEventos.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeDocumentosAsientoRegistral(AsientoRegistral asientoRegistral) {
		this.documentosAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

	}

	/**
	 * Finds a row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return DocumentoAsientoRegistral
	 */
	public DocumentoAsientoRegistral findDocumentoAR(DocumentoAsientoRegistral documentoAsientoRegistral) {
		return this.documentosAsientoRegistralDao.findDocumentoAR(documentoAsientoRegistral);
	}

	/**
	 * Updates a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoAsientoRegistral update(DocumentoAsientoRegistral documentoAsientoRegistral) {
		return this.documentosAsientoRegistralDao.update(documentoAsientoRegistral);
	}

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return Long
	 */
	public Long countDocsSinRellenar(DocumentoAsientoRegistral documentoAsientoRegistral) {
		return this.documentosAsientoRegistralDao.countDocsSinRellenar(documentoAsientoRegistral);
	}

	/**
	 * Resets to null doumental type and desc fields for every document of the
	 * asientoregistral identified by idAsiento
	 * 
	 * @param idAsiento
	 *            String
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reseteaDocsAsiento(String idAsiento) {
		this.documentosAsientoRegistralDao.reseteaDocsAsiento(idAsiento);
	}

}
