package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.util.Date;
import java.util.List;

import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.DocumentoSolicitudTelematicaEventos;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.model.TramiteHechoModal;

/**
 * BandejaSolicitudesService  
 * 
 *  
 */

public interface DocumentosAsientoRegistralService {

	/**
	 * Finds a List of rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoAsientoRegistral> findAllDocumentosAR(DocumentoAsientoRegistral filterDocumentoAsientoRegistral,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param filterDocumentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return Long
	 */
	public Long findAllDocumentosARCount(DocumentoAsientoRegistral filterDocumentoAsientoRegistral);

	/**
	 * Inserts a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	DocumentoAsientoRegistral add(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Removes all rows in the DocumentoAsientoRegistral from AsientoRegistral.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeDocumentosAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * Finds a row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return DocumentoAsientoRegistral
	 */
	DocumentoAsientoRegistral findDocumentoAR(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Updates a single row in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * @return DocumentoAsientoRegistral
	 */
	DocumentoAsientoRegistral update(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Counts rows in the DocumentoAsientoRegistral table.
	 * 
	 * @param documentoAsientoRegistral
	 *            DocumentoAsientoRegistral
	 * 
	 * 
	 * @return Long
	 */
	Long countDocsSinRellenar(DocumentoAsientoRegistral documentoAsientoRegistral);

	/**
	 * Resets to null doumental type and desc fields for every document of the
	 * asientoregistral identified by idAsiento
	 * 
	 * @param idAsiento
	 *            String
	 * 
	 */
	void reseteaDocsAsiento(String idAsiento);

}