package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.EstTipoDoc;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.TramiteComun;

/**
 * * EstablecimientoService  
 * 
 *  
 */

public interface DocsEstablecimientoService {

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento add(Establecimiento establecimiento);

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param establecimSector
	 *            EstablecimSector
	 * @param sedeAux
	 *            Sede
	 * @return Establecimiento
	 */
	public Establecimiento addEstablecimiento(Establecimiento establecimiento,
			EstablecimArbitra establecimArbitra,
			EstablecimSector establecimSector, Sede sedeAux) throws Exception;

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento find(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Establecimiento> findAll(Establecimiento establecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllCount(Establecimiento establecimiento);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLike(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLikeEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeEstablecimientoCount(Establecimiento establecimiento,
			EstablecimSector establecimSector, Boolean startsWith);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	void remove(Establecimiento establecimiento);

	/**
	 * Deletes multiple rows in the Establecimiento table.
	 * 
	 * @param establecimientoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Establecimiento> establecimientoList);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	void removeEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector);

	/**
	 * Guardamos los cambios en la tabla final de documentos y en dokusi
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return PlantillaEstablecimientoDetalle
	 */
	void guardarDocumentos(Establecimiento establecimiento) throws Exception;

	List<EstTipoDoc> findAllTipoDocs();

	void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);
}
