package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DocCensoDao;
import com.ejie.y41b.dao.DocCensoTempDao;
import com.ejie.y41b.model.DocCensoTemp;

/**
 * DocCensoTempServiceImpl  
 * 
 *  
 */

@Service(value = "docCensoTempService")
public class DocCensoTempServiceImpl implements DocCensoTempService {

	@Autowired()
	private DocCensoTempDao docCensoTempDao;

	@Autowired()
	private DocCensoDao docCensoDao;

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocCensoTemp add(DocCensoTemp docCensoTemp) {
		docCensoTemp.setEacodocumento(this.docCensoDao.getNewPK());
		return this.docCensoTempDao.add(docCensoTemp);
	}

	/**
	 * Updates a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocCensoTemp update(DocCensoTemp docCensoTemp) {
		return this.docCensoTempDao.update(docCensoTemp);
	}

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	public DocCensoTemp find(DocCensoTemp docCensoTemp) {
		return (DocCensoTemp) this.docCensoTempDao.find(docCensoTemp);
	}

	/**
	 * Finds a List of rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocCensoTemp> findAll(DocCensoTemp docCensoTemp,
			Pagination pagination) {
		return (List<DocCensoTemp>) this.docCensoTempDao.findAll(docCensoTemp,
				pagination);
	}

	/**
	 * Counts rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return Long
	 */
	public Long findAllCount(DocCensoTemp docCensoTemp) {
		return this.docCensoTempDao.findAllCount(docCensoTemp);
	}

	/**
	 * Finds rows in the DocCensoTemp table using like.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocCensoTemp> findAllLike(DocCensoTemp docCensoTemp,
			Pagination pagination, Boolean startsWith) {
		return (List<DocCensoTemp>) this.docCensoTempDao.findAllLike(
				docCensoTemp, pagination, startsWith);
	}

	/**
	 * Counts rows in the DocCensoTemp table using like.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DocCensoTemp docCensoTemp, Boolean startsWith) {
		return this.docCensoTempDao.findAllLikeCount(docCensoTemp, startsWith);
	}

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DocCensoTemp docCensoTemp) {
		this.docCensoTempDao.remove(docCensoTemp);
	}

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeByEntidad(DocCensoTemp docCensoTemp) {
		this.docCensoTempDao.removeByEntidad(docCensoTemp);
	}

	/**
	 * Deletes multiple rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTempList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<DocCensoTemp> docCensoTempList) {
		for (DocCensoTemp docCensoTempAux : docCensoTempList) {
			this.docCensoTempDao.removeByEntidad(docCensoTempAux);
		}
	}

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	public DocCensoTemp addLobTablaTemporal(DocCensoTemp docCensoTemp) {
		return this.docCensoTempDao.addLobTablaTemporal(docCensoTemp);
	}

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	public void removeLobTablaTemporal(DocCensoTemp docCensoTemp) {
		this.docCensoTempDao.removeLobTablaTemporal(docCensoTemp);
	}

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */

	public DocCensoTemp findLobTablaTemporal(DocCensoTemp docCensoTemp) {
		return this.docCensoTempDao.findLobTablaTemporal(docCensoTemp);

	}

}
