package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocCensoTemp;

/**
 * DocCensoTempService  
 * 
 *  
 */

public interface DocCensoTempService {

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp add(DocCensoTemp docCensoTemp);

	/**
	 * Updates a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp update(DocCensoTemp docCensoTemp);

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp find(DocCensoTemp docCensoTemp);

	/**
	 * Finds a List of rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocCensoTemp> findAll(DocCensoTemp docCensoTemp, Pagination pagination);

	/**
	 * Counts rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return Long
	 */
	Long findAllCount(DocCensoTemp docCensoTemp);

	/**
	 * Finds rows in the DocCensoTemp table using like.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocCensoTemp> findAllLike(DocCensoTemp docCensoTemp,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the DocCensoTemp table using like.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DocCensoTemp docCensoTemp, Boolean startsWith);

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return
	 */
	void remove(DocCensoTemp docCensoTemp);

	/**
	 * Deletes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return
	 */
	void removeByEntidad(DocCensoTemp docCensoTemp);

	/**
	 * Deletes multiple rows in the DocCensoTemp table.
	 * 
	 * @param docCensoTempList
	 *            List
	 * @return
	 */
	void removeMultiple(List<DocCensoTemp> docCensoTempList);

	/**
	 * Inserts a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp addLobTablaTemporal(DocCensoTemp docCensoTemp);

	/**
	 * Removes a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 */
	void removeLobTablaTemporal(DocCensoTemp docCensoTemp);

	/**
	 * Finds a single row in the DocCensoTemp table.
	 * 
	 * @param docCensoTemp
	 *            DocCensoTemp
	 * @return DocCensoTemp
	 */
	DocCensoTemp findLobTablaTemporal(DocCensoTemp docCensoTemp);

}
