package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DocCensoDao;
import com.ejie.y41b.model.DocCenso;

/**
 * DocCensoServiceImpl  
 * 
 *  
 */

@Service(value = "docCensoService")
public class DocCensoServiceImpl implements DocCensoService {

	@Autowired()
	private DocCensoDao docCensoDao;

	/**
	 * Inserts a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocCenso add(DocCenso docCenso) {
		return this.docCensoDao.add(docCenso);
	}

	/**
	 * Updates a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocCenso update(DocCenso docCenso) {
		return this.docCensoDao.update(docCenso);
	}

	/**
	 * Finds a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	public DocCenso find(DocCenso docCenso) {
		return (DocCenso) this.docCensoDao.find(docCenso);
	}

	/**
	 * Finds a List of rows in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocCenso> findAll(DocCenso docCenso, Pagination pagination) {
		return (List<DocCenso>) this.docCensoDao.findAll(docCenso, pagination);
	}

	/**
	 * Counts rows in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return Long
	 */
	public Long findAllCount(DocCenso docCenso) {
		return this.docCensoDao.findAllCount(docCenso);
	}

	/**
	 * Finds rows in the DocCenso table using like.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<DocCenso> findAllLike(DocCenso docCenso, Pagination pagination,
			Boolean startsWith) {
		return (List<DocCenso>) this.docCensoDao.findAllLike(docCenso,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the DocCenso table using like.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DocCenso docCenso, Boolean startsWith) {
		return this.docCensoDao.findAllLikeCount(docCenso, startsWith);
	}

	/**
	 * Deletes a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DocCenso docCenso) {
		this.docCensoDao.remove(docCenso);
	}

	/**
	 * Deletes multiple rows in the DocCenso table.
	 * 
	 * @param docCensoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<DocCenso> docCensoList) {
		for (DocCenso docCensoAux : docCensoList) {
			this.docCensoDao.remove(docCensoAux);
		}
	}

}
