package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocCenso;

/**
 * DocCensoService  
 * 
 *  
 */

public interface DocCensoService {

	/**
	 * Inserts a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso add(DocCenso docCenso);

	/**
	 * Updates a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso update(DocCenso docCenso);

	/**
	 * Finds a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return DocCenso
	 */
	DocCenso find(DocCenso docCenso);

	/**
	 * Finds a List of rows in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocCenso> findAll(DocCenso docCenso, Pagination pagination);

	/**
	 * Counts rows in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return Long
	 */
	Long findAllCount(DocCenso docCenso);

	/**
	 * Finds rows in the DocCenso table using like.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocCenso> findAllLike(DocCenso docCenso, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the DocCenso table using like.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DocCenso docCenso, Boolean startsWith);

	/**
	 * Deletes a single row in the DocCenso table.
	 * 
	 * @param docCenso
	 *            DocCenso
	 * @return
	 */
	void remove(DocCenso docCenso);

	/**
	 * Deletes multiple rows in the DocCenso table.
	 * 
	 * @param docCensoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<DocCenso> docCensoList);

}
