package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DistribuidorDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Distribuidor;

/**
 * DistribuidorServiceImpl  
 *  
 */

@Service(value = "distribuidorService")
public class DistribuidorServiceImpl implements DistribuidorService {

	@Autowired
	private DistribuidorDao distribuidorDao;

	/**
	 * Inserts a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Distribuidor add(Distribuidor distribuidor) {
		return this.distribuidorDao.add(distribuidor);
	}

	/**
	 * Updates a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Distribuidor update(Distribuidor distribuidor) {
		return this.distribuidorDao.update(distribuidor);
	 }

	/**
	 * Finds a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
	public Distribuidor find(Distribuidor distribuidor) {
		return (Distribuidor) this.distribuidorDao.find(distribuidor);
	}

	/**
	 * Finds a List of rows in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Distribuidor> findAll(Distribuidor distribuidor, Pagination pagination) {
		return (List<Distribuidor>) this.distribuidorDao.findAll(distribuidor, pagination);
	}
    
	/**
	 * Counts rows in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Long
	 */
	public Long findAllCount(Distribuidor distribuidor) {        
		return  this.distribuidorDao.findAllCount(distribuidor);
	}

	/**
	 * Finds rows in the Distribuidor table using like.
	 *
	 * @param distribuidor Distribuidor
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Distribuidor> findAllLike(Distribuidor distribuidor, Pagination pagination, Boolean startsWith) {
		return (List<Distribuidor>) this.distribuidorDao.findAllLike(distribuidor, pagination, startsWith);
	}

	/**
	 * Counts rows in the Distribuidor table using like.
	 *
	 * @param distribuidor Distribuidor
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Distribuidor distribuidor, Boolean startsWith) {
		return this.distribuidorDao.findAllLikeCount(distribuidor, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Distribuidor distribuidor) {
		this.distribuidorDao.remove(distribuidor);
	}
	
	/**
	 * Deletes multiple rows in the Distribuidor table.
	 *
	 * @param distribuidorList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Distribuidor> distribuidorList) {
		for (Distribuidor  distribuidorAux:distribuidorList) {
			this.distribuidorDao.remove(distribuidorAux);
		}
	}
	
}

