package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Distribuidor;

/**
 * DistribuidorService  
 *  
 */

public interface DistribuidorService {

	/**
	 * Inserts a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
    Distribuidor add(Distribuidor distribuidor);

	/**
	 * Updates a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
	Distribuidor update(Distribuidor distribuidor);

	/**
	 * Finds a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Distribuidor
	 */
	Distribuidor find(Distribuidor distribuidor);

	/**
	 * Finds a List of rows in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @param pagination Pagination
	 * @return List
	 */
	List<Distribuidor> findAll(Distribuidor distribuidor, Pagination pagination);

	/**
	 * Counts rows in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return Long
	 */
	Long findAllCount(Distribuidor distribuidor);
	
	/**
	 * Finds rows in the Distribuidor table using like.
	 *
	 * @param distribuidor Distribuidor
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Distribuidor> findAllLike(Distribuidor distribuidor, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Distribuidor table using like.
	 *
	 * @param distribuidor Distribuidor
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Distribuidor distribuidor, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Distribuidor table.
	 *
	 * @param distribuidor Distribuidor
	 * @return 
	 */
	void remove(Distribuidor distribuidor);
	
	/**
	 * Deletes multiple rows in the Distribuidor table.
	 *
	 * @param distribuidorList List
	 * @return 
	 */	
	void removeMultiple(List<Distribuidor> distribuidorList);
    
}


