package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DescriptorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.ProductoDao;
import com.ejie.y41b.dao.SectorDao;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * DescriptorServiceImpl  
 * 
 *  
 */

@Service(value = "descriptorService")
public class DescriptorServiceImpl implements DescriptorService {

	private static final Logger logger = LoggerFactory
			.getLogger(DescriptorServiceImpl.class);
	@Autowired
	private DescriptorDao descriptorDao;
	@Autowired
	private SectorDao sectorDao;
	@Autowired
	private ProductoDao productoDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;
	@Autowired
	private ExpedienDao expedienDao;

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Descriptor add(Descriptor descriptor) {
		return this.descriptorDao.add(descriptor);
	}

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Descriptor addDescriptor(Descriptor descriptor) {
		descriptor.setIdDescriptor(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));

		this.descriptorDao.add(descriptor);

		Descriptor descriptorAux = new Descriptor();
		descriptorAux.setNombre(descriptor.getNombre());
		Long numDescriptores = this.descriptorDao
				.findAllNombreDescriptorCount(descriptorAux);

		if (numDescriptores > 1) {
			throw new Y41bUDAException("error.descriptor.DuplicateException",
					true, new Exception());
		}

		return descriptor;
	}

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Descriptor update(Descriptor descriptor) {
		return this.descriptorDao.update(descriptor);
	}

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Descriptor updateDescriptor(Descriptor descriptor) {
		this.descriptorDao.update(descriptor);

		Descriptor descriptorAux = new Descriptor();
		descriptorAux.setNombre(descriptor.getNombre());
		Long numDescriptores = this.descriptorDao
				.findAllNombreDescriptorCount(descriptorAux);

		if (numDescriptores > 1) {
			throw new Y41bUDAException("error.descriptor.DuplicateException",
					true, new Exception());
		}

		return descriptor;
	}

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptorBueno
	 *            Descriptor
	 * @param descriptoresListABorrar
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void fusionDescriptor(Descriptor descriptorBueno,
			ArrayList<Descriptor> descriptoresListABorrar) {
		for (Descriptor descriptorAux : descriptoresListABorrar) {

			// Sector
			Sector sector = new Sector();
			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			Descriptor descriptor = null;
			descriptor = new Descriptor();
			descriptor.setIdDescriptor(descriptorAux.getIdDescriptor());
			descriptores.add(descriptor);

			sector.setDescriptores(descriptores);

			// Buscamos los sectores que tienen los 2 descriptores
			List<Sector> listSector = this.sectorDao
					.findAllSectoresDescriptores(sector, null, false);

			for (Sector sectorAux : listSector) {
				// recorremos la lista y eliminamos el descriptor que se elimina
				List<Descriptor> descriptoresAux = new ArrayList<Descriptor>();

				Descriptor descripAux = null;
				descripAux = new Descriptor();
				descripAux.setIdDescriptor(descriptorBueno.getIdDescriptor());
				descriptoresAux.add(descripAux);

				sectorAux.setDescriptores(descriptoresAux);

				this.sectorDao.removeSectorDescriptor(sectorAux);
			}

			this.sectorDao.updateSectorDescriptor(descriptorAux,
					descriptorBueno);

			// Producto
			Producto producto = new Producto();

			producto.setDescriptores(descriptores);

			// Buscamos los productos que tienen los 2 descriptores
			List<Producto> listProducto = this.productoDao
					.findAllProductosDescriptores(producto, null, false);

			for (Producto productoAux : listProducto) {
				// recorremos la lista y eliminamos el descriptor que se elimina
				List<Descriptor> descriptoresAux = new ArrayList<Descriptor>();

				Descriptor descripAux = null;
				descripAux = new Descriptor();
				descripAux.setIdDescriptor(descriptorBueno.getIdDescriptor());
				descriptoresAux.add(descripAux);

				productoAux.setDescriptores(descriptoresAux);

				this.productoDao.removeProductoDescriptor(productoAux);
			}

			this.productoDao.updateProductoDescriptor(descriptorAux,
					descriptorBueno);

			// Establecimiento
			Establecimiento establecimiento = new Establecimiento();

			establecimiento.setDescriptores(descriptores);

			// Buscamos los establecimiento que tienen los 2 descriptores
			List<Establecimiento> listEstablecimiento = this.establecimientoDao
					.findAllEstablecimientosDescriptores(establecimiento, null,
							false);

			for (Establecimiento establecimientoAux : listEstablecimiento) {
				// recorremos la lista y eliminamos el descriptor que se elimina
				List<Descriptor> descriptoresAux = new ArrayList<Descriptor>();

				Descriptor descripAux = null;
				descripAux = new Descriptor();
				descripAux.setIdDescriptor(descriptorBueno.getIdDescriptor());
				descriptoresAux.add(descripAux);

				establecimientoAux.setDescriptores(descriptoresAux);

				this.establecimientoDao
						.removeEstablecimientoDescriptor(establecimientoAux);
			}

			this.establecimientoDao.updateEstablecimientoDescriptor(
					descriptorAux, descriptorBueno);

			// Solicitudes
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();

			solicitudDetalle.setDescriptores(descriptores);

			// Buscamos los establecimiento que tienen los 2 descriptores
			List<SolicitudDetalle> listSolicitudDetalle = this.hechoDenunciadoDao
					.findAllHechosDenunciadosDescriptores(solicitudDetalle,
							null);

			for (SolicitudDetalle solicitudDetalleAux : listSolicitudDetalle) {
				// recorremos la lista y eliminamos el descriptor que se elimina
				List<Descriptor> descriptoresAux = new ArrayList<Descriptor>();

				Descriptor descripAux = null;
				descripAux = new Descriptor();
				descripAux.setIdDescriptor(descriptorBueno.getIdDescriptor());
				descriptoresAux.add(descripAux);

				solicitudDetalleAux.setDescriptores(descriptoresAux);

				this.hechoDenunciadoDao
						.removeHechoDenunciadoDescriptor(solicitudDetalleAux);
			}

			this.hechoDenunciadoDao.updateHechoDenunciadoDescriptor(
					descriptorAux, descriptorBueno);

			// Sancionadores
			Expedien expedien = new Expedien();

			expedien.setDescriptores(descriptores);

			// Buscamos los sancionadores que tienen alguno de los 2
			// descriptores
			List<Expedien> listExpedien = this.expedienDao
					.findAllSancionDescriptores(expedien, null);

			for (Expedien expedienAux : listExpedien) {
				// recorremos la lista y eliminamos el descriptor que se elimina
				List<Descriptor> descriptoresAux = new ArrayList<Descriptor>();

				Descriptor descripAux = null;
				descripAux = new Descriptor();
				descripAux.setIdDescriptor(descriptorBueno.getIdDescriptor());
				descriptoresAux.add(descripAux);

				expedienAux.setDescriptores(descriptoresAux);

				this.expedienDao.removeSancionDescriptor(expedienAux);
			}

			this.expedienDao.updateSancionDescriptor(descriptorAux,
					descriptorBueno);

			this.descriptorDao.remove(descriptorAux);
		}
	}

	/**
	 * Finds a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor find(Descriptor descriptor) {
		return (Descriptor) this.descriptorDao.find(descriptor);
	}

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAll(Descriptor descriptor, Pagination pagination) {
		return (List<Descriptor>) this.descriptorDao.findAll(descriptor,
				pagination);
	}

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Long
	 */
	public Long findAllCount(Descriptor descriptor) {
		return this.descriptorDao.findAllCount(descriptor);
	}

	/**
	 * Finds rows in the Descriptor table using like.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Descriptor> findAllLike(Descriptor descriptor,
			Pagination pagination, Boolean startsWith) {

		if (pagination == null) {
			pagination = new Pagination();
			pagination.setSort("NOMBRE");
			pagination.setAscDsc("ASC");
		}
		return (List<Descriptor>) this.descriptorDao.findAllLike(descriptor,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Descriptor descriptor, Boolean startsWith) {
		return this.descriptorDao.findAllLikeCount(descriptor, startsWith);
	}

	/**
	 * Deletes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Descriptor descriptor) {
		this.descriptorDao.remove(descriptor);
	}

	/**
	 * Deletes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeDescriptor(Descriptor descriptor) {
		try {
			this.descriptorDao.remove(descriptor);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.descriptor.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Descriptor table.
	 * 
	 * @param descriptorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Descriptor> descriptorList) {
		for (Descriptor descriptorAux : descriptorList) {
			this.descriptorDao.remove(descriptorAux);
		}
	}

	/**
	 * Getter method for DescriptorDao
	 * 
	 * @return DescriptorDao
	 */
	public DescriptorDao getDescriptorDao() {
		return this.descriptorDao;
	}

	/**
	 * Setter method for DescriptorDao.
	 * 
	 * @param descriptorDao
	 *            DescriptorDao
	 * @return
	 */
	public void setDescriptorDao(DescriptorDao descriptorDao) {
		logger.info("Setting Dependency " + descriptorDao);
		this.descriptorDao = descriptorDao;
	}
}
