package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Descriptor;

/**
 * * DescriptorService  
 * 
 *  
 */

public interface DescriptorService {

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor add(Descriptor descriptor);

	/**
	 * Inserts a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor addDescriptor(Descriptor descriptor);

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor update(Descriptor descriptor);

	/**
	 * Updates a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateDescriptor(Descriptor descriptor);

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptorBueno
	 *            Descriptor
	 * @param descriptoresListABorrar
	 *            ArrayList
	 * @return
	 */
	public void fusionDescriptor(Descriptor descriptorBueno,
			ArrayList<Descriptor> descriptoresListABorrar);

	/**
	 * Finds a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Descriptor
	 */
	Descriptor find(Descriptor descriptor);

	/**
	 * Finds a List of rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Descriptor> findAll(Descriptor descriptor, Pagination pagination);

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return Long
	 */
	Long findAllCount(Descriptor descriptor);

	/**
	 * Finds rows in the Descriptor table using like.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Descriptor> findAllLike(Descriptor descriptor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Descriptor descriptor, Boolean startsWith);

	/**
	 * Deletes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return
	 */
	void remove(Descriptor descriptor);

	/**
	 * Deletes a single row in the Descriptor table.
	 * 
	 * @param descriptor
	 *            Descriptor
	 * @return
	 */
	public void removeDescriptor(Descriptor descriptor);

	/**
	 * Deletes multiple rows in the Descriptor table.
	 * 
	 * @param descriptorList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Descriptor> descriptorList);

}
