// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.BandejaSolicitudesDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.DecisionHechoDao;
import com.ejie.y41b.dao.DecisionL21Dao;
import com.ejie.y41b.dao.DenunciaDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.InspeccionesTipoDocumentoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.NumSolicitudDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.SolicitudArbitrajeDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PaisDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.dao.TipoDocumentoDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TrasladoDao;
import com.ejie.y41b.jms.Y41bTratamientoDokusiJMSService;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.AsientoRegistralDetalle;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DecisionHecho;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.DecisionL21;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteDecisionDetalle;
import com.ejie.y41b.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudArbitrajeDetalle;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.SolicitudEnvios;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoReclamacion;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.Traslado;
import com.ejie.y41b.model.TrasladoBusqueda;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.Contact;
import com.ejie.y41b.model.platea.ContextSubmission;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.InterestedRRI;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RepresentativeRRI;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bEjgvUtils;
import com.ejie.y41b.utils.Y41bStringUtils;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * * DenunciaServiceImpl  
 * 
 *  
 */
@Service(value = "denunciaService")
public class DenunciaServiceImpl implements DenunciaService {

	private static final Logger logger = LoggerFactory.getLogger(DenunciaServiceImpl.class);

	@Autowired
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private BandejaSolicitudesDao bandejaSolicitudesDao;

	@Autowired
	private NumSolicitudDao numSolicitudDao;

	@Autowired
	private DenunciaDao denunciaDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private TramiteDao tramiteDao;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired
	private HistoricofasesService historicofasesService;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;

	@Autowired
	private DecisionHechoDao decisionHechoDao;

	@Autowired
	private SolicitudArbitrajeDao solicitudArbitrajeDao;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private EstablecimientoDao establecimientoDao;

	@Autowired
	private EstablecimSectorDao establecimSectorDao;

	@Autowired
	private ConsumidorDao consumidorDao;

	@Autowired
	private TrasladoDao trasladoDao;

	@Autowired
	private OrganismoDao organismoDao;

	@Autowired
	private SanexprelDao sanexprelDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private CensoMonitorDao censoMonitorDao;

	@Autowired
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;

	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;
	@Autowired
	private DatosMailSedeDao datosMailSedeDao;

	@Autowired
	private SedeDao sedeDao;

	@Autowired
	private SedeService sedeService;

	@Autowired
	private EstablecimientoService establecimientoService;

	@Autowired
	private DecisionL21Dao decisionL21Dao;

	@Autowired
	private SanpropbandejaService sanpropbandejaService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired
	private SolarbService solarbService;

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired
	private TipoDocumentoDao tipoDocumentoDao;

	@Autowired
	private InspeccionesTipoDocumentoDao inspeccionesTipoDocumentoDao;

	@Autowired
	private ArbtipdocDao arbtipdocDao;

	@Autowired
	private SantipdocDao santipdocDao;

	@Autowired
	private ArbpropbandejaService arbpropbandejaService;

	@Autowired
	private SoltramexpService soltramexpService;

	// NORA.
	@Autowired()
	private T17PaisDao paisDao;

	@Autowired()
	private T17ProvinciaDao provinciaDao;

	@Autowired()
	private T17MunicipioDao municipioDao;

	@Autowired()
	private T17LocalidadDao localidadDao;

	@Autowired()
	private T17PortalDao portalDao;

	@Autowired()
	private ActuacionService actuacionService;

	@Autowired
	private Y41bTratamientoDokusiJMSService tratamientoDokusiJMS;

	@Autowired
	private AsientoRegistralService asientoRegistralService;

	@Autowired
	private DocumentosAsientoRegistralService documentosAsientoRegistralService;

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia add(Denuncia denuncia) {
		return this.denunciaDao.add(denuncia);
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSolicitud(SolicitudDetalle solicitudDetalle) {
		// comprobacion de que el registro de solicitud(apertura del expediente)
		// no se ha tramitado

		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

		tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		try {
			tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
		} catch (Exception e) {
		}

		// buscar la solicitud
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		if (solDetalle != null && solDetalle.getTfpcodigo() != null
				&& (solDetalle.getTfpcodigo().equals(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB)
						|| solDetalle.getTfpcodigo().equals(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP))) {
			// "si es origen Web (las que son web o app mvil) mostrar mensaje
			// de error: No se puede eliminar las solicitudes web"
			throw new Y41bUDAException("error.solicitud.removeWebException", true, new Exception());
		}

		// si se ha tramitado el registro de solicitud error
		if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
			throw new Y41bUDAException("error.solicitud.removeException", true, new Exception());
		} else {
			// si no se eliminan las tablas

			// eliminar la bandeja de ese expediente
			BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
			bandejasolicitudes.setHdcodigo(solicitudDetalle.getHdcodigo());
			this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);

			// eliminar docs tramite hecho
			if (tramiteHechoDetalle != null && Y41bUtils.isFilled(tramiteHechoDetalle.getEhcodigo())) {
				DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
				this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);
			}

			// eliminar documentos hecho
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());
			this.documentoHechoDao.removeDocsExpediente(documentoHecho);

			// eliminar intervinientes
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(solicitudDetalle.getHdcodigo());
			this.intervinientesDao.removeIntervinientesExpediente(intervinientes);

			// eliminar expedientes relacionados
			Sanexprel sanexprel = new Sanexprel();
			sanexprel.setRlhdcodigo(solicitudDetalle.getHdcodigo());
			this.sanexprelDao.removeExpedienteSolicitud(sanexprel);

			// eliminar traslado
			this.trasladoDao.removeTrasladoExpediente(solicitudDetalle);

			// eliminar todos los tramites
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcohd(solicitudDetalle.getHdcodigo());
			this.tramiteHechoDao.removeTramitesExpediente(tramitehecho);

			// eliminar historico de fases
			Historicofases historicofases = new Historicofases();
			historicofases.setHfhdcodigo(solicitudDetalle.getHdcodigo());
			this.historicofasesService.removeHistoricoFasesExpediente(historicofases);

			// eliminar decision hecho
			DecisionHecho decisionhecho = new DecisionHecho();
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(solicitudDetalle.getHdcodigo());
			decisionhecho.setHechoDenunciado(hechoDenunciado);
			this.decisionHechoDao.removeDecisionSolicitud(decisionhecho);

			// eliminar hecho denunciado
			this.hechoDenunciadoDao.removeAllHechoDenunciadoDescriptor(solicitudDetalle);
			this.hechoDenunciadoDao.remove(hechoDenunciado);

			// eliminar denuncia
			this.denunciaDao.removeDenunciaExpediente(hechoDenunciado);
		}
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle addSolicitud(SolicitudDetalle solicitudDetalle) {

		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(solicitudDetalle.getTfpcodigo());

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solicitudDetalle.getDtcodigo());

			Denuncia denuncia = new Denuncia(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					solicitudDetalle.getDecoor(), solicitudDetalle.getDenran(), solicitudDetalle.getDenror(),
					solicitudDetalle.getDefede(), solicitudDetalle.getDefere(), null, null, Y41bConstantes.VALOR_NO,
					null, formaPresentacion, consumidor);

			Denuncia denunciaAux = this.numSolicitudDao.findNumSolicitud(denuncia);

			denuncia.setDenror(denunciaAux.getDenror());

			denuncia.setDenombretelematico(solicitudDetalle.getDenombretelematico());
			denuncia.setDedirecciontelematico(solicitudDetalle.getDedirecciontelematico());

			if (denuncia.getDenombretelematico() != null && denuncia.getDenombretelematico().length() > 254) {
				denuncia.setDenombretelematico(denuncia.getDenombretelematico().substring(0, 254));
			}

			if (denuncia.getDedirecciontelematico() != null && denuncia.getDedirecciontelematico().length() > 3999) {
				denuncia.setDedirecciontelematico(denuncia.getDedirecciontelematico().substring(0, 3999));
			}

			this.numSolicitudDao.add(denuncia);

			solicitudDetalle.setDecodigo(denuncia.getDecodigo());

			// Da de alta denuncia
			this.denunciaDao.addDenuncia(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solicitudDetalle.getEscodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solicitudDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solicitudDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solicitudDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solicitudDetalle.getTircodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado(
					// Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
					solicitudDetalle.getHdcodigo(), solicitudDetalle.getHdnror(), solicitudDetalle.getHdte(), null,
					null, solicitudDetalle.getHdnops(), solicitudDetalle.getHdnomaps(), solicitudDetalle.getHdnomops(),
					solicitudDetalle.getHdnrlops(), solicitudDetalle.getHdcodigobarras(),
					solicitudDetalle.getHdfedmps(), null, Y41bConstantes.SOLICITUD_MEDIACION,
					solicitudDetalle.getHdcaptso(), solicitudDetalle.getHdteso(), null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, solicitudDetalle.getHdcosc(), null, null, null, null, null, null,
					solicitudDetalle.getHdfehd(), null, null, null, null, null, null, null, null, null,
					Y41bConstantes.SI, solicitudDetalle.getHdformanotificacion(),
					solicitudDetalle.getHdformanotificacionestablecimiento(),
					solicitudDetalle.getHdcodexpedienteorigen(), solicitudDetalle.getNumregistroentrada(), null, null,
					solicitudDetalle.getHdinteresado(), denuncia, establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo);

			if (hechoDenunciado.getHdcodigo() == null) {
				hechoDenunciado.setHdcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			}

			solicitudDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());
			hechoDenunciado.setHdidioma(solicitudDetalle.getHdidioma());
			hechoDenunciado.setHdidiomareclamado(solicitudDetalle.getHdidiomareclamado());
			hechoDenunciado.setHdnumregistroentradaorigen(solicitudDetalle.getHdnumregistroentradaorigen());
			hechoDenunciado.setHdfecharegistroorigen(solicitudDetalle.getHdfecharegistroorigen());
			hechoDenunciado.setHdformaventa(solicitudDetalle.getFvcodigo());
			hechoDenunciado.setHdformaventatelematica(solicitudDetalle.getFvtelematicocodigo());
			hechoDenunciado.setHddenunciaaaccempresas(solicitudDetalle.getHddenunciaaaccempresas());
			hechoDenunciado.setHdtipodenunciante(solicitudDetalle.getHdtipodenunciante());
			hechoDenunciado.setHdparticipacionreclamado(Y41bConstantes.VALOR_NO);

			hechoDenunciado.setHddestnotificareclamante(solicitudDetalle.getHddestnotificareclamante());
			hechoDenunciado.setHddestnotificareclamado(solicitudDetalle.getHddestnotificareclamado());

			hechoDenunciado.setIstelematico(solicitudDetalle.getistelematico());

			hechoDenunciado.setHdesnombretelematico(solicitudDetalle.getHdesnombretelematico());
			hechoDenunciado.setHdesdirecciontelematico(solicitudDetalle.getHdesdirecciontelematico());

			if (hechoDenunciado.getHdesnombretelematico() != null
					&& hechoDenunciado.getHdesnombretelematico().length() > 254) {
				hechoDenunciado.setHdesnombretelematico(hechoDenunciado.getHdesnombretelematico().substring(0, 254));
			}

			if (hechoDenunciado.getHdesdirecciontelematico() != null
					&& hechoDenunciado.getHdesdirecciontelematico().length() > 3999) {
				hechoDenunciado
						.setHdesdirecciontelematico(hechoDenunciado.getHdesdirecciontelematico().substring(0, 3999));
			}
			hechoDenunciado.setIsSir(solicitudDetalle.getIsSir());
			hechoDenunciado.setArSolicitante(solicitudDetalle.getArSolicitante());
			hechoDenunciado.setArResumen(solicitudDetalle.getArResumen());

			// Da de alta hecho denuncia
			this.hechoDenunciadoDao.addHechoDenunciado(hechoDenunciado);

			// descriptores
			String idsDescriptores = solicitudDetalle.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}

			solicitudDetalle.setDescriptores(descriptores);

			this.hechoDenunciadoDao.addHechoDenunciadoDescriptor(solicitudDetalle);

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(solicitudDetalle.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

			// Dependiendo del tipo denunciante...
			Intervinientes intervinientesAux = null;
			StringBuffer sbPerson = new StringBuffer();

			if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getHddenunciaaaccempresas())
					&& Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solicitudDetalle.getTfpcodigo())
					&& Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getistelematico())) {
				// Para las nuevas solicitudes de denuncia de empresas llegadas
				// por WEB, todavia no le ponemos el reclamado.

			} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_AACC.equals(solicitudDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OOEE.equals(solicitudDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OTRAS.equals(solicitudDetalle.getHdtipodenunciante())) {

				// Alta interviniente organismo
				Organismo organismo = new Organismo();
				organismo.setEntidadId(solicitudDetalle.getDtcodigo());

				organismo = this.organismoDao.findOrganismoById(organismo);

				String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						solicitudDetalle.getDtcodigo(), null, organismo.getEntidadId(), organismo.getNombreEs(), null,
						null, null, null, organismo.getCif(), null, null, null, organismo.getUrl(), null, null,
						organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
						organismo.getNoraProvinciaId(), organismo.getNombreProvincia(), organismo.getNoraMunicipioId(),
						organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
						organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
						organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
						organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
						organismo.getNombreCalle(), null, null, null, null, null,
						Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, solicitudDetalle.getHdcodigo(), null, null,
						null, null);

				this.intervinientesDao.add(intervinientesAux);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);

				if (Y41bUtils.isFilled(organismo.getCif())) {
					sbPerson.append(organismo.getCif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(organismo.getNombreEs())) {
					sbPerson.append(organismo.getNombreEs());
					sbPerson.append(" ");
				}

			} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS
					.equals(solicitudDetalle.getHdtipodenunciante())) {

				// Alta interviniente establecimiento
				Establecimiento establecimientoAux = new Establecimiento();
				establecimientoAux.setEscodigo(solicitudDetalle.getDtcodigo());
				establecimientoAux = this.establecimientoDao.find(establecimientoAux);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimientoAux);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						solicitudDetalle.getDtcodigo(), establecimientoAux.getEscodigo(), null,
						establecimientoAux.getEsnombre(), null, null, establecimientoAux.getEsnoco(), null,
						establecimientoAux.getEsnif(), null, null, establecimientoAux.getEscoidco(),
						establecimientoAux.getEsteurl(), establecimientoAux.getEsnopeco(),
						establecimientoAux.getEsfeba(), establecimientoAux.getEsnrtel(),
						establecimientoAux.getEsnrtel2(), establecimientoAux.getEscoem(),
						establecimientoAux.getEsextranjero(), establecimientoAux.getEsnoraProvinciaId(),
						establecimientoAux.getEsnombreProvincia(), establecimientoAux.getEsnoraMunicipioId(),
						establecimientoAux.getEsnombreMunicipio(), establecimientoAux.getEsnoraLocalidadId(),
						establecimientoAux.getEsnombreLocalidad(), establecimientoAux.getEsnoraCalleId(),
						establecimientoAux.getEsnombreCalle(), establecimientoAux.getEsnoraCpId(),
						establecimientoAux.getEsnombreCp(), establecimientoAux.getEsnoraPortalId(),
						establecimientoAux.getEsnombrePortal(), establecimientoAux.getEsnombrePiso(),
						establecimientoAux.getEsnoraPaisId(), establecimientoAux.getEsnoraPaisNombre(),
						establecimientoAux.getEsdireccion_nocapv(), null, establecimientoAux.getEsinadar(),
						establecSector.getSector().getSecodigo(), establecSector.getSector().getSenombre(),
						establecSector.getSector().getSenombree(), Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
						hechoDenunciado.getHdcodigo(), null, establecimientoAux.getEsfemod(),
						establecimientoAux.getCensoMonitor().getMocodigo(),
						establecimientoAux.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);

				if (Y41bUtils.isFilled(establecimientoAux.getEsnif())) {
					sbPerson.append(establecimientoAux.getEsnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(establecimientoAux.getEsnombre())) {
					sbPerson.append(establecimientoAux.getEsnombre());
					sbPerson.append(" ");
				}
			} else {

				// Alta de interviniente consumidor
				consumidor = this.consumidorDao.find(consumidor);

				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), consumidor.getDtcodigo(),
						null, null, consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(),
						null, consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
						consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
						consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
						consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
						consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
						consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
						consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
						consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
						consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
						consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
						Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, hechoDenunciado.getHdcodigo(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);

				if (Y41bUtils.isFilled(consumidor.getDtnif())) {
					sbPerson.append(consumidor.getDtnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtnombre())) {
					sbPerson.append(consumidor.getDtnombre());
					sbPerson.append(" ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtapellido1())) {
					sbPerson.append(consumidor.getDtapellido1());
					sbPerson.append(" ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtapellido2())) {
					sbPerson.append(consumidor.getDtapellido2());
					sbPerson.append(" ");
				}
			}

			// Se genera el numero de registro de entrada
			if (solicitudDetalle.getNumregistroentrada() == null
					|| solicitudDetalle.getNumregistroentrada().equals("")) {
				// Inicio Bloque del Test
				WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

				if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				} else if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				} else if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				} else if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				}

				ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

				WSParamPerson wSParamPerson = new WSParamPerson();
				wSParamPerson.setPersonName(sbPerson.toString());

				persons.getWSParamPerson().add(wSParamPerson);

				datas.setPersons(persons);

				SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				StringBuffer sbMatter = new StringBuffer();
				sbMatter.append(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
				sbMatter.append(" - [");
				sbMatter.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				sbMatter.append("-");
				sbMatter.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
						.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
				sbMatter.append("]");
				datas.setMatter(sbMatter.toString());

				N61ServiceImpl n61Service = new N61ServiceImpl();
				WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

				hechoDenunciado.setNumregistroentrada(wSInputRegister.getNumber());

				this.hechoDenunciadoDao.updateNumregistroEntrada(hechoDenunciado);
			}

			if (solicitudDetalle.getEscodigo() != null && !solicitudDetalle.getEscodigo().equals("")) {
				// Alta interviniente establecimiento
				establecimiento = this.establecimientoDao.find(establecimiento);

				establecimiento = this.tratamientoAnyadirIntervinienteDemandado(establecimiento);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						null, establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO, hechoDenunciado.getHdcodigo(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientes);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMADO(intervinientes);
			}

			// Alta interviniente administrador
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solicitudDetalle.getDecoor());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					null, organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
					null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
					organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null,
					null, null);

			this.intervinientesDao.add(intervinientes);

			// Creacion de tramite de registro de solicitud pendiente de
			// tramitacion
			// Se devuelve el documentoHecho de la SOLICITUD
			this.tramitarAddTramiteRegistroSolicitud(solicitudDetalle, hechoDenunciado);

			DecisionHecho decisionHecho = new DecisionHecho(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), solicitudDetalle.getDecoor(),
					null, null, null, hechoDenunciado, null);

			// Da de alta una decision vacia
			this.decisionHechoDao.add(decisionHecho);

			// Actualizo la fase del expediente
			Historicofases historicoejecutadotr = new Historicofases();
			historicoejecutadotr.setHfhdcodigo(hechoDenunciado.getHdcodigo());
			historicoejecutadotr.setHffcodigo(Y41bConstantes.FASE_REGISTRO);
			historicoejecutadotr.setHffinicio(new Date());
			historicoejecutadotr.setHfffin(null);
			this.historicofasesService.add(historicoejecutadotr);

			// Actualizar ultimo tramite
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(hechoDenunciado.getHdcodigo());
			hechodenunciadoAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
			hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

			this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);

			// Tratar la bandeja
			this.tratamientoBandejaSolicitudes(hechoDenunciado);

			// Actualizamos la bandeja de propuestas de sancion
			this.tratamientoBandejaPropuestaSancion(hechoDenunciado);

			// Actualizamos la bandeja de propuestas de arbitraje
			this.tratamientoBandejaPropuestaArbitraje(hechoDenunciado);

		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41bUDAException("error.solicitud.consumidor", true, e);
			} else if (j != -1) {
				throw new Y41bUDAException("error.solicitud.establecimiento", true, e);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("##################addSolicitudException", e);
			throw new Y41bUDAException("error.generico", true, e);
		} catch (Throwable ex) {
			logger.error("##################addSolicitudThrowable", ex);
			throw new Y41bUDAException("error.generico", true, ex);
		}

		return solicitudDetalle;
	}

	private Establecimiento tratamientoAnyadirIntervinienteDemandado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un establecimiento a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

	private Map<String, String> getReclamacionFormFromXml(String xml) {
		try {
			XMLInputFactory factory = XMLInputFactory.newInstance();
			XMLEventReader reader = factory.createXMLEventReader(new java.io.StringReader(xml));

			String nombreElemento = null;

			Map<String, String> reclamacionForm = new HashMap<String, String>();
			while (reader.hasNext()) {
				XMLEvent event = reader.nextEvent();
				if (event.isStartElement()) {
					nombreElemento = ((StartElement) event).getName().toString();
				}
				if (event.isCharacters()) {
					Characters characters = (Characters) event;
					if (characters.getData() != null && !"".equals(characters.getData())
							&& !"\n".equals(characters.getData()) && !"\r\n".equals(characters.getData())) {
						// logger.info("Elemento: " + nombreElemento +
						// ". Texto: " + characters.getData());

						reclamacionForm.put(nombreElemento, characters.getData());
					}
				}
			}

			return reclamacionForm;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param solicitudID
	 *            String
	 * @param listDocumento
	 *            List<Documento>
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle enviarSolicitudTelematica(SolicitudDetalle solicitudDetalle,
			ContextSubmission contextSubmission, String solicitudID, List<Documento> listDocumento) throws Exception {
		try {

			// Recupera el formulario
			String xml = this.getXmlNegocioFromDocuments(solicitudID);
			Map<String, String> reclamacionForm = this.getReclamacionFormFromXml(xml);

			solicitudDetalle.setDecodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			solicitudDetalle.setHdidiomareclamado(Y41bConstantes.CASTELLANO);

			solicitudDetalle.setHdformanotificacion(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
			solicitudDetalle.setHdformanotificacionestablecimiento(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO);

			solicitudDetalle.setHdcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			String email = "";
			String telefono = "";

			RepresentativeRRI representanteReclamante = null;
			InterestedRRI reclamante = null;

			reclamante = contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0);

			solicitudDetalle.setHdidioma(contextSubmission.getApplicantInfoRRI().getInterestedListRRI()
					.getInterestedRRI().get(0).getLanguage());

			if (contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
					.getAccount() != null
					&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList() != null
					&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList().getContact() != null
					&& !contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
							.getAccount().getContactList().getContact().isEmpty()) {
				for (Contact contact : contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI()
						.get(0).getAccount().getContactList().getContact()) {
					if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
						email = contact.getValue().getEmailAddress();
					}

					if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
						telefono = contact.getValue().getSmsNumber();
					}
				}
			}

			if (contextSubmission.getApplicantInfoRRI().getRepresentativeRRI() != null
					&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getID() != null
					&& !contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getID().equals("")) {
				solicitudDetalle
						.setHdidioma(contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getLanguage());

				representanteReclamante = contextSubmission.getApplicantInfoRRI().getRepresentativeRRI();

				if (contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount() != null
						&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
								.getContactList() != null
						&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount().getContactList()
								.getContact() != null
						&& !contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount().getContactList()
								.getContact().isEmpty()) {
					for (Contact contact : contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
							.getContactList().getContact()) {
						if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
							email = contact.getValue().getEmailAddress();
						}

						if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
							telefono = contact.getValue().getSmsNumber();
						}
					}
				}
			}

			// ***********************************************
			// ************* DATOS DEL RECLAMANTE *************
			// ***********************************************
			// Si es una SOLICITUD de reclamacion de un CONSUMIDOR...
			if (Y41bConstantes.RECLAMACION_TOOLKIT_TIPODENUNCIA_SOLICITUD
					.equals(reclamacionForm.get("datoschoiceTipoDenuncia"))) {

				solicitudDetalle = this.procesarTitularSolicitudConsumidor(solicitudDetalle, reclamante,
						representanteReclamante, reclamacionForm, email, telefono);

				// Si es una DENUNCIA de una AACC, OOEE o EMPRESA...
			} else if (Y41bConstantes.RECLAMACION_TOOLKIT_TIPODENUNCIA_EMPRESA
					.equals(reclamacionForm.get("datoschoiceTipoDenuncia"))) {

				solicitudDetalle = this.procesarTitularSolicitudEmpresa(solicitudDetalle, reclamante,
						representanteReclamante, reclamacionForm, email, telefono);
			}

			// **************************************************************
			// ************* DATOS DEL REPRESENTANTE RECLAMANTE
			// *************
			// **************************************************************
			solicitudDetalle = this.procesarRepresentanteSolicitud(solicitudDetalle, representanteReclamante,
					reclamacionForm, email, telefono);

			// ***********************************************
			// ************* DATOS DEL RECLAMADO *************
			// ***********************************************
			solicitudDetalle = this.procesarReclamadoSolicitud(solicitudDetalle, reclamacionForm);

			// ***************************************
			// ************* OTROS DATOS *************
			// ***************************************
			String esEmpresa = (Y41bConstantes.RECLAMACION_TOOLKIT_TIPODENUNCIA_EMPRESA
					.equals(reclamacionForm.get("datoschoiceTipoDenuncia")) ? "AACC" : "");

			// solicitudDetalle.setFvcodigo(reclamacionForm.get("holderchoiceFormaVenta"
			// + esEmpresa));
			solicitudDetalle.setFvtelematicocodigo(reclamacionForm.get("holderchoiceFormaVenta" + esEmpresa));
			solicitudDetalle.setPscodigo(reclamacionForm.get("holderchoiceProductoServicio" + esEmpresa));
			solicitudDetalle.setHdte(reclamacionForm.get("holderDescripconhecho" + esEmpresa));

			if (reclamacionForm.get("holderFechaHecho" + esEmpresa) != null
					&& !"".equals(reclamacionForm.get("holderFechaHecho" + esEmpresa))) {
				String fechaHecho = reclamacionForm.get("holderFechaHecho" + esEmpresa);

				StringTokenizer token = new StringTokenizer(fechaHecho, "/");

				Date hdfehd = null;
				if (token.nextToken().length() == 2) {
					hdfehd = Y41bUtils.parseDate(reclamacionForm.get("holderFechaHecho" + esEmpresa),
							new Locale(Y41bConstantes.CASTELLANO));
				} else {
					hdfehd = Y41bUtils.parseDate(reclamacionForm.get("holderFechaHecho" + esEmpresa),
							new Locale(Y41bConstantes.EUSKERA));
				}
				solicitudDetalle.setHdfehd(hdfehd);
			}

			solicitudDetalle.setTsrcodigo(reclamacionForm.get("holderchoiceReclamacion"));
			solicitudDetalle.setHdteso(reclamacionForm.get("holderComentarios"));

			if (solicitudDetalle.getHdteso() != null
					&& solicitudDetalle.getHdteso().length() > Y41bConstantes.NUM_255) {
				solicitudDetalle.setHdteso(solicitudDetalle.getHdteso().substring(0, Y41bConstantes.NUM_255));
			}
			// 0198618
			// if (reclamacionForm.get("campoBasicoImporte") != null
			// && !"".equals(reclamacionForm.get("campoBasicoImporte"))) {
			// solicitudDetalle
			// .setHdcaptso(new
			// BigDecimal(reclamacionForm.get("campoBasicoImporte").replace(',',
			// '.')));
			// }

			if (reclamacionForm.get("campoBasicoImporte") != null
					&& !"".equals(reclamacionForm.get("campoBasicoImporte"))) {

				solicitudDetalle.setHdcaptso(new BigDecimal(reclamacionForm.get("campoBasicoImporte").replace('.', ' ')
						.replaceAll("\\s", "").replace(',', '.')));
			}

			if (Y41bConstantes.RECLAMACION_TOOLKIT_TIPODENUNCIA_SOLICITUD
					.equals(reclamacionForm.get("datoschoiceTipoDenuncia"))) {
				String esExtranjero = Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_SI
						.equals(reclamacionForm.get("datoschoiceExtranjero")) ? Y41bConstantes.VALOR_SI
								: Y41bConstantes.VALOR_NO;

				// Oficina encargada dependiendo del origen del reclamante.
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				String idProvincia = reclamacionForm.get("holderchoiceProvinciaDomicilioSocial");

				if (esExtranjero.equals(Y41bConstantes.NO)) {
					if (Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(idProvincia)) {
						solicitudDetalle.setDecoor(prop.getProperty("oficina.territorio.bizkaia"));
					} else if (Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(idProvincia)) {
						solicitudDetalle.setDecoor(prop.getProperty("oficina.territorio.gipuzkoa"));
					} else if (Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(idProvincia)) {
						solicitudDetalle.setDecoor(prop.getProperty("oficina.territorio.araba"));
					} else {
						solicitudDetalle.setDecoor(prop.getProperty("oficina.territorio.fueracapv"));
					}
				} else if (Y41bConstantes.SI.equals(esExtranjero)) {
					solicitudDetalle.setDecoor(prop.getProperty("oficina.territorio.extranjero"));
				}
			} else {
				solicitudDetalle.setDecoor(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
			}

			Calendar now = Calendar.getInstance();
			int year = now.get(Calendar.YEAR);
			solicitudDetalle.setDenran(year);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			solicitudDetalle.setDefede(todayWithZeroTime);
			solicitudDetalle.setDefere(todayWithZeroTime);

			solicitudDetalle.setTfpcodigo(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
			solicitudDetalle.setistelematico(Y41bConstantes.VALOR_SI);

			solicitudDetalle = this.addSolicitud(solicitudDetalle);

			// *******************************************************
			// ************* GUARDAR DOCUMENTOS ADJUNTOS *************
			// *******************************************************
			this.procesarDocumentosSolicitud(solicitudDetalle, representanteReclamante, listDocumento);

			// buscar la solicitud
			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
					.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
					.append(solDetalle.getHdnror());

			solicitudDetalle.setNumExpediente(numeroExpediente.toString());

			return solicitudDetalle;

		} catch (Throwable e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Metodo que procesa los datos del titular de una solicitud telematica de
	 * un consumidor
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param reclamante
	 *            InterestedRRI
	 * @param representanteReclamante
	 *            RepresentativeRRI
	 * @param reclamacionForm
	 *            Map<String, String>
	 * @param email
	 *            String
	 * @param telefono
	 *            String
	 * 
	 * @return SolicitudDetalle
	 */
	private SolicitudDetalle procesarTitularSolicitudConsumidor(SolicitudDetalle solicitudDetalle,
			InterestedRRI reclamante, RepresentativeRRI representanteReclamante, Map<String, String> reclamacionForm,
			String email, String telefono) {

		String esExtranjero = Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_SI.equals(
				reclamacionForm.get("datoschoiceExtranjero")) ? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
		solicitudDetalle.setDtextranjero(esExtranjero);

		Consumidor consumidorReclamante = new Consumidor();
		consumidorReclamante.setDtnif(reclamante.getID());

		consumidorReclamante.setDtnombre(reclamante.getName());
		if (consumidorReclamante.getDtnombre() != null && consumidorReclamante.getDtnombre().length() > 50) {
			consumidorReclamante.setDtnombre(consumidorReclamante.getDtnombre().substring(0, 49));
		}

		consumidorReclamante.setDtapellido1(reclamante.getApe1());
		consumidorReclamante.setDtapellido2(reclamante.getApe2());

		if (representanteReclamante == null) {
			consumidorReclamante.setDttecoem(email);
			consumidorReclamante.setDtnrtel(telefono);

			consumidorReclamante.setDtextranjero(esExtranjero);

			if (Y41bConstantes.VALOR_NO.equals(esExtranjero)) {
				// Nombre e Id de Provincia.
				if (reclamacionForm.get("holderchoiceProvinciaDomicilioSocial") != null
						&& !(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial").equalsIgnoreCase(""))) {
					consumidorReclamante
							.setDtnoraProvinciaId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					T17Provincia t17provincia = new T17Provincia();
					t17provincia.setId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17provincia = this.provinciaDao.find(t17provincia);
					consumidorReclamante.setDtnombreProvincia(t17provincia.getDsO());
				} else {
					consumidorReclamante.setDtnoraProvinciaId("");
					consumidorReclamante.setDtnombreProvincia("");
				}

				// Nombre e Id de Municipio.
				if (reclamacionForm.get("holderchoiceMunicipioDomicilioSocial") != null
						&& !(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial").equalsIgnoreCase(""))) {

					consumidorReclamante
							.setDtnoraMunicipioId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"));
					T17Municipio t17municipio = new T17Municipio();
					t17municipio.setId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"));
					t17municipio.setProvinciaId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17municipio = this.municipioDao.find(t17municipio);
					consumidorReclamante.setDtnombreMunicipio(t17municipio.getDsO());
				} else {
					consumidorReclamante.setDtnoraMunicipioId("");
					consumidorReclamante.setDtnombreMunicipio("");
				}

				if (reclamacionForm.get("holderchoiceLocalidadDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"))) {
					// Nombre e Id de Localidad.
					consumidorReclamante
							.setDtnoraLocalidadId(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"));
					T17Localidad t17localidad = new T17Localidad();
					t17localidad.setId(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"));
					t17localidad = this.localidadDao.find(t17localidad);
					consumidorReclamante.setDtnombreLocalidad(t17localidad.getDsO());
				} else {
					consumidorReclamante.setDtnoraLocalidadId("");
					consumidorReclamante.setDtnombreLocalidad("");
				}

				// Otros.
				if (reclamacionForm.get("holderchoiceCpDomicilioSocial") != null
						&& !(reclamacionForm.get("holderchoiceCpDomicilioSocial").equalsIgnoreCase(""))) {
					consumidorReclamante.setDtnombreCp(reclamacionForm.get("holderchoiceCpDomicilioSocial"));
				} else {
					consumidorReclamante.setDtnombreCp("");
				}

				if (consumidorReclamante.getDtnoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
						|| consumidorReclamante.getDtnoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)
						|| consumidorReclamante.getDtnoraProvinciaId()
								.equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null
							&& !(reclamacionForm.get("holderchoiceCalleDomicilioSocial").equalsIgnoreCase(""))) {
						consumidorReclamante.setDtnombreCalle(reclamacionForm.get("holderchoiceCalleDomicilioSocial"));
					} else {
						consumidorReclamante.setDtnombreCalle("");
					}

					// 0193034-0171498

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocialCod") != null
							&& !(reclamacionForm.get("holderchoiceCalleDomicilioSocialCod").equalsIgnoreCase(""))) {
						consumidorReclamante
								.setDtnoraCalleId(reclamacionForm.get("holderchoiceCalleDomicilioSocialCod"));
					} else {
						consumidorReclamante.setDtnoraCalleId("");
					}

					T17Portal t17portal = null;
					if (reclamacionForm.get("holderchoicePortalDomicilioSocialCod") != null
							&& !(reclamacionForm.get("holderchoicePortalDomicilioSocialCod").equalsIgnoreCase(""))) {
						consumidorReclamante
								.setDtnoraPortalId(reclamacionForm.get("holderchoicePortalDomicilioSocialCod"));
						if (reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
								&& !(reclamacionForm.get("holderchoicePortalDomicilioSocial").equalsIgnoreCase(""))) {
							consumidorReclamante
									.setDtnombrePortal(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
						} else {
							consumidorReclamante.setDtnombrePortal("");
						}
					} else {
						consumidorReclamante.setDtnoraPortalId("");
					}

					if (Y41bUtils.isFilled(consumidorReclamante.getDtnoraCalleId())
							&& Y41bUtils.isFilled(reclamacionForm.get("holderchoicePortalDomicilioSocial"))
							&& Y41bUtils.isNumericShort(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {

						t17portal = new T17Portal();
						t17portal.setCalleId(new Long(consumidorReclamante.getDtnoraCalleId()));
						t17portal.setNumero(Short.parseShort(reclamacionForm.get("holderchoicePortalDomicilioSocial")));
						List<T17Portal> listaPortales = this.portalDao.findAll(t17portal, null);
						if (listaPortales != null && listaPortales.size() == 1) {
							consumidorReclamante.setDtnoraPortalId(listaPortales.get(0).getId().toString());
						}
						consumidorReclamante.setDtnombrePortal(String.valueOf(t17portal.getNumero()));

					}
					// 0193034-0171498

					// T17Portal t17portal = null;
					// if
					// (reclamacionForm.get("holderchoicePortalDomicilioSocial")
					// != null) {
					// try {
					// t17portal = new T17Portal();
					// t17portal.setNumero(new
					// Short(reclamacionForm.get("holderchoicePortalDomicilioSocial")));
					// t17portal = this.portalDao.findByNumero(t17portal);
					//
					// if (t17portal != null) {
					// consumidorReclamante.setDtnoraPortalId(t17portal.getId().toString());
					// consumidorReclamante.setDtnombrePortal(String.valueOf(t17portal.getNumero()));
					// }
					// } catch (NumberFormatException e) {
					// t17portal = null;
					// }
					// }

					StringBuilder dtNombrePiso = new StringBuilder("");
					if (t17portal == null && reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {
						dtNombrePiso.append(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoicePisoDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePisoDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoicePisoDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceLetraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceLetraDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoiceLetraDomicilioSocial"));
					}

					consumidorReclamante.setDtnombrePiso(dtNombrePiso.toString().trim());
				} else {
					StringBuilder dtdireccionNocapv = new StringBuilder("");

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceCalleDomicilioSocial"))) {
						dtdireccionNocapv.append(reclamacionForm.get("holderchoiceCalleDomicilioSocial"));
					}

					if (reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
					}

					if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"))) {
						dtdireccionNocapv.append(" ")
								.append(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoicePisoDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePisoDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoicePisoDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceLetraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceLetraDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoiceLetraDomicilioSocial"));
					}

					consumidorReclamante.setDtdireccion_nocapv(dtdireccionNocapv.toString().trim());
				}

			} else {
				// El reclamante es extranjero.

				if (reclamacionForm.get("holderchoicePaisDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoicePaisDomicilioSocial"))) {
					// Nombre e Id de Pais.
					T17Pais t17pais = new T17Pais();
					t17pais.setId(reclamacionForm.get("holderchoicePaisDomicilioSocial"));
					t17pais = this.paisDao.find(t17pais);
					consumidorReclamante.setDtnoraPaisNombre(t17pais.getDsO());
					consumidorReclamante.setDtnoraPaisId(reclamacionForm.get("holderchoicePaisDomicilioSocial"));
				} else {
					consumidorReclamante.setDtnoraPaisNombre("");
					consumidorReclamante.setDtnoraPaisId("");
				}

				if (reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"))) {
					consumidorReclamante.setDtdireccion_nocapv(
							reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"));
				} else {
					consumidorReclamante.setDtdireccion_nocapv("");
				}

				if (reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"))) {

					consumidorReclamante
							.setDtnombreCp(reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"));
				} else {
					consumidorReclamante.setDtnombreCp("");
				}

			}
		}

		// Buscamos el reclamante en la db.
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtnif(reclamante.getID());

		List<Consumidor> listConsumidor = this.consumidorDao.findAllLikeConsumidor(consumidorAux, null, false);
		if (listConsumidor == null || listConsumidor.size() == 0) {

			// Si no existe se inserta el consumidor.
			consumidorReclamante.setDtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			this.consumidorDao.add(consumidorReclamante);

			solicitudDetalle.setDtcodigo(consumidorReclamante.getDtcodigo());

		} else {

			// Si tiene representante, solo se actualizan nombre,
			// apellidos
			// y nif del consumidor recuperado.
			if (representanteReclamante != null) {
				consumidorAux.setDtcodigo(listConsumidor.get(0).getDtcodigo());
				consumidorAux.setDtnombre(reclamante.getName());
				consumidorAux.setDtnif(reclamante.getID());
				consumidorAux.setDtapellido1(reclamante.getApe1());
				consumidorAux.setDtapellido2(reclamante.getApe2());

				this.consumidorDao.updateNombreApellidos(consumidorAux);
			} else {

				// consumidorReclamante es donde se han metido todos los datos
				// del holderChoice

				consumidorAux = consumidorReclamante;

				// consumidor - si esta en el censo - y no tiene representante
				// dire
				// comprobar que es direccion completa

				boolean varTieneDireccionCompleta = true;

				if (consumidorAux.getDtextranjero() != null
						&& consumidorAux.getDtextranjero().equalsIgnoreCase(Y41bConstantes.SI)) {
					if (consumidorAux.getDtnoraPaisNombre() != null
							&& !(consumidorAux.getDtnoraPaisNombre().equalsIgnoreCase(""))
							&& consumidorAux.getDtnombreCalle() != null
							&& !(consumidorAux.getDtnombreCalle().equalsIgnoreCase(""))) {
						varTieneDireccionCompleta = true;
					} else {
						varTieneDireccionCompleta = false;
					}
				} else {
					if (consumidorAux.getDtnombreProvincia() != null
							&& !(consumidorAux.getDtnombreProvincia().equalsIgnoreCase(""))
							&& consumidorAux.getDtnombreMunicipio() != null
							&& !(consumidorAux.getDtnombreMunicipio().equalsIgnoreCase(""))
							&& consumidorAux.getDtnombreCalle() != null
							&& !(consumidorAux.getDtnombreCalle().equalsIgnoreCase(""))) {
						// && intervinientesAux.getNombrePortal()!=null &&
						// !(intervinientesAux.getNombrePortal().equalsIgnoreCase(""))
						varTieneDireccionCompleta = true;
						// si NO es de capv
					} else if (consumidorAux.getDtdireccion_nocapv() != null
							&& !(consumidorAux.getDtdireccion_nocapv().equalsIgnoreCase(""))) {
						varTieneDireccionCompleta = true;
					} else {
						varTieneDireccionCompleta = false;
					}
				}

				if (varTieneDireccionCompleta) {
					this.consumidorDao.updateConsumidorTelematico(consumidorAux);
				}
			}

			solicitudDetalle.setDtcodigo(listConsumidor.get(0).getDtcodigo());
		}

		return solicitudDetalle;
	}

	/**
	 * Metodo que procesa los datos del titular de una solicitud telematica de
	 * una empresa
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param reclamante
	 *            InterestedRRI
	 * @param representanteReclamante
	 *            RepresentativeRRI
	 * @param reclamacionForm
	 *            Map<String, String>
	 * @param email
	 *            String
	 * @param telefono
	 *            String
	 * 
	 * @return SolicitudDetalle
	 */
	private SolicitudDetalle procesarTitularSolicitudEmpresa(SolicitudDetalle solicitudDetalle,
			InterestedRRI reclamante, RepresentativeRRI representanteReclamante, Map<String, String> reclamacionForm,
			String email, String telefono) {

		String esExtranjero = Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_SI.equals(
				reclamacionForm.get("datoschoiceExtranjero")) ? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
		solicitudDetalle.setDtextranjero(esExtranjero);

		solicitudDetalle.setHddenunciaaaccempresas(Y41bConstantes.VALOR_SI);
		solicitudDetalle.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_DENUNCIA);

		StringBuilder reclamanteNombre = new StringBuilder(reclamante.getID());

		if (reclamante.getName() != null && !"".equals(reclamante.getName())) {
			reclamanteNombre.append(" ").append(reclamante.getName());
		}
		if (reclamante.getApe1() != null && !"".equals(reclamante.getApe1())) {
			reclamanteNombre.append(" ").append(reclamante.getApe1());
		}
		if (reclamante.getApe2() != null && !"".equals(reclamante.getApe2())) {
			reclamanteNombre.append(" ").append(reclamante.getApe2());
		}
		solicitudDetalle.setDenombretelematico(reclamanteNombre.toString());

		if (representanteReclamante == null) {

			StringBuilder reclamanteDireccion = new StringBuilder();

			if (Y41bUtils.isFilled(email)) {
				reclamanteDireccion.append(email).append("\n");
			}

			if (Y41bUtils.isFilled(telefono)) {
				reclamanteDireccion.append(telefono).append("\n");
			}

			if (Y41bConstantes.VALOR_NO.equals(esExtranjero)) {

				if (reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceCalleDomicilioSocial"))) {
					reclamanteDireccion.append(reclamacionForm.get("holderchoiceCalleDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {
					reclamanteDireccion.append(" ").append(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"))) {
					reclamanteDireccion.append(" ").append(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoicePisoDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoicePisoDomicilioSocial"))) {
					reclamanteDireccion.append(" ").append(reclamacionForm.get("holderchoicePisoDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoiceLetraDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceLetraDomicilioSocial"))) {
					reclamanteDireccion.append(" ").append(reclamacionForm.get("holderchoiceLetraDomicilioSocial"));
				}

				reclamanteDireccion.append(", ");
				if (reclamacionForm.get("holderchoiceCpDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceCpDomicilioSocial"))) {
					reclamanteDireccion.append(reclamacionForm.get("holderchoiceCpDomicilioSocial"));
				}
				reclamanteDireccion.append(". ");

				if (reclamacionForm.get("holderchoiceLocalidadDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"))) {
					// Nombre de Localidad.
					T17Localidad t17localidad = new T17Localidad();
					t17localidad.setId(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"));
					t17localidad = this.localidadDao.find(t17localidad);
					reclamanteDireccion.append(t17localidad.getDsO() + "/");
				}

				// Nombre de Municipio.
				if (reclamacionForm.get("holderchoiceMunicipioDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"))) {
					T17Municipio t17municipio = new T17Municipio();
					t17municipio.setId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"));
					t17municipio.setProvinciaId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17municipio = this.municipioDao.find(t17municipio);
					reclamanteDireccion.append(t17municipio.getDsO() + ", ");
				}
				// Nombre de Provincia.
				if (reclamacionForm.get("holderchoiceProvinciaDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"))) {
					T17Provincia t17provincia = new T17Provincia();
					t17provincia.setId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17provincia = this.provinciaDao.find(t17provincia);
					reclamanteDireccion.append(t17provincia.getDsO());
				}

			} else {
				// El reclamante es extranjero.
				if (reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"))) {
					reclamanteDireccion.append(reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"))) {
					reclamanteDireccion
							.append(" - " + reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"));
				}
				if (reclamacionForm.get("holderchoicePaisDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoicePaisDomicilioSocial"))) {
					T17Pais t17pais = new T17Pais();
					t17pais.setId(reclamacionForm.get("holderchoicePaisDomicilioSocial"));
					t17pais = this.paisDao.find(t17pais);
					reclamanteDireccion.append(". " + t17pais.getDsO());
				}
			}

			solicitudDetalle.setDedirecciontelematico(reclamanteDireccion.toString());
		}

		return solicitudDetalle;
	}

	/**
	 * Metodo que procesa los datos del representante de una solicitud
	 * telematica
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param representanteReclamante
	 *            RepresentativeRRI
	 * @param reclamacionForm
	 *            Map<String, String>
	 * @param email
	 *            String
	 * @param telefono
	 *            String
	 * 
	 * @return SolicitudDetalle
	 */
	private SolicitudDetalle procesarRepresentanteSolicitud(SolicitudDetalle solicitudDetalle,
			RepresentativeRRI representanteReclamante, Map<String, String> reclamacionForm, String email,
			String telefono) {

		String esExtranjero = Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_SI.equals(
				reclamacionForm.get("datoschoiceExtranjero")) ? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;
		solicitudDetalle.setDtextranjero(esExtranjero);

		// Representante reclamante.
		if (representanteReclamante != null) {
			Intervinientes representanteReclamanteInterv = new Intervinientes();
			representanteReclamanteInterv
					.setIdinterviniente(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			representanteReclamanteInterv
					.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);

			representanteReclamanteInterv.setNombre(representanteReclamante.getName());
			representanteReclamanteInterv.setApellido1(representanteReclamante.getApe1());
			representanteReclamanteInterv.setApellido2(representanteReclamante.getApe2());
			representanteReclamanteInterv.setNif(representanteReclamante.getID());

			representanteReclamanteInterv.setCoem(email);
			representanteReclamanteInterv.setNrtel(telefono);

			representanteReclamanteInterv.setExtranjero(esExtranjero);

			if (Y41bConstantes.VALOR_NO.equals(esExtranjero)) {
				// Nombre e Id de Provincia.

				if (reclamacionForm.get("holderchoiceProvinciaDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"))) {
					representanteReclamanteInterv
							.setNoraProvinciaId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					T17Provincia t17provincia = new T17Provincia();
					t17provincia.setId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17provincia = this.provinciaDao.find(t17provincia);
					representanteReclamanteInterv.setNombreProvincia(t17provincia.getDsO());
				} else {
					representanteReclamanteInterv.setNoraProvinciaId("");
					representanteReclamanteInterv.setNombreProvincia("");
				}

				// Nombre e Id de Municipio.

				if (reclamacionForm.get("holderchoiceMunicipioDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"))) {
					representanteReclamanteInterv
							.setNoraMunicipioId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"));
					T17Municipio t17municipio = new T17Municipio();
					t17municipio.setId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocial"));
					t17municipio.setProvinciaId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocial"));
					t17municipio = this.municipioDao.find(t17municipio);
					representanteReclamanteInterv.setNombreMunicipio(t17municipio.getDsO());
				} else {
					representanteReclamanteInterv.setNoraMunicipioId("");
					representanteReclamanteInterv.setNombreMunicipio("");
				}

				if (reclamacionForm.get("holderchoiceLocalidadDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"))) {
					// Nombre e Id de Localidad.
					representanteReclamanteInterv
							.setNoraLocalidadId(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"));
					T17Localidad t17localidad = new T17Localidad();
					t17localidad.setId(reclamacionForm.get("holderchoiceLocalidadDomicilioSocial"));
					t17localidad = this.localidadDao.find(t17localidad);
					representanteReclamanteInterv.setNombreLocalidad(t17localidad.getDsO());
				} else {
					representanteReclamanteInterv.setNoraLocalidadId("");
					representanteReclamanteInterv.setNombreLocalidad("");
				}

				// Otros.
				if (reclamacionForm.get("holderchoiceCpDomicilioSocial") != null
						&& reclamacionForm.get("holderchoiceCpDomicilioSocial") != null) {
					representanteReclamanteInterv.setNombreCp(reclamacionForm.get("holderchoiceCpDomicilioSocial"));
				}

				if (representanteReclamanteInterv.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
						|| representanteReclamanteInterv.getNoraProvinciaId()
								.equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)
						|| representanteReclamanteInterv.getNoraProvinciaId()
								.equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null
							&& reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null) {
						representanteReclamanteInterv
								.setNombreCalle(reclamacionForm.get("holderchoiceCalleDomicilioSocial"));
					}

					// 0193034-0171498

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocialCod") != null
							&& reclamacionForm.get("holderchoiceCalleDomicilioSocialCod") != null) {
						representanteReclamanteInterv
								.setNoraCalleId(reclamacionForm.get("holderchoiceCalleDomicilioSocialCod"));
					}

					T17Portal t17portal = null;
					if (reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
							&& reclamacionForm.get("holderchoicePortalDomicilioSocialCod") != null) {
						representanteReclamanteInterv
								.setNoraPortalId(reclamacionForm.get("holderchoicePortalDomicilioSocialCod"));
						representanteReclamanteInterv
								.setNombrePortal(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
					} else if (Y41bUtils.isFilled(representanteReclamanteInterv.getNoraCalleId())
							&& Y41bUtils.isFilled(reclamacionForm.get("holderchoicePortalDomicilioSocial"))
							&& Y41bUtils.isNumericShort(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {

						t17portal = new T17Portal();
						t17portal.setCalleId(new Long(representanteReclamanteInterv.getNoraCalleId()));
						t17portal.setNumero(Short.parseShort(reclamacionForm.get("holderchoicePortalDomicilioSocial")));
						List<T17Portal> listaPortales = this.portalDao.findAll(t17portal, null);
						if (listaPortales != null && listaPortales.size() == 1) {
							representanteReclamanteInterv.setNoraPortalId(listaPortales.get(0).getId().toString());
						}
						representanteReclamanteInterv.setNombrePortal(String.valueOf(t17portal.getNumero()));

					}
					// 0193034-0171498

					// T17Portal t17portal = null;
					// if
					// (reclamacionForm.get("holderchoicePortalDomicilioSocial")
					// != null) {
					// try {
					// t17portal = new T17Portal();
					// t17portal.setNumero(new
					// Short(reclamacionForm.get("holderchoicePortalDomicilioSocial")));
					// t17portal = this.portalDao.findByNumero(t17portal);
					//
					// if (t17portal != null) {
					// representanteReclamanteInterv.setNoraPortalId(t17portal.getId().toString());
					// representanteReclamanteInterv.setNombrePortal(String.valueOf(t17portal.getNumero()));
					// }
					// } catch (NumberFormatException e) {
					// t17portal = null;
					// }
					// }

					StringBuilder dtNombrePiso = new StringBuilder("");
					if (t17portal == null && reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {
						dtNombrePiso.append(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoicePisoDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePisoDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoicePisoDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceLetraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceLetraDomicilioSocial"))) {
						dtNombrePiso.append(" ").append(reclamacionForm.get("holderchoiceLetraDomicilioSocial"));
					}

					representanteReclamanteInterv.setNombrePiso(dtNombrePiso.toString().trim());
				} else {
					StringBuilder dtdireccionNocapv = new StringBuilder("");

					if (reclamacionForm.get("holderchoiceCalleDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceCalleDomicilioSocial"))) {
						dtdireccionNocapv.append(reclamacionForm.get("holderchoiceCalleDomicilioSocial"));
					}

					if (reclamacionForm.get("holderchoicePortalDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePortalDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoicePortalDomicilioSocial"));
					}

					if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"))) {
						dtdireccionNocapv.append(" ")
								.append(reclamacionForm.get("holderchoiceEscaleraDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoicePisoDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoicePisoDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoicePisoDomicilioSocial"));
					}
					if (reclamacionForm.get("holderchoiceLetraDomicilioSocial") != null
							&& !"".equals(reclamacionForm.get("holderchoiceLetraDomicilioSocial"))) {
						dtdireccionNocapv.append(" ").append(reclamacionForm.get("holderchoiceLetraDomicilioSocial"));
					}

					representanteReclamanteInterv.setDireccionNocapv(dtdireccionNocapv.toString().trim());
				}

			} else {
				// El reclamante es extranjero.

				if (reclamacionForm.get("holderchoicePaisDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoicePaisDomicilioSocial"))) {

					// Nombre e Id de Pais.
					T17Pais t17pais = new T17Pais();
					t17pais.setId(reclamacionForm.get("holderchoicePaisDomicilioSocial"));
					t17pais = this.paisDao.find(t17pais);
					representanteReclamanteInterv.setNombrePais(t17pais.getDsO());
					representanteReclamanteInterv.setNoraPaisId(reclamacionForm.get("holderchoicePaisDomicilioSocial"));
				} else {
					representanteReclamanteInterv.setNombrePais("");
					representanteReclamanteInterv.setNoraPaisId("");
				}

				if (reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"))) {
					representanteReclamanteInterv
							.setDireccionNocapv(reclamacionForm.get("holderchoiceDireccionExtranjeroDomicilioSocial"));
				}

				if (reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial") != null
						&& !"".equals(reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"))) {

					representanteReclamanteInterv
							.setNombreCp(reclamacionForm.get("holderchoiceCodigoPostalExtranjeroDomicilioSocial"));
				}

			}

			representanteReclamanteInterv.setIdExpediente(solicitudDetalle.getHdcodigo());

			solicitudDetalle.setHddestnotificareclamante(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE);

			this.intervinientesDao.add(representanteReclamanteInterv);
		} else {
			solicitudDetalle.setHddestnotificareclamante(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);
		}

		return solicitudDetalle;
	}

	/**
	 * Metodo que procesa los datos del reclamdo de una solicitud telematica
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param reclamacionForm
	 *            Map<String, String>
	 * 
	 * @return SolicitudDetalle
	 */
	private SolicitudDetalle procesarReclamadoSolicitud(SolicitudDetalle solicitudDetalle,
			Map<String, String> reclamacionForm) {
		// Se guarda el representante en los campos telematicos.
		String esEmpresa = (Y41bConstantes.RECLAMACION_TOOLKIT_TIPODENUNCIA_EMPRESA
				.equals(reclamacionForm.get("datoschoiceTipoDenuncia")) ? "AACC" : "");
		StringBuilder reclamadoNombre = new StringBuilder("");

		if (reclamacionForm.get("holderEmpresaDenunciadaCIF" + esEmpresa) != null
				&& !"".equals(reclamacionForm.get("holderEmpresaDenunciadaCIF" + esEmpresa))) {
			reclamadoNombre.append(reclamacionForm.get("holderEmpresaDenunciadaCIF" + esEmpresa));
		}

		if (reclamacionForm.get("holderEmpresaDenunciadaNombreComercial" + esEmpresa) != null
				&& !"".equals(reclamacionForm.get("holderEmpresaDenunciadaNombreComercial" + esEmpresa))) {
			reclamadoNombre.append(" " + reclamacionForm.get("holderEmpresaDenunciadaNombreComercial" + esEmpresa));
		}

		if (reclamacionForm.get("holderEmpresaDenunciadaRazonSocial" + esEmpresa) != null
				&& !"".equals(reclamacionForm.get("holderEmpresaDenunciadaRazonSocial" + esEmpresa))) {
			reclamadoNombre.append(" " + reclamacionForm.get("holderEmpresaDenunciadaRazonSocial" + esEmpresa));
		}

		solicitudDetalle.setHdesnombretelematico(reclamadoNombre.toString());

		solicitudDetalle.setHddestnotificareclamado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);

		StringBuilder reclamadoDireccion = new StringBuilder();

		if (Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_NO
				.equals(reclamacionForm.get("datoschoiceExtranjeroEmpresaDenunciada" + esEmpresa))) {
			// El reclamado es local
			reclamadoDireccion
					.append(reclamacionForm.get("holderchoiceCalleDomicilioSocialEmpresaDenunciada" + esEmpresa));

			if (reclamacionForm.get("holderchoicePortalDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoicePortalDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(" ")
						.append(reclamacionForm.get("holderchoicePortalDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}
			if (reclamacionForm.get("holderchoiceEscaleraDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoiceEscaleraDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(" ").append(
						reclamacionForm.get("holderchoiceEscaleraDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}
			if (reclamacionForm.get("holderchoicePisoDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoicePisoDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(" ")
						.append(reclamacionForm.get("holderchoicePisoDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}
			if (reclamacionForm.get("holderchoiceLetraDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoiceLetraDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(" ")
						.append(reclamacionForm.get("holderchoiceLetraDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}

			reclamadoDireccion.append(", ");
			reclamadoDireccion
					.append(reclamacionForm.get("holderchoiceCpDomicilioSocialEmpresaDenunciada" + esEmpresa));
			reclamadoDireccion.append(". ");

			if (reclamacionForm.get("holderchoiceLocalidadDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoiceLocalidadDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				// Nombre de Localidad.
				T17Localidad t17localidad = new T17Localidad();
				t17localidad.setId(
						reclamacionForm.get("holderchoiceLocalidadDomicilioSocialEmpresaDenunciada" + esEmpresa));
				t17localidad = this.localidadDao.find(t17localidad);
				reclamadoDireccion.append(t17localidad.getDsO() + " ");

				if (t17localidad.getDsO() != null && !"".equals(t17localidad.getDsO())) {
					reclamadoDireccion.append("/");
				}
			}

			// Nombre de Municipio.
			T17Municipio t17municipio = new T17Municipio();
			t17municipio
					.setId(reclamacionForm.get("holderchoiceMunicipioDomicilioSocialEmpresaDenunciada" + esEmpresa));
			t17municipio.setProvinciaId(
					reclamacionForm.get("holderchoiceProvinciaDomicilioSocialEmpresaDenunciada" + esEmpresa));
			t17municipio = this.municipioDao.find(t17municipio);
			reclamadoDireccion.append(t17municipio.getDsO() + ", ");

			T17Provincia t17provincia = new T17Provincia();
			t17provincia
					.setId(reclamacionForm.get("holderchoiceProvinciaDomicilioSocialEmpresaDenunciada" + esEmpresa));
			t17provincia = this.provinciaDao.find(t17provincia);
			reclamadoDireccion.append(t17provincia.getDsO());

		} else if (Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_SI
				.equals(reclamacionForm.get("datoschoiceExtranjeroEmpresaDenunciada" + esEmpresa))) {
			// El reclamado es extranjero.
			if (reclamacionForm
					.get("holderchoiceDireccionExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa) != null
					&& !"".equals(reclamacionForm
							.get("holderchoiceDireccionExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(reclamacionForm
						.get("holderchoiceDireccionExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}
			if (reclamacionForm
					.get("holderchoiceCodigoPostalExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa) != null
					&& !"".equals(reclamacionForm
							.get("holderchoiceCodigoPostalExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa))) {
				reclamadoDireccion.append(" - " + reclamacionForm
						.get("holderchoiceCodigoPostalExtranjeroDomicilioSocialEmpresaDenunciada" + esEmpresa));
			}

			if (reclamacionForm.get("holderchoicePaisDomicilioSocialEmpresaDenunciada" + esEmpresa) != null && !""
					.equals(reclamacionForm.get("holderchoicePaisDomicilioSocialEmpresaDenunciada" + esEmpresa))) {

				T17Pais t17pais = new T17Pais();
				t17pais.setId(reclamacionForm.get("holderchoicePaisDomicilioSocialEmpresaDenunciada" + esEmpresa));
				t17pais = this.paisDao.find(t17pais);
				reclamadoDireccion.append(". " + t17pais.getDsO());
			}
		} else if (Y41bConstantes.RECLAMACION_TOOLKIT_ESEXTRANJERO_OTROSDATOS
				.equals(reclamacionForm.get("datoschoiceExtranjeroEmpresaDenunciada" + esEmpresa))) {
			// Es otros datos de localizacion
			reclamadoDireccion.append(
					reclamacionForm.get("holderchoiceDireccionOtrosDatosLocalizacionEmpresaDenunciada" + esEmpresa));
		}

		solicitudDetalle.setHdesdirecciontelematico(reclamadoDireccion.toString());

		return solicitudDetalle;
	}

	/**
	 * Metodo que procesa los datos del reclamdo de una solicitud telematica
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param representanteReclamante
	 *            RepresentativeRRI
	 * @param listDocumento
	 *            List<Documento>
	 */
	private void procesarDocumentosSolicitud(SolicitudDetalle solicitudDetalle,
			RepresentativeRRI representanteReclamante, List<Documento> listDocumento) {

		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
		tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);

		if (listDocumento.size() > 1) {
			String tipodocumento = null;
			for (Documento documento : listDocumento) {
				if (Y41bUtils.isFilled(documento.getOidDokusi())) {
					Documento documentoAux = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documentoAux.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documentoAux.setProcedure(procedure);
					documentoAux.setOidDokusi(documento.getOidDokusi());

					// Recuperar el documento de dokusi
					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documentoAux);

					// Insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());
					documentoHecho.setQ5tedesfile(documento.getDescripcion());
					documentoHecho.setQ5iddocumentum(documento.getOidDokusi());

					if (documento.getTipoDocumental() != null) {
						tipodocumento = this.getTipoDocumento(documento.getTipoDocumental());
					}
					documentoHecho.setQ5idTipodoc(tipodocumento);
					documentoHecho.setQ5nofile(docDokusi.getNombre());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5fecha(new Date());
					documentoHecho.setQ5fechaentrada(new Date());
					documentoHecho.setQ5fechaaportacion(new Date());

					if (representanteReclamante != null) {
						documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
					} else {
						documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
					}

					documentoHecho.setQ5tramite(tramiteHechoDetalle.getEhcodigo());

					this.documentoHechoDao.add(documentoHecho);

					// Insertar los documentos en la tabla intermedia
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteHechoDetalle.getEhcodigo());
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}
	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		} else {
			String asuntodocumental = tokCadena.nextToken();
			if (asuntodocumental != null && !asuntodocumental.equals("0")) {
				tipo = roleId;
			}
		}

		return tipo;
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param listDocumento
	 *            List<Documento>
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle enviarSolicitudTelematicaANTERIOR(SolicitudDetalle solicitudDetalle,
			List<Documento> listDocumento) throws Exception {

		SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
		try {
			// Grabar el campo HDTE (problema de los campos tipo Long a traves
			// de DBLink)
			solicitudDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporalTelematica(solicitudDetalle);

		} catch (EmptyResultDataAccessException e) {
			// Si la solicitud no existe devolvemos la solicitud vacía
			return solicitudDetalleAux;
		}

		// buscar el interviniente interesado
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(solicitudDetalleAux.getHdcodigo());
		intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao
				.findAllIntervinientesTelematicos(intervinientesAux, null);

		if (listIntervinientes == null || listIntervinientes.size() > 0) {
			solicitudDetalleAux.setDtnif(listIntervinientes.get(0).getNif());
		}

		// buscar por dni el consumidor
		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtnif(solicitudDetalleAux.getDtnif());

		List<Consumidor> listConsumidor = this.consumidorDao.findAllLikeConsumidor(consumidorAux, null, false);

		if (listConsumidor == null || listConsumidor.size() == 0) {
			solicitudDetalleAux.setDtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			// si no existe se inserta
			// insertar el consumidor
			this.consumidorDao.enviarConsumidorTelematico(solicitudDetalleAux);
			solicitudDetalle.setDtcodigo(solicitudDetalleAux.getDtcodigo());
		} else {
			for (Consumidor consumi : listConsumidor) {

				SolicitudDetalle solDetalleAux = new SolicitudDetalle();
				solDetalleAux.setHdcodigo(solicitudDetalleAux.getHdcodigo());
				solDetalleAux.setDtcodigo(consumi.getDtcodigo());

				this.consumidorDao.actualizarConsumidorTelematico(solDetalleAux);

				solicitudDetalle.setDtcodigo(consumi.getDtcodigo());
			}
		}

		// insertar la denuncia telematica en denuncias
		this.denunciaDao.enviarDenunciaTelematica(solicitudDetalle);

		// insertar el hecho denunciado telematica en hecho denunciado
		this.hechoDenunciadoDao.enviarHechoDenunciadoTelematico(solicitudDetalle);

		// Grabar el campo HDTE (problema de los campos tipo Long a traves de
		// DBLink)
		this.hechoDenunciadoDao.updateHDTE(solicitudDetalleAux);

		// insertar los documentos de la solicitud telematica en documentos de
		// solicitudes
		// this.documentoHechoDao.enviarDocumentosSolicitudTelematica(solicitudDetalleAux);

		// buscar la solicitud
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);

		for (Documento documentoAux : listDocumento) {
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			documento.setProcedure(procedure);
			documento.setOidDokusi(documentoAux.getOidDokusi());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			// insertar el documento
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
			documentoHecho.setQ5hdcodigo(solDetalle.getHdcodigo());
			documentoHecho.setQ5nofile(docDokusi.getNombre());
			documentoHecho.setQ5tedesfile(documentoAux.getDescripcion());
			documentoHecho.setQ5iddocumentum(documentoAux.getOidDokusi());
			documentoHecho.setQ5sizefile((int) docDokusi.getLength());
			// Blob blob = new
			// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			// documentoHecho.setQ5datafile(blob);
			documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
			documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

			documentoHecho.setQ5fecha(new Date());
			documentoHecho.setQ5fechaaportacion(new Date());

			documentoHecho.setQ5fechaentrada(new Date());
			documentoHecho.setQ5fechaaportacion(new Date());

			documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);

			this.documentoHechoDao.add(documentoHecho);
		}

		// Alta de interviniente consumidor
		Consumidor consumidor = new Consumidor();
		consumidor.setDtcodigo(solDetalle.getDtcodigo());

		consumidor = this.consumidorDao.find(consumidor);

		Intervinientes intervinientes = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), consumidor.getDtcodigo(), null, null,
				consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
				consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
				consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
				consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
				consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(), consumidor.getDtnoraMunicipioId(),
				consumidor.getDtnombreMunicipio(), consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
				consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
				consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
				consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
				consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, solicitudDetalleAux.getHdcodigo(), null,
				consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
				consumidor.getCensoMonitor().getUsuarioxlnet());

		this.intervinientesDao.add(intervinientes);

		// insertar intervininete administrador
		// Alta interviniente administrador
		Organismo organismo = new Organismo();
		organismo.setCodOrg(solDetalle.getDecoor());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
				null, organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
				null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
				esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
				organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
				organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
				organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
				organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
				organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null, null,
				null);

		this.intervinientesDao.add(intervinientes);

		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setHdcodigo(solicitudDetalleAux.getHdcodigo());

		// Creacion de tramite de registro de solicitud pendiente de
		// tramitacion
		// Se devuelve el documentoHecho de la SOLICITUD
		TramiteHecho tramiteHecho = this.tramitarAddTramiteRegistroSolicitud(solicitudDetalleAux, hechoDenunciado);

		// Recuperar los documentos del expediente
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(solicitudDetalleAux.getHdcodigo());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosHecho(tramiteComun,
				null);

		DocumentoHecho documentoHecho = null;
		DocumentoTramiteHecho documentoTramiteHecho = null;
		for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
			documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(documentoExpediente.getCodocumento());
			documentoHecho.setQ5tramite(tramiteHecho.getEhcodigo());

			// update del q5tramite
			this.documentoHechoDao.updateTramite(documentoHecho);

			// insertar los documentos en la tabla intermedia
			documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(tramiteHecho.getEhcodigo());
			documentoTramiteHecho.setCodocumento(documentoExpediente.getCodocumento());
			documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
		}

		DecisionHecho decisionHecho = new DecisionHecho(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), solDetalle.getDecoor(), null, null,
				null, hechoDenunciado, null);

		// Da de alta una decision vacia
		this.decisionHechoDao.add(decisionHecho);

		// Actualizar ultimo tramite
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(hechoDenunciado.getHdcodigo());
		hechodenunciadoAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
		hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);

		// Tratar la bandeja
		this.tratamientoBandejaSolicitudes(hechoDenunciado);

		// borrar los documentos telematicos
		this.documentoHechoDao.removeDocumentosSolicitudTelematica(solicitudDetalleAux);

		// borrar los intervinientes
		this.consumidorDao.removeConsumidorTelematico(solicitudDetalleAux);

		// borrar el hecho denunciado telematico
		this.hechoDenunciadoDao.removeHechoDenunciadoTelematico(solicitudDetalleAux);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		// borrar la denuncia telematica
		this.denunciaDao.removeDenunciaTelematica(solDetalle);

		// devolver la solicitud
		return solDetalle;
	}

	/**
	 * getXmlNegocioFromDocuments
	 * 
	 * @param solicitudID
	 *            String
	 * @return String
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	protected String getXmlNegocioFromDocuments(String solicitudID) throws Exception {
		logger.info("BackOfficeServiceImpl.getXmlNegocioFromDocuments - Inicio");
		try {
			if (solicitudID != null) {
				String ejgvStr = this.y41bPlateaAdapterService.getRequestInformation(solicitudID, null);

				return Y41bEjgvUtils.getDetailInfo(ejgvStr);
			}
			throw new Y41bUDAException("error.platea.parseXml", false, new Exception());

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e_getXmlNegocioFromDocuments) {
			logger.error("BackOfficeServiceImpl.getXmlNegocioFromDocuments", e_getXmlNegocioFromDocuments);
			throw new Y41bUDAException("error.platea.invocation", true, e_getXmlNegocioFromDocuments);
		} finally {
			logger.info("BackOfficeServiceImpl.getXmlNegocioFromDocuments - Final");
		}
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(SolicitudDetalle solicitudDetalle,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception {

		try {
			logger.info("generarTramiteAportacionDocumentacion - Inicio");

			solicitudDetalle = this.hechoDenunciadoDao.findSolicitudByNumeroExpediente(solicitudDetalle);

			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramitehecho.setEhcohd(solicitudDetalle.getHdcodigo());
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);

			// Evita problemas con las fechas desde hasta
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
			tramitehecho.setEhfecha(todayWithZeroTime);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			tramitehecho.setEhhora(ehhora);
			tramitehecho.setEhfechainicio(todayWithZeroTime);
			tramitehecho.setEhistelematico(Y41bConstantes.VALOR_SI);
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			this.tramiteHechoService.addTramiteHecho(tramitehecho);

			// buscar el interviniente por el DNI
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setNif(mensajeAportacionDoc.getSender());
			intervinientes.setIdExpediente(solicitudDetalle.getHdcodigo());
			intervinientes = this.intervinientesDao.findIntervinienteByNif(intervinientes);

			List<Documento> listDocumentos = mensajeAportacionDoc.getDocumentosAportados();

			String tipodocumento = "";

			for (Documento documentoAux : listDocumentos) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);

					// insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());
					documentoHecho.setQ5nofile(docDokusi.getNombre());
					documentoHecho.setQ5tedesfile(documentoAux.getDescripcion());
					documentoHecho.setQ5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setQ5datafile(blob);
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null) {
						if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO);
						} else {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS);
						}
					}

					documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());

					SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
							Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					Date dateFechaRegistro = formatterFechaRegistro
							.parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					documentoHecho.setQ5fecha(dateFechaRegistro);
					documentoHecho.setQ5fechaaportacion(dateFechaRegistro);
					documentoHecho.setQ5tramite(tramitehecho.getEhcodigo());

					documentoHecho.setQ5fechaentrada(dateFechaRegistro);
					documentoHecho.setQ5numregistroentrada(mensajeAportacionDoc.getRegistro().getRegistryNumber());

					if (documentoAux.getTipoDocumental() != null) {
						tipodocumento = this.getTipoDocumento(documentoAux.getTipoDocumental());
					}
					documentoHecho.setQ5idTipodoc(tipodocumento);

					this.documentoHechoDao.add(documentoHecho);

					// insertar en la tabla de relacion
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramitehecho.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			this.actualizarMisGestionesAportaciondocumentacion(tramitehecho, listDocumentoHecho);

			// Actualizar ultimo tramite
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(solicitudDetalle.getHdcodigo());
			hechoDenunciado.setTrcodigoactual(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);

			this.hechoDenunciadoDao.updateUltimoTramiteGenerico(hechoDenunciado);

			// Tratar la bandeja
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(solicitudDetalle.getHdcodigo());
			this.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacion - Final");
		}

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesAportaciondocumentacion(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception {

		// Obtengo la información del expediente
		SolicitudDetalle solDetalle = new SolicitudDetalle();
		solDetalle.setHdcodigo(tramitehecho.getEhcohd());

		SolicitudDetalle solicitudDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);

		int reclamante = 0;
		int reclamado = 0;
		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			if (documentoHechoAux.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
					|| documentoHechoAux.getQ5origen()
							.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE)) {
				reclamante++;
			} else if (documentoHechoAux.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
					|| documentoHechoAux.getQ5origen()
							.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO)) {
				reclamado++;
			}
		}

		if (reclamante > 0) {
			this.actualizarMisGestionesAportaciondocumentacionReclamante(tramitehecho, solicitudDetalle,
					listDocumentoHecho);
		}

		if (reclamado > 0) {
			this.actualizarMisGestionesAportaciondocumentacionReclamado(tramitehecho, solicitudDetalle,
					listDocumentoHecho);
		}

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado por el reclamante
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarMisGestionesAportaciondocumentacionReclamante(TramiteHecho tramitehecho,
			SolicitudDetalle solicitudDetalle, List<DocumentoHecho> listDocumentoHecho) throws Exception {

		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamante());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getDtnif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(solicitudDetalle.getDtnombre());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido1());
		}

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido2())) {
			nombreCompleto.append(" ").append(solicitudDetalle.getDtapellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(solicitudDetalle.getDtapellido1())) {
			datosPersona.setApellido1(solicitudDetalle.getDtapellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bUtils.isFilled(tramitehecho.getEhproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		List<Documento> listaDocumentosRdo = null;
		Date fechaAportacion = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE))) {
					if (fechaAportacion == null) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					} else if (documentoHecho.getQ5fechaentrada() != null
							&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					}
					documento = new Documento();
					documento.setNombre(documentoHecho.getQ5nofile());
					documento.setDescripcion(documentoHecho.getQ5tedesfile());
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
					documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
					listaDocumentosRdo.add(documento);
				}
			}
		}

		Calendar aportacionTimestamp = Calendar.getInstance();

		String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, Y41bConstantes.CASTELLANO);

		String fechaAportacionConHoras = "";

		DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

		fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
				.append(hourFormat.format(tramitehecho.getEhfechainicio())).toString();
		aportacionTimestamp
				.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

		actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

		// Los documentos son de origen interesado
		if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {
			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
			// y41bPlateaAdapterService.actualizarMisGestionesX43(actualizarMisGestiones);

			tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado por el reclamado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarMisGestionesAportaciondocumentacionReclamado(TramiteHecho tramitehecho,
			SolicitudDetalle solicitudDetalle, List<DocumentoHecho> listDocumentoHecho) throws Exception {
		tramitehecho = this.tramiteHechoDao.find(tramitehecho);

		if (solicitudDetalle.getHdparticipacionreclamado() == null
				|| solicitudDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_NO)) {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(tramitehecho.getEhcohd());
			this.soltramexpService.actualizarParticipacionReclamado(tramiteComun);

			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(tramitehecho.getEhcohd());
			hechodenunciado.setHdparticipacionreclamado(Y41bConstantes.VALOR_SI);
			this.hechoDenunciadoDao.updateParticipacionReclamado(hechodenunciado);

		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(solicitudDetalle.getHdidparticipacionreclamado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(solicitudDetalle.getEsnif());

		StringBuffer nombreCompleto = new StringBuffer();
		nombreCompleto.append(solicitudDetalle.getEsnombre());

		datosPersona.setNombre(nombreCompleto.toString());

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solicitudDetalle.getDecoor())
				.append("-").append(solicitudDetalle.getDenror()).append("-").append(solicitudDetalle.getDenran())
				.append("-").append(solicitudDetalle.getHdnror());

		actualizarMisGestiones.setEjercicio(solicitudDetalle.getDenran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bUtils.isFilled(tramitehecho.getEhproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(tramitehecho.getEhproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteHechoService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		List<Documento> listaDocumentosRdo = null;
		Date fechaAportacion = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO))) {
					if (fechaAportacion == null) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					} else if (documentoHecho.getQ5fechaentrada() != null
							&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					}
					documento = new Documento();
					documento.setNombre(documentoHecho.getQ5nofile());
					documento.setDescripcion(documentoHecho.getQ5tedesfile());
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
					documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
					listaDocumentosRdo.add(documento);
				}
			}
		}

		Calendar aportacionTimestamp = Calendar.getInstance();

		String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, Y41bConstantes.CASTELLANO);

		String fechaAportacionConHoras = "";

		DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

		fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
				.append(hourFormat.format(tramitehecho.getEhfechainicio())).toString();
		aportacionTimestamp
				.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

		actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

		// Los documentos son de origen interesado
		if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {
			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);

			tramitehecho.setEhproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteHechoDao.updateProceedingsIdPlatea(tramitehecho);
		}
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia update(Denuncia denuncia) {
		return this.denunciaDao.update(denuncia);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle updateSolicitud(SolicitudDetalle solicitudDetalle) {

		try {

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(solicitudDetalle.getTfpcodigo());

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solicitudDetalle.getDtcodigo());

			Denuncia denuncia = new Denuncia(solicitudDetalle.getDecodigo(), null, solicitudDetalle.getDecoor(),
					solicitudDetalle.getDenran(), solicitudDetalle.getDenror(), solicitudDetalle.getDefede(),
					solicitudDetalle.getDefere(), null, null, Y41bConstantes.VALOR_NO, null, formaPresentacion,
					consumidor);
			denuncia.setDehojareclamacion(solicitudDetalle.getDehojareclamacion());

			// Modifica una denuncia
			this.denunciaDao.update(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solicitudDetalle.getEscodigo());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solicitudDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solicitudDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solicitudDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solicitudDetalle.getTircodigo());

			String hdinsoma = Y41bConstantes.SOLICITUD_MEDIACION;

			if (solDetalle.getHdinsoma() != null
					&& solDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
				hdinsoma = Y41bConstantes.SOLICITUD_ARBITRAJE;
			}

			HechoDenunciado hechoDenunciado = new HechoDenunciado(solicitudDetalle.getHdcodigo(),
					solicitudDetalle.getHdnror(), solicitudDetalle.getHdte(), null, null, solicitudDetalle.getHdnops(),
					solicitudDetalle.getHdnomaps(), solicitudDetalle.getHdnomops(), solicitudDetalle.getHdnrlops(),
					solicitudDetalle.getHdcodigobarras(), solicitudDetalle.getHdfedmps(), null, hdinsoma,
					solicitudDetalle.getHdcaptso(), solicitudDetalle.getHdteso(), null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, solicitudDetalle.getHdcosc(), null, null, null, null, null, null,
					solicitudDetalle.getHdfehd(), null, null, null, null, null, null, null, null, null,
					Y41bConstantes.SI, solicitudDetalle.getHdformanotificacion(),
					solicitudDetalle.getHdformanotificacionestablecimiento(),
					solicitudDetalle.getHdcodexpedienteorigen(), solicitudDetalle.getNumregistroentrada(), null, null,
					solicitudDetalle.getHdinteresado(), denuncia, establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo);

			hechoDenunciado.setHdidioma(solicitudDetalle.getHdidioma());
			hechoDenunciado.setHdidiomareclamado(solicitudDetalle.getHdidiomareclamado());

			hechoDenunciado.setHdnumregistroentradaorigen(solicitudDetalle.getHdnumregistroentradaorigen());
			hechoDenunciado.setHdfecharegistroorigen(solicitudDetalle.getHdfecharegistroorigen());
			hechoDenunciado.setHdformaventa(solicitudDetalle.getFvcodigo());
			hechoDenunciado.setHdtipodenunciante(solicitudDetalle.getHdtipodenunciante());

			hechoDenunciado.setHddestnotificareclamante(solicitudDetalle.getHddestnotificareclamante());
			hechoDenunciado.setHddestnotificareclamado(solicitudDetalle.getHddestnotificareclamado());

			// Actualiza el hecho denunciado.
			this.hechoDenunciadoDao.update(hechoDenunciado);

			// Descriptores
			String idsDescriptores = solicitudDetalle.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}

			solicitudDetalle.setDescriptores(descriptores);

			// Descriptores
			this.hechoDenunciadoDao.removeAllHechoDenunciadoDescriptor(solicitudDetalle);
			this.hechoDenunciadoDao.addHechoDenunciadoDescriptor(solicitudDetalle);

			// Comprobar que el nif del reclamante y el del telematico es el
			// mismo.
			if (solDetalle.getDenombretelematico() != null && !"".equals(solDetalle.getDenombretelematico())) {
				String nifTelematico = solDetalle.getDenombretelematico();
				int num = nifTelematico.indexOf(" ");
				if ((Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solDetalle.getTfpcodigo())
						|| Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO.equals(solDetalle.getTfpcodigo()))
						&& num > 0) {
					nifTelematico = nifTelematico.substring(0, num);
					if (nifTelematico != null && !"".equals(nifTelematico)
							&& !nifTelematico.equals(solicitudDetalle.getDtnif())) {
						throw new Y41bUDAException("error.solicitud.nifReclamanteYTelematicoDiferentesException", true,
								new Exception());
					}
				}
			}

			// buscar el interviniente interesado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(solicitudDetalle.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			// Dependiendo del tipo denunciante...
			Intervinientes intervinientesAux = null;
			StringBuffer sbPerson = new StringBuffer();
			if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_AACC.equals(solicitudDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OOEE.equals(solicitudDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OTRAS.equals(solicitudDetalle.getHdtipodenunciante())) {

				// Modificacion interviniente organismo
				Organismo organismo = new Organismo();
				organismo.setEntidadId(solicitudDetalle.getDtcodigo());

				organismo = this.organismoDao.findOrganismoById(organismo);

				// si est el tramite de registro de solicitud tramitado
				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null
						&& solDetalle.getDtnif() != null && !solDetalle.getDtnif().equals(organismo.getCif())) {
					throw new Y41bUDAException("error.solicitud.nifReclamanteDiferenteException", true,
							new Exception());
				}

				if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getReclamanteCambio())) {
					if (listIntervinientes.size() > 0) {
						intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(),
								solicitudDetalle.getDtcodigo(), null, organismo.getEntidadId(), organismo.getNombreEs(),
								null, null, null, null, organismo.getCif(), null, null, null, organismo.getUrl(), null,
								null, organismo.getTelefono(), null, organismo.getEmail(), null,
								organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
								organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
								organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
								organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
								organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
								organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
								organismo.getNombreCalle(), null, null, null, null, null,
								Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, intervinientes.getIdExpediente(), null,
								null, null, null);

						this.intervinientesDao.update(intervinientesAux);
					} else {
						intervinientesAux = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
								solicitudDetalle.getDtcodigo(), null, organismo.getEntidadId(), organismo.getNombreEs(),
								null, null, null, null, organismo.getCif(), null, null, null, organismo.getUrl(), null,
								null, organismo.getTelefono(), null, organismo.getEmail(), null,
								organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
								organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
								organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
								organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
								organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
								organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
								organismo.getNombreCalle(), null, null, null, null, null,
								Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, intervinientes.getIdExpediente(), null,
								null, null, null);

						this.intervinientesDao.add(intervinientesAux);
						this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);
					}
				}

				if (Y41bUtils.isFilled(organismo.getCif())) {
					sbPerson.append(organismo.getCif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(organismo.getNombreEs())) {
					sbPerson.append(organismo.getNombreEs());
					sbPerson.append(" ");
				}
			} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS
					.equals(solicitudDetalle.getHdtipodenunciante())) {

				// Modificacion interviniente establecimiento
				Establecimiento establecimientoAux = new Establecimiento();
				establecimientoAux.setEscodigo(solicitudDetalle.getDtcodigo());
				establecimientoAux = this.establecimientoDao.find(establecimientoAux);

				// si est el tramite de registro de solicitud tramitado
				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null
						&& !solDetalle.getDtnif().equals(establecimientoAux.getEsnif())) {
					throw new Y41bUDAException("error.solicitud.nifReclamanteDiferenteException", true,
							new Exception());
				}

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimientoAux);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getReclamanteCambio())) {
					if (listIntervinientes.size() > 0) {
						intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(),
								solicitudDetalle.getDtcodigo(), establecimientoAux.getEscodigo(), null,
								establecimientoAux.getEsnombre(), null, null, establecimientoAux.getEsnoco(), null,
								establecimientoAux.getEsnif(), null, null, establecimientoAux.getEscoidco(),
								establecimientoAux.getEsteurl(), establecimientoAux.getEsnopeco(),
								establecimientoAux.getEsfeba(), establecimientoAux.getEsnrtel(),
								establecimientoAux.getEsnrtel2(), establecimientoAux.getEscoem(),
								establecimientoAux.getEsextranjero(), establecimientoAux.getEsnoraProvinciaId(),
								establecimientoAux.getEsnombreProvincia(), establecimientoAux.getEsnoraMunicipioId(),
								establecimientoAux.getEsnombreMunicipio(), establecimientoAux.getEsnoraLocalidadId(),
								establecimientoAux.getEsnombreLocalidad(), establecimientoAux.getEsnoraCalleId(),
								establecimientoAux.getEsnombreCalle(), establecimientoAux.getEsnoraCpId(),
								establecimientoAux.getEsnombreCp(), establecimientoAux.getEsnoraPortalId(),
								establecimientoAux.getEsnombrePortal(), establecimientoAux.getEsnombrePiso(),
								establecimientoAux.getEsnoraPaisId(), establecimientoAux.getEsnoraPaisNombre(),
								establecimientoAux.getEsdireccion_nocapv(), null, establecimientoAux.getEsinadar(),
								establecSector.getSector().getSecodigo(), establecSector.getSector().getSenombre(),
								establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, hechoDenunciado.getHdcodigo(), null,
								establecimientoAux.getEsfemod(), establecimientoAux.getCensoMonitor().getMocodigo(),
								establecimientoAux.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.update(intervinientesAux);
					} else {
						intervinientesAux = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
								solicitudDetalle.getDtcodigo(), establecimientoAux.getEscodigo(), null,
								establecimientoAux.getEsnombre(), null, null, establecimientoAux.getEsnoco(), null,
								establecimientoAux.getEsnif(), null, null, establecimientoAux.getEscoidco(),
								establecimientoAux.getEsteurl(), establecimientoAux.getEsnopeco(),
								establecimientoAux.getEsfeba(), establecimientoAux.getEsnrtel(),
								establecimientoAux.getEsnrtel2(), establecimientoAux.getEscoem(),
								establecimientoAux.getEsextranjero(), establecimientoAux.getEsnoraProvinciaId(),
								establecimientoAux.getEsnombreProvincia(), establecimientoAux.getEsnoraMunicipioId(),
								establecimientoAux.getEsnombreMunicipio(), establecimientoAux.getEsnoraLocalidadId(),
								establecimientoAux.getEsnombreLocalidad(), establecimientoAux.getEsnoraCalleId(),
								establecimientoAux.getEsnombreCalle(), establecimientoAux.getEsnoraCpId(),
								establecimientoAux.getEsnombreCp(), establecimientoAux.getEsnoraPortalId(),
								establecimientoAux.getEsnombrePortal(), establecimientoAux.getEsnombrePiso(),
								establecimientoAux.getEsnoraPaisId(), establecimientoAux.getEsnoraPaisNombre(),
								establecimientoAux.getEsdireccion_nocapv(), null, establecimientoAux.getEsinadar(),
								establecSector.getSector().getSecodigo(), establecSector.getSector().getSenombre(),
								establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, hechoDenunciado.getHdcodigo(), null,
								establecimientoAux.getEsfemod(), establecimientoAux.getCensoMonitor().getMocodigo(),
								establecimientoAux.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.add(intervinientesAux);
						this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);
					}
				}
				if (Y41bUtils.isFilled(establecimientoAux.getEsnif())) {
					sbPerson.append(establecimientoAux.getEsnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(establecimientoAux.getEsnombre())) {
					sbPerson.append(establecimientoAux.getEsnombre());
					sbPerson.append(" ");
				}
			} else {

				// Modificacion de interviniente consumidor
				consumidor = this.consumidorDao.find(consumidor);

				// 0206196
				String formaPresentacionAux = solDetalle.getTfpcodigo().toString();
				if (!(formaPresentacionAux.equalsIgnoreCase(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB))) {
					if (consumidor != null && Y41bUtils.isFilled(consumidor.getDtnombreCalle())
							&& (consumidor.getDtnoraCalleId() == null || consumidor.getDtnoraCalleId().equals(""))) {
						throw new Y41bUDAException("error.solicitud.direccionNoCompletaReclamanteException", true,
								new Exception());
					}
				}

				// si est el tramite de registro de solicitud tramitado
				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null
						&& solDetalle.getDtnif() != null && !solDetalle.getDtnif().equals(consumidor.getDtnif())) {
					throw new Y41bUDAException("error.solicitud.nifReclamanteDiferenteException", true,
							new Exception());
				} else if (solDetalle.getistelematico() != null
						&& solDetalle.getistelematico().equals(Y41bConstantes.SI) && solDetalle.getDtnif() != null
						&& !solDetalle.getDtnif().equals(consumidor.getDtnif())) {
					throw new Y41bUDAException("error.solicitud.nifReclamanteDiferenteException", true,
							new Exception());
				}

				if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getReclamanteCambio())) {
					if (listIntervinientes.size() > 0) {
						intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(),
								solicitudDetalle.getDtcodigo(), null, null, consumidor.getDtnombre(),
								consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
								consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
								consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null,
								consumidor.getDtnrtel(), consumidor.getDtnrtel2(), consumidor.getDttecoem(),
								consumidor.getDtextranjero(), consumidor.getDtnoraProvinciaId(),
								consumidor.getDtnombreProvincia(), consumidor.getDtnoraMunicipioId(),
								consumidor.getDtnombreMunicipio(), consumidor.getDtnoraLocalidadId(),
								consumidor.getDtnombreLocalidad(), consumidor.getDtnoraCalleId(),
								consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(),
								consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
								consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(),
								consumidor.getDtnoraPaisNombre(), consumidor.getDtdireccion_nocapv(), null, null, null,
								null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
								hechoDenunciado.getHdcodigo(), null, consumidor.getDtfemod(),
								consumidor.getCensoMonitor().getMocodigo(),
								consumidor.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.update(intervinientesAux);
					} else {
						intervinientesAux = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
								consumidor.getDtcodigo(), null, null, consumidor.getDtnombre(),
								consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
								consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
								consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null,
								consumidor.getDtnrtel(), consumidor.getDtnrtel2(), consumidor.getDttecoem(),
								consumidor.getDtextranjero(), consumidor.getDtnoraProvinciaId(),
								consumidor.getDtnombreProvincia(), consumidor.getDtnoraMunicipioId(),
								consumidor.getDtnombreMunicipio(), consumidor.getDtnoraLocalidadId(),
								consumidor.getDtnombreLocalidad(), consumidor.getDtnoraCalleId(),
								consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(),
								consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
								consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(),
								consumidor.getDtnoraPaisNombre(), consumidor.getDtdireccion_nocapv(), null, null, null,
								null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
								hechoDenunciado.getHdcodigo(), null, consumidor.getDtfemod(),
								consumidor.getCensoMonitor().getMocodigo(),
								consumidor.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.add(intervinientesAux);
						this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientesAux);
					}
				}

				if (Y41bUtils.isFilled(consumidor.getDtnif())) {
					sbPerson.append(consumidor.getDtnif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtnombre())) {
					sbPerson.append(consumidor.getDtnombre());
					sbPerson.append(" ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtapellido1())) {
					sbPerson.append(consumidor.getDtapellido1());
					sbPerson.append(" ");
				}
				if (Y41bUtils.isFilled(consumidor.getDtapellido2())) {
					sbPerson.append(consumidor.getDtapellido2());
					sbPerson.append(" ");
				}
			}

			// Se genera el numero de registro de entrada
			if (solicitudDetalle.getNumregistroentrada() == null
					|| solicitudDetalle.getNumregistroentrada().equals("")) {
				if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)
						|| solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)
						|| solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)
						|| solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					// Inicio Bloque del Test
					WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

					if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
						datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					} else if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
						datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					} else if (solicitudDetalle.getDecoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
						datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					} else if (solicitudDetalle.getDecoor()
							.equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
						datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					}

					ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

					WSParamPerson wSParamPerson = new WSParamPerson();
					wSParamPerson.setPersonName(sbPerson.toString());

					persons.getWSParamPerson().add(wSParamPerson);

					datas.setPersons(persons);

					solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

					StringBuffer sbMatter = new StringBuffer();
					sbMatter.append(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
					sbMatter.append(" - [");
					sbMatter.append(Y41bConstantes.TIPO_PROC_SOLICITUDES);
					sbMatter.append("-");
					sbMatter.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
							.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());
					sbMatter.append("]");
					datas.setMatter(sbMatter.toString());

					N61ServiceImpl n61Service = new N61ServiceImpl();
					WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

					hechoDenunciado.setNumregistroentrada(wSInputRegister.getNumber());

					this.hechoDenunciadoDao.updateNumregistroEntrada(hechoDenunciado);
				}
			}

			// buscar el interviniente demandado
			intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(solicitudDetalle.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			// Alta interviniente establecimiento
			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimiento = this.tratamientoAnyadirIntervinienteDemandado(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			if (listIntervinientes.size() > 0) {

				logger.debug("JJ Lista de intervinientes > 0: " + listIntervinientes.get(0).getIdinterviniente());

				if (Y41bUtils.isValidCIF(solDetalle.getEsnif()) || Y41bUtils.isValidNIF(solDetalle.getEsnif())) {
					// si est el tramite de registro de solicitud tramitado
					if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null
							&& Y41bConstantes.VALOR_SI.equals(solDetalle.getHdparticipacionreclamado())
							&& !solDetalle.getEsnif().equals(establecimiento.getEsnif())) {
						throw new Y41bUDAException("error.solicitud.nifReclamadoDiferenteException", true,
								new Exception());
					}
				}

				if (Y41bConstantes.VALOR_SI.equals(solicitudDetalle.getReclamadoCambio())) {
					intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO, hechoDenunciado.getHdcodigo(), null,
							establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.update(intervinientesAux);
				}
			} else {
				logger.debug("JJ Lista de intervinientes else <= 0: new");

				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
						establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO, hechoDenunciado.getHdcodigo(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMADO(intervinientesAux);
			}

			// Actualizamos la bandeja de propuestas de sancion
			this.tratamientoBandejaPropuestaSancion(hechoDenunciado);

			// Actualizamos la bandeja de propuestas de arbitraje
			this.tratamientoBandejaPropuestaArbitraje(hechoDenunciado);

			tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(hechoDenunciado.getHdcodigo());

			// si est el tramite de registro de solicitud tramitado
			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
				this.soltramexpService.actualizarParticipacionReclamante(tramiteComun);
			}

			if (solDetalle.getHdparticipacionreclamado() != null
					&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
				this.soltramexpService.actualizarParticipacionReclamado(tramiteComun);
			}

		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41bUDAException("error.solicitud.consumidor", true, e);
			} else if (j != -1) {
				throw new Y41bUDAException("error.solicitud.establecimiento", true, e);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor, CensoMonitor censoMonitor)
			throws Exception {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// comprobar si el organismo es diferente al del expediente
		if (solDetalle.getHccoor().equals(solicitudCambioInstructor.getOrganismo().getCodOrg())) {
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setCensoMonitor(solicitudCambioInstructor.getInstructorNuevo());
			hechodenunciado.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

			// si es igual el organismo
			// update del instructor
			this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

			// buscar tramites pendientes y modificar el usuario asignado
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(hechodenunciado.getHdcodigo());

			List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
					.findAllTramiteHechoPendientes(tramiteHechoDetalle, null);

			Tramite tramiteAux = null;
			for (TramiteHechoDetalle tramiteHechoDetalleAux : listTramiteHechoDetalle) {
				tramiteAux = new Tramite();
				tramiteAux.setTrcodigo(tramiteHechoDetalleAux.getTrcodigo());
				tramiteAux = this.tramiteDao.find(tramiteAux);

				if (tramiteAux != null && tramiteAux.getPcodigo() != null
						&& tramiteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					TramiteHecho tramitehecho = new TramiteHecho();
					tramitehecho.setEhcomo(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
					tramitehecho.setEhcomoasignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
					tramitehecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

					this.tramiteHechoDao.updateInstructor(tramitehecho);
				}
			}

		} else {
			this.updateTrasladoOrganismoCambioInstructor(solicitudCambioInstructor, censoMonitor, true);
		}

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
		tratamientoBandejaSolicitudes(hechodenunciadoAux);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param generarComunicacion
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateTrasladoOrganismoCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor,
			CensoMonitor censoMonitor, boolean generarComunicacion) throws Exception {

		/*
		 * si es diferente se da de alta el traslado con fecha de recepcion
		 * update de organismo propietario del expediente update del instructor
		 * tratamiento bandeja
		 */

		// Insertar traslado para KONTSUMONET
		// Update de HCCOOR con el codigo de organismo al que se
		// traslada la solicitud de la tabla L2125T00 DECISION HECHO
		DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
		decisionHechoDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

		decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

		String codOrganismoOrigen = decisionHechoDetalle.getHccoor();

		Organismo organismo = new Organismo();
		organismo.setCodOrg(solicitudCambioInstructor.getOrganismo().getCodOrg());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		// buscar el interviniente interesado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(solicitudCambioInstructor.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION);

		Intervinientes intervinientesAux = new Intervinientes(
				Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null, organismo.getEntidadId(),
				organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null, null, null,
				organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
				organismo.getNoraProvinciaId(), organismo.getNombreProvincia(), organismo.getNoraMunicipioId(),
				organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
				organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
				organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
				organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
				organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null, null,
				null);

		this.intervinientesDao.add(intervinientesAux);

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(solicitudCambioInstructor.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_TRASLADO_KONBIDE);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhcomoasignado(solicitudCambioInstructor.getInstructorActual().getMocodigo());
		tramitehecho.setEhfechafin(todayWithZeroTime);
		tramitehecho.setEhcomoejecucion(solicitudCambioInstructor.getInstructorActual().getMocodigo());
		tramitehecho.setEhcomo(solicitudCambioInstructor.getInstructorActual().getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhcoortraspaso(solicitudCambioInstructor.getOrganismo().getCodOrg());

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		// Se graba un registro en TRASLADO

		Traslado traslado = new Traslado();
		traslado.setIhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		traslado.setIhcoortr(codOrganismoOrigen);
		traslado.setIhnrantr(new BigDecimal(Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_ANYO)));

		if (organismo.getIskontsumonet().equals(Y41bConstantes.VALOR_SI)) {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_TRASLADO);
		} else {
			traslado.setIhinintr(Y41bConstantes.TIPO_TRANSMISION_COMUNICACION);
		}

		traslado.setIhtedoad("");
		traslado.setIhfereor(todayWithZeroTime);
		traslado.setIhcooror(codOrganismoOrigen); // cod
													// org
													// de
													// la
		// denuncia
		traslado.setIhcoordt(solicitudCambioInstructor.getOrganismo().getCodOrg());

		DecisionHecho decisiontraslado = new DecisionHecho();
		decisiontraslado.setHccodigo(decisionHechoDetalle.getHccodigo());
		traslado.setDecisionHecho(decisiontraslado); // codigo
														// de
														// la
														// decision

		traslado.setIhfereen(todayWithZeroTime);

		traslado.setIhcoeh(tramitehecho.getEhcodigo());

		// // JAVI 09/01
		//
		// String texto = Y41bUtils.clobToString(tramitehecho
		// .getEhmotivorechazo());
		// if (texto.length() > 255) {
		// texto = Y41bUtils.clobToString(
		// tramitehecho.getEhmotivorechazo()).substring(0, 255);
		// }
		// traslado.setIhtedoad(texto);

		// alta traslado
		this.trasladoDao.addTraslado(traslado);

		DecisionHecho decisionHecho = new DecisionHecho();
		decisionHecho.setHccoor(solicitudCambioInstructor.getOrganismo().getCodOrg());
		decisionHecho.setHccodigo(decisionHechoDetalle.getHccodigo());

		this.decisionHechoDao.updateOrganismoTraslado(decisionHecho);

		if (generarComunicacion) {
			// generar el documento
			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_TRASLADO_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			// Obtener los datos de la solicitud
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = new PlantillaTramiteHechoDetalle();
			plantillaTramiteHechoDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

			plantillaTramiteHechoDetalle = this.tramiteHechoDao.findPlantillaTramiteHecho(plantillaTramiteHechoDetalle);

			plantillaTramiteHechoDetalle.setFechaHoy(todayWithZeroTime);

			SolicitudDetalle solDetalleAux = new SolicitudDetalle();
			solDetalleAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
			solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solDetalleAux);
			plantillaTramiteHechoDetalle.setHdte(solDetalleAux.getHdte());

			// organismo traslado
			plantillaTramiteHechoDetalle.setCodOrgTraslado(organismo.getCodOrg());
			plantillaTramiteHechoDetalle.setNombreEsTraslado(organismo.getNombreEs());
			plantillaTramiteHechoDetalle.setNombreEuTraslado(organismo.getNombreEu());
			plantillaTramiteHechoDetalle.setNoraProvinciaIdTraslado(organismo.getNoraProvinciaId());
			plantillaTramiteHechoDetalle.setNombreProvinciaTraslado(organismo.getNombreProvincia());
			plantillaTramiteHechoDetalle.setNoraMunicipioIdTraslado(organismo.getNoraMunicipioId());
			plantillaTramiteHechoDetalle.setNombreMunicipioTraslado(organismo.getNombreMunicipio());
			plantillaTramiteHechoDetalle.setNoraLocalidadIdTraslado(organismo.getNoraLocalidadId());
			plantillaTramiteHechoDetalle.setNombreLocalidadTraslado(organismo.getNombreLocalidad());
			plantillaTramiteHechoDetalle.setNoraCalleIdTraslado(organismo.getNoraCalleId());
			plantillaTramiteHechoDetalle.setNombreCalleTraslado(organismo.getNombreCalle());
			plantillaTramiteHechoDetalle.setNoraCpIdTraslado(organismo.getNoraCpId());
			plantillaTramiteHechoDetalle.setNombreCpTraslado(organismo.getNombreCp());
			plantillaTramiteHechoDetalle.setNoraPortalIdTraslado(organismo.getNoraPortalId());
			plantillaTramiteHechoDetalle.setNombrePortalTraslado(organismo.getNombrePortal());

			plantillaTramiteHechoDetalle.setTelefonoTraslado(organismo.getTelefono());
			plantillaTramiteHechoDetalle.setFaxTraslado(organismo.getFax());
			plantillaTramiteHechoDetalle.setEmailTraslado(organismo.getEmail());

			plantillaTramiteHechoDetalle = this.completeInfoPlantillaTramiteHechoDetalle(plantillaTramiteHechoDetalle);

			String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML.toString(),
					plantillaTramiteHechoDetalle, plantilla);

			Blob q5datafile = new SerialBlob(ficheroGenerado.getBytes());

			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
			int codDocumentoHecho = this.getNewPKDocumentoHecho().intValue();
			documentoTramiteHecho.setCodocumento(String.valueOf(codDocumentoHecho));
			documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(String.valueOf(codDocumentoHecho));
			documentoHecho.setQ5hdcodigo(solicitudCambioInstructor.getIdExpediente());
			documentoHecho.setQ5tramite(tramitehecho.getEhcodigo());

			documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_COMUNICACION);

			documentoHecho.setQ5tedesfile("COMUNICACION TRASLADO");
			documentoHecho.setQ5nofile(Y41bConstantes.NOMBRE_PLANTILLA_TRASLADO_RTF);
			documentoHecho.setQ5datafile(q5datafile);
			documentoHecho.setQ5sizefile(ficheroGenerado.getBytes().length);
			documentoHecho.setQ5contenttypefile("application/msword");

			documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
			documentoHecho.setQ5fecha(new Date());

			this.documentoHechoDao.add(documentoHecho);

			this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

			// generar la comunicacion al demandado
			generarTramiteComunicacionAutomaticoTrasladoKonbide(solicitudCambioInstructor, tramitehecho);
		}

		// buscar el tramite de asignacion
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

		Long tramiteAsignacionInstructorSinTramitar = this.tramiteHechoDao
				.findAllTramiteAsignacionInstructorSinTramitarCount(tramiteHechoDetalle);

		// Coordinador
		CensoMonitor censoMonitorCoordinador = new CensoMonitor();
		try {
			censoMonitorCoordinador.setOrganismo(solicitudCambioInstructor.getOrganismo());

			censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorSolicitudes(censoMonitorCoordinador);
		} catch (Exception e) {
			censoMonitorCoordinador = new CensoMonitor();
		}

		if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {

			if (Y41bUtils.isFilled(solicitudCambioInstructor.getInstructorNuevo().getMocodigo())) {
				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

				SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				if (tramiteAsignacionInstructorSinTramitar == 0) {
					generarTramiteAsignacionInstructorTramitadoAutomaticoTrasladoKonbide(solicitudCambioInstructor,
							solDetalle, censoMonitor);
				} else {
					tramitarTramiteAsignacionInstructorTramitadoAutomaticoTrasladoKonbide(solicitudCambioInstructor,
							solDetalle, censoMonitor);
				}

				// cambiar el instructor del expediente al responsable
				// seleccionado
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setCensoMonitor(solicitudCambioInstructor.getInstructorNuevo());
				hechodenunciado.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

				// si es igual el organismo
				// update del instructor
				this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

			} else {
				if (tramiteAsignacionInstructorSinTramitar == 0) {
					generarTramiteAsignacionInstructorAutomaticoTrasladoKonbide(solicitudCambioInstructor,
							censoMonitorCoordinador);
				}

				if (censoMonitorCoordinador.getMocodigo() != null) {
					// cambiar el instructor del expediente al coordinador
					HechoDenunciado hechodenunciado = new HechoDenunciado();
					hechodenunciado.setCensoMonitor(censoMonitorCoordinador);
					hechodenunciado.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

					// si es igual el organismo
					// update del instructor
					this.hechoDenunciadoDao.updateInstructor(hechodenunciado);
				}
			}
		} else {
			if (tramiteAsignacionInstructorSinTramitar == 0) {
				generarTramiteAsignacionInstructorAutomaticoTrasladoKonbide(solicitudCambioInstructor,
						censoMonitorCoordinador);
			}

			if (censoMonitorCoordinador.getMocodigo() != null) {
				// cambiar el instructor del expediente al coordinador
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setCensoMonitor(censoMonitorCoordinador);
				hechodenunciado.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

				// si es igual el organismo
				// update del instructor
				this.hechoDenunciadoDao.updateInstructor(hechodenunciado);
			}
		}

		// Actualizar ultimo tramite
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
		hechodenunciadoAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
		hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);
	}

	/**
	 * Generar Tramite Automatico de Asignacion de Instructor
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitorCoordinador
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteAsignacionInstructorAutomaticoTrasladoKonbide(
			SolicitudCambioInstructor solicitudCambioInstructor, CensoMonitor censoMonitorCoordinador)
			throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(solicitudCambioInstructor.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhcomoasignado(censoMonitorCoordinador.getMocodigo());
		tramitehecho.setEhcomo(censoMonitorCoordinador.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Asignacion de Instructor
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param censoMonitorCoordinador
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteAsignacionInstructorTramitadoAutomaticoTrasladoKonbide(
			SolicitudCambioInstructor solicitudCambioInstructor, SolicitudDetalle solDetalle, CensoMonitor censoMonitor)
			throws Exception {
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(solicitudCambioInstructor.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhcomoasignado(censoMonitor.getMocodigo());
		tramitehecho.setEhfechafin(todayWithZeroTime);
		tramitehecho.setEhcomoejecucion(censoMonitor.getMocodigo());
		tramitehecho.setEhcomo(censoMonitor.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhcosc(solDetalle.getHdcosc());

		tramitehecho.setEhcomodesignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Tramita Tramite Automatico de Asignacion de Instructor
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param solDetalle
	 *            SolicitudDetalle
	 * @param censoMonitorCoordinador
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho tramitarTramiteAsignacionInstructorTramitadoAutomaticoTrasladoKonbide(
			SolicitudCambioInstructor solicitudCambioInstructor, SolicitudDetalle solDetalle, CensoMonitor censoMonitor)
			throws Exception {

		// buscar el ultimo tramite de asignacion no tramitado
		TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
		tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		tramiteHechoDetalleAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
		try {
			tramiteHechoDetalleAux = this.tramiteHechoDao
					.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteHechoDetalleAux);
		} catch (Exception e) {
		}

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
		tramitehecho.setEhcohd(solicitudCambioInstructor.getIdExpediente());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin
		tramitehecho.setEhfecha(todayWithZeroTime);
		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhcomoasignado(censoMonitor.getMocodigo());
		tramitehecho.setEhfechafin(todayWithZeroTime);
		tramitehecho.setEhcomoejecucion(censoMonitor.getMocodigo());
		tramitehecho.setEhcomo(censoMonitor.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhcosc(solDetalle.getHdcosc());

		tramitehecho.setEhcomodesignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se actualiza el tramite
		this.tramiteHechoService.updateTramiteHecho(tramitehecho);

		return tramitehecho;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Traslado Red Ciac
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho generarTramiteComunicacionAutomaticoTrasladoKonbide(
			SolicitudCambioInstructor solicitudCambioInstructor, TramiteHecho tramitehecho) throws Exception {

		TramiteHecho tramitehechoAux = new TramiteHecho();

		tramitehechoAux.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehechoAux.setEhcohd(solicitudCambioInstructor.getIdExpediente());
		tramitehechoAux.setEhcotee(Y41bConstantes.TRAMITE_COMUNICACION);

		tramitehechoAux.setEhenvrem(Y41bConstantes.VALOR_SI);

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
		tramitehechoAux.setEhfecha(todayWithZeroTime);
		// La hora Ini
		String ehhora = null;
		try {
			Calendar todayCalendar = Calendar.getInstance();
			todayCalendar.add(Calendar.SECOND, Y41bConstantes.NUM_1);
			ehhora = Y41bUtils.formatearDateToString(todayCalendar.getTime(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}
		// La hora Fin

		tramitehechoAux.setEhhora(ehhora);
		tramitehechoAux.setEhfechainicio(todayWithZeroTime);
		tramitehechoAux.setEhcomoasignado(solicitudCambioInstructor.getInstructorActual().getMocodigo());
		tramitehechoAux.setEhcomo(solicitudCambioInstructor.getInstructorActual().getMocodigo());
		tramitehechoAux.setEhtexto("");

		tramitehechoAux.setEhfechacomunicacion(todayWithZeroTime);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(solicitudCambioInstructor.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramitehechoAux.setEhiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramitehechoAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		tramitehechoAux.setTramiteHecho(tramitehecho);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehechoAux);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(solicitudCambioInstructor.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramitehecho.getEhcodigo());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramitehechoAux.getEhcodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		return tramitehechoAux;
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor) {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(solicitudCambioInstructor.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// comprobar si el organismo es diferente al del expediente
		if (solDetalle.getHccoor().equals(solicitudCambioInstructor.getOrganismo().getCodOrg())) {
			SolicitudBusqueda solicitudesBusqueda = new SolicitudBusqueda();
			solicitudesBusqueda.setMocodigoExpediente(solicitudCambioInstructor.getInstructorActual().getMocodigo());
			solicitudesBusqueda.setCodOrgSeleccionado(solicitudCambioInstructor.getOrganismo().getCodOrg());

			// buscar todos los expedientes abiertos del instructor origen
			List<SolicitudBusqueda> listSolicitudBusqueda = this.hechoDenunciadoDao
					.findAllSolicitudesAbiertasInstructor(solicitudesBusqueda, null);

			// por cada expediente abierto, cambiar el instructor
			for (SolicitudBusqueda sol : listSolicitudBusqueda) {
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setCensoMonitor(solicitudCambioInstructor.getInstructorNuevo());
				hechodenunciado.setHdcodigo(sol.getHdcodigo());

				// si es igual el organismo
				// update del instructor
				this.hechoDenunciadoDao.updateInstructor(hechodenunciado);

				// buscar tramites pendientes y modificar el usuario asignado
				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
				tramiteHechoDetalle.setHdcodigo(hechodenunciado.getHdcodigo());

				List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
						.findAllTramiteHechoPendientes(tramiteHechoDetalle, null);

				Tramite tramiteAux = null;
				if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {
					for (TramiteHechoDetalle tramiteHechoDetalleAux : listTramiteHechoDetalle) {

						tramiteAux = new Tramite();
						tramiteAux.setTrcodigo(tramiteHechoDetalleAux.getTrcodigo());
						tramiteAux = this.tramiteDao.find(tramiteAux);

						if (tramiteAux != null && tramiteAux.getPcodigo() != null
								&& tramiteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
							TramiteHecho tramitehecho = new TramiteHecho();
							tramitehecho.setEhcomo(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
							tramitehecho
									.setEhcomoasignado(solicitudCambioInstructor.getInstructorNuevo().getMocodigo());
							tramitehecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

							this.tramiteHechoDao.updateInstructor(tramitehecho);

							// Tratar la bandeja
							HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
							hechodenunciadoAux.setHdcodigo(tramiteHechoDetalleAux.getHdcodigo());
							tratamientoBandejaSolicitudes(hechodenunciadoAux);
						}
					}
				} else {
					// Tratar la bandeja
					HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
					hechodenunciadoAux.setHdcodigo(hechodenunciado.getHdcodigo());
					tratamientoBandejaSolicitudes(hechodenunciadoAux);
				}
			}
		} else {
			throw new Y41bUDAException("error.solicitud.organismoException", true, new Exception());
		}
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	public Denuncia find(Denuncia denuncia) {
		return (Denuncia) this.denunciaDao.find(denuncia);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	public Denuncia findDenunciaPropARB(Denuncia denuncia) {
		return (Denuncia) this.denunciaDao.findDenunciaPropARB(denuncia);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		if (solDetalle != null && solDetalle.getSecodigo() == null) {
			solDetalle.setSecodigo("");
			solDetalle.setSenombre("");
			solDetalle.setSenombree("");
		}

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solicitudDetalle);
		solDetalle.setHdte(solDetalleAux.getHdte());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new SolicitudArbitrajeDetalle();
		solicitudArbitrajeDetalle.setHdcodigo(solDetalle.getHdcodigo());
		solicitudArbitrajeDetalle = this.solicitudArbitrajeDao.findSolicitudArbitraje(solicitudArbitrajeDetalle);

		if (solicitudArbitrajeDetalle.getHdcodigo() == null || solicitudArbitrajeDetalle.getHdcodigo().equals("")) {
			solDetalle.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);
		}

		if (tratamientoSeguridad(solDetalle, censoMonitor)) {
			solDetalle.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			solDetalle.setPermisoModificacion(Y41bConstantes.NO);
		}

		// descriptores
		List<Descriptor> listDescriptor = this.hechoDenunciadoDao.findAllHechoDenunciadoDescriptor(solDetalle, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		solDetalle.setIdsDescriptores(strIdsDescriptores.toString());
		solDetalle.setDescsDescriptores(strDescsDescriptores.toString());

		if (solDetalle.getTrcodigo() != null && solDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_GENERICO)) {
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcohd(solDetalle.getHdcodigo());

			TramiteHecho tramiteHechoAux = null;

			tramiteHechoAux = this.tramiteHechoDao.findUltimoTramite(tramitehecho);

			solDetalle.setTrnombre(tramiteHechoAux.getEhnombretramite());
			solDetalle.setTrnombree(tramiteHechoAux.getEhnombretramite());
		}

		// Expediente antiguo
		if (solDetalle.getFcodigo() == null) {
			solDetalle.setPermisoModificacion(Y41bConstantes.NO);

			if (solDetalle.getDtcodigo() != null && solDetalle.getEscodigo() != null) {

				// buscar consumidor
				Consumidor consumidor = new Consumidor();
				consumidor.setDtcodigo(solDetalle.getDtcodigo());
				consumidor = this.consumidorDao.find(consumidor);

				solDetalle.setDtnombre(consumidor.getDtnombre());
				solDetalle.setDtapellido1(consumidor.getDtapellido1());
				solDetalle.setDtapellido2(consumidor.getDtapellido2());
				solDetalle.setDtnif(consumidor.getDtnif());
				solDetalle.setDttecoem(consumidor.getDttecoem());
				solDetalle.setDtnrtel(consumidor.getDtnrtel());
				solDetalle.setDtnombreProvincia(consumidor.getDtnombreProvincia());
				solDetalle.setDtnombreMunicipio(consumidor.getDtnombreMunicipio());
				solDetalle.setDtnombreLocalidad(consumidor.getDtnombreLocalidad());
				solDetalle.setDtextranjero(consumidor.getDtextranjero());
				solDetalle.setDtnoraPaisNombre(consumidor.getDtnoraPaisNombre());
				solDetalle.setDtdireccion_nocapv(consumidor.getDtdireccion_nocapv());

				// buscar establecimiento
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(solDetalle.getEscodigo());
				// Alta interviniente establecimiento
				establecimiento = this.establecimientoDao.find(establecimiento);

				solDetalle.setEsnombre(establecimiento.getEsnombre());
				solDetalle.setEsnoco(establecimiento.getEsnoco());
				solDetalle.setEsnif(establecimiento.getEsnif());
				solDetalle.setEscoem(establecimiento.getEscoem());

				solDetalle.setEsinadar(establecimiento.getEsinadar());

				solDetalle.setEsnombreProvincia(establecimiento.getEsnombreProvincia());
				solDetalle.setEsnombreMunicipio(establecimiento.getEsnombreMunicipio());
				solDetalle.setEsnombreLocalidad(establecimiento.getEsnombreLocalidad());
				solDetalle.setEsextranjero(establecimiento.getEsextranjero());
				solDetalle.setEsnoraPaisNombre(establecimiento.getEsnoraPaisNombre());
				solDetalle.setEsdireccion_nocapv(establecimiento.getEsdireccion_nocapv());

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				solDetalle.setSecodigo(establecSector.getSector().getSecodigo());
				solDetalle.setSenombre(establecSector.getSector().getSenombre());
				solDetalle.setSenombree(establecSector.getSector().getSenombree());

			}
		}

		// Obtenet el valor de estado de adhesion del censo
		if (!Y41bUtils.esNullOCadenaVacia(solDetalle.getEscodigo())) {
			solDetalle.setEsinadar(
					this.establecimientoService.estadoAdhesionEstablecimientoCenso(solDetalle.getEscodigo()));
		}
		// buscar el tramite de decision con propuesta sancion No avenencia con
		// propuesta de sanción
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

		Long decisionPropuestaSancion = this.tramiteHechoDao
				.findAllTramiteDecisionPropuestaSancionCount(tramiteHechoDetalle);

		if (decisionPropuestaSancion > 0) {
			solDetalle.setPermisoModificacionFechaHecho(Y41bConstantes.NO);
		} else {
			solDetalle.setPermisoModificacionFechaHecho(Y41bConstantes.SI);
		}

		tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

		Long tramiteAsignacionInstructorTramitado = this.tramiteHechoDao
				.findAllTramiteAsignacionInstructorTramitadoCount(tramiteHechoDetalle);

		if (tramiteAsignacionInstructorTramitado > 0) {
			solDetalle.setPermisoModificacionTipoSolicitud(Y41bConstantes.NO);
		} else {
			solDetalle.setPermisoModificacionTipoSolicitud(Y41bConstantes.SI);
		}

		// buscar el tramite de decision con propuesta sancion No avenencia con
		// propuesta de sanción
		tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

		Long tramiteRegistroSolicitudTramitado = this.tramiteHechoDao
				.findAllTramiteRegistroSolicitudTramitadoCount(tramiteHechoDetalle);

		if (tramiteRegistroSolicitudTramitado > 0) {
			solDetalle.setPermisoModificacionCambioResponsable(Y41bConstantes.SI);
		} else {
			solDetalle.setPermisoModificacionCambioResponsable(Y41bConstantes.NO);

			// buscar tramite de recpecion de traslado
			tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

			Long tramiteRecepcionTrasladoTramitado = this.tramiteHechoDao
					.findAllTramiteRecepcionTrasladoTramitadoCount(tramiteHechoDetalle);

			if (tramiteRecepcionTrasladoTramitado > 0) {
				solDetalle.setPermisoModificacionCambioResponsable(Y41bConstantes.SI);
			}
		}

		// comprobar tramite asignacion de responsable tramitado en funcion de
		// tramite registro tramitado 0135090
		tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

		tramiteRegistroSolicitudTramitado = this.tramiteHechoDao
				.findAllTramiteRegistroSolicitudTramitadoCount(tramiteHechoDetalle);

		if (tramiteRegistroSolicitudTramitado > 0) {

			// buscar asignacion responsable
			tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(solDetalle.getHdcodigo());

			tramiteAsignacionInstructorTramitado = this.tramiteHechoDao
					.findAllTramiteAsignacionInstructorTramitadoCount(tramiteHechoDetalle);

			if (tramiteAsignacionInstructorTramitado > 0) {
				solDetalle.setPermisoConversionDenuncia(Y41bConstantes.NO);
			} else {
				solDetalle.setPermisoConversionDenuncia(Y41bConstantes.SI);
			}

		} else {
			solDetalle.setPermisoConversionDenuncia(Y41bConstantes.NO);
		}

		if (solDetalle != null && solDetalle.getTrcodigo() != null
				&& solDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR)) {
			TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
			tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			tramiteHechoDetalleAux.setHdcodigo(solDetalle.getHdcodigo());
			try {
				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
			} catch (Exception e) {
			}

			if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhfechafin() != null) {
				// buscar tramite
				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

				tramitehecho = this.tramiteHechoDao.find(tramitehecho);

				solDetalle.setSiguientesTramitesCambioResponsable(
						Y41bUtils.clobToString(tramitehecho.getEhsiguientestramites()));
			}
		}

		try {
			this.actualizarDocumentosLocalizados(solDetalle);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes

		String cerrado = "";
		if (solDetalle.getHdtipodenunciante() != null && solDetalle.getHdtipodenunciante()
				.equalsIgnoreCase(Y41bConstantes.TIPO_INTERVINIENTESOL_ESTABLECIMIENTO)) {
			if (!Y41bUtils.esNullOCadenaVacia(solDetalle.getDtcodigo())) {
				cerrado = this.establecimientoService.estadoCerradoEstablecimientoCenso(solDetalle.getDtcodigo());
				solDetalle.setDtEstablecimientoCerrado(cerrado);
			}
		}

		cerrado = "";

		if (!Y41bUtils.esNullOCadenaVacia(solDetalle.getEscodigo())) {
			cerrado = this.establecimientoService.estadoCerradoEstablecimientoCenso(solDetalle.getEscodigo());
			solDetalle.setEsEstablecimientoCerrado(cerrado);
		}

		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes

		return solDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle findNumExpedienteSolicitud(SolicitudDetalle solicitudDetalle) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		return solDetalle;
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return ConsumidorDetalle
	 */
	public ConsumidorDetalle findIntervinienteConsumidor(Intervinientes intervinientes) {

		// buscar el interviniente interesado
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(intervinientes.getIdExpediente());
		intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes == null || listIntervinientes.size() > 0) {
			intervinientes.setDtcodigo(listIntervinientes.get(0).getDtcodigo());
		}

		Intervinientes intervinien = this.intervinientesDao.findIntervinienteConsumidor(intervinientes);

		ConsumidorDetalle consumidorDetalle = new ConsumidorDetalle(intervinien.getDtcodigo(), intervinien.getIncozs(),
				null, intervinien.getUsuarioxlnet(), intervinien.getDtrango_edad(), null, intervinien.getNombre(),
				intervinien.getApellido1(), intervinien.getApellido2(), intervinien.getNif(), null, null, null,
				intervinien.getNrtel(), null, null, null, intervinien.getCoem(), intervinien.getNrtel2(), null,
				intervinien.getCoidco(), null, null, null, null, null, null, intervinien.getDtcosx(), null, null,
				intervinien.getInfemod(), null, null, null, null, null, null, null, null, null, null, null,
				intervinien.getDtintipid(), intervinien.getNoraPaisId(), intervinien.getNombrePais(),
				intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(), intervinien.getNoraMunicipioId(),
				intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(), intervinien.getNombreLocalidad(),
				intervinien.getNoraCalleId(), intervinien.getNombreCalle(), intervinien.getNoraCpId(),
				intervinien.getNombreCp(), intervinien.getNoraPortalId(), intervinien.getNombrePortal(),
				intervinien.getNombrePiso(), intervinien.getDireccionNocapv(), intervinien.getDireccionCompleta(), null,
				null, null, intervinien.getExtranjero());

		return consumidorDetalle;
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimiento(Intervinientes intervinientes) {

		// buscar el interviniente interesado
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(intervinientes.getIdExpediente());
		intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes == null || listIntervinientes.size() > 0) {
			intervinientes.setEscodigo(listIntervinientes.get(0).getEscodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);// J
																								// 19/12
		}

		Intervinientes intervinien = this.intervinientesDao.findIntervinienteEstablecimiento(intervinientes);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(intervinien.getEscodigo(),
				intervinien.getIncozs(), null, intervinien.getUsuarioxlnet(), intervinien.getNombre(), null,
				intervinien.getNif(), null, intervinien.getEsnoco(), null, null, null, intervinien.getNrtel(), null,
				null, null, null, null, intervinien.getInadar(), null, intervinien.getCoem(), null, null,
				intervinien.getNrtel2(), null, intervinien.getEsfeba(), null, null, null, null, null,
				intervinien.getEsnopeco(), null, null, intervinien.getInfemod(), null, null, null, null, null, null,
				intervinien.getEsteurl(), null, null, null, null, null, intervinien.getNoraPaisId(),
				intervinien.getNombrePais(), intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(),
				intervinien.getNoraMunicipioId(), intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(),
				intervinien.getNombreLocalidad(), intervinien.getNoraCalleId(), intervinien.getNombreCalle(),
				intervinien.getNoraCpId(), intervinien.getNombreCp(), intervinien.getNoraPortalId(),
				intervinien.getNombrePortal(), intervinien.getNombrePiso(), intervinien.getDireccionNocapv(),
				intervinien.getDireccionCompleta(), null, null, null, null, null, intervinien.getSecodigo(),
				intervinien.getSenombre(), intervinien.getSenombree(), null, intervinien.getExtranjero(), null);

		// buscar establecimiento
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(intervinien.getEscodigo());
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEsteco(estableci.getEsteco());
		establecidetalle.setEstipid(estableci.getEstipid());

		// Mail de avisos
		establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

		// 0157454 reapertura nota (0209071)
		establecidetalle.setEsfeba(estableci.getEsfeba());

		// Datos aadidos por especificacin en arbitraje
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());

		// Buscar arbitraje
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			// Datos aadidos por especificacin en arbitraje
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}

		// Buscar sedes
		// buscar sedes
		if (establecidetalle.getEssede() != null && establecidetalle.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(establecidetalle.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		// buscar la solicitud
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(intervinientes.getIdExpediente());
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (Y41bConstantes.CASTELLANO.equals(solDetalle.getHdidiomareclamado())) {
			establecidetalle.setEscoidco(Y41bConstantes.CASTELLANO_CENSO);
		} else if (Y41bConstantes.EUSKERA.equals(solDetalle.getHdidiomareclamado())) {
			establecidetalle.setEscoidco(Y41bConstantes.EUSKERA_CENSO);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}

		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return establecidetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByNumeroExpediente(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitudByNumeroExpediente(solicitudDetalle);

		if (solDetalle != null && solDetalle.getDecodigo() == null) {
			throw new Y41bUDAException("error.solicitud.numExpedienteException", true, new Exception());
		}

		if (solDetalle != null && solDetalle.getSecodigo() == null) {
			solDetalle.setSecodigo("");
			solDetalle.setSenombre("");
			solDetalle.setSenombree("");
		}

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solDetalle);
		solDetalle.setHdte(solDetalleAux.getHdte());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new SolicitudArbitrajeDetalle();
		solicitudArbitrajeDetalle.setHdcodigo(solDetalle.getHdcodigo());
		solicitudArbitrajeDetalle = this.solicitudArbitrajeDao.findSolicitudArbitraje(solicitudArbitrajeDetalle);

		if (solicitudArbitrajeDetalle.getHdcodigo() == null || solicitudArbitrajeDetalle.getHdcodigo().equals("")) {
			solDetalle.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);
		}

		if (tratamientoSeguridad(solDetalle, censoMonitor)) {
			solDetalle.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			solDetalle.setPermisoModificacion(Y41bConstantes.NO);
		}

		// descriptores
		List<Descriptor> listDescriptor = this.hechoDenunciadoDao.findAllHechoDenunciadoDescriptor(solDetalle, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		solDetalle.setIdsDescriptores(strIdsDescriptores.toString());
		solDetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return solDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByRegistryNumber(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitudByRegistryNumber(solicitudDetalle);

		if (solDetalle != null && Y41bUtils.isFilled(solDetalle.getHdcodigo())) {

			if (solDetalle != null && solDetalle.getDecodigo() == null) {
				throw new Y41bUDAException("error.solicitud.numExpedienteException", true, new Exception());
			}

			if (solDetalle != null && solDetalle.getSecodigo() == null) {
				solDetalle.setSecodigo("");
				solDetalle.setSenombre("");
				solDetalle.setSenombree("");
			}

			SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solDetalle);
			solDetalle.setHdte(solDetalleAux.getHdte());

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
					.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

			solDetalle.setNumExpediente(numeroExpediente.toString());

			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new SolicitudArbitrajeDetalle();
			solicitudArbitrajeDetalle.setHdcodigo(solDetalle.getHdcodigo());
			solicitudArbitrajeDetalle = this.solicitudArbitrajeDao.findSolicitudArbitraje(solicitudArbitrajeDetalle);

			if (solicitudArbitrajeDetalle.getHdcodigo() == null || solicitudArbitrajeDetalle.getHdcodigo().equals("")) {
				solDetalle.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);
			}

			if (tratamientoSeguridad(solDetalle, censoMonitor)) {
				solDetalle.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				solDetalle.setPermisoModificacion(Y41bConstantes.NO);
			}

			// descriptores
			List<Descriptor> listDescriptor = this.hechoDenunciadoDao.findAllHechoDenunciadoDescriptor(solDetalle,
					null);

			StringBuffer strIdsDescriptores = new StringBuffer();
			StringBuffer strDescsDescriptores = new StringBuffer();

			strDescsDescriptores.append("[");

			boolean firstElement = true;

			// se recorre para obtener los ids de etiquetas
			for (Descriptor descriptor : listDescriptor) {
				if (firstElement) {
					strIdsDescriptores.append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(descriptor.getNombre());
					firstElement = false;
				} else {
					strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
					strDescsDescriptores.append(",").append(descriptor.getNombre());
				}
			}
			strDescsDescriptores.append("]");

			solDetalle.setIdsDescriptores(strIdsDescriptores.toString());
			solDetalle.setDescsDescriptores(strDescsDescriptores.toString());
		}

		return solDetalle;
	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	private boolean tratamientoSeguridad(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor) {

		if (censoMonitor == null) {
			return false;
		}

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		if (solicitudDetalle != null && solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {

			if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {

				// Miro si la solicitud esta cerrada
				if (solicitudDetalle.getHdfechacierre() == null) {

					// obtener el estado
					if (solicitudDetalle.getHdinsoma() != null
							&& solicitudDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
						return false;
					} else if (solicitudDetalle.getHccoor() != null
							&& !solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
						return false;
					} else if (solicitudDetalle.getHccoor() != null
							&& solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {

						if (solicitudDetalle.getTrcodigo() != null
								&& (solicitudDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO))) {
							return false;
						} else {
							return true;
						}
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				if (solicitudDetalle.getMocodigo() != null
						&& solicitudDetalle.getMocodigo().equals(censoMonitor.getMocodigo())) {
					// Miro si la solicitud esta cerrada
					if (solicitudDetalle.getHdfechacierre() == null) {
						// obtener el estado
						if (solicitudDetalle.getHdinsoma() != null
								&& solicitudDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
							return false;
						} else if (solicitudDetalle.getHccoor() != null
								&& !solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
							return false;
						} else if (solicitudDetalle.getHccoor() != null
								&& solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {

							if (solicitudDetalle.getTrcodigo() != null && (solicitudDetalle.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO))) {
								return false;
							} else {
								return true;
							}
						} else {
							return false;
						}
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
				// Miro si la solicitud esta cerrada
				if (solicitudDetalle.getHdfechacierre() == null) {
					// obtener el estado
					if (solicitudDetalle.getHdinsoma() != null
							&& solicitudDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
						return false;
					} else if (solicitudDetalle.getHccoor() != null
							&& !solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
						return false;
					} else if (solicitudDetalle.getHccoor() != null
							&& solicitudDetalle.getHccoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
						if (solicitudDetalle.getTrcodigo() != null
								&& (solicitudDetalle.getTrcodigo().equals(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO))) {

							TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
							tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

							tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
							try {
								tramiteHechoDetalle = this.tramiteHechoDao
										.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
							} catch (Exception e) {
							}

							// buscar tramite de recepcion traslado
							// si esta tramitado se puede modificar
							if (tramiteHechoDetalle.getEhfechafin() != null) {
								return true;
							} else {
								return false;
							}
						} else {
							return true;
						}
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				// Miro si la solicitud esta cerrada
				if (solicitudDetalle.getHdfechacierre() == null) {
					// obtener el estado
					if (solicitudDetalle.getHdinsoma() != null
							&& solicitudDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
						return false;
					} else {
						return true;
					}
				} else {
					return false;
				}
			} else if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)) {
				return false;
			} else {
				return false;
			}

		} else {
			// si el usuario conectado tiene perfil de supervisior, le damos
			// permiso para modificar
			if (censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				// Miro si la solicitud esta cerrada
				if (solicitudDetalle.getHdfechacierre() == null) {
					// obtener el estado
					if (solicitudDetalle.getHdinsoma() != null
							&& solicitudDetalle.getHdinsoma().equals(Y41bConstantes.SOLICITUDES_ARBITRAJE)) {
						return false;
					} else {
						return true;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	public PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(SolicitudDetalle solicitudDetalle) {

		// Obtenemos los datos de la consulta de PlantillaSolicitudDetalle
		PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.hechoDenunciadoDao
				.findPlantillaSolicitudDetalle(solicitudDetalle);

		if (plantillaSolicitudDetalle.getMocodigo() != null) {

			// Expediente antiguo
			if (plantillaSolicitudDetalle.getDtnombre() == null
					|| plantillaSolicitudDetalle.getDtnombre().trim().equals("")) {

				// buscar consumidor
				Consumidor consumidor = new Consumidor();
				consumidor.setDtcodigo(plantillaSolicitudDetalle.getDtcodigo());
				consumidor = this.consumidorDao.find(consumidor);

				plantillaSolicitudDetalle.setDtnombre(consumidor.getDtnombre());
				plantillaSolicitudDetalle.setDtnif(consumidor.getDtnif());
				plantillaSolicitudDetalle.setDttecoem(consumidor.getDttecoem());
				plantillaSolicitudDetalle.setDtnrtel(consumidor.getDtnrtel());
				plantillaSolicitudDetalle.setDtnrtel2(consumidor.getDtnrtel2());
				plantillaSolicitudDetalle.setDtprovinciaId(consumidor.getDtnoraProvinciaId());
				plantillaSolicitudDetalle.setDtnombreProvincia(consumidor.getDtnombreProvincia());
				plantillaSolicitudDetalle.setDtmunicipioId(consumidor.getDtnoraMunicipioId());
				plantillaSolicitudDetalle.setDtnombreMunicipio(consumidor.getDtnombreMunicipio());
				plantillaSolicitudDetalle.setDtlocalidadId(consumidor.getDtnoraLocalidadId());
				plantillaSolicitudDetalle.setDtnombreLocalidad(consumidor.getDtnombreLocalidad());
				plantillaSolicitudDetalle.setDtcalleId(consumidor.getDtnoraCalleId());
				plantillaSolicitudDetalle.setDtcalleId_label(consumidor.getDtnombreCalle());
				plantillaSolicitudDetalle.setDtcpId(consumidor.getDtnoraCpId());
				plantillaSolicitudDetalle.setDtnombreCp(consumidor.getDtnombreCp());
				plantillaSolicitudDetalle.setDtportalId(consumidor.getDtnoraPortalId());
				plantillaSolicitudDetalle.setDtnombrePortal(consumidor.getDtnombrePortal());
				plantillaSolicitudDetalle.setDtnombrePiso(consumidor.getDtnombrePiso());
				plantillaSolicitudDetalle.setDtnolo(consumidor.getDtnolo());
				plantillaSolicitudDetalle.setDtnodir(consumidor.getDtnodir());
				plantillaSolicitudDetalle.setDtnrcopo(consumidor.getDtnrcopo());
				plantillaSolicitudDetalle.setDtdireccion_nocapv(consumidor.getDtdireccion_nocapv());

				// buscar establecimiento
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(plantillaSolicitudDetalle.getEscodigo());
				// Alta interviniente establecimiento
				establecimiento = this.establecimientoDao.find(establecimiento);

				plantillaSolicitudDetalle.setEsnombre(establecimiento.getEsnombre());
				plantillaSolicitudDetalle.setEsnoco(establecimiento.getEsnoco());
				plantillaSolicitudDetalle.setEsnif(establecimiento.getEsnif());
				plantillaSolicitudDetalle.setEsnrtel(establecimiento.getEsnrtel());
				plantillaSolicitudDetalle.setEsnrtel2(establecimiento.getEsnrtel2());
				plantillaSolicitudDetalle.setEscoem(establecimiento.getEscoem());
				plantillaSolicitudDetalle.setEsprovinciaId(establecimiento.getEsnoraProvinciaId());
				plantillaSolicitudDetalle.setEsnombreProvincia(establecimiento.getEsnombreProvincia());
				plantillaSolicitudDetalle.setEsmunicipioId(establecimiento.getEsnoraMunicipioId());
				plantillaSolicitudDetalle.setEsnombreMunicipio(establecimiento.getEsnombreMunicipio());
				plantillaSolicitudDetalle.setEslocalidadId(establecimiento.getEsnoraLocalidadId());
				plantillaSolicitudDetalle.setEsnombreLocalidad(establecimiento.getEsnombreLocalidad());
				plantillaSolicitudDetalle.setEscalleId(establecimiento.getEsnoraCalleId());
				plantillaSolicitudDetalle.setEscalleId_label(establecimiento.getEsnombreCalle());
				plantillaSolicitudDetalle.setEscpId(establecimiento.getEsnoraCpId());
				plantillaSolicitudDetalle.setEsnombreCp(establecimiento.getEsnombreCp());
				plantillaSolicitudDetalle.setEsportalId(establecimiento.getEsnoraPortalId());
				plantillaSolicitudDetalle.setEsnombrePortal(establecimiento.getEsnombrePortal());
				plantillaSolicitudDetalle.setEsnombrePiso(establecimiento.getEsnombrePiso());
				plantillaSolicitudDetalle.setEsnolo(establecimiento.getEsnolo());
				plantillaSolicitudDetalle.setEsnodir(establecimiento.getEsnodir());
				plantillaSolicitudDetalle.setEsnrcopo(establecimiento.getEsnrcopo());
				plantillaSolicitudDetalle.setEsdireccion_nocapv(establecimiento.getEsdireccion_nocapv());
			}
		}
		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solicitudDetalle);

		plantillaSolicitudDetalle.setHdte(Y41bStringUtils.unescapeHTML(solDetalleAux.getHdte(), 0));

		plantillaSolicitudDetalle.setHdteso(Y41bStringUtils.unescapeHTML(plantillaSolicitudDetalle.getHdteso(), 0));

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());

		// Obtenemos los documentos de la solicitud
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

		Pagination pagination = new Pagination();
		pagination.setSort("EHFECHA ASC, EHHORA");
		pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);

		// Obtenemos los tramites de la solicitud
		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
				.findAllTramiteHecho(tramiteHechoDetalle, pagination);

		// Creamos la tabla de documentos
		String tablaDocumentos = this.generarTablaDocumentos(listDocumentoHecho);
		plantillaSolicitudDetalle.setTablaDocumentacion(tablaDocumentos);

		// Creamos la tabla de tramites
		String tablaTramites = this.generarTablaTramites(listTramiteHechoDetalle);
		plantillaSolicitudDetalle.setTablaTramites(tablaTramites);

		// Completamos el objetos con las fechas en formato texto
		plantillaSolicitudDetalle = this.completeInfoPlantillaSolicitudDetalle(plantillaSolicitudDetalle);

		// Devolvemos el objeto
		return plantillaSolicitudDetalle;

	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Denuncia> findAll(Denuncia denuncia, Pagination pagination) {
		return (List<Denuncia>) this.denunciaDao.findAll(denuncia, pagination);
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	public Long findAllCount(Denuncia denuncia) {
		return this.denunciaDao.findAllCount(denuncia);
	}

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination, Boolean startsWith) {
		return (List<Denuncia>) this.denunciaDao.findAllLike(denuncia, pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudes(SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("decoor ASC, denran ASC, LPAD(denror, 12) ");

		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {

			pagination.setSort("decoor DESC, denran DESC, LPAD(denror,12) ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("dtnombreMunicipio")) {
			pagination.setSort("DTNOMBRE_MUNICIPIO");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("orgNombre")) {
			pagination.setSort("ORGANISMONOMBREES");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("orgNombree")) {
			pagination.setSort("ORGANISMONOMBREEU");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<SolicitudBusqueda> listSolicitudesBusqueda = this.hechoDenunciadoDao
					.findAllLikeSolicitudes(solicitudesBusqueda, pagination, startsWith);

			for (SolicitudBusqueda sol : listSolicitudesBusqueda) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(sol.getDecoor()).append("-").append(sol.getDenror()).append("-")
						.append(sol.getDenran()).append("-").append(sol.getHdnror());

				sol.setNumExpediente(numeroExpediente.toString());

				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcohd(sol.getHdcodigo());

				TramiteHecho tramiteHechoAux = null;

				tramiteHechoAux = this.tramiteHechoDao.findUltimoTramite(tramitehecho);

				// Find Monitor
				if (tramiteHechoAux != null && tramiteHechoAux.getEhcomo() != null
						&& !tramiteHechoAux.getEhcomo().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomo());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				} else if (tramiteHechoAux != null && tramiteHechoAux.getEhcomoasignado() != null
						&& !tramiteHechoAux.getEhcomoasignado().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomoasignado());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				} else if (tramiteHechoAux != null && tramiteHechoAux.getEhcomoejecucion() != null
						&& !tramiteHechoAux.getEhcomoejecucion().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomoejecucion());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				}

				if (sol.getTrcodigo() != null && sol.getTrcodigo().equals(Y41bConstantes.TRAMITE_GENERICO)) {

					sol.setTrnombre(tramiteHechoAux.getEhnombretramite());
					sol.setTrnombree(tramiteHechoAux.getEhnombretramite());
				}

				// Expediente antiguo
				if (sol.getFcodigo() == null && sol.getDtcodigo() != null && sol.getEscodigo() != null) {
					logger.info("numeroExpediente: ", sol.getNumExpediente());
					logger.info("tramitehecho - Ehcohd: ", tramitehecho.getEhcohd());
					// buscar consumidor
					Consumidor consumidor = new Consumidor();
					consumidor.setDtcodigo(sol.getDtcodigo());
					consumidor = this.consumidorDao.find(consumidor);

					sol.setDtnombre(consumidor.getDtnombre());
					sol.setDtapellido1(consumidor.getDtapellido1());
					sol.setDtapellido2(consumidor.getDtapellido2());
					sol.setDtnif(consumidor.getDtnif());

					// buscar establecimiento
					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(sol.getEscodigo());
					// Alta interviniente establecimiento
					establecimiento = this.establecimientoDao.find(establecimiento);

					sol.setEsnombre(establecimiento.getEsnombre());
					sol.setEsnoco(establecimiento.getEsnoco());
					sol.setEsnif(establecimiento.getEsnif());
				}

				StringBuffer nombreCompleto = new StringBuffer();

				if (Y41bUtils.isFilled(sol.getDtnombre())) {
					nombreCompleto.append(sol.getDtnombre());
				}
				if (Y41bUtils.isFilled(sol.getDtapellido1())) {
					nombreCompleto.append(" ").append(sol.getDtapellido1());
				}
				if (Y41bUtils.isFilled(sol.getDtapellido2())) {
					nombreCompleto.append(" ").append(sol.getDtapellido2());
				}

				sol.setDtnombre(nombreCompleto.toString());

				if (sol.getDecodigo() != null && !Y41bUtils.isFilled(sol.getDenombre())) {
					// buscar en decisiones antiguas
					DecisionL21 decisionl21 = new DecisionL21();
					decisionl21.setTtdcodigo(sol.getDecodigo());

					decisionl21 = this.decisionL21Dao.find(decisionl21);

					// rellenar el nombre 
					if (decisionl21 != null) {
						sol.setDenombre(decisionl21.getTtdnombre());
						sol.setDenombree(decisionl21.getTtdnombree());
					}
				}
			}

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			logger.error("##################findAllLikeSolicitudes", e);
			return null;
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith) {
		return this.hechoDenunciadoDao.findAllLikeSolicitudesCount(solicitudesBusqueda, startsWith);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("decoor ASC, denran ASC, LPAD(denror, 12) ");

		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("decoor DESC, denran DESC, LPAD(denror,12) ");

		}

		if (pagination.getSort() != null && pagination.getSort().equals("dtnombreMunicipio")) {
			pagination.setSort("DTNOMBRE_MUNICIPIO");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("orgNombre")) {
			pagination.setSort("ORGANISMONOMBREES");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("orgNombree")) {
			pagination.setSort("ORGANISMONOMBREEU");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<SolicitudBusqueda> listSolicitudesBusqueda = this.hechoDenunciadoDao
					.findAllLikeSolicitudesBusquedaCombinada(busquedaCombinada, pagination, startsWith);

			for (SolicitudBusqueda sol : listSolicitudesBusqueda) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(sol.getDecoor()).append("-").append(sol.getDenror()).append("-")
						.append(sol.getDenran()).append("-").append(sol.getHdnror());

				sol.setNumExpediente(numeroExpediente.toString());

				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcohd(sol.getHdcodigo());

				TramiteHecho tramiteHechoAux = null;

				tramiteHechoAux = this.tramiteHechoDao.findUltimoTramite(tramitehecho);

				// Find Monitor
				if (tramiteHechoAux != null && tramiteHechoAux.getEhcomo() != null
						&& !tramiteHechoAux.getEhcomo().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomo());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				} else if (tramiteHechoAux != null && tramiteHechoAux.getEhcomoasignado() != null
						&& !tramiteHechoAux.getEhcomoasignado().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomoasignado());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				} else if (tramiteHechoAux != null && tramiteHechoAux.getEhcomoejecucion() != null
						&& !tramiteHechoAux.getEhcomoejecucion().equals("")) {
					CensoMonitor censoMonitor = new CensoMonitor();
					censoMonitor.setMocodigo(tramiteHechoAux.getEhcomoejecucion());

					censoMonitor = this.censoMonitorDao.find(censoMonitor);
					sol.setMocodigoTramitador(censoMonitor.getMocodigo());
					sol.setMonombreTramitador(censoMonitor.getMonombre());
				}

				if (sol.getTrcodigo() != null && sol.getTrcodigo().equals(Y41bConstantes.TRAMITE_GENERICO)) {
					sol.setTrnombre(tramiteHechoAux.getEhnombretramite());
					sol.setTrnombree(tramiteHechoAux.getEhnombretramite());
				}

				// Expediente antiguo
				if (sol.getFcodigo() == null && sol.getDtcodigo() != null && sol.getEscodigo() != null) {
					// if (sol.getFcodigo() == null ) {
					// buscar consumidor
					Consumidor consumidor = new Consumidor();
					consumidor.setDtcodigo(sol.getDtcodigo());
					consumidor = this.consumidorDao.find(consumidor);

					sol.setDtnombre(consumidor.getDtnombre());
					sol.setDtapellido1(consumidor.getDtapellido1());
					sol.setDtapellido2(consumidor.getDtapellido2());
					sol.setDtnif(consumidor.getDtnif());

					// buscar establecimiento
					Establecimiento establecimiento = new Establecimiento();
					establecimiento.setEscodigo(sol.getEscodigo());
					// Alta interviniente establecimiento
					establecimiento = this.establecimientoDao.find(establecimiento);

					sol.setEsnombre(establecimiento.getEsnombre());
					sol.setEsnoco(establecimiento.getEsnoco());
					sol.setEsnif(establecimiento.getEsnif());
				}

				StringBuffer nombreCompleto = new StringBuffer();

				if (Y41bUtils.isFilled(sol.getDtnombre())) {
					nombreCompleto.append(sol.getDtnombre());
				}
				if (Y41bUtils.isFilled(sol.getDtapellido1())) {
					nombreCompleto.append(" ").append(sol.getDtapellido1());
				}
				if (Y41bUtils.isFilled(sol.getDtapellido2())) {
					nombreCompleto.append(" ").append(sol.getDtapellido2());
				}

				sol.setDtnombre(nombreCompleto.toString());
			}

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith) {
		return this.hechoDenunciadoDao.findAllLikeSolicitudesBusquedaCombinadaCount(busquedaCombinada, startsWith);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return DecisionHechoDetalle
	 */
	public DecisionHechoDetalle findDecisionHecho(DecisionHechoDetalle decisionHechoDetalle) {
		return (DecisionHechoDetalle) this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoHechoDetalle findDocumentoHecho(DocumentoHechoDetalle documentoHechoDetalle)
			throws SerialException, SQLException, Exception {
		logger.info("findDocumentoHecho - Inicio");
		DocumentoHecho documentoHecho = new DocumentoHecho();

		documentoHecho.setQ5codocumento(documentoHechoDetalle.getQ5codocumento());

		documentoHecho = this.documentoHechoDao.findDocumentoHecho(documentoHecho);

		// si est en dokusi, descargar de dokusi
		if (documentoHecho != null && documentoHecho.getQ5iddocumentum() != null
				&& !documentoHecho.getQ5iddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			documento.setProcedure(procedure);
			documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

			Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
			documentoHecho.setQ5datafile(blob);
			documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
			documentoHecho.setQ5nofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			documentoHecho.setQ5sizefile(Integer.valueOf((int) docDokusi.getLength()));
		} else {
			// si no est en dokusi descargar de base de datos
		}

		documentoHechoDetalle = new DocumentoHechoDetalle(documentoHecho.getQ5codocumento(),
				documentoHecho.getQ5nofile(), documentoHecho.getQ5datafile(), documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(), documentoHecho.getQ5fecha(),
				documentoHecho.getQ5indmail(), documentoHecho.getQ5contenttypefile(), null, null, null, null, null,
				documentoHecho.getQ5tramite(), null, null, null, null, null, documentoHecho.getQ5ptcodigo());

		documentoHechoDetalle.setQ5iddocumentum(documentoHecho.getQ5iddocumentum());

		documentoHechoDetalle.setQ5numregistroentrada(documentoHecho.getQ5numregistroentrada());
		documentoHechoDetalle.setQ5fechaentrada(documentoHecho.getQ5fechaentrada());

		logger.info("findDocumentoHecho - Fin");

		return documentoHechoDetalle;
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocumentoHechoDetalle findDocumentoHechoSinDocumento(DocumentoHechoDetalle documentoHechoDetalle)
			throws SerialException, SQLException, Exception {
		logger.info("findDocumentoHecho - Inicio");
		DocumentoHecho documentoHecho = new DocumentoHecho();

		documentoHecho.setQ5codocumento(documentoHechoDetalle.getQ5codocumento());

		documentoHecho = this.documentoHechoDao.findDocumentoHecho(documentoHecho);

		// si est en dokusi, descargar de dokusi
		if (documentoHecho != null && documentoHecho.getQ5iddocumentum() != null
				&& !documentoHecho.getQ5iddocumentum().equals("")) {
			// descargar de dokusi
			// descargar documentos dokusi
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			documento.setProcedure(procedure);
			documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

			Documento docDokusi = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

			documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
			documentoHecho.setQ5nofile(Y41bUtils.getNameFileDokusi(docDokusi.getNombre()));
			documentoHecho.setQ5sizefile(Integer.valueOf((int) docDokusi.getLength()));
			documentoHecho.setRutaPif(docDokusi.getPifId());
		} else {
			// si no est en dokusi descargar de base de datos
		}

		documentoHechoDetalle = new DocumentoHechoDetalle(documentoHecho.getQ5codocumento(),
				documentoHecho.getQ5nofile(), documentoHecho.getQ5datafile(), documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(), documentoHecho.getQ5fecha(),
				documentoHecho.getQ5indmail(), documentoHecho.getQ5contenttypefile(), null, null, null, null, null,
				documentoHecho.getQ5tramite(), null, null, null, null, null, documentoHecho.getQ5ptcodigo());

		documentoHechoDetalle.setQ5iddocumentum(documentoHecho.getQ5iddocumentum());
		documentoHechoDetalle.setRutaPif(documentoHecho.getRutaPif());

		documentoHechoDetalle.setQ5numregistroentrada(documentoHecho.getQ5numregistroentrada());
		documentoHechoDetalle.setQ5fechaentrada(documentoHecho.getQ5fechaentrada());

		logger.info("findDocumentoHecho - Fin");

		return documentoHechoDetalle;
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 */
	public DocumentoHechoDetalle findDocumentoHechoByOIDDokusi(DocumentoHecho documentoHecho) {

		documentoHecho = this.documentoHechoDao.findDocumentoHechoByOIDDokusi(documentoHecho);

		DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle(documentoHecho.getQ5codocumento(),
				documentoHecho.getQ5nofile(), documentoHecho.getQ5datafile(), documentoHecho.getQ5sizefile(),
				documentoHecho.getQ5tedesfile(), documentoHecho.getQ5origen(), documentoHecho.getQ5fecha(),
				documentoHecho.getQ5indmail(), documentoHecho.getQ5contenttypefile(), null, null, null, null, null,
				null, null, null, null, null, null, null);

		return documentoHechoDetalle;
	}

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudArbitrajeDetalle
	 *            SolicitudArbitrajeDetalle
	 * @return SolicitudArbitrajeDetalle
	 */
	public SolicitudArbitrajeDetalle findSolicitudArbitraje(SolicitudArbitrajeDetalle solicitudArbitrajeDetalle) {

		try {
			return this.solicitudArbitrajeDao.findSolicitudArbitraje(solicitudArbitrajeDetalle);
		} catch (EmptyResultDataAccessException e) {
			throw new Y41bUDAException("error.solicitud.arbitraje.EmptyResultDataAccessException", true, e);
		}
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Denuncia denuncia) {
		this.denunciaDao.remove(denuncia);
	}

	/**
	 * Deletes multiple rows in the Denuncia table.
	 * 
	 * @param denunciaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Denuncia> denunciaList) {
		for (Denuncia denunciaAux : denunciaList) {
			this.denunciaDao.remove(denunciaAux);
		}
	}

	/**
	 * Getter method for DenunciaDao
	 * 
	 * @return DenunciaDao
	 */
	public DenunciaDao getDenunciaDao() {
		return this.denunciaDao;
	}

	/**
	 * Setter method for DenunciaDao.
	 * 
	 * @param denunciaDao
	 *            DenunciaDao
	 * @return
	 */
	public void setDenunciaDao(DenunciaDao denunciaDao) {
		logger.info("Setting Dependency " + denunciaDao);
		this.denunciaDao = denunciaDao;
	}

	/**
	 * Get a New PK DocumentoHecho.
	 * 
	 * @return Long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long getNewPKDocumentoHecho() {
		return this.documentoHechoDao.getNewPK();
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantilla(PlantillaTramite plantillaTramite, TramiteComun tramiteComun) throws Exception {

		// Obtener la plantilla del tramite
		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = this.findPlantillaTramiteHechoDetalle(tramiteComun);

		String ficheroGenerado = "";
		if (plantillaTramite.getPtplantilla() != null) {
			// Transformar el documento en castellano
			String plantilla = Y41bUtils.blobToString(plantillaTramite.getPtplantilla());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

			rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_TRAMITE_CASTELLANO);

			ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
					plantillaTramiteHechoDetalle, plantilla);
		}

		return ficheroGenerado;
	}

	/**
	 * Finds PlantillaTramiteHechoDetalle.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHechoDetalle(TramiteComun tramiteComun) throws Exception {
		// Obtener los datos de la solicitud
		PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle = new PlantillaTramiteHechoDetalle();
		plantillaTramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		plantillaTramiteHechoDetalle = this.tramiteHechoDao.findPlantillaTramiteHecho(plantillaTramiteHechoDetalle);
		// 202802
		plantillaTramiteHechoDetalle.setNombreTitularReclamante(plantillaTramiteHechoDetalle.getDtnombre());
		plantillaTramiteHechoDetalle.setIdentificacionTitularReclamante(plantillaTramiteHechoDetalle.getDtnif());

		plantillaTramiteHechoDetalle.setEhfecha(new Date());

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solicitudDetalle);
		plantillaTramiteHechoDetalle.setHdte(solDetalleAux.getHdte());

		if (plantillaTramiteHechoDetalle != null && plantillaTramiteHechoDetalle.getHdte() != null) {
			plantillaTramiteHechoDetalle.setHdte(Y41bStringUtils.unescapeHTML(
					Y41bUtils.eliminarTags(plantillaTramiteHechoDetalle.getHdte().replaceAll("\n", "&lineSeparator;")
							.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;")),
					0));
		}

		if (plantillaTramiteHechoDetalle != null && plantillaTramiteHechoDetalle.getHdteso() != null) {
			plantillaTramiteHechoDetalle.setHdteso(Y41bStringUtils.unescapeHTML(
					Y41bUtils.eliminarTags(plantillaTramiteHechoDetalle.getHdteso().replaceAll("\n", "&lineSeparator;")
							.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;")),
					0));
		}

		try {
			TramiteHecho tramitehechoMediacion = new TramiteHecho();
			tramitehechoMediacion.setEhcodigo(tramiteComun.getIdTramite());

			tramitehechoMediacion = this.tramiteHechoDao.find(tramitehechoMediacion);

			if (tramitehechoMediacion != null && tramitehechoMediacion.getEhfechamediacion() != null) {
				plantillaTramiteHechoDetalle.setEhfechamediacion(tramitehechoMediacion.getEhfechamediacion());

				plantillaTramiteHechoDetalle
						.setEhresumenmediacion(Y41bUtils.clobToString(tramitehechoMediacion.getEhresumenmediacion()));

				if (plantillaTramiteHechoDetalle.getEhresumenmediacion() != null) {
					plantillaTramiteHechoDetalle.setEhresumenmediacion(Y41bStringUtils.unescapeHTML(
							plantillaTramiteHechoDetalle.getEhresumenmediacion().replaceAll("\n", "&lineSeparator;"),
							0));
				}
			}
			if (tramitehechoMediacion != null && (tramitehechoMediacion.getEhcotee()
					.equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION)
					|| tramitehechoMediacion.getEhcotee().equals(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION))) {

				plantillaTramiteHechoDetalle.setDocumentacionrequerida(
						Y41bUtils.clobToString(tramitehechoMediacion.getEhdocumentacionrequerida()));

				if (plantillaTramiteHechoDetalle.getDocumentacionrequerida() != null) {
					plantillaTramiteHechoDetalle.setDocumentacionrequerida(Y41bStringUtils.unescapeHTML(
							plantillaTramiteHechoDetalle.getDocumentacionrequerida().replaceAll("\n", "&lineSeparator;")
									.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"),
							0));
				}

				plantillaTramiteHechoDetalle.setDocumentacionrequeridae(
						Y41bUtils.clobToString(tramitehechoMediacion.getEhdocumentacionrequeridae()));

				if (plantillaTramiteHechoDetalle.getDocumentacionrequeridae() != null) {
					plantillaTramiteHechoDetalle
							.setDocumentacionrequeridae(Y41bStringUtils.unescapeHTML(plantillaTramiteHechoDetalle
									.getDocumentacionrequeridae().replaceAll("\n", "&lineSeparator;")
									.replaceAll("", "&euro;").replaceAll("\u20AC", "&euro;"), 0));
				}
			}

			if (tramitehechoMediacion != null
					&& tramitehechoMediacion.getEhcotee().equals(Y41bConstantes.TRAMITE_RESPUESTA_AMPLIACION_PLAZO)) {
				plantillaTramiteHechoDetalle.setFechaSolAmpliacionPlazoTextoCas(
						Y41bUtils.formatearDateToString(tramitehechoMediacion.getEhfechasolampliacionplazo(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFechaSolAmpliacionPlazoTextoEus(
						Y41bUtils.formatearDateToStringEuskera(tramitehechoMediacion.getEhfechasolampliacionplazo(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

				plantillaTramiteHechoDetalle.setPlazoConcedido(tramitehechoMediacion.getEhplazoconcedido());

			}
			// 200990 //
			// INTERLOCUTOR
			plantillaTramiteHechoDetalle
					.setInterlocutor(Y41bUtils.clobToString(tramitehechoMediacion.getEhintervinientes()));

			// IMPORTE
			if (plantillaTramiteHechoDetalle.getHdcaptso() != null) {
				StringBuffer importe = new StringBuffer();
				// EU
				importe.append(this.appMessageSource.getMessage("informemediacion.importe", null,
						new Locale(Y41bConstantes.EUSKERA)));
				// Separador
				importe.append(" / ");
				// ES
				importe.append(this.appMessageSource.getMessage("informemediacion.importe", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				importe.append(": ");
				importe.append(plantillaTramiteHechoDetalle.getHdcaptso());

				plantillaTramiteHechoDetalle.setImporte(importe.toString());

			} else {
				plantillaTramiteHechoDetalle.setImporte("");
			}

		} catch (Exception e) {
		}

		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		plantillaTramiteHechoDetalle.setFechaHoy(todayWithZeroTime);

		// PLANTILLA - TRASLADO RED CIAC
		// 1.- buscar el ultimo TRAMITE_TRASLADO_RED_CIAC = "K12";
		TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
		tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_TRASLADO_RED_CIAC);
		tramiteHechoDetalleAux.setHdcodigo(solicitudDetalle.getHdcodigo());
		try {
			tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
		} catch (Exception e) {
		}
		if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcoortraspaso() != null) {
			// 2.- coger el cod organismo de traslado y hacer un find de
			// organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramiteHechoDetalleAux.getEhcoortraspaso());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
			// 3.- meter los datos del organismo de traslado en
			// plantillaTramiteHechoDetalle
			plantillaTramiteHechoDetalle.setCodOrgTraslado(organismo.getCodOrg());
			plantillaTramiteHechoDetalle.setNombreEuTraslado(organismo.getNombreEu());
			plantillaTramiteHechoDetalle.setNombreEsTraslado(organismo.getNombreEs());
			plantillaTramiteHechoDetalle.setNombreCalleTraslado(organismo.getNombreCalle());
			plantillaTramiteHechoDetalle.setNoraCpIdTraslado(organismo.getNoraCpId());
			plantillaTramiteHechoDetalle.setNombreMunicipioTraslado(organismo.getNombreMunicipio());
			plantillaTramiteHechoDetalle.setNombrePortalTraslado(organismo.getNombrePortal());
			plantillaTramiteHechoDetalle.setNombrePisoTraslado(organismo.getCompleDirec());
			if (organismo.getNoraPaisId() != null && !organismo.getNoraPaisId().equals("0")
					&& !organismo.getNoraPaisId().equals("128")) {
				plantillaTramiteHechoDetalle.setNombrePaisTraslado(organismo.getNombrePais());
			}
			plantillaTramiteHechoDetalle.setDireccionNocapvTraslado(organismo.getNombreCalle());

			plantillaTramiteHechoDetalle.setTelefonoTraslado(organismo.getTelefono());
			plantillaTramiteHechoDetalle.setFaxTraslado(organismo.getFax());
			plantillaTramiteHechoDetalle.setEmailTraslado(organismo.getEmail());
		}

		// PLANTILLA - SOLICITUD COLABORACION OTRO ORGANISMO
		// 1.- buscar el ultimo TRAMITE_SOLICITUD_COLABORACION = "K50";
		tramiteHechoDetalleAux = new TramiteHechoDetalle();
		tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_SOLICITUD_COLABORACION);
		tramiteHechoDetalleAux.setHdcodigo(solicitudDetalle.getHdcodigo());
		try {
			tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
		} catch (Exception e) {
		}
		if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhidorganismocolabsol() != null) {
			// 2.- coger el cod organismo de destino y hacer un find de
			// organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramiteHechoDetalleAux.getEhidorganismocolabsol());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
			// 3.- meter los datos del organismo de traslado en
			// plantillaTramiteHechoDetalle
			plantillaTramiteHechoDetalle.setCodOrgDestColaboracion(organismo.getCodOrg());
			plantillaTramiteHechoDetalle.setNombreEuDestColaboracion(organismo.getNombreEu());
			plantillaTramiteHechoDetalle.setNombreEsDestColaboracion(organismo.getNombreEs());
			plantillaTramiteHechoDetalle.setNombreCalleDestColaboracion(organismo.getNombreCalle());
			plantillaTramiteHechoDetalle.setNoraCpIdDestColaboracion(organismo.getNoraCpId());
			plantillaTramiteHechoDetalle.setNombreCpDestColaboracion(organismo.getNombreCp());
			plantillaTramiteHechoDetalle.setNombreMunicipioDestColaboracion(organismo.getNombreMunicipio());
			plantillaTramiteHechoDetalle.setNombreProvinciaDestColaboracion(organismo.getNombreProvincia());
			plantillaTramiteHechoDetalle.setNombrePortalDestColaboracion(organismo.getNombrePortal());
			plantillaTramiteHechoDetalle.setNombrePisoDestColaboracion(organismo.getCompleDirec());
			if (organismo.getNoraPaisId() != null && !organismo.getNoraPaisId().equals("0")
					&& !organismo.getNoraPaisId().equals("128")) {
				plantillaTramiteHechoDetalle.setNombrePaisDestColaboracion(organismo.getNombrePais());
			}
			plantillaTramiteHechoDetalle.setDireccionNocapvDestColaboracion(organismo.getNombreCalle());

			plantillaTramiteHechoDetalle.setTelefonoDestColaboracion(organismo.getTelefono());
			plantillaTramiteHechoDetalle.setFaxDestColaboracion(organismo.getFax());
			plantillaTramiteHechoDetalle.setEmailDestColaboracion(organismo.getEmail());
		}

		/*
		 * CONSUMIDOR - ALEGACIONES 1.- findUltimoTramiteReqAlegacion (K06 y C)
		 * -> fecha req cas y eus 2.- findTramiteRelacionadoAlegacion (ehcodigo
		 * y codrelacionado) -> fecha com cas y eus 3.- si tiene comunicacion o
		 * alegacion para fecha recepcion nuevas alegaciones
		 */

		tramiteHechoDetalleAux = new TramiteHechoDetalle();

		try {
			TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
			miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
			miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
			String origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;

			tramiteHechoDetalleAux = this.tramiteHechoDao
					.findUltimoTramiteHechoPorTipoTramiteYOrigen(miTramiteHechoDetalle, origen);
		} catch (Exception e) {
		}

		if (tramiteHechoDetalleAux != null) {
			plantillaTramiteHechoDetalle.setFechaSolicitudAlegacionCasCons(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setFechaSolicitudAlegacionEusCons(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

			try {
				TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
				miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
				miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
				miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

				tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
			} catch (Exception e) {
			}

			if (tramiteHechoDetalleAux != null) {
				plantillaTramiteHechoDetalle.setFechaRecepcionalegacionesCasCons(
						Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFechaRecepcionalegacionesEusCons(
						Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

				try {
					TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
					miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
					miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
					miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

					tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null) {
					TramiteHecho tramiteHechoAux = new TramiteHecho();
					tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

					tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

					if (tramiteHechoAux != null) {
						plantillaTramiteHechoDetalle.setFechacomunicacionAlegacionesCasEst(Y41bUtils.parseDateToString(
								tramiteHechoAux.getEhfechacomunicacion(), Y41bConstantes.CASTELLANO));
						plantillaTramiteHechoDetalle.setFechacomunicacionAlegacionesEusEst(Y41bUtils
								.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(), Y41bConstantes.EUSKERA));
					}
				}

			}

		}

		/*
		 * ESTABLECIMIENTO - ALEGACIONES 1.- findUltimoTramiteReqAlegacion (K06
		 * y R) 2.- findTramiteRelacionadoAlegacion (ehcodigo y codrelacionado)
		 * 3.- si tiene comunicacion o alegacion para fecha recepcion
		 */

		tramiteHechoDetalleAux = new TramiteHechoDetalle();

		try {
			TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
			miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
			miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
			String origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;

			tramiteHechoDetalleAux = this.tramiteHechoDao
					.findUltimoTramiteHechoPorTipoTramiteYOrigen(miTramiteHechoDetalle, origen);
		} catch (Exception e) {
		}

		if (tramiteHechoDetalleAux != null) {
			plantillaTramiteHechoDetalle.setFechaSolicitudAlegacionCasEst(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setFechaSolicitudAlegacionEusEst(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

			try {
				TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
				miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
				miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
				miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

				tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
			} catch (Exception e) {
			}

			if (tramiteHechoDetalleAux != null) {
				plantillaTramiteHechoDetalle.setFechaRecepcionalegacionesCasEst(
						Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFechaRecepcionalegacionesEusEst(
						Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

				try {
					TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
					miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
					miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
					miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

					tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null) {
					TramiteHecho tramiteHechoAux = new TramiteHecho();
					tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

					tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

					if (tramiteHechoAux != null) {
						plantillaTramiteHechoDetalle.setFechacomunicacionAlegacionesCasCons(Y41bUtils.parseDateToString(
								tramiteHechoAux.getEhfechacomunicacion(), Y41bConstantes.CASTELLANO));
						plantillaTramiteHechoDetalle.setFechacomunicacionAlegacionesEusCons(Y41bUtils
								.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(), Y41bConstantes.EUSKERA));
					}
				}

			}

		}

		tramiteHechoDetalleAux = new TramiteHechoDetalle();

		try {
			TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
			miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO);
			miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

			tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(miTramiteHechoDetalle);
		} catch (Exception e) {
		}

		if (tramiteHechoDetalleAux != null) {
			plantillaTramiteHechoDetalle.setFechaRegistroOrdenConsejeroCas(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setFechaRegistroOrdenConsejeroEus(
					Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));
		}

		tramiteHechoDetalleAux = new TramiteHechoDetalle();

		try {
			TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
			miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_DECISION);
			miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

			tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(miTramiteHechoDetalle);
		} catch (Exception e) {
		}

		if (tramiteHechoDetalleAux != null) {
			TramiteHecho tramiteHechoAux = new TramiteHecho();
			tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

			tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

			if (tramiteHechoAux != null) {
				plantillaTramiteHechoDetalle.setFechaTramitacionResolucionCas(
						Y41bUtils.parseDateToString(tramiteHechoAux.getEhfecharesolucion(), Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFechaTramitacionResolucionEus(
						Y41bUtils.parseDateToString(tramiteHechoAux.getEhfecharesolucion(), Y41bConstantes.EUSKERA));

				plantillaTramiteHechoDetalle.setFechaTramitacionResolucionTextoCas(
						Y41bUtils.formatearDateToString(tramiteHechoAux.getEhfecharesolucion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFechaTramitacionResolucionTextoEus(
						Y41bUtils.formatearDateToStringEuskera(tramiteHechoAux.getEhfecharesolucion(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
			decisionHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());

			decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

			plantillaTramiteHechoDetalle.setDenombre(decisionHechoDetalle.getDenombre());
			plantillaTramiteHechoDetalle.setDenombree(decisionHechoDetalle.getDenombree());
		}

		// 1.- buscar el ultimo TRAMITE_RECEPCION_RECURSO = "K15";
		tramiteHechoDetalleAux = new TramiteHechoDetalle();
		tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_RECEPCION_RECURSO);
		tramiteHechoDetalleAux.setHdcodigo(solicitudDetalle.getHdcodigo());
		try {
			tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
		} catch (Exception e) {
		}
		if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcodigo() != null) {

			TramiteHecho tramitehechoRecurso = new TramiteHecho();
			tramitehechoRecurso.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

			tramitehechoRecurso = this.tramiteHechoDao.find(tramitehechoRecurso);

			if (tramitehechoRecurso != null) {
				plantillaTramiteHechoDetalle.setFecharecursoCas(Y41bUtils
						.parseDateToString(tramitehechoRecurso.getEhfecharecurso(), Y41bConstantes.CASTELLANO));
				plantillaTramiteHechoDetalle.setFecharecursoEus(
						Y41bUtils.parseDateToString(tramitehechoRecurso.getEhfecharecurso(), Y41bConstantes.EUSKERA));

				plantillaTramiteHechoDetalle
						.setEhmotivorecurso(Y41bUtils.clobToString(tramitehechoRecurso.getEhmotivorecurso()));
			}

		}

		//

		plantillaTramiteHechoDetalle = this.completeInfoPlantillaTramiteHechoDetalle(plantillaTramiteHechoDetalle);

		TramiteHecho tramitehechoComunicacionNotificacion = new TramiteHecho();
		tramitehechoComunicacionNotificacion.setEhcodigo(tramiteComun.getIdTramite());

		tramitehechoComunicacionNotificacion = this.tramiteHechoDao.find(tramitehechoComunicacionNotificacion);

		if (tramitehechoComunicacionNotificacion != null && tramitehechoComunicacionNotificacion.getEhsede() != null
				&& tramitehechoComunicacionNotificacion.getEhsede().equals(Y41bConstantes.VALOR_SI)) {

			// Primero, hay que recuperar el establecimiento marcado como
			// sede
			Establecimiento establecimientoDeSedeAux = new Establecimiento();
			establecimientoDeSedeAux.setEsnif(plantillaTramiteHechoDetalle.getEsnif());
			establecimientoDeSedeAux = this.establecimientoService.obtenerEstablecimientoSede(establecimientoDeSedeAux);

			// Se recupera los datos de sede del establecimiento marcado en
			// BBDD como sede
			Sede sedeAux = new Sede();
			sedeAux.setEscodigo(establecimientoDeSedeAux.getEscodigo());
			sedeAux.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			List<Sede> listasede = this.sedeService.findAll(sedeAux, null);

			if (listasede != null && listasede.size() > 0) {
				Sede sede = listasede.get(0);

				plantillaTramiteHechoDetalle.setEsprovinciaId(sede.getNoraProvinciaId());
				plantillaTramiteHechoDetalle.setEsnombreProvincia(sede.getNombreProvincia());
				plantillaTramiteHechoDetalle.setEsmunicipioId(sede.getNoraMunicipioId());
				plantillaTramiteHechoDetalle.setEsnombreMunicipio(sede.getNombreMunicipio());
				plantillaTramiteHechoDetalle.setEslocalidadId(sede.getNoraLocalidadId());
				plantillaTramiteHechoDetalle.setEsnombreLocalidad(sede.getNombreLocalidad());
				plantillaTramiteHechoDetalle.setEsnoraCalleId(sede.getNoraCalleId());
				plantillaTramiteHechoDetalle.setEsnombreCalle(sede.getNombreCalle());
				plantillaTramiteHechoDetalle.setEscpId(sede.getNoraCpId());
				plantillaTramiteHechoDetalle.setEsnombreCp(sede.getNombreCp());
				plantillaTramiteHechoDetalle.setEsportalId(sede.getNoraPortalId());
				plantillaTramiteHechoDetalle.setEsnombrePortal(sede.getNombrePortal());
				plantillaTramiteHechoDetalle.setEsnombrePiso(sede.getNombrePiso());

				plantillaTramiteHechoDetalle.setEsdireccion_nocapv(sede.getDireccionNocapv());

				// Creamos el campo direccion del establecimiento
				StringBuffer direccionCompleta = new StringBuffer();

				if (plantillaTramiteHechoDetalle.getEsnombreCalle() != null
						&& !plantillaTramiteHechoDetalle.getEsnombreCalle().equals("")) {
					direccionCompleta.append(plantillaTramiteHechoDetalle.getEsnombreCalle());

					if (plantillaTramiteHechoDetalle.getEsnombrePortal() != null
							&& !plantillaTramiteHechoDetalle.getEsnombrePortal().equals("")) {
						direccionCompleta.append(", ").append(plantillaTramiteHechoDetalle.getEsnombrePortal());
					}
					if (plantillaTramiteHechoDetalle.getEsnombrePiso() != null
							&& !plantillaTramiteHechoDetalle.getEsnombrePiso().equals("")) {
						direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getEsnombrePiso());
					}
				} else {
					if (plantillaTramiteHechoDetalle.getEsdireccion_nocapv() != null
							&& !plantillaTramiteHechoDetalle.getEsdireccion_nocapv().equals("")) {
						direccionCompleta.append(plantillaTramiteHechoDetalle.getEsdireccion_nocapv());
					} else {
						direccionCompleta.append(plantillaTramiteHechoDetalle.getEsnodir());
					}
				}

				plantillaTramiteHechoDetalle.setEsdireccion(direccionCompleta.toString());

				// Creamos el campo codigo postal y municipio del
				// establecimiento
				StringBuffer cpMunicipio = new StringBuffer();

				if (plantillaTramiteHechoDetalle.getEsnombreCp() != null
						&& !plantillaTramiteHechoDetalle.getEsnombreCp().equals("")) {
					cpMunicipio.append(plantillaTramiteHechoDetalle.getEsnombreCp());

					if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
							&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio().equals("")) {
						cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getEsnombreMunicipio());
					}
				} else if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio().equals("")) {
					cpMunicipio.append(plantillaTramiteHechoDetalle.getEsnombreMunicipio());
				}

				plantillaTramiteHechoDetalle.setEscpMunicipio(cpMunicipio.toString());
			}
		}

		if (tramitehechoComunicacionNotificacion != null
				&& tramitehechoComunicacionNotificacion.getEhiddestinatario() != null) {

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramitehechoComunicacionNotificacion.getEhiddestinatario());

			Intervinientes intervinientesAux = this.intervinientesDao.find(intervinientes);

			if (intervinientesAux.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {

				plantillaTramiteHechoDetalle.setNombreDestinatario(plantillaTramiteHechoDetalle.getDtnombre());
				plantillaTramiteHechoDetalle.setNombreComercialDestinatario("");

				plantillaTramiteHechoDetalle.setIdentificacionDestinatario(plantillaTramiteHechoDetalle.getDtnif());
				plantillaTramiteHechoDetalle
						.setProvinciaIdDestinatario(plantillaTramiteHechoDetalle.getDtprovinciaId());
				plantillaTramiteHechoDetalle
						.setNombreProvinciaDestinatario(plantillaTramiteHechoDetalle.getDtnombreProvincia());
				plantillaTramiteHechoDetalle
						.setMunicipioIdDestinatario(plantillaTramiteHechoDetalle.getDtmunicipioId());
				plantillaTramiteHechoDetalle
						.setNombreMunicipioDestinatario(plantillaTramiteHechoDetalle.getDtnombreMunicipio());
				plantillaTramiteHechoDetalle
						.setLocalidadIdDestinatario(plantillaTramiteHechoDetalle.getDtlocalidadId());
				plantillaTramiteHechoDetalle
						.setNombreLocalidadDestinatario(plantillaTramiteHechoDetalle.getDtnombreLocalidad());
				plantillaTramiteHechoDetalle
						.setNoraCalleIdDestinatario(plantillaTramiteHechoDetalle.getDtnoraCalleId());
				plantillaTramiteHechoDetalle
						.setNombreCalleDestinatario(plantillaTramiteHechoDetalle.getDtnombreCalle());
				plantillaTramiteHechoDetalle.setCpIdDestinatario(plantillaTramiteHechoDetalle.getDtcpId());
				plantillaTramiteHechoDetalle.setNombreCpDestinatario(plantillaTramiteHechoDetalle.getDtnombreCp());
				plantillaTramiteHechoDetalle.setPortalIdDestinatario(plantillaTramiteHechoDetalle.getDtportalId());
				plantillaTramiteHechoDetalle
						.setNombrePortalDestinatario(plantillaTramiteHechoDetalle.getDtnombrePortal());
				plantillaTramiteHechoDetalle.setNombrePisoDestinatario(plantillaTramiteHechoDetalle.getDtnombrePiso());

				plantillaTramiteHechoDetalle.setNoloDestinatario(plantillaTramiteHechoDetalle.getDtnolo());
				plantillaTramiteHechoDetalle.setNodirDestinatario(plantillaTramiteHechoDetalle.getDtnodir());
				plantillaTramiteHechoDetalle.setNrcopoDestinatario(plantillaTramiteHechoDetalle.getDtnrcopo());
				plantillaTramiteHechoDetalle
						.setDireccion_nocapvDestinatario(plantillaTramiteHechoDetalle.getDtdireccion_nocapv());

				plantillaTramiteHechoDetalle.setDireccionDestinatario(plantillaTramiteHechoDetalle.getDtdireccion());
				plantillaTramiteHechoDetalle
						.setCpMunicipioDestinatario(plantillaTramiteHechoDetalle.getDtcpMunicipio());

			} else if (intervinientesAux.getTipoInterviniente()
					.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {

				plantillaTramiteHechoDetalle.setNombreDestinatario(plantillaTramiteHechoDetalle.getEsnombre());
				plantillaTramiteHechoDetalle.setNombreComercialDestinatario(plantillaTramiteHechoDetalle.getEsnoco());

				plantillaTramiteHechoDetalle.setIdentificacionDestinatario(plantillaTramiteHechoDetalle.getEsnif());
				plantillaTramiteHechoDetalle
						.setProvinciaIdDestinatario(plantillaTramiteHechoDetalle.getEsprovinciaId());
				plantillaTramiteHechoDetalle
						.setNombreProvinciaDestinatario(plantillaTramiteHechoDetalle.getEsnombreProvincia());
				plantillaTramiteHechoDetalle
						.setMunicipioIdDestinatario(plantillaTramiteHechoDetalle.getEsmunicipioId());
				plantillaTramiteHechoDetalle
						.setNombreMunicipioDestinatario(plantillaTramiteHechoDetalle.getEsnombreMunicipio());
				plantillaTramiteHechoDetalle
						.setLocalidadIdDestinatario(plantillaTramiteHechoDetalle.getEslocalidadId());
				plantillaTramiteHechoDetalle
						.setNombreLocalidadDestinatario(plantillaTramiteHechoDetalle.getEsnombreLocalidad());
				plantillaTramiteHechoDetalle
						.setNoraCalleIdDestinatario(plantillaTramiteHechoDetalle.getEsnoraCalleId());
				plantillaTramiteHechoDetalle
						.setNombreCalleDestinatario(plantillaTramiteHechoDetalle.getEsnombreCalle());
				plantillaTramiteHechoDetalle.setCpIdDestinatario(plantillaTramiteHechoDetalle.getEscpId());
				plantillaTramiteHechoDetalle.setNombreCpDestinatario(plantillaTramiteHechoDetalle.getEsnombreCp());
				plantillaTramiteHechoDetalle.setPortalIdDestinatario(plantillaTramiteHechoDetalle.getEsportalId());
				plantillaTramiteHechoDetalle
						.setNombrePortalDestinatario(plantillaTramiteHechoDetalle.getEsnombrePortal());
				plantillaTramiteHechoDetalle.setNombrePisoDestinatario(plantillaTramiteHechoDetalle.getEsnombrePiso());

				plantillaTramiteHechoDetalle.setNoloDestinatario(plantillaTramiteHechoDetalle.getEsnolo());
				plantillaTramiteHechoDetalle.setNodirDestinatario(plantillaTramiteHechoDetalle.getEsnodir());
				plantillaTramiteHechoDetalle.setNrcopoDestinatario(plantillaTramiteHechoDetalle.getEsnrcopo());
				plantillaTramiteHechoDetalle
						.setDireccion_nocapvDestinatario(plantillaTramiteHechoDetalle.getEsdireccion_nocapv());

				plantillaTramiteHechoDetalle.setDireccionDestinatario(plantillaTramiteHechoDetalle.getEsdireccion());
				plantillaTramiteHechoDetalle
						.setCpMunicipioDestinatario(plantillaTramiteHechoDetalle.getEscpMunicipio());
			} else {

				StringBuffer nombredestinatario = new StringBuffer();
				nombredestinatario.append(intervinientesAux.getNombre());

				if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
					nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
				}

				if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
					nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
				}

				plantillaTramiteHechoDetalle.setNombreDestinatario(nombredestinatario.toString());
				plantillaTramiteHechoDetalle.setNombreComercialDestinatario("");

				plantillaTramiteHechoDetalle.setIdentificacionDestinatario(intervinientesAux.getNif());
				plantillaTramiteHechoDetalle.setProvinciaIdDestinatario(intervinientesAux.getNoraProvinciaId());
				plantillaTramiteHechoDetalle.setNombreProvinciaDestinatario(intervinientesAux.getNombreProvincia());
				plantillaTramiteHechoDetalle.setMunicipioIdDestinatario(intervinientesAux.getNoraMunicipioId());
				plantillaTramiteHechoDetalle.setNombreMunicipioDestinatario(intervinientesAux.getNombreMunicipio());
				plantillaTramiteHechoDetalle.setLocalidadIdDestinatario(intervinientesAux.getNoraLocalidadId());
				plantillaTramiteHechoDetalle.setNombreLocalidadDestinatario(intervinientesAux.getNombreLocalidad());
				plantillaTramiteHechoDetalle.setNoraCalleIdDestinatario(intervinientesAux.getNoraCalleId());
				plantillaTramiteHechoDetalle.setNombreCalleDestinatario(intervinientesAux.getNombreCalle());
				plantillaTramiteHechoDetalle.setCpIdDestinatario(intervinientesAux.getNoraCpId());
				plantillaTramiteHechoDetalle.setNombreCpDestinatario(intervinientesAux.getNombreCp());
				plantillaTramiteHechoDetalle.setPortalIdDestinatario(intervinientesAux.getNoraPortalId());
				plantillaTramiteHechoDetalle.setNombrePortalDestinatario(intervinientesAux.getNombrePortal());
				plantillaTramiteHechoDetalle.setNombrePisoDestinatario(intervinientesAux.getNombrePiso());

				plantillaTramiteHechoDetalle.setDireccion_nocapvDestinatario(intervinientesAux.getDireccionNocapv());

				// Creamos el campo direccion del establecimiento
				StringBuffer direccionCompleta = new StringBuffer();

				if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
					direccionCompleta.append(intervinientesAux.getNombreCalle());

					if (intervinientesAux.getNombrePortal() != null
							&& !intervinientesAux.getNombrePortal().equals("")) {
						direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
					}
					if (intervinientesAux.getNombrePiso() != null && !intervinientesAux.getNombrePiso().equals("")) {
						direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
					}
				} else {
					if (intervinientesAux.getDireccionNocapv() != null
							&& !intervinientesAux.getDireccionNocapv().equals("")) {
						direccionCompleta.append(intervinientesAux.getDireccionNocapv());
					}
				}

				plantillaTramiteHechoDetalle.setDireccionDestinatario(direccionCompleta.toString());

				// Creamos el campo codigo postal y municipio del
				// establecimiento
				StringBuffer cpMunicipio = new StringBuffer();

				if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
					cpMunicipio.append(intervinientesAux.getNombreCp());

					if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
					}
				} else if (intervinientesAux.getNombreMunicipio() != null
						&& !intervinientesAux.getNombreMunicipio().equals("")) {
					cpMunicipio.append(intervinientesAux.getNombreMunicipio());
				}

				plantillaTramiteHechoDetalle.setCpMunicipioDestinatario(cpMunicipio.toString());
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);

		Intervinientes intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientesAux != null) {
			StringBuffer nombredestinatario = new StringBuffer();
			nombredestinatario.append(intervinientesAux.getNombre());

			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
			}

			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
			}

			plantillaTramiteHechoDetalle.setNombreRepresentanteReclamante(nombredestinatario.toString());
			plantillaTramiteHechoDetalle.setNifRepresentanteReclamante(intervinientesAux.getNif());
		}

		intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);

		intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientesAux != null) {
			StringBuffer nombredestinatario = new StringBuffer();
			nombredestinatario.append(intervinientesAux.getNombre());

			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
			}

			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
			}

			plantillaTramiteHechoDetalle.setNombreRepresentanteReclamado(nombredestinatario.toString());
			plantillaTramiteHechoDetalle.setNifRepresentanteReclamado(intervinientesAux.getNif());
		}

		if (tramitehechoComunicacionNotificacion != null
				&& tramitehechoComunicacionNotificacion.getEhorigenalegacion() != null) {
			if (tramitehechoComunicacionNotificacion.getEhorigenalegacion()
					.equals(Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE)) {
				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteHechoDetalle.setNombreTitular(nombredestinatario.toString());
					plantillaTramiteHechoDetalle.setNombreComercialTitular("");

					plantillaTramiteHechoDetalle.setIdentificacionTitular(intervinientesAux.getNif());
					plantillaTramiteHechoDetalle.setProvinciaIdTitular(intervinientesAux.getNoraProvinciaId());
					plantillaTramiteHechoDetalle.setNombreProvinciaTitular(intervinientesAux.getNombreProvincia());
					plantillaTramiteHechoDetalle.setMunicipioIdTitular(intervinientesAux.getNoraMunicipioId());
					plantillaTramiteHechoDetalle.setNombreMunicipioTitular(intervinientesAux.getNombreMunicipio());
					plantillaTramiteHechoDetalle.setLocalidadIdTitular(intervinientesAux.getNoraLocalidadId());
					plantillaTramiteHechoDetalle.setNombreLocalidadTitular(intervinientesAux.getNombreLocalidad());
					plantillaTramiteHechoDetalle.setNoraCalleIdTitular(intervinientesAux.getNoraCalleId());
					plantillaTramiteHechoDetalle.setNombreCalleTitular(intervinientesAux.getNombreCalle());
					plantillaTramiteHechoDetalle.setCpIdTitular(intervinientesAux.getNoraCpId());
					plantillaTramiteHechoDetalle.setNombreCpTitular(intervinientesAux.getNombreCp());
					plantillaTramiteHechoDetalle.setPortalIdTitular(intervinientesAux.getNoraPortalId());
					plantillaTramiteHechoDetalle.setNombrePortalTitular(intervinientesAux.getNombrePortal());
					plantillaTramiteHechoDetalle.setNombrePisoTitular(intervinientesAux.getNombrePiso());

					plantillaTramiteHechoDetalle.setDireccion_nocapvTitular(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteHechoDetalle.setDireccionTitular(direccionCompleta.toString());

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteHechoDetalle.setCpMunicipioTitular(cpMunicipio.toString());
				}

				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteHechoDetalle.setNombreRepresentanteNoValidado(nombredestinatario.toString());
					plantillaTramiteHechoDetalle.setNombreComercialRepresentanteNoValidado("");

					plantillaTramiteHechoDetalle.setIdentificacionRepresentanteNoValidado(intervinientesAux.getNif());
					plantillaTramiteHechoDetalle
							.setProvinciaIdRepresentanteNoValidado(intervinientesAux.getNoraProvinciaId());
					plantillaTramiteHechoDetalle
							.setNombreProvinciaRepresentanteNoValidado(intervinientesAux.getNombreProvincia());
					plantillaTramiteHechoDetalle
							.setMunicipioIdRepresentanteNoValidado(intervinientesAux.getNoraMunicipioId());
					plantillaTramiteHechoDetalle
							.setNombreMunicipioRepresentanteNoValidado(intervinientesAux.getNombreMunicipio());
					plantillaTramiteHechoDetalle
							.setLocalidadIdRepresentanteNoValidado(intervinientesAux.getNoraLocalidadId());
					plantillaTramiteHechoDetalle
							.setNombreLocalidadRepresentanteNoValidado(intervinientesAux.getNombreLocalidad());
					plantillaTramiteHechoDetalle
							.setNoraCalleIdRepresentanteNoValidado(intervinientesAux.getNoraCalleId());
					plantillaTramiteHechoDetalle
							.setNombreCalleRepresentanteNoValidado(intervinientesAux.getNombreCalle());
					plantillaTramiteHechoDetalle.setCpIdRepresentanteNoValidado(intervinientesAux.getNoraCpId());
					plantillaTramiteHechoDetalle.setNombreCpRepresentanteNoValidado(intervinientesAux.getNombreCp());
					plantillaTramiteHechoDetalle
							.setPortalIdRepresentanteNoValidado(intervinientesAux.getNoraPortalId());
					plantillaTramiteHechoDetalle
							.setNombrePortalRepresentanteNoValidado(intervinientesAux.getNombrePortal());
					plantillaTramiteHechoDetalle
							.setNombrePisoRepresentanteNoValidado(intervinientesAux.getNombrePiso());

					plantillaTramiteHechoDetalle
							.setDireccion_nocapvRepresentanteNoValidado(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteHechoDetalle.setDireccionRepresentanteNoValidado(direccionCompleta.toString());

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteHechoDetalle.setCpMunicipioRepresentanteNoValidado(cpMunicipio.toString());
				}
			} else if (tramitehechoComunicacionNotificacion.getEhorigenalegacion()
					.equals(Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO)) {
				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteHechoDetalle.setNombreTitular(nombredestinatario.toString());
					plantillaTramiteHechoDetalle.setNombreComercialTitular("");

					plantillaTramiteHechoDetalle.setIdentificacionTitular(intervinientesAux.getNif());
					plantillaTramiteHechoDetalle.setProvinciaIdTitular(intervinientesAux.getNoraProvinciaId());
					plantillaTramiteHechoDetalle.setNombreProvinciaTitular(intervinientesAux.getNombreProvincia());
					plantillaTramiteHechoDetalle.setMunicipioIdTitular(intervinientesAux.getNoraMunicipioId());
					plantillaTramiteHechoDetalle.setNombreMunicipioTitular(intervinientesAux.getNombreMunicipio());
					plantillaTramiteHechoDetalle.setLocalidadIdTitular(intervinientesAux.getNoraLocalidadId());
					plantillaTramiteHechoDetalle.setNombreLocalidadTitular(intervinientesAux.getNombreLocalidad());
					plantillaTramiteHechoDetalle.setNoraCalleIdTitular(intervinientesAux.getNoraCalleId());
					plantillaTramiteHechoDetalle.setNombreCalleTitular(intervinientesAux.getNombreCalle());
					plantillaTramiteHechoDetalle.setCpIdTitular(intervinientesAux.getNoraCpId());
					plantillaTramiteHechoDetalle.setNombreCpTitular(intervinientesAux.getNombreCp());
					plantillaTramiteHechoDetalle.setPortalIdTitular(intervinientesAux.getNoraPortalId());
					plantillaTramiteHechoDetalle.setNombrePortalTitular(intervinientesAux.getNombrePortal());
					plantillaTramiteHechoDetalle.setNombrePisoTitular(intervinientesAux.getNombrePiso());

					plantillaTramiteHechoDetalle.setDireccion_nocapvTitular(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteHechoDetalle.setDireccionTitular(direccionCompleta.toString());

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteHechoDetalle.setCpMunicipioTitular(cpMunicipio.toString());
				}

				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes
						.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteHechoDetalle.setNombreRepresentanteNoValidado(nombredestinatario.toString());
					plantillaTramiteHechoDetalle.setNombreComercialRepresentanteNoValidado("");

					plantillaTramiteHechoDetalle.setIdentificacionRepresentanteNoValidado(intervinientesAux.getNif());
					plantillaTramiteHechoDetalle
							.setProvinciaIdRepresentanteNoValidado(intervinientesAux.getNoraProvinciaId());
					plantillaTramiteHechoDetalle
							.setNombreProvinciaRepresentanteNoValidado(intervinientesAux.getNombreProvincia());
					plantillaTramiteHechoDetalle
							.setMunicipioIdRepresentanteNoValidado(intervinientesAux.getNoraMunicipioId());
					plantillaTramiteHechoDetalle
							.setNombreMunicipioRepresentanteNoValidado(intervinientesAux.getNombreMunicipio());
					plantillaTramiteHechoDetalle
							.setLocalidadIdRepresentanteNoValidado(intervinientesAux.getNoraLocalidadId());
					plantillaTramiteHechoDetalle
							.setNombreLocalidadRepresentanteNoValidado(intervinientesAux.getNombreLocalidad());
					plantillaTramiteHechoDetalle
							.setNoraCalleIdRepresentanteNoValidado(intervinientesAux.getNoraCalleId());
					plantillaTramiteHechoDetalle
							.setNombreCalleRepresentanteNoValidado(intervinientesAux.getNombreCalle());
					plantillaTramiteHechoDetalle.setCpIdRepresentanteNoValidado(intervinientesAux.getNoraCpId());
					plantillaTramiteHechoDetalle.setNombreCpRepresentanteNoValidado(intervinientesAux.getNombreCp());
					plantillaTramiteHechoDetalle
							.setPortalIdRepresentanteNoValidado(intervinientesAux.getNoraPortalId());
					plantillaTramiteHechoDetalle
							.setNombrePortalRepresentanteNoValidado(intervinientesAux.getNombrePortal());
					plantillaTramiteHechoDetalle
							.setNombrePisoRepresentanteNoValidado(intervinientesAux.getNombrePiso());

					plantillaTramiteHechoDetalle
							.setDireccion_nocapvRepresentanteNoValidado(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteHechoDetalle.setDireccionRepresentanteNoValidado(direccionCompleta.toString());

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteHechoDetalle.setCpMunicipioRepresentanteNoValidado(cpMunicipio.toString());
				}

			}
		}

		return plantillaTramiteHechoDetalle;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantillaDecision(PlantillaDecision plantillaDecision, TramiteComun tramiteComun)
			throws Exception {
		String ficheroGenerado = "";
		// Obtener la plantilla del tramite
		plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);
		try {

			if (plantillaDecision.getPdplantilla() != null) {
				DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
				decisionHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

				decisionHechoDetalle = this.decisionHechoDao.findDecisionHecho(decisionHechoDetalle);

				PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle = new PlantillaTramiteDecisionDetalle();
				plantillaTramiteDecisionDetalle.setHccodigo(decisionHechoDetalle.getHccodigo());

				plantillaTramiteDecisionDetalle = this.decisionHechoDao
						.findPlantillaTramiteDecision(plantillaTramiteDecisionDetalle);

				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
				plantillaTramiteDecisionDetalle.setFechaHoy(todayWithZeroTime);

				/*
				 * buscar el ultimo tramite de traslado o inhibicion (donde se
				 * mete el organismo) coger el cod organismo de traslado y hacer
				 * un find de organismo y meter los datos del organismo de
				 * traslado en plantillaTramiteDecisionDetalle
				 */

				// PLANTILLA - TRASLADO
				// 1.- buscar el ultimo TRAMITE_REGISTRO_DECISION = "K14";
				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_DECISION);
				tramiteHechoDetalleAux.setHdcodigo(decisionHechoDetalle.getHdcodigo());
				try {
					tramiteHechoDetalleAux = this.tramiteHechoDao
							.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getEhcoortraspaso() != null) {
					// 2.- coger el cod organismo de traslado y hacer un find de
					// organismo
					Organismo organismo = new Organismo();
					organismo.setCodOrg(tramiteHechoDetalleAux.getEhcoortraspaso());
					organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

					// 3.- meter los datos del organismo de traslado en
					// plantillaTramiteHechoDetalle
					plantillaTramiteDecisionDetalle.setCodOrgTraslado(organismo.getCodOrg());
					plantillaTramiteDecisionDetalle.setNombreEuTraslado(organismo.getNombreEu());
					plantillaTramiteDecisionDetalle.setNombreEsTraslado(organismo.getNombreEs());
					plantillaTramiteDecisionDetalle.setNombreCalleTraslado(organismo.getNombreCalle());
					plantillaTramiteDecisionDetalle.setNoraCpIdTraslado(organismo.getNoraCpId());
					plantillaTramiteDecisionDetalle.setNombreMunicipioTraslado(organismo.getNombreMunicipio());
					plantillaTramiteDecisionDetalle.setNombrePortalTraslado(organismo.getNombrePortal());
					plantillaTramiteDecisionDetalle.setNombrePisoTraslado(organismo.getCompleDirec());

					if (organismo.getNoraPaisId() != null && !organismo.getNoraPaisId().equals("0")
							&& !organismo.getNoraPaisId().equals("108")) {
						plantillaTramiteDecisionDetalle.setNombrePaisTraslado(organismo.getNombrePais());
					}

					plantillaTramiteDecisionDetalle.setDireccionNocapvTraslado(organismo.getNombreCalle());
					plantillaTramiteDecisionDetalle.setTelefonoTraslado(organismo.getTelefono());
					plantillaTramiteDecisionDetalle.setFaxTraslado(organismo.getFax());
					plantillaTramiteDecisionDetalle.setEmailTraslado(organismo.getEmail());
				}
				//

				// CLOB justificacion infraccion
				TramiteHecho tramitehecho = new TramiteHecho();
				tramitehecho.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

				TramiteHecho tramiteHechoAux = null;
				try {
					tramiteHechoAux = this.tramiteHechoDao.find(tramitehecho);
				} catch (Exception e) {
				}

				if (tramiteHechoAux != null && tramiteHechoAux.getEhjustificacioninfraccion() != null) {
					StringBuffer sbJustificacionInfraccion = new StringBuffer(120);

					sbJustificacionInfraccion.append("{ ");
					sbJustificacionInfraccion.append(" \\\\pard\\\\sb2 ");
					sbJustificacionInfraccion.append(" \\\\tab - \\\\tab ");
					sbJustificacionInfraccion
							.append(Y41bUtils.clobToString(tramiteHechoAux.getEhjustificacioninfraccion()));
					sbJustificacionInfraccion.append(" \\\\par ");

					sbJustificacionInfraccion.append("}");

					plantillaTramiteDecisionDetalle.setJustificacionInfraccion(sbJustificacionInfraccion.toString());
				}

				// APERCIBIMIENTO

				if (tramiteHechoAux != null && tramiteHechoAux.getEhapercibimientoes() != null) {

					plantillaTramiteDecisionDetalle
							.setApercibimientoEs(Y41bUtils.clobToString(tramiteHechoAux.getEhapercibimientoes()));

					if (plantillaTramiteDecisionDetalle.getApercibimientoEs() != null) {
						plantillaTramiteDecisionDetalle
								.setApercibimientoEs(Y41bStringUtils.unescapeHTML(plantillaTramiteDecisionDetalle
										.getApercibimientoEs().replaceAll("\n", "&lineSeparator;"), 0));
					}
				}
				if (tramiteHechoAux != null && tramiteHechoAux.getEhapercibimientoeu() != null) {

					plantillaTramiteDecisionDetalle
							.setApercibimientoEu(Y41bUtils.clobToString(tramiteHechoAux.getEhapercibimientoeu()));

					if (plantillaTramiteDecisionDetalle.getApercibimientoEu() != null) {
						plantillaTramiteDecisionDetalle
								.setApercibimientoEu(Y41bStringUtils.unescapeHTML(plantillaTramiteDecisionDetalle
										.getApercibimientoEu().replaceAll("\n", "&lineSeparator;"), 0));
					}
				}

				// if (tramiteHechoAux != null &&
				// tramiteHechoAux.getEhapercibimientoes() != null) {
				//
				// plantillaTramiteDecisionDetalle.setApercibimientoEs(Y41bUtils
				// .clobToString(tramiteHechoAux.getEhapercibimientoes()).replaceAll("\n",
				// "&lineSeparator;"));
				//
				// }
				// if (tramiteHechoAux != null &&
				// tramiteHechoAux.getEhapercibimientoeu() != null) {
				//
				// plantillaTramiteDecisionDetalle.setApercibimientoEu(Y41bUtils
				// .clobToString(tramiteHechoAux.getEhapercibimientoeu()).replaceAll("\n",
				// "&lineSeparator;"));
				// }

				//

				// INFRACCIONES
				// 1.- Recuperarar el listado de infracciones asociados
				AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
				adjunInfraccHechoDenunFilter.setHicohd(tramiteComun.getIdExpediente());
				List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = null;
				listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService.findAll(adjunInfraccHechoDenunFilter,
						null);

				// 2.- Formar el texto que se metera en la plantilla con ellas
				StringBuffer sbInfraccionesES = new StringBuffer(120);
				StringBuffer sbInfraccionesEU = new StringBuffer(120);

				if (listAdjunInfraccHechoDenun != null) {

					Iterator<AdjunInfraccHechoDenun> it = listAdjunInfraccHechoDenun.iterator();
					while (it.hasNext()) {
						AdjunInfraccHechoDenun adjunInfraccHechoDenun = (AdjunInfraccHechoDenun) it.next();

						sbInfraccionesES.append("{ ");
						sbInfraccionesES.append(" \\\\pard\\\\sb1 ");
						sbInfraccionesES.append(" \\\\tab - \\\\tab ");
						sbInfraccionesES.append(adjunInfraccHechoDenun.getTtinombre());
						sbInfraccionesES.append(" \\\\line\\\\par ");
						sbInfraccionesES.append("}");

						sbInfraccionesEU.append("{ ");
						sbInfraccionesEU.append(" \\\\pard\\\\sb1 ");
						sbInfraccionesEU.append(" \\\\tab - \\\\tab ");
						sbInfraccionesEU.append(adjunInfraccHechoDenun.getTtinombree());
						sbInfraccionesEU.append(" \\\\line\\\\par ");
						sbInfraccionesEU.append("}");
					}
				}
				plantillaTramiteDecisionDetalle.setTextoListaInfraccionesES(sbInfraccionesES.toString());
				plantillaTramiteDecisionDetalle.setTextoListaInfraccionesEU(sbInfraccionesEU.toString());
				//

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				/*
				 * CONSUMIDOR - ALEGACIONES 1.- findUltimoTramiteReqAlegacion
				 * (K06 y C) -> fecha req cas y eus 2.-
				 * findTramiteRelacionadoAlegacion (ehcodigo y codrelacionado)
				 * -> fecha com cas y eus 3.- si tiene comunicacion o alegacion
				 * para fecha recepcion nuevas alegaciones
				 */

				tramiteHechoDetalleAux = new TramiteHechoDetalle();

				try {
					TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
					miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
					miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
					String origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMANTE;

					tramiteHechoDetalleAux = this.tramiteHechoDao
							.findUltimoTramiteHechoPorTipoTramiteYOrigen(miTramiteHechoDetalle, origen);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null) {
					plantillaTramiteDecisionDetalle.setFechaSolicitudAlegacionCasCons(Y41bUtils
							.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
					plantillaTramiteDecisionDetalle.setFechaSolicitudAlegacionEusCons(
							Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

					try {
						TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
						miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
						miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
						miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

						tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null) {
						plantillaTramiteDecisionDetalle.setFechaRecepcionalegacionesCasCons(Y41bUtils
								.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
						plantillaTramiteDecisionDetalle.setFechaRecepcionalegacionesEusCons(Y41bUtils
								.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

						try {
							TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
							miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
							miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
							miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

							tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
						} catch (Exception e) {
						}

						if (tramiteHechoDetalleAux != null) {
							tramiteHechoAux = new TramiteHecho();
							tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

							tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

							if (tramiteHechoAux != null) {
								plantillaTramiteDecisionDetalle.setFechacomunicacionAlegacionesCasEst(
										Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
												Y41bConstantes.CASTELLANO));
								plantillaTramiteDecisionDetalle.setFechacomunicacionAlegacionesEusEst(
										Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
												Y41bConstantes.EUSKERA));
							}
						}

					}

				}

				/*
				 * ESTABLECIMIENTO - ALEGACIONES 1.-
				 * findUltimoTramiteReqAlegacion (K06 y R) 2.-
				 * findTramiteRelacionadoAlegacion (ehcodigo y codrelacionado)
				 * 3.- si tiene comunicacion o alegacion para fecha recepcion
				 */

				tramiteHechoDetalleAux = new TramiteHechoDetalle();

				try {
					TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
					miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
					miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
					String origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;

					tramiteHechoDetalleAux = this.tramiteHechoDao
							.findUltimoTramiteHechoPorTipoTramiteYOrigen(miTramiteHechoDetalle, origen);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null) {
					plantillaTramiteDecisionDetalle.setFechaSolicitudAlegacionCasEst(Y41bUtils
							.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
					plantillaTramiteDecisionDetalle.setFechaSolicitudAlegacionEusEst(
							Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

					try {
						TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
						miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
						miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
						miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

						tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null) {
						plantillaTramiteDecisionDetalle.setFechaRecepcionalegacionesCasEst(Y41bUtils
								.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.CASTELLANO));
						plantillaTramiteDecisionDetalle.setFechaRecepcionalegacionesEusEst(Y41bUtils
								.parseDateToString(tramiteHechoDetalleAux.getEhfecha(), Y41bConstantes.EUSKERA));

						try {
							TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
							miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
							miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
							miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

							tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
						} catch (Exception e) {
						}

						if (tramiteHechoDetalleAux != null) {
							tramiteHechoAux = new TramiteHecho();
							tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

							tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

							if (tramiteHechoAux != null) {
								plantillaTramiteDecisionDetalle.setFechacomunicacionAlegacionesCasCons(
										Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
												Y41bConstantes.CASTELLANO));
								plantillaTramiteDecisionDetalle.setFechacomunicacionAlegacionesEusCons(
										Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
												Y41bConstantes.EUSKERA));
							}
						}

					}

				}

				tramiteHechoDetalleAux = new TramiteHechoDetalle();

				try {
					TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
					miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_ALEGACION);
					miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
					String origen = Y41bConstantes.ORIGEN_ALEGACION_RECLAMADO;

					tramiteHechoDetalleAux = this.tramiteHechoDao
							.findUltimoTramiteHechoPorTipoTramiteYOrigen(miTramiteHechoDetalle, origen);
				} catch (Exception e) {
				}

				if (tramiteHechoDetalleAux != null && Y41bUtils.isFilled(tramiteHechoDetalleAux.getEhcodigo())) {

					try {
						TramiteHechoDetalle miTramiteHechoDetalle = new TramiteHechoDetalle();
						miTramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
						miTramiteHechoDetalle.setHdcodigo(solicitudDetalle.getHdcodigo());
						miTramiteHechoDetalle.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

						tramiteHechoDetalleAux = this.tramiteHechoDao.findTramiteRelacionado(miTramiteHechoDetalle);
					} catch (Exception e) {
					}

					if (tramiteHechoDetalleAux != null) {
						tramiteHechoAux = new TramiteHecho();
						tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

						tramiteHechoAux = this.tramiteHechoDao.find(tramiteHechoAux);

						if (tramiteHechoAux != null) {
							plantillaTramiteDecisionDetalle.setFechaUltcomunicacionAlegacionesCasCons(
									Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
											Y41bConstantes.CASTELLANO));
							plantillaTramiteDecisionDetalle.setFechaUltcomunicacionAlegacionesEusCons(
									Y41bUtils.parseDateToString(tramiteHechoAux.getEhfechacomunicacion(),
											Y41bConstantes.EUSKERA));
						}
					}
				}

				//

				// COMPLETE
				plantillaTramiteDecisionDetalle = this.completeInfoPlantillaTramiteDecisionDetalle(
						plantillaTramiteDecisionDetalle, decisionHechoDetalle);

				// Transformar el documento en castellano
				String plantilla = Y41bUtils.blobToString(plantillaDecision.getPdplantilla());

				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

				StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

				rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_XML_DECISION_CASTELLANO); // ññ

				ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
						plantillaTramiteDecisionDetalle, plantilla);
			}
		} finally {
		}
		return ficheroGenerado;
	}

	/**
	 * Complete information of the object PlantillaTramiteDecisionDetalle.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	private PlantillaTramiteDecisionDetalle completeInfoPlantillaTramiteDecisionDetalle(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle,
			DecisionHechoDetalle decisionHechoDetalle) {

		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(plantillaTramiteDecisionDetalle.getHdcodigo());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			Intervinientes intervinientesAux = new Intervinientes();
			intervinientesAux.setIdExpediente(plantillaTramiteDecisionDetalle.getHdcodigo());

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

			if (listIntervinientes.size() > 1) {
				for (Intervinientes intervinientes : listIntervinientes) {
					if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
						if (solDetalle.getHddestnotificareclamante() != null && solDetalle.getHddestnotificareclamante()
								.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
								plantillaTramiteDecisionDetalle.setDtcodigo(intervinientesAux.getDtcodigo());

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteDecisionDetalle.setDtnombre(nombreCompleto.toString());
								plantillaTramiteDecisionDetalle.setDtnif(intervinientesAux.getNif());
								plantillaTramiteDecisionDetalle
										.setDtprovinciaId(intervinientesAux.getNoraProvinciaId());
								plantillaTramiteDecisionDetalle
										.setDtnombreProvincia(intervinientesAux.getNombreProvincia());
								plantillaTramiteDecisionDetalle
										.setDtmunicipioId(intervinientesAux.getNoraMunicipioId());
								plantillaTramiteDecisionDetalle
										.setDtnombreMunicipio(intervinientesAux.getNombreMunicipio());
								plantillaTramiteDecisionDetalle
										.setDtlocalidadId(intervinientesAux.getNoraLocalidadId());
								plantillaTramiteDecisionDetalle
										.setDtnombreLocalidad(intervinientesAux.getNombreLocalidad());
								plantillaTramiteDecisionDetalle.setDtnoraCalleId(intervinientesAux.getNoraCalleId());
								plantillaTramiteDecisionDetalle.setDtnombreCalle(intervinientesAux.getNombreCalle());
								plantillaTramiteDecisionDetalle.setDtcpId(intervinientesAux.getNoraCpId());
								plantillaTramiteDecisionDetalle.setDtnombreCp(intervinientesAux.getNombreCp());
								plantillaTramiteDecisionDetalle.setDtportalId(intervinientesAux.getNoraPortalId());
								plantillaTramiteDecisionDetalle.setDtnombrePortal(intervinientesAux.getNombrePortal());
								plantillaTramiteDecisionDetalle.setDtnombrePiso(intervinientesAux.getNombrePiso());
								plantillaTramiteDecisionDetalle.setDtnoraPaisId(intervinientesAux.getNoraPaisId());
								plantillaTramiteDecisionDetalle.setDtnoraPaisNombre(intervinientesAux.getNombrePais());

								plantillaTramiteDecisionDetalle
										.setDtdireccion_nocapv(intervinientesAux.getDireccionNocapv());
							} else {
								intervinientesAux = new Intervinientes();
								intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
								intervinientesAux.setTipoInterviniente(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
								intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

								if (intervinientesAux != null
										&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
									plantillaTramiteDecisionDetalle.setDtcodigo(intervinientesAux.getDtcodigo());

									StringBuffer nombreCompleto = new StringBuffer();

									nombreCompleto.append(intervinientesAux.getNombre());

									if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
									}

									if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
									}

									plantillaTramiteDecisionDetalle.setDtnombre(nombreCompleto.toString());
									plantillaTramiteDecisionDetalle.setDtnif(intervinientesAux.getNif());
									plantillaTramiteDecisionDetalle
											.setDtprovinciaId(intervinientesAux.getNoraProvinciaId());
									plantillaTramiteDecisionDetalle
											.setDtnombreProvincia(intervinientesAux.getNombreProvincia());
									plantillaTramiteDecisionDetalle
											.setDtmunicipioId(intervinientesAux.getNoraMunicipioId());
									plantillaTramiteDecisionDetalle
											.setDtnombreMunicipio(intervinientesAux.getNombreMunicipio());
									plantillaTramiteDecisionDetalle
											.setDtlocalidadId(intervinientesAux.getNoraLocalidadId());
									plantillaTramiteDecisionDetalle
											.setDtnombreLocalidad(intervinientesAux.getNombreLocalidad());
									plantillaTramiteDecisionDetalle
											.setDtnoraCalleId(intervinientesAux.getNoraCalleId());
									plantillaTramiteDecisionDetalle
											.setDtnombreCalle(intervinientesAux.getNombreCalle());
									plantillaTramiteDecisionDetalle.setDtcpId(intervinientesAux.getNoraCpId());
									plantillaTramiteDecisionDetalle.setDtnombreCp(intervinientesAux.getNombreCp());
									plantillaTramiteDecisionDetalle.setDtportalId(intervinientesAux.getNoraPortalId());
									plantillaTramiteDecisionDetalle
											.setDtnombrePortal(intervinientesAux.getNombrePortal());
									plantillaTramiteDecisionDetalle.setDtnombrePiso(intervinientesAux.getNombrePiso());
									plantillaTramiteDecisionDetalle.setDtnoraPaisId(intervinientesAux.getNoraPaisId());
									plantillaTramiteDecisionDetalle
											.setDtnoraPaisNombre(intervinientesAux.getNombrePais());

									plantillaTramiteDecisionDetalle
											.setDtdireccion_nocapv(intervinientesAux.getDireccionNocapv());
								}
							}
						}
					} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
						if (solDetalle.getHddestnotificareclamado() != null && solDetalle.getHddestnotificareclamado()
								.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
							intervinientesAux
									.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
								plantillaTramiteDecisionDetalle.setEscodigo(intervinientesAux.getEscodigo());

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteDecisionDetalle.setEsnombre(nombreCompleto.toString());
								plantillaTramiteDecisionDetalle.setEsnif(intervinientesAux.getNif());
								plantillaTramiteDecisionDetalle.setEsnoco(nombreCompleto.toString());
								plantillaTramiteDecisionDetalle.setEsinadar(intervinientesAux.getInadar());
								plantillaTramiteDecisionDetalle
										.setEsprovinciaId(intervinientesAux.getNoraProvinciaId());
								plantillaTramiteDecisionDetalle
										.setEsnombreProvincia(intervinientesAux.getNombreProvincia());
								plantillaTramiteDecisionDetalle
										.setEsmunicipioId(intervinientesAux.getNoraMunicipioId());
								plantillaTramiteDecisionDetalle
										.setEsnombreMunicipio(intervinientesAux.getNombreMunicipio());
								plantillaTramiteDecisionDetalle
										.setEslocalidadId(intervinientesAux.getNoraLocalidadId());
								plantillaTramiteDecisionDetalle
										.setEsnombreLocalidad(intervinientesAux.getNombreLocalidad());
								plantillaTramiteDecisionDetalle.setEsnoraCalleId(intervinientesAux.getNoraCalleId());
								plantillaTramiteDecisionDetalle.setEsnombreCalle(intervinientesAux.getNombreCalle());
								plantillaTramiteDecisionDetalle.setEscpId(intervinientesAux.getNoraCpId());
								plantillaTramiteDecisionDetalle.setEsnombreCp(intervinientesAux.getNombreCp());
								plantillaTramiteDecisionDetalle.setEsportalId(intervinientesAux.getNoraPortalId());
								plantillaTramiteDecisionDetalle.setEsnombrePortal(intervinientesAux.getNombrePortal());
								plantillaTramiteDecisionDetalle.setEsnombrePiso(intervinientesAux.getNombrePiso());
								plantillaTramiteDecisionDetalle.setEsnoraPaisId(intervinientesAux.getNoraPaisId());
								plantillaTramiteDecisionDetalle.setEsnoraPaisNombre(intervinientesAux.getNombrePais());

								plantillaTramiteDecisionDetalle
										.setEsdireccion_nocapv(intervinientesAux.getDireccionNocapv());
							} else {
								intervinientesAux = new Intervinientes();
								intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
								intervinientesAux.setTipoInterviniente(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
								intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

								if (intervinientesAux != null
										&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
									plantillaTramiteDecisionDetalle.setEscodigo(intervinientesAux.getEscodigo());

									StringBuffer nombreCompleto = new StringBuffer();

									nombreCompleto.append(intervinientesAux.getNombre());

									if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
									}

									if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
									}

									plantillaTramiteDecisionDetalle.setEsnombre(nombreCompleto.toString());
									plantillaTramiteDecisionDetalle.setEsnif(intervinientesAux.getNif());
									plantillaTramiteDecisionDetalle.setEsnoco(nombreCompleto.toString());
									plantillaTramiteDecisionDetalle.setEsinadar(intervinientesAux.getInadar());
									plantillaTramiteDecisionDetalle
											.setEsprovinciaId(intervinientesAux.getNoraProvinciaId());
									plantillaTramiteDecisionDetalle
											.setEsnombreProvincia(intervinientesAux.getNombreProvincia());
									plantillaTramiteDecisionDetalle
											.setEsmunicipioId(intervinientesAux.getNoraMunicipioId());
									plantillaTramiteDecisionDetalle
											.setEsnombreMunicipio(intervinientesAux.getNombreMunicipio());
									plantillaTramiteDecisionDetalle
											.setEslocalidadId(intervinientesAux.getNoraLocalidadId());
									plantillaTramiteDecisionDetalle
											.setEsnombreLocalidad(intervinientesAux.getNombreLocalidad());
									plantillaTramiteDecisionDetalle
											.setEsnoraCalleId(intervinientesAux.getNoraCalleId());
									plantillaTramiteDecisionDetalle
											.setEsnombreCalle(intervinientesAux.getNombreCalle());
									plantillaTramiteDecisionDetalle.setEscpId(intervinientesAux.getNoraCpId());
									plantillaTramiteDecisionDetalle.setEsnombreCp(intervinientesAux.getNombreCp());
									plantillaTramiteDecisionDetalle.setEsportalId(intervinientesAux.getNoraPortalId());
									plantillaTramiteDecisionDetalle
											.setEsnombrePortal(intervinientesAux.getNombrePortal());
									plantillaTramiteDecisionDetalle.setEsnombrePiso(intervinientesAux.getNombrePiso());
									plantillaTramiteDecisionDetalle.setEsnoraPaisId(intervinientesAux.getNoraPaisId());
									plantillaTramiteDecisionDetalle
											.setEsnoraPaisNombre(intervinientesAux.getNombrePais());

									plantillaTramiteDecisionDetalle
											.setEsdireccion_nocapv(intervinientesAux.getDireccionNocapv());
								}
							}
						}
					}
				}
			}

			// Formateamos las fecha a castellano e euskera
			// fecha de hoy texto
			plantillaTramiteDecisionDetalle
					.setFechaHoyCas(Y41bUtils.formatearDateToString(plantillaTramiteDecisionDetalle.getFechaHoy(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setFechaHoyEus(
					Y41bUtils.formatearDateToStringEuskera(plantillaTramiteDecisionDetalle.getFechaHoy(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setDefedeCas(Y41bUtils
					.parseDateToString(plantillaTramiteDecisionDetalle.getDefede(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setDefedeEus(
					Y41bUtils.parseDateToString(plantillaTramiteDecisionDetalle.getDefede(), Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setEhFechaResolucionSimpleCas(Y41bUtils.parseDateToString(
					plantillaTramiteDecisionDetalle.getEhFechaResolucion(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setEhFechaResolucionSimpleEus(Y41bUtils
					.parseDateToString(plantillaTramiteDecisionDetalle.getEhFechaResolucion(), Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setEhFechaResolucionCas(
					Y41bUtils.formatearDateToString(plantillaTramiteDecisionDetalle.getEhFechaResolucion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setEhFechaResolucionEus(
					Y41bUtils.formatearDateToStringEuskera(plantillaTramiteDecisionDetalle.getEhFechaResolucion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setHcfedeTextoCas(
					Y41bUtils.formatearDateToString(plantillaTramiteDecisionDetalle.getEhFechaResolucion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setHcfedeTextoEus(
					Y41bUtils.formatearDateToStringEuskera(plantillaTramiteDecisionDetalle.getEhFechaResolucion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setHcfedeCas(Y41bUtils.parseDateToString(
					plantillaTramiteDecisionDetalle.getEhFechaResolucion(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setHcfedeEus(Y41bUtils
					.parseDateToString(plantillaTramiteDecisionDetalle.getEhFechaResolucion(), Y41bConstantes.EUSKERA));

			plantillaTramiteDecisionDetalle.setFechaHoySimpleCas(Y41bUtils
					.parseDateToString(plantillaTramiteDecisionDetalle.getFechaHoy(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setFechaHoySimpleEus(
					Y41bUtils.parseDateToString(plantillaTramiteDecisionDetalle.getFechaHoy(), Y41bConstantes.EUSKERA));

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(decisionHechoDetalle.getHdcodigo());

			// Formatear las fechas castellano y euskera
			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			plantillaTramiteDecisionDetalle.setFechaRequerirSubsanacionCas(
					Y41bUtils.parseDateToString(tramiteHechoDetalle.getEhfecha(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setFechaRequerirSubsanacionEus(
					Y41bUtils.parseDateToString(tramiteHechoDetalle.getEhfecha(), Y41bConstantes.EUSKERA));

			// Formatear las fechas castellano y euskera
			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			plantillaTramiteDecisionDetalle.setFechaRequerirAlegacionCas(
					Y41bUtils.parseDateToString(tramiteHechoDetalle.getEhfecha(), Y41bConstantes.CASTELLANO));
			plantillaTramiteDecisionDetalle.setFechaRequerirAlegacionEus(
					Y41bUtils.parseDateToString(tramiteHechoDetalle.getEhfecha(), Y41bConstantes.EUSKERA));

			// Creamos el campo numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(plantillaTramiteDecisionDetalle.getDecoor()).append("-")
					.append(plantillaTramiteDecisionDetalle.getDenror()).append("-")
					.append(plantillaTramiteDecisionDetalle.getDenran()).append("-")
					.append(plantillaTramiteDecisionDetalle.getHdnror());

			plantillaTramiteDecisionDetalle.setNumExpediente(numeroExpediente.toString());

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getEsnombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle.getEsnombreCalle());

				if (plantillaTramiteDecisionDetalle.getEsnombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteDecisionDetalle.getEsnombrePortal());
				}
				if (plantillaTramiteDecisionDetalle.getEsnombrePiso() != null
						&& !plantillaTramiteDecisionDetalle.getEsnombrePiso().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getEsnombrePiso());
				}
			} else {
				if (plantillaTramiteDecisionDetalle.getEsdireccion_nocapv() != null
						&& !plantillaTramiteDecisionDetalle.getEsdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteDecisionDetalle.getEsdireccion_nocapv());

					if (plantillaTramiteDecisionDetalle.getEsnoraPaisNombre() != null
							&& !plantillaTramiteDecisionDetalle.getEsnoraPaisNombre().equals("")) {
						direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getEsnoraPaisNombre());
					}
				} else {
					direccionCompleta.append(plantillaTramiteDecisionDetalle.getEsnodir());
				}
			}

			plantillaTramiteDecisionDetalle.setEsdireccion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getEsnombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getEsnombreCp());

				if (plantillaTramiteDecisionDetalle.getEsnombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle.getEsnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteDecisionDetalle.getEsnombreMunicipio());
				}
			} else if (plantillaTramiteDecisionDetalle.getEsnombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getEsnombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getEsnombreMunicipio());
			}

			plantillaTramiteDecisionDetalle.setEscpMunicipio(cpMunicipio.toString());

			// Creamos el campo direccion del consumidor
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getDtnombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle.getDtnombreCalle());

				if (plantillaTramiteDecisionDetalle.getDtnombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getDtnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteDecisionDetalle.getDtnombrePortal());
				}
				if (plantillaTramiteDecisionDetalle.getDtnombrePiso() != null
						&& !plantillaTramiteDecisionDetalle.getDtnombrePiso().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getDtnombrePiso());
				}
			} else {
				if (plantillaTramiteDecisionDetalle.getDtdireccion_nocapv() != null
						&& !plantillaTramiteDecisionDetalle.getDtdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteDecisionDetalle.getDtdireccion_nocapv());

					if (plantillaTramiteDecisionDetalle.getDtnoraPaisNombre() != null
							&& !plantillaTramiteDecisionDetalle.getDtnoraPaisNombre().equals("")) {
						direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getDtnoraPaisNombre());
					}
				} else {
					direccionCompleta.append(plantillaTramiteDecisionDetalle.getDtnodir());
				}
			}

			plantillaTramiteDecisionDetalle.setDtdireccion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del consumidor
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getDtnombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getDtnombreCp());

				if (plantillaTramiteDecisionDetalle.getDtnombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle.getDtnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteDecisionDetalle.getDtnombreMunicipio());
				}
			} else if (plantillaTramiteDecisionDetalle.getDtnombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getDtnombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getDtnombreMunicipio());
			}

			plantillaTramiteDecisionDetalle.setDtcpMunicipio(cpMunicipio.toString());

			// Creamos el campo direccion del organismo conectado
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCalle() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle.getNombreCalle());

				if (plantillaTramiteDecisionDetalle.getNombrePortal() != null
						&& !plantillaTramiteDecisionDetalle.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteDecisionDetalle.getNombrePortal());
				}
			}

			plantillaTramiteDecisionDetalle.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCp() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getNombreCp());

				if (plantillaTramiteDecisionDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteDecisionDetalle.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteDecisionDetalle.getNombreMunicipio());
				}
			} else if (plantillaTramiteDecisionDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteDecisionDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getNombreMunicipio());
			}

			plantillaTramiteDecisionDetalle.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo direccion del organismo al que se traslada
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCalleTraslado() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCalleTraslado().equals("")) {
				direccionCompleta.append(plantillaTramiteDecisionDetalle.getNombreCalleTraslado());

				if (plantillaTramiteDecisionDetalle.getNombrePortalTraslado() != null
						&& !plantillaTramiteDecisionDetalle.getNombrePortalTraslado().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteDecisionDetalle.getNombrePortalTraslado());
				}

				if (plantillaTramiteDecisionDetalle.getNombrePisoTraslado() != null
						&& !plantillaTramiteDecisionDetalle.getNombrePisoTraslado().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getNombrePisoTraslado());
				}

				if (plantillaTramiteDecisionDetalle.getNombrePaisTraslado() != null
						&& !plantillaTramiteDecisionDetalle.getNombrePaisTraslado().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteDecisionDetalle.getNombrePaisTraslado());
				}
			}

			plantillaTramiteDecisionDetalle.setDireccionTraslado(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo al que
			// se traslada
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteDecisionDetalle.getNombreCpTraslado() != null
					&& !plantillaTramiteDecisionDetalle.getNombreCpTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getNombreCpTraslado());

				if (plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado() != null
						&& !plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado());
				}
			} else if (plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado() != null
					&& !plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteDecisionDetalle.getNombreMunicipioTraslado());
			}

			plantillaTramiteDecisionDetalle.setCpMunicipioTraslado(cpMunicipio.toString());

			if (plantillaTramiteDecisionDetalle.getEsinadar() != null
					&& plantillaTramiteDecisionDetalle.getEsinadar().equals(Y41bConstantes.VALOR_SI)) {

				// recuperar texto de properties
				plantillaTramiteDecisionDetalle.setTextoArbitrajeCas(appMessageSource
						.getMessage("decision.texto.arbitraje", null, new Locale(Y41bConstantes.CASTELLANO)));
				plantillaTramiteDecisionDetalle.setTextoArbitrajeEus(appMessageSource
						.getMessage("decision.texto.arbitraje", null, new Locale(Y41bConstantes.EUSKERA)));
			}

			// FIRMA
			// Director
			CensoMonitor censoMonitorDirector = new CensoMonitor();

			try {
				censoMonitorDirector = this.censoMonitorDao.findDirectorSolicitudes();
				if (censoMonitorDirector.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorDirector = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}

			plantillaTramiteDecisionDetalle.setDirector(censoMonitorDirector.getMonombre());
			// recuperar texto de properties
			plantillaTramiteDecisionDetalle.setTextoPuestoDirectorCas(appMessageSource
					.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
			plantillaTramiteDecisionDetalle.setTextoPuestoDirectorEus(
					appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {
				Organismo organismo = new Organismo();
				organismo.setCodOrg(plantillaTramiteDecisionDetalle.getCodOrg());
				censoMonitorCoordinador.setOrganismo(organismo);

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorSolicitudes(censoMonitorCoordinador);
				if (censoMonitorCoordinador.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
			}

			plantillaTramiteDecisionDetalle.setCoordinador(censoMonitorCoordinador.getMonombre());

			boolean inhibicionTransporteAlava = false;

			if (censoMonitorCoordinador.getOrganismo() != null
					&& censoMonitorCoordinador.getOrganismo().getCodOrg() != null) {
				String strTerritorio = censoMonitorCoordinador.getOrganismo().getCodOrg();

				strTerritorio = strTerritorio.substring(0, 2);

				if (censoMonitorCoordinador.getOrganismo().getCodOrg()
						.equalsIgnoreCase(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					// recuperar texto de properties
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource.getMessage(
							"plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.EUSKERA)));
				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
					// recuperar texto de properties
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.EUSKERA)));

					inhibicionTransporteAlava = true;

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					// recuperar texto de properties
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.EUSKERA)));
					inhibicionTransporteAlava = false;

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
					// recuperar texto de properties
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.EUSKERA)));
					inhibicionTransporteAlava = false;
				}

			}
			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer();

			piepagina_linea1.append(plantillaTramiteDecisionDetalle.getDireccionOrganismo()).append(" - ")
					.append(plantillaTramiteDecisionDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(plantillaTramiteDecisionDetalle.getTelefonoOrganismo());

			plantillaTramiteDecisionDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(plantillaTramiteDecisionDetalle.getEmailOrganismo())
					.append(" / ").append(plantillaTramiteDecisionDetalle.getWebOrganismo());

			plantillaTramiteDecisionDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

			// 0154940: Actualizacin de datos explcitos en plantillas a uso de
			// campos combinados
			// OFICINA CENTRAL

			Organismo organismo = new Organismo();
			organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
			organismo = this.organismoDao.findOrganismo(organismo);

			if (organismo != null && organismo.getEntidadId() != null) {

				// Creamos el campo central pie pagina linea1
				StringBuffer centralpiepagina_linea1 = new StringBuffer();

				centralpiepagina_linea1.append(organismo.getNombreCalle()).append(" ")
						.append(organismo.getNombrePortal()).append(" - ").append(organismo.getNombreCp()).append(" / ")
						.append(" Tl. ").append(organismo.getTelefono());

				plantillaTramiteDecisionDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

				// Creamos el campo central pie pagina linea2
				StringBuffer centralpiepagina_linea2 = new StringBuffer();

				centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
						.append(organismo.getUrl());

				plantillaTramiteDecisionDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

				plantillaTramiteDecisionDetalle.setCentralMail(organismo.getEmail());

				plantillaTramiteDecisionDetalle.setCentralTelefono(organismo.getTelefono());
			}

			// 0154940
			// 0197528 diferenciado por TH y valores desde tabla de parametros

			if (censoMonitorCoordinador.getOrganismo() != null
					&& censoMonitorCoordinador.getOrganismo().getCodOrg() != null) {
				String strTerritorio = censoMonitorCoordinador.getOrganismo().getCodOrg();

				strTerritorio = strTerritorio.substring(0, 2);

				if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {

					Parametros parametros1 = new Parametros();
					parametros1.setParametro(Y41bConstantes.IT_01_Linea1);
					parametros1 = this.parametrosDao.find(parametros1);
					plantillaTramiteDecisionDetalle.setInhiTransLine1(parametros1.getValor());

					Parametros parametros2 = new Parametros();
					parametros2.setParametro(Y41bConstantes.IT_01_Linea2);
					parametros2 = this.parametrosDao.find(parametros2);
					plantillaTramiteDecisionDetalle.setInhiTransLine2(parametros2.getValor());

					Parametros parametros3 = new Parametros();
					parametros3.setParametro(Y41bConstantes.IT_01_Linea3);
					parametros3 = this.parametrosDao.find(parametros3);
					plantillaTramiteDecisionDetalle.setInhiTransLine3(parametros3.getValor());

					Parametros parametros4 = new Parametros();
					parametros4.setParametro(Y41bConstantes.IT_01_Linea4);
					parametros4 = this.parametrosDao.find(parametros4);
					plantillaTramiteDecisionDetalle.setInhiTransLine4(parametros4.getValor());

					Parametros parametros5 = new Parametros();
					parametros5.setParametro(Y41bConstantes.IT_01_Linea5);
					parametros5 = this.parametrosDao.find(parametros5);
					plantillaTramiteDecisionDetalle.setInhiTransLine5(parametros5.getValor());

					Parametros parametros6 = new Parametros();
					parametros6.setParametro(Y41bConstantes.IT_01_Linea6);
					parametros6 = this.parametrosDao.find(parametros6);
					plantillaTramiteDecisionDetalle.setInhiTransLine6(parametros6.getValor());

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {

					Parametros parametros1 = new Parametros();
					parametros1.setParametro(Y41bConstantes.IT_48_Linea1);
					parametros1 = this.parametrosDao.find(parametros1);
					plantillaTramiteDecisionDetalle.setInhiTransLine1(parametros1.getValor());

					Parametros parametros2 = new Parametros();
					parametros2.setParametro(Y41bConstantes.IT_48_Linea2);
					parametros2 = this.parametrosDao.find(parametros2);
					plantillaTramiteDecisionDetalle.setInhiTransLine2(parametros2.getValor());

					Parametros parametros3 = new Parametros();
					parametros3.setParametro(Y41bConstantes.IT_48_Linea3);
					parametros3 = this.parametrosDao.find(parametros3);
					plantillaTramiteDecisionDetalle.setInhiTransLine3(parametros3.getValor());

					Parametros parametros4 = new Parametros();
					parametros4.setParametro(Y41bConstantes.IT_48_Linea4);
					parametros4 = this.parametrosDao.find(parametros4);
					plantillaTramiteDecisionDetalle.setInhiTransLine4(parametros4.getValor());

					Parametros parametros5 = new Parametros();
					parametros5.setParametro(Y41bConstantes.IT_48_Linea5);
					parametros5 = this.parametrosDao.find(parametros5);
					plantillaTramiteDecisionDetalle.setInhiTransLine5(parametros5.getValor());

					Parametros parametros6 = new Parametros();
					parametros6.setParametro(Y41bConstantes.IT_48_Linea6);
					parametros6 = this.parametrosDao.find(parametros6);
					plantillaTramiteDecisionDetalle.setInhiTransLine6(parametros6.getValor());

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {

					Parametros parametros1 = new Parametros();
					parametros1.setParametro(Y41bConstantes.IT_20_Linea1);
					parametros1 = this.parametrosDao.find(parametros1);
					plantillaTramiteDecisionDetalle.setInhiTransLine1(parametros1.getValor());

					Parametros parametros2 = new Parametros();
					parametros2.setParametro(Y41bConstantes.IT_20_Linea2);
					parametros2 = this.parametrosDao.find(parametros2);
					plantillaTramiteDecisionDetalle.setInhiTransLine2(parametros2.getValor());

					Parametros parametros3 = new Parametros();
					parametros3.setParametro(Y41bConstantes.IT_20_Linea3);
					parametros3 = this.parametrosDao.find(parametros3);
					plantillaTramiteDecisionDetalle.setInhiTransLine3(parametros3.getValor());

					Parametros parametros4 = new Parametros();
					parametros4.setParametro(Y41bConstantes.IT_20_Linea4);
					parametros4 = this.parametrosDao.find(parametros4);
					plantillaTramiteDecisionDetalle.setInhiTransLine4(parametros4.getValor());

					Parametros parametros5 = new Parametros();
					parametros5.setParametro(Y41bConstantes.IT_20_Linea5);
					parametros5 = this.parametrosDao.find(parametros5);
					plantillaTramiteDecisionDetalle.setInhiTransLine5(parametros5.getValor());

					Parametros parametros6 = new Parametros();
					parametros6.setParametro(Y41bConstantes.IT_20_Linea6);
					parametros6 = this.parametrosDao.find(parametros6);
					plantillaTramiteDecisionDetalle.setInhiTransLine6(parametros6.getValor());

				}
			}

			// // creamos el texto para inhibicion transporte
			// if (inhibicionTransporteAlava) {
			// plantillaTramiteDecisionDetalle.setInhiTransLine1(Y41bConstantes.IT_01_Linea1);
			// plantillaTramiteDecisionDetalle.setInhiTransLine2(Y41bConstantes.IT_01_Linea2);
			// plantillaTramiteDecisionDetalle.setInhiTransLine3(Y41bConstantes.IT_01_Linea3);
			// plantillaTramiteDecisionDetalle.setInhiTransLine4(Y41bConstantes.IT_01_Linea4);
			// plantillaTramiteDecisionDetalle.setInhiTransLine5(Y41bConstantes.IT_01_Linea5);
			// plantillaTramiteDecisionDetalle.setInhiTransLine6(Y41bConstantes.IT_01_Linea6);
			// } else {
			// plantillaTramiteDecisionDetalle.setInhiTransLine1(Y41bConstantes.IT_20_48_Linea1);
			// plantillaTramiteDecisionDetalle.setInhiTransLine2(Y41bConstantes.IT_20_48_Linea2);
			// plantillaTramiteDecisionDetalle.setInhiTransLine3(Y41bConstantes.IT_20_48_Linea3);
			// plantillaTramiteDecisionDetalle.setInhiTransLine4(Y41bConstantes.IT_20_48_Linea4);
			// plantillaTramiteDecisionDetalle.setInhiTransLine5(Y41bConstantes.IT_20_48_Linea5);
			// plantillaTramiteDecisionDetalle.setInhiTransLine6(Y41bConstantes.IT_20_48_Linea6);
			// }

			// No avenencia- cons texto aparece en funcion de si esa dherido o
			// no
			if (plantillaTramiteDecisionDetalle.getEsinadar() != null
					&& plantillaTramiteDecisionDetalle.getEsinadar().equalsIgnoreCase(Y41bConstantes.SI)) {

				plantillaTramiteDecisionDetalle.setTextoAdheridoCas(appMessageSource
						.getMessage("plantilla.noavenenciacons.adherido", null, new Locale(Y41bConstantes.CASTELLANO)));

				plantillaTramiteDecisionDetalle.setTextoAdheridoEus(appMessageSource
						.getMessage("plantilla.noavenenciacons.adherido", null, new Locale(Y41bConstantes.EUSKERA)));

			} else {
				plantillaTramiteDecisionDetalle.setTextoAdheridoCas("");
				plantillaTramiteDecisionDetalle.setTextoAdheridoEus("");
			}

			return plantillaTramiteDecisionDetalle;

		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Busqueda para montar el hashmap - siempre ordenado por fecha y hora desc
	 * Al que se le aade el calculo de la fase para los tramites sin fase -
	 * calculo ok con ese orden
	 */
	public List<TramiteHechoDetalle> findAllTramiteHechoHash(TramiteHechoDetalle tramiteHechoDetalle) {

		Pagination pagination = new Pagination();

		pagination.setSort("EHFECHA DESC, EHHORA");
		pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
				.findAllTramiteHecho(tramiteHechoDetalle, pagination);

		if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {
			ListIterator iter = listTramiteHechoDetalle.listIterator(listTramiteHechoDetalle.size());

			TramiteHechoDetalle tramiteHechoDetalleAux = null;
			String fnombre = null;
			String fnombree = null;

			while (iter.hasPrevious()) {
				tramiteHechoDetalleAux = (TramiteHechoDetalle) iter.previous();

				if (tramiteHechoDetalleAux.getFnombre() == null || tramiteHechoDetalleAux.getFnombre().equals("")) {

					if (fnombre == null || fnombre.equals("")) {
						try {
							TramiteHechoDetalle tramHechoDetalleAux = new TramiteHechoDetalle();
							tramHechoDetalleAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());
							tramHechoDetalleAux.setHdcodigo(tramiteHechoDetalleAux.getHdcodigo());

							tramHechoDetalleAux = this.tramiteHechoDao.findUltimaFase(tramHechoDetalleAux);
							fnombre = tramHechoDetalleAux.getFnombre();
							fnombree = tramHechoDetalleAux.getFnombree();

							tramiteHechoDetalleAux.setFnombre(fnombre);
							tramiteHechoDetalleAux.setFnombree(fnombree);
						} catch (Exception e) {
						}
					} else {
						tramiteHechoDetalleAux.setFnombre(fnombre);
						tramiteHechoDetalleAux.setFnombree(fnombree);
					}
				} else {
					fnombre = tramiteHechoDetalleAux.getFnombre();
					fnombree = tramiteHechoDetalleAux.getFnombree();
				}
			}
		}
		return listTramiteHechoDetalle;
	}

	//
	/**
	 * Guardar esa informacion en el Hashmap - idTramite + Tramite
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public Map<String, TramiteHechoDetalle> creaHashmapTramitacion(List<TramiteHechoDetalle> listTramiteHechoDetalle) {

		Map<String, TramiteHechoDetalle> mapaTramiteHechoDetalle = new HashMap<String, TramiteHechoDetalle>();

		ListIterator iter = listTramiteHechoDetalle.listIterator(listTramiteHechoDetalle.size());

		TramiteHechoDetalle tramiteHechoDetalleAux = null;

		while (iter.hasPrevious()) {
			tramiteHechoDetalleAux = (TramiteHechoDetalle) iter.previous();
			mapaTramiteHechoDetalle.put(tramiteHechoDetalleAux.getEhcodigo(), tramiteHechoDetalleAux);
		}

		return mapaTramiteHechoDetalle;
	}

	//

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoDetalle> findAllTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("EHFECHA DESC, EHHORA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		// --------------------- datos fase buenos en el hashmap
		List<TramiteHechoDetalle> listTramiteHechoDetalleHash = this.findAllTramiteHechoHash(tramiteHechoDetalle);

		Map<String, TramiteHechoDetalle> mapaTramiteHechoDetalle = new HashMap<String, TramiteHechoDetalle>();

		if (listTramiteHechoDetalleHash != null) {
			mapaTramiteHechoDetalle = this.creaHashmapTramitacion(listTramiteHechoDetalleHash);
		}

		// ---------------------
		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.tramiteHechoDao
				.findAllTramiteHecho(tramiteHechoDetalle, pagination);

		if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {
			ListIterator iter = listTramiteHechoDetalle.listIterator(listTramiteHechoDetalle.size());

			TramiteHechoDetalle tramiteHechoDetalleAux = null;
			String trnombre = null;
			String trnombree = null;

			while (iter.hasPrevious()) {
				tramiteHechoDetalleAux = (TramiteHechoDetalle) iter.previous();

				// buscar los documentos del tramite
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(tramiteHechoDetalleAux.getEhcodigo());

				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				// origen comunicacion notificacion
				if (Y41bConstantes.TRAMITE_COMUNICACION.equals(tramiteHechoDetalleAux.getTrcodigo())
						|| Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramiteHechoDetalleAux.getTrcodigo())) {
					tramiteHechoDetalleAux.setOrigenDestino(tramiteHechoDetalleAux.getTipoInterviniente());

				}

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					tramiteHechoDetalleAux.setIndVariosDocumentos(Y41bConstantes.NO);

					tramiteHechoDetalleAux.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
					tramiteHechoDetalleAux.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
					tramiteHechoDetalleAux.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
					tramiteHechoDetalleAux.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
					tramiteHechoDetalleAux.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());

					if (Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION.equals(tramiteHechoDetalleAux.getTrcodigo())) {
						tramiteHechoDetalleAux.setOrigenDestino(listDocumentoHecho.get(0).getQ5origen());
					}
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						tramiteHechoDetalleAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}
					if (Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION.equals(tramiteHechoDetalleAux.getTrcodigo())) {
						int reclamante = 0;
						int reclamado = 0;
						int repReclamante = 0;
						int repReclamado = 0;
						int administracion = 0;
						int otros = 0;
						for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
							if (documentoHechoAux.getQ5origen().equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE)) {
								reclamante++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO)) {
								reclamado++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE)) {
								repReclamante++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO)) {
								repReclamado++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION)) {
								administracion++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS)) {
								otros++;
							}

						}
						if (reclamante == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
						} else if (reclamado == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO);
						} else if (repReclamante == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
						} else if (repReclamado == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO);
						} else if (administracion == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
						} else if (otros == listDocumentoHecho.size()) {
							tramiteHechoDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS);
						} else {
							tramiteHechoDetalleAux.setOrigenDestino(Y41bConstantes.NO);
						}

					}

				}
				if (listDocumentoHecho != null) {
					Parametros parametros = new Parametros();

					parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
					parametros = this.parametrosDao.find(parametros);

					for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
						if (documentoHechoAux.getQ5fechasollocalizador() != null
								&& !tramiteHechoDetalleAux.getEhestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramiteHechoDetalleAux.getEhestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramiteHechoDetalleAux.getEhestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
							if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {

								int minutos = 0;
								if (parametros != null && parametros.getValor() != null
										&& Y41bUtils.isNumeric(parametros.getValor())) {
									minutos = Integer.parseInt(parametros.getValor());
								}

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (60 * 1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}

								if (diffMinutes > minutos) {
									tramiteHechoDetalleAux
											.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
								} else {
									tramiteHechoDetalleAux
											.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
								}
							} else {
								if (tramiteHechoDetalleAux.getEhestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									tramiteHechoDetalleAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
								} else if (!tramiteHechoDetalleAux.getEhestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
										&& !tramiteHechoDetalleAux.getEhestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
										&& !tramiteHechoDetalleAux.getEhestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
										&& !tramiteHechoDetalleAux.getEhestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
										&& !tramiteHechoDetalleAux.getEhestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
									tramiteHechoDetalleAux.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
								}
							}
						}
					}
				}

				if (listTramiteHechoDetalleHash != null) {
					// fase de los valores del hashmap
					tramiteHechoDetalleAux.setFnombre(
							(mapaTramiteHechoDetalle.get(tramiteHechoDetalleAux.getEhcodigo())).getFnombre());
					tramiteHechoDetalleAux.setFnombree(
							(mapaTramiteHechoDetalle.get(tramiteHechoDetalleAux.getEhcodigo())).getFnombree());
				} else {
					tramiteHechoDetalleAux.setFnombre("");
					tramiteHechoDetalleAux.setFnombree("");

				}
				/*
				 * if (tramiteHechoDetalleAux.getFnombre() == null ||
				 * tramiteHechoDetalleAux.getFnombre().equals("")) {
				 * 
				 * if (fnombre == null || fnombre.equals("")) { try {
				 * TramiteHechoDetalle tramHechoDetalleAux = new
				 * TramiteHechoDetalle(); tramHechoDetalleAux
				 * .setEhcodigo(tramiteHechoDetalleAux .getEhcodigo());
				 * tramHechoDetalleAux .setHdcodigo(tramiteHechoDetalleAux
				 * .getHdcodigo());
				 * 
				 * tramHechoDetalleAux = this.tramiteHechoDao
				 * .findUltimaFase(tramHechoDetalleAux); fnombre =
				 * tramHechoDetalleAux.getFnombre(); fnombree =
				 * tramHechoDetalleAux.getFnombree();
				 * 
				 * tramiteHechoDetalleAux.setFnombre(fnombre);
				 * tramiteHechoDetalleAux.setFnombree(fnombree); } catch
				 * (Exception e) { } } else {
				 * tramiteHechoDetalleAux.setFnombre(fnombre);
				 * tramiteHechoDetalleAux.setFnombree(fnombree); } } else {
				 * fnombre = tramiteHechoDetalleAux.getFnombre(); fnombree =
				 * tramiteHechoDetalleAux.getFnombree(); }
				 */
				if (tramiteHechoDetalleAux.getTrnombre() == null || tramiteHechoDetalleAux.getTrnombre().equals("")) {
					try {
						Tramite tramiteAux = new Tramite();
						tramiteAux.setTrcodigo(tramiteHechoDetalleAux.getTrcodigo());
						tramiteAux = this.tramiteDao.findTramiteKontsumoGest(tramiteAux);
						trnombre = tramiteAux.getTrnombre();
						trnombree = tramiteAux.getTrnombree();

						tramiteHechoDetalleAux.setTrnombre(trnombre);
						tramiteHechoDetalleAux.setTrnombree(trnombree);
					} catch (Exception e) {
					}
				}

				if (tramiteHechoDetalleAux.getEhfechaEnvioBOPVBOE() != null) {
					if (!tramiteHechoDetalleAux.getEhestadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
						StringBuffer sbTrnombre = new StringBuffer();
						sbTrnombre.append(tramiteHechoDetalleAux.getTrnombre());
						sbTrnombre.append(" (");
						sbTrnombre.append(Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfechaEnvioBOPVBOE(),
								Y41bConstantes.CASTELLANO));
						sbTrnombre.append(")");

						StringBuffer sbTrnombree = new StringBuffer();
						sbTrnombree.append(tramiteHechoDetalleAux.getTrnombree());
						sbTrnombree.append(" (");
						sbTrnombree.append(Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfechaEnvioBOPVBOE(),
								Y41bConstantes.EUSKERA));
						sbTrnombree.append(")");

						tramiteHechoDetalleAux.setTrnombre(sbTrnombre.toString());
						tramiteHechoDetalleAux.setTrnombree(sbTrnombree.toString());
					}
				}
				// TELEMATICA O APORTACIONES DE Y41R
				if ((tramiteHechoDetalleAux.getEhistelematico() != null)
						|| (tramiteHechoDetalleAux.getEhIsWebSinCertificado() != null && tramiteHechoDetalleAux
								.getEhIsWebSinCertificado().equalsIgnoreCase(Y41bConstantes.VALOR_SI))) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalleAux.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(appMessageSource.getMessage("comun.telematico", null,
							new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalleAux.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(")");

					tramiteHechoDetalleAux.setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalleAux.setTrnombree(sbTrnombree.toString());
				}
				// solo se mostrara coletilla sir si
				if ((tramiteHechoDetalleAux.getEhissir() != null
						&& tramiteHechoDetalleAux.getEhissir().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
						&& !(tramiteHechoDetalleAux.getEhissirconnumregentori() != null))
						|| (tramiteHechoDetalleAux.getEhissir() != null
								&& tramiteHechoDetalleAux.getEhissir().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
								&& tramiteHechoDetalleAux.getEhissirconnumregentori() != null && tramiteHechoDetalleAux
										.getEhissirconnumregentori().equalsIgnoreCase(Y41bConstantes.VALOR_SI))) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalleAux.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalleAux.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree
							.append(appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(")");

					tramiteHechoDetalleAux.setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalleAux.setTrnombree(sbTrnombree.toString());
				}

			}
		}

		return listTramiteHechoDetalle;
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle) {
		return this.tramiteHechoDao.findAllTramiteHechoCount(tramiteHechoDetalle);
	}

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntradaAlta(String dni, String nombre) throws Exception {

		// SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		// solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
		//
		// SolicitudDetalle solDetalle = this.hechoDenunciadoDao
		// .findSolicitud(solicitudDetalle);

		RegistroEntrada registroEntrada = new RegistroEntrada();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		registroEntrada.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(dni);
		datosPersona.setNombre(nombre);

		registroEntrada.setSolicitante(datosPersona);

		registroEntrada.setIdioma(Y41bConstantes.CASTELLANO);

		registroEntrada = y41bPlateaAdapterService.obtenerRegistroEntrada(registroEntrada);
		registroEntrada.setRegistryDate(Y41bUtils.parseRegistrytimestamp(registroEntrada.getRegistryTimestamp()));

		return registroEntrada;
	}

	/**
	 * Tratamiento para gestionar la bandeja de solicitudes.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void tratamientoBandejaSolicitudes(HechoDenunciado hechodenunciado) {
		// borrar los tramites del expediente en la bandeja
		BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
		bandejasolicitudes.setHdcodigo(hechodenunciado.getHdcodigo());

		this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hechodenunciado.getHdcodigo());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// Miro si la solicitud esta cerrada
		if (solDetalle.getHdfechacierre() == null) {
			// consultar los tramites no tramitados
			List<BandejaSolicitudes> listBandejaSolicitudes = this.bandejaSolicitudesDao
					.findAllTramitesPendientesSolicitudes(bandejasolicitudes, null);

			if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {
				// insertar los tramites no tramitados en la bandeja
				for (BandejaSolicitudes bandejaSolicitudesAux : listBandejaSolicitudes) {

					// Si el tramite es una comunicacion, se mira si el tramite
					// de
					// comunicacion esta relacionado con un traslado,
					// Si pertenece a un traslado, se mete el organismo origen
					// en la
					// bandeja, para que aparezca en la bandeja
					// de los instructores del organismo origen para poder
					// realizar
					// la comunicacion
					if (bandejaSolicitudesAux != null && bandejaSolicitudesAux.getTrcodigo() != null
							&& bandejaSolicitudesAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
						TramiteHecho tramitehecho = new TramiteHecho();
						tramitehecho.setEhcodigo(bandejaSolicitudesAux.getEhcodigo());

						tramitehecho = this.tramiteHechoDao.find(tramitehecho);

						try {
							if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
									&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
								TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
								tramiteHechoDet.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
								TrasladoBusqueda trasladoBusqueda = this.trasladoDao
										.findTrasladoTramite(tramiteHechoDet);
								if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
									bandejaSolicitudesAux.setHdcomo(tramitehecho.getEhcomoasignado());
									bandejaSolicitudesAux.setHccoor(trasladoBusqueda.getIhcooror());
								}
							}
						} catch (Throwable e) {
						}
					}

					// insertar el ultimo tramite realizado
					this.bandejaSolicitudesDao.add(bandejaSolicitudesAux);
				}

			} else {
				// si no hay tramites no tramitados
				listBandejaSolicitudes = this.bandejaSolicitudesDao
						.findAllTramitesFinalizadosSolicitudes(bandejasolicitudes, null);

				if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {
					if (!listBandejaSolicitudes.get(0).getTrcodigo().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {

						this.bandejaSolicitudesDao.add(listBandejaSolicitudes.get(0));
					}
				}
			}
		}
	}

	/**
	 * Complete information of the object PlantillaSolicitudDetalle.
	 * 
	 * @param plantillaSolicitudDetalle
	 *            PlantillaSolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	private PlantillaSolicitudDetalle completeInfoPlantillaSolicitudDetalle(
			PlantillaSolicitudDetalle plantillaSolicitudDetalle) {

		try {
			if (plantillaSolicitudDetalle.getDtcalleId_label() == null
					|| plantillaSolicitudDetalle.getDtcalleId_label().equals("")) {
				if (plantillaSolicitudDetalle.getDtdireccion_nocapv() == null
						|| plantillaSolicitudDetalle.getDtdireccion_nocapv().equals("")) {
					plantillaSolicitudDetalle.setDtcalleId_label(plantillaSolicitudDetalle.getDtnodir());
				} else {
					plantillaSolicitudDetalle.setDtcalleId_label(plantillaSolicitudDetalle.getDtdireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio.append(plantillaSolicitudDetalle.getDtcalleId_label());

				if (plantillaSolicitudDetalle.getDtnombrePortal() != null) {
					domicilio.append(", ").append(plantillaSolicitudDetalle.getDtnombrePortal());
				}
				if (plantillaSolicitudDetalle.getDtnombrePiso() != null) {
					domicilio.append(" ").append(plantillaSolicitudDetalle.getDtnombrePiso());
				}
				plantillaSolicitudDetalle.setDtcalleId_label(domicilio.toString());
			}

			if (plantillaSolicitudDetalle.getEscalleId_label() == null
					|| plantillaSolicitudDetalle.getEscalleId_label().equals("")) {
				if (plantillaSolicitudDetalle.getEsdireccion_nocapv() == null
						|| plantillaSolicitudDetalle.getEsdireccion_nocapv().equals("")) {

					plantillaSolicitudDetalle.setEscalleId_label(plantillaSolicitudDetalle.getEsnodir());
				} else {
					plantillaSolicitudDetalle.setEscalleId_label(plantillaSolicitudDetalle.getEsdireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio.append(plantillaSolicitudDetalle.getEscalleId_label());

				if (plantillaSolicitudDetalle.getEsnombrePortal() != null) {
					domicilio.append(", ").append(plantillaSolicitudDetalle.getEsnombrePortal());
				}
				if (plantillaSolicitudDetalle.getEsnombrePiso() != null) {
					domicilio.append(" ").append(plantillaSolicitudDetalle.getEsnombrePiso());
				}
				plantillaSolicitudDetalle.setEscalleId_label(domicilio.toString());
			}

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(plantillaSolicitudDetalle.getDecoor()).append("-")
					.append(plantillaSolicitudDetalle.getDenror()).append("-")
					.append(plantillaSolicitudDetalle.getDenran()).append("-")
					.append(plantillaSolicitudDetalle.getHdnror());

			plantillaSolicitudDetalle.setNumExpediente(numeroExpediente.toString());

			// Formateamos las fecha a castellano e euskera
			plantillaSolicitudDetalle.setFechaActualTextoCas(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaSolicitudDetalle.setFechaActualTextoEus(Y41bUtils.formatearDateToStringEuskera(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			return plantillaSolicitudDetalle;

		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.plantill", true, e);
		}
	}

	/**
	 * Genera la tabla de documentos que estara en la plantilla de la solicitud
	 * 
	 * @param documentoHechoList
	 *            List
	 * @return String
	 */
	private String generarTablaDocumentos(List<DocumentoHecho> documentoHechoList) {

		/*** Insertar TABLA ***/
		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");

		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh-500 ");

		// Bordes de la fila
		stablaDoc.append(" \\\\trbrdrt\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrl\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrb\\\\brdrs\\\\brdrw10 ");
		stablaDoc.append(" \\\\trbrdrr\\\\brdrs\\\\brdrw10 ");

		// // Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx8500");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		if (documentoHechoList != null) {
			for (DocumentoHecho documentoHechoAux : documentoHechoList) {
				stablaDoc.append(documentoHechoAux.getQ5nofile());
				stablaDoc.append("\\\\cell");
				stablaDoc.append(" \\\\row ");
			}
		}

		stablaDoc.append(" \\\\pard ");
		// Cierre final
		stablaDoc.append("}");

		return stablaDoc.toString();
	}

	/**
	 * Genera la tabla de tramites que estara en la plantilla de la solicitud
	 * 
	 * @param tramiteHechoDetalleList
	 *            List
	 * @return String
	 */
	private String generarTablaTramites( /*********************************************/
	List<TramiteHechoDetalle> tramiteHechoDetalleList) {

		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");
		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh500 ");// stablaDoc.append(" \\\\trrh-500 ");

		// Bordes de la fila
		stablaDoc.append("\\\\trbrdrt\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrl\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrb\\\\brdrs\\\\brdrw10");
		stablaDoc.append("\\\\trbrdrr\\\\brdrs\\\\brdrw10");

		// Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx2055");

		// Bordes de la segunda celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx3402");

		// Bordes de la tercera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx4750");

		// Bordes de la cuarta celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx6663");

		// Bordes de la quinta celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\clbrdrt\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrl\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrb\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\clbrdrr\\\\brdrw15\\\\brdrs");
		stablaDoc.append("\\\\cellx8612");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		// Trazado de la filas

		// inicio cabecera *****************
		// stablaDoc.append(" \\\\intbl ");

		// c1
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("MONITOREA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  MONITOR");
		stablaDoc.append(" \\\\cell ");
		// c2
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("DATA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  FECHA");
		stablaDoc.append(" \\\\cell ");
		// c3
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("ORDU");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  HORA");
		stablaDoc.append(" \\\\cell ");
		// c4
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("IZAPIDEA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  TRAMITE");
		stablaDoc.append(" \\\\cell ");
		// c5
		stablaDoc.append(" \\\\qc ");
		stablaDoc.append(" \\\\b ");
		stablaDoc.append("DATA");
		stablaDoc.append(" \\\\b0 ");
		stablaDoc.append(" /  COMENTARIO");
		stablaDoc.append(" \\\\cell  ");

		stablaDoc.append(" \\\\row  ");
		// fin cabecera **********************

		// Inicio Resto filas

		if (tramiteHechoDetalleList != null) {
			for (TramiteHechoDetalle tramiteHechoDetalleAux : tramiteHechoDetalleList) {
				// stablaDoc.append(" \\\\intbl ");

				if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getMonombre())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getMonombre());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (tramiteHechoDetalleAux.getEhfecha() != null) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(Y41bUtils.parseDateToString(tramiteHechoDetalleAux.getEhfecha(),
							Y41bConstantes.CASTELLANO));
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getEhhora())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getEhhora());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				/*
				 * ***************************************************** CONTROL
				 * SITUACION ACUSE
				 * *****************************************************
				 */

				String estadoAcuseES = "";
				String estadoAcuseEU = "";
				String postFijoES = "";
				String postFijoEU = "";

				if (tramiteHechoDetalleAux.getSituacionacuse() != null) {
					if (Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO
							.equals(tramiteHechoDetalleAux.getSituacionacuse())) {

						estadoAcuseEU = appMessageSource.getMessage("situacionacuse.aceptado", null,
								new Locale(Y41bConstantes.EUSKERA));
						estadoAcuseES = appMessageSource.getMessage("situacionacuse.aceptado", null,
								new Locale(Y41bConstantes.CASTELLANO));
					} else if (Y41bConstantes.SITUACION_ACUSERECIBO_RECHAZADO
							.equals(tramiteHechoDetalleAux.getSituacionacuse())) {
						estadoAcuseEU = appMessageSource.getMessage("situacionacuse.rechazado", null,
								new Locale(Y41bConstantes.EUSKERA));
						estadoAcuseES = appMessageSource.getMessage("situacionacuse.rechazado", null,
								new Locale(Y41bConstantes.CASTELLANO));
					} else if (Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO
							.equals(tramiteHechoDetalleAux.getSituacionacuse())) {
						estadoAcuseEU = appMessageSource.getMessage("situacionacuse.noentregado", null,
								new Locale(Y41bConstantes.EUSKERA));
						estadoAcuseES = appMessageSource.getMessage("situacionacuse.noentregado", null,
								new Locale(Y41bConstantes.CASTELLANO));
					}

					if (Y41bConstantes.VALOR_SI.equals(tramiteHechoDetalleAux.getEhacusereintentado())) {

						String estadoReintentadoEU = appMessageSource.getMessage("situacionacuse.reintentado", null,
								new Locale(Y41bConstantes.EUSKERA));
						String estadoReintentadoES = appMessageSource.getMessage("situacionacuse.reintentado", null,
								new Locale(Y41bConstantes.CASTELLANO));
						postFijoEU = " (" + estadoAcuseEU + ") (" + estadoReintentadoEU + ")";
						postFijoES = " (" + estadoAcuseES + ") (" + estadoReintentadoES + ")";
					} else {
						postFijoEU = " (" + estadoAcuseEU + ")";
						postFijoES = " (" + estadoAcuseES + ")";
					}
				} else {
					if (tramiteHechoDetalleAux.getEnvcdessitcorreoseu() != null) {
						postFijoEU = " (" + tramiteHechoDetalleAux.getEnvcdessitcorreoseu() + ")";
					}

					if (tramiteHechoDetalleAux.getEnvcdessitcorreoses() != null) {
						postFijoES = " (" + tramiteHechoDetalleAux.getEnvcdessitcorreoses() + ")";

					}
				}

				/* ***************************************************** */

				if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getTrnombre())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getTrnombree());
					stablaDoc.append(postFijoEU);
					stablaDoc.append(" / ");
					stablaDoc.append(tramiteHechoDetalleAux.getTrnombre());
					stablaDoc.append(postFijoES);
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				TramiteHecho tramiteHechoAux = new TramiteHecho();
				tramiteHechoAux.setEhcodigo(tramiteHechoDetalleAux.getEhcodigo());

				TramiteHecho tramHecho = this.tramiteHechoDao.findLobTablaTemporal(tramiteHechoAux);
				if (Y41bUtils.isFilled(tramHecho.getEhtexto())) {
					tramiteHechoDetalleAux.setEhtexto(
							Y41bStringUtils.unescapeHTML(Y41bUtils.eliminarTags(tramHecho.getEhtexto()), 0));
				}

				if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getEhtexto())) {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append(tramiteHechoDetalleAux.getEhtexto());
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				} else {
					stablaDoc.append(" \\\\b0 ");
					stablaDoc.append("  \\\\cell  ");
				}

				stablaDoc.append("  \\\\row  ");
			}
		}

		// Fin resto filas
		stablaDoc.append(" \\\\pard\\\\par ");
		// Cierre final
		stablaDoc.append("}");

		// /*** Insertar TABLA ***/
		// StringBuffer stablaDoc = new StringBuffer(120);
		// stablaDoc.append("{"); // <-- Inicio de la tabla
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append("\\\\trowd");
		// stablaDoc.append("\\\\trqc");
		//
		// stablaDoc.append("\\\\trgaph0");// <--márgenes izquierdo y derecho
		// de
		// // las celdas=70
		//
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx2055");//
		// stablaDoc.append("\\\\cellx1985");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx3402");//
		// stablaDoc.append("\\\\cellx3402");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx4750");//
		// stablaDoc.append("\\\\cellx4820");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx6663");//
		// stablaDoc.append("\\\\cellx6663");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx8612");//
		// stablaDoc.append("\\\\cellx8612");
		//
		// // Cabecera
		// //
		// ******************************************************************************
		//
		// stablaDoc.append("{");
		//
		// // Columna 1
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("MONITOREA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / MONITOR");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 2
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("DATA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / FECHA");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 3
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("ORDU");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / HORA");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 4
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("IZAPIDEA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / TRAMITE");
		// stablaDoc.append(" \\\\cell ");
		//
		// // Columna 5
		// stablaDoc.append(" \\\\par ");
		// stablaDoc.append(" \\\\qc ");
		// stablaDoc.append(" \\\\b ");
		// stablaDoc.append("DATA");
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" / COMENTARIO");
		// stablaDoc.append(" \\\\cell }");
		//
		// stablaDoc.append(" \\\\b0 ");
		// stablaDoc.append(" \\\\ql ");
		// stablaDoc.append(" \\\\row");
		//
		// // Hasta aquí generación de cabecera
		// // *************************************************************
		//
		// if (tramiteHechoDetalleList != null) {
		// for (TramiteHechoDetalle tramiteHechoDetalleAux :
		// tramiteHechoDetalleList) {
		//
		// // TABLA
		// stablaDoc.append("\\\\trowd");
		// stablaDoc.append("\\\\trgaph00");// <--márgenes izquierdo y
		// // derecho
		// // de las celdas=70
		// stablaDoc.append("\\\\trqc");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx2055");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx3402");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx4750");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx6663");
		// stablaDoc.append("\\\\clbrdrl\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrt\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrr\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\clbrdrb\\\\brdrw10\\\\brdrs");
		// stablaDoc.append("\\\\cellx8612");
		//
		// if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getMonombre())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getMonombre());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (tramiteHechoDetalleAux.getEhfecha() != null) {
		// stablaDoc.append(Y41bUtils.parseDateToString(
		// tramiteHechoDetalleAux.getEhfecha(),
		// Y41bConstantes.CASTELLANO));
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getEhhora())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getEhhora());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getTrnombre())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getTrnombree());
		// stablaDoc.append(" / ");
		// stablaDoc.append(tramiteHechoDetalleAux.getTrnombre());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// if (Y41bUtils.isFilled(tramiteHechoDetalleAux.getEhtexto())) {
		// stablaDoc.append(tramiteHechoDetalleAux.getEhtexto());
		// stablaDoc.append(" \\\\cell ");
		// } else {
		// stablaDoc.append(" ");
		// stablaDoc.append(" \\\\cell ");
		// }
		//
		// stablaDoc.append(" \\\\row");
		// }
		// }
		//
		// // Cierre final
		// stablaDoc.append("}");

		return stablaDoc.toString();
	}

	/**
	 * Complete information of the object PlantillaTramiteHechoDetalle.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	public PlantillaTramiteHechoDetalle completeInfoPlantillaTramiteHechoDetalle(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle) {

		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(plantillaTramiteHechoDetalle.getHdcodigo());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			Intervinientes intervinientesAux = new Intervinientes();
			intervinientesAux.setIdExpediente(plantillaTramiteHechoDetalle.getHdcodigo());

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

			if (listIntervinientes.size() > 1) {
				for (Intervinientes intervinientes : listIntervinientes) {

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
						if (solDetalle.getHddestnotificareclamante() != null && solDetalle.getHddestnotificareclamante()
								.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
								plantillaTramiteHechoDetalle.setDtcodigo(intervinientesAux.getDtcodigo());

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								// 202802
								// reclamante con representante validado
								// con com/notificacion a representante
								// en la plantilla seleccionando destinatario
								// (plantilla al reclamado) quieren que aparezca
								// el titular (reclamante) no su representante
								// se habilita el campo que se usa en
								// alegaciones NOMBRETITULAR y su
								// IDENTIFICACIONTITULAR para que usen estos
								// campos como habian solicitado

								// plantillaTramiteHechoDetalle
								// .setNombreTitular(plantillaTramiteHechoDetalle.getDtnombre());
								// plantillaTramiteHechoDetalle
								// .setIdentificacionTitular(plantillaTramiteHechoDetalle.getDtnif());
								//
								plantillaTramiteHechoDetalle.setDtnombre(nombreCompleto.toString());
								plantillaTramiteHechoDetalle.setDtnif(intervinientesAux.getNif());
								plantillaTramiteHechoDetalle.setDtprovinciaId(intervinientesAux.getNoraProvinciaId());
								plantillaTramiteHechoDetalle
										.setDtnombreProvincia(intervinientesAux.getNombreProvincia());
								plantillaTramiteHechoDetalle.setDtmunicipioId(intervinientesAux.getNoraMunicipioId());
								plantillaTramiteHechoDetalle
										.setDtnombreMunicipio(intervinientesAux.getNombreMunicipio());
								plantillaTramiteHechoDetalle.setDtlocalidadId(intervinientesAux.getNoraLocalidadId());
								plantillaTramiteHechoDetalle
										.setDtnombreLocalidad(intervinientesAux.getNombreLocalidad());
								plantillaTramiteHechoDetalle.setDtnoraCalleId(intervinientesAux.getNoraCalleId());
								plantillaTramiteHechoDetalle.setDtnombreCalle(intervinientesAux.getNombreCalle());
								plantillaTramiteHechoDetalle.setDtcpId(intervinientesAux.getNoraCpId());
								plantillaTramiteHechoDetalle.setDtnombreCp(intervinientesAux.getNombreCp());
								plantillaTramiteHechoDetalle.setDtportalId(intervinientesAux.getNoraPortalId());
								plantillaTramiteHechoDetalle.setDtnombrePortal(intervinientesAux.getNombrePortal());
								plantillaTramiteHechoDetalle.setDtnombrePiso(intervinientesAux.getNombrePiso());
								plantillaTramiteHechoDetalle.setDtnoraPaisId(intervinientesAux.getNoraPaisId());
								plantillaTramiteHechoDetalle.setDtnoraPaisNombre(intervinientesAux.getNombrePais());

								plantillaTramiteHechoDetalle.setDtnrtel(intervinientesAux.getNrtel());
								plantillaTramiteHechoDetalle.setDtnrtel2(intervinientesAux.getNrtel2());
								plantillaTramiteHechoDetalle.setDttecoem(intervinientesAux.getCoem());

								plantillaTramiteHechoDetalle
										.setDtdireccion_nocapv(intervinientesAux.getDireccionNocapv());
							} else {
								intervinientesAux = new Intervinientes();
								intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
								intervinientesAux.setTipoInterviniente(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
								intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

								if (intervinientesAux != null
										&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
									plantillaTramiteHechoDetalle.setDtcodigo(intervinientesAux.getDtcodigo());

									StringBuffer nombreCompleto = new StringBuffer();

									nombreCompleto.append(intervinientesAux.getNombre());

									if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
									}

									if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
									}

									plantillaTramiteHechoDetalle.setDtnombre(nombreCompleto.toString());
									plantillaTramiteHechoDetalle.setDtnif(intervinientesAux.getNif());
									plantillaTramiteHechoDetalle
											.setDtprovinciaId(intervinientesAux.getNoraProvinciaId());
									plantillaTramiteHechoDetalle
											.setDtnombreProvincia(intervinientesAux.getNombreProvincia());
									plantillaTramiteHechoDetalle
											.setDtmunicipioId(intervinientesAux.getNoraMunicipioId());
									plantillaTramiteHechoDetalle
											.setDtnombreMunicipio(intervinientesAux.getNombreMunicipio());
									plantillaTramiteHechoDetalle
											.setDtlocalidadId(intervinientesAux.getNoraLocalidadId());
									plantillaTramiteHechoDetalle
											.setDtnombreLocalidad(intervinientesAux.getNombreLocalidad());
									plantillaTramiteHechoDetalle.setDtnoraCalleId(intervinientesAux.getNoraCalleId());
									plantillaTramiteHechoDetalle.setDtnombreCalle(intervinientesAux.getNombreCalle());
									plantillaTramiteHechoDetalle.setDtcpId(intervinientesAux.getNoraCpId());
									plantillaTramiteHechoDetalle.setDtnombreCp(intervinientesAux.getNombreCp());
									plantillaTramiteHechoDetalle.setDtportalId(intervinientesAux.getNoraPortalId());
									plantillaTramiteHechoDetalle.setDtnombrePortal(intervinientesAux.getNombrePortal());
									plantillaTramiteHechoDetalle.setDtnombrePiso(intervinientesAux.getNombrePiso());
									plantillaTramiteHechoDetalle.setDtnoraPaisId(intervinientesAux.getNoraPaisId());
									plantillaTramiteHechoDetalle.setDtnoraPaisNombre(intervinientesAux.getNombrePais());

									plantillaTramiteHechoDetalle.setDtnrtel(intervinientesAux.getNrtel());
									plantillaTramiteHechoDetalle.setDtnrtel2(intervinientesAux.getNrtel2());
									plantillaTramiteHechoDetalle.setDttecoem(intervinientesAux.getCoem());

									plantillaTramiteHechoDetalle
											.setDtdireccion_nocapv(intervinientesAux.getDireccionNocapv());
								}
							}
						}
					} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
						if (solDetalle.getHddestnotificareclamado() != null && solDetalle.getHddestnotificareclamado()
								.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
							intervinientesAux
									.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
								plantillaTramiteHechoDetalle.setEscodigo(intervinientesAux.getEscodigo());

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteHechoDetalle.setEsnombre(nombreCompleto.toString());
								plantillaTramiteHechoDetalle.setEsnif(intervinientesAux.getNif());
								plantillaTramiteHechoDetalle.setEsnoco(nombreCompleto.toString());
								plantillaTramiteHechoDetalle.setEsinadar(intervinientesAux.getInadar());
								plantillaTramiteHechoDetalle.setEsprovinciaId(intervinientesAux.getNoraProvinciaId());
								plantillaTramiteHechoDetalle
										.setEsnombreProvincia(intervinientesAux.getNombreProvincia());
								plantillaTramiteHechoDetalle.setEsmunicipioId(intervinientesAux.getNoraMunicipioId());
								plantillaTramiteHechoDetalle
										.setEsnombreMunicipio(intervinientesAux.getNombreMunicipio());
								plantillaTramiteHechoDetalle.setEslocalidadId(intervinientesAux.getNoraLocalidadId());
								plantillaTramiteHechoDetalle
										.setEsnombreLocalidad(intervinientesAux.getNombreLocalidad());
								plantillaTramiteHechoDetalle.setEsnoraCalleId(intervinientesAux.getNoraCalleId());
								plantillaTramiteHechoDetalle.setEsnombreCalle(intervinientesAux.getNombreCalle());
								plantillaTramiteHechoDetalle.setEscpId(intervinientesAux.getNoraCpId());
								plantillaTramiteHechoDetalle.setEsnombreCp(intervinientesAux.getNombreCp());
								plantillaTramiteHechoDetalle.setEsportalId(intervinientesAux.getNoraPortalId());
								plantillaTramiteHechoDetalle.setEsnombrePortal(intervinientesAux.getNombrePortal());
								plantillaTramiteHechoDetalle.setEsnombrePiso(intervinientesAux.getNombrePiso());
								plantillaTramiteHechoDetalle.setEsnoraPaisId(intervinientesAux.getNoraPaisId());
								plantillaTramiteHechoDetalle.setEsnoraPaisNombre(intervinientesAux.getNombrePais());

								plantillaTramiteHechoDetalle.setEsnrtel(intervinientesAux.getNrtel());
								plantillaTramiteHechoDetalle.setEsnrtel2(intervinientesAux.getNrtel2());
								plantillaTramiteHechoDetalle.setEstecoem(intervinientesAux.getCoem());

								plantillaTramiteHechoDetalle
										.setEsdireccion_nocapv(intervinientesAux.getDireccionNocapv());
							} else {
								intervinientesAux = new Intervinientes();
								intervinientesAux.setIdExpediente(solDetalle.getHdcodigo());
								intervinientesAux.setTipoInterviniente(
										Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
								intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

								if (intervinientesAux != null
										&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
									plantillaTramiteHechoDetalle.setEscodigo(intervinientesAux.getEscodigo());

									StringBuffer nombreCompleto = new StringBuffer();

									nombreCompleto.append(intervinientesAux.getNombre());

									if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
									}

									if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
										nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
									}

									plantillaTramiteHechoDetalle.setEsnombre(nombreCompleto.toString());
									plantillaTramiteHechoDetalle.setEsnif(intervinientesAux.getNif());
									plantillaTramiteHechoDetalle.setEsnoco(nombreCompleto.toString());
									plantillaTramiteHechoDetalle.setEsinadar(intervinientesAux.getInadar());
									plantillaTramiteHechoDetalle
											.setEsprovinciaId(intervinientesAux.getNoraProvinciaId());
									plantillaTramiteHechoDetalle
											.setEsnombreProvincia(intervinientesAux.getNombreProvincia());
									plantillaTramiteHechoDetalle
											.setEsmunicipioId(intervinientesAux.getNoraMunicipioId());
									plantillaTramiteHechoDetalle
											.setEsnombreMunicipio(intervinientesAux.getNombreMunicipio());
									plantillaTramiteHechoDetalle
											.setEslocalidadId(intervinientesAux.getNoraLocalidadId());
									plantillaTramiteHechoDetalle
											.setEsnombreLocalidad(intervinientesAux.getNombreLocalidad());
									plantillaTramiteHechoDetalle.setEsnoraCalleId(intervinientesAux.getNoraCalleId());
									plantillaTramiteHechoDetalle.setEsnombreCalle(intervinientesAux.getNombreCalle());
									plantillaTramiteHechoDetalle.setEscpId(intervinientesAux.getNoraCpId());
									plantillaTramiteHechoDetalle.setEsnombreCp(intervinientesAux.getNombreCp());
									plantillaTramiteHechoDetalle.setEsportalId(intervinientesAux.getNoraPortalId());
									plantillaTramiteHechoDetalle.setEsnombrePortal(intervinientesAux.getNombrePortal());
									plantillaTramiteHechoDetalle.setEsnombrePiso(intervinientesAux.getNombrePiso());
									plantillaTramiteHechoDetalle.setEsnoraPaisId(intervinientesAux.getNoraPaisId());
									plantillaTramiteHechoDetalle.setEsnoraPaisNombre(intervinientesAux.getNombrePais());

									plantillaTramiteHechoDetalle.setEsnrtel(intervinientesAux.getNrtel());
									plantillaTramiteHechoDetalle.setEsnrtel2(intervinientesAux.getNrtel2());
									plantillaTramiteHechoDetalle.setEstecoem(intervinientesAux.getCoem());

									plantillaTramiteHechoDetalle
											.setEsdireccion_nocapv(intervinientesAux.getDireccionNocapv());
								}
							}
						}
					}
				}
			}

			// Formateamos las fecha a castellano e euskera
			// fecha de hoy texto
			plantillaTramiteHechoDetalle
					.setFechaHoyCas(Y41bUtils.formatearDateToString(plantillaTramiteHechoDetalle.getFechaHoy(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle
					.setFechaHoyEus(Y41bUtils.formatearDateToStringEuskera(plantillaTramiteHechoDetalle.getFechaHoy(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			plantillaTramiteHechoDetalle
					.setEhfechaTextoCas(Y41bUtils.formatearDateToString(plantillaTramiteHechoDetalle.getEhfecha(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setEhfechaTextoEus(
					Y41bUtils.formatearDateToStringEuskera(plantillaTramiteHechoDetalle.getEhfecha(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			plantillaTramiteHechoDetalle
					.setEhfechaCas(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO));
			plantillaTramiteHechoDetalle.setEhfechaEus(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.EUSKERA));

			// Creamos el campo numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(plantillaTramiteHechoDetalle.getDecoor()).append("-")
					.append(plantillaTramiteHechoDetalle.getDenror()).append("-")
					.append(plantillaTramiteHechoDetalle.getDenran()).append("-")
					.append(plantillaTramiteHechoDetalle.getHdnror());

			plantillaTramiteHechoDetalle.setNumExpediente(numeroExpediente.toString());

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getEsnombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle.getEsnombreCalle());

				if (plantillaTramiteHechoDetalle.getEsnombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteHechoDetalle.getEsnombrePortal());
				}
				if (plantillaTramiteHechoDetalle.getEsnombrePiso() != null
						&& !plantillaTramiteHechoDetalle.getEsnombrePiso().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getEsnombrePiso());
				}
			} else {
				if (plantillaTramiteHechoDetalle.getEsdireccion_nocapv() != null
						&& !plantillaTramiteHechoDetalle.getEsdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteHechoDetalle.getEsdireccion_nocapv());

					if (plantillaTramiteHechoDetalle.getEsnoraPaisNombre() != null
							&& !plantillaTramiteHechoDetalle.getEsnoraPaisNombre().equals("")) {
						direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getEsnoraPaisNombre());
					}
				} else {
					direccionCompleta.append(plantillaTramiteHechoDetalle.getEsnodir());
				}
			}

			plantillaTramiteHechoDetalle.setEsdireccion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del establecimiento
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getEsnombreCp() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getEsnombreCp());

				if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getEsnombreMunicipio());
				}
			} else if (plantillaTramiteHechoDetalle.getEsnombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getEsnombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getEsnombreMunicipio());
			}

			plantillaTramiteHechoDetalle.setEscpMunicipio(cpMunicipio.toString());

			// Creamos el campo direccion del consumidor
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getDtnombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle.getDtnombreCalle());

				if (plantillaTramiteHechoDetalle.getDtnombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getDtnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteHechoDetalle.getDtnombrePortal());
				}
				if (plantillaTramiteHechoDetalle.getDtnombrePiso() != null
						&& !plantillaTramiteHechoDetalle.getDtnombrePiso().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getDtnombrePiso());
				}
			} else {
				if (plantillaTramiteHechoDetalle.getDtdireccion_nocapv() != null
						&& !plantillaTramiteHechoDetalle.getDtdireccion_nocapv().equals("")) {
					direccionCompleta.append(plantillaTramiteHechoDetalle.getDtdireccion_nocapv());

					if (plantillaTramiteHechoDetalle.getDtnoraPaisNombre() != null
							&& !plantillaTramiteHechoDetalle.getDtnoraPaisNombre().equals("")) {
						direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getDtnoraPaisNombre());
					}
				} else {
					direccionCompleta.append(plantillaTramiteHechoDetalle.getDtnodir());
				}
			}

			plantillaTramiteHechoDetalle.setDtdireccion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del consumidor
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getDtnombreCp() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getDtnombreCp());

				if (plantillaTramiteHechoDetalle.getDtnombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getDtnombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getDtnombreMunicipio());
				}
			} else if (plantillaTramiteHechoDetalle.getDtnombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getDtnombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getDtnombreMunicipio());
			}

			plantillaTramiteHechoDetalle.setDtcpMunicipio(cpMunicipio.toString());

			// Creamos el campo direccion del organismo conectado
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCalle() != null
					&& !plantillaTramiteHechoDetalle.getNombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle.getNombreCalle());

				if (plantillaTramiteHechoDetalle.getNombrePortal() != null
						&& !plantillaTramiteHechoDetalle.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteHechoDetalle.getNombrePortal());
				}
			}

			plantillaTramiteHechoDetalle.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCp() != null
					&& !plantillaTramiteHechoDetalle.getNombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreCp());

				if (plantillaTramiteHechoDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteHechoDetalle.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getNombreMunicipio());
				}
			} else if (plantillaTramiteHechoDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteHechoDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreMunicipio());
			}

			plantillaTramiteHechoDetalle.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo direccion del organismo al que se traslada
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCalleTraslado() != null
					&& !plantillaTramiteHechoDetalle.getNombreCalleTraslado().equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle.getNombreCalleTraslado());

				if (plantillaTramiteHechoDetalle.getNombrePortalTraslado() != null
						&& !plantillaTramiteHechoDetalle.getNombrePortalTraslado().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteHechoDetalle.getNombrePortalTraslado());
				}

				if (plantillaTramiteHechoDetalle.getNombrePisoTraslado() != null
						&& !plantillaTramiteHechoDetalle.getNombrePisoTraslado().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getNombrePisoTraslado());
				}

				if (plantillaTramiteHechoDetalle.getNombrePaisTraslado() != null
						&& !plantillaTramiteHechoDetalle.getNombrePaisTraslado().equals("")) {
					direccionCompleta.append(" ").append(plantillaTramiteHechoDetalle.getNombrePaisTraslado());
				}
			}

			plantillaTramiteHechoDetalle.setDireccionTraslado(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo al que
			// se traslada
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCpTraslado() != null
					&& !plantillaTramiteHechoDetalle.getNombreCpTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreCpTraslado());

				if (plantillaTramiteHechoDetalle.getNombreMunicipioTraslado() != null
						&& !plantillaTramiteHechoDetalle.getNombreMunicipioTraslado().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getNombreMunicipioTraslado());
				}
			} else if (plantillaTramiteHechoDetalle.getNombreMunicipioTraslado() != null
					&& !plantillaTramiteHechoDetalle.getNombreMunicipioTraslado().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreMunicipioTraslado());
			}

			plantillaTramiteHechoDetalle.setCpMunicipioTraslado(cpMunicipio.toString());

			// Creamos el campo direccion del organismo destino de la
			// colaboracin
			direccionCompleta = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCalleDestColaboracion() != null
					&& !plantillaTramiteHechoDetalle.getNombreCalleDestColaboracion().equals("")) {
				direccionCompleta.append(plantillaTramiteHechoDetalle.getNombreCalleDestColaboracion());

				if (plantillaTramiteHechoDetalle.getNombrePortalDestColaboracion() != null
						&& !plantillaTramiteHechoDetalle.getNombrePortalDestColaboracion().equals("")) {
					direccionCompleta.append(", ")
							.append(plantillaTramiteHechoDetalle.getNombrePortalDestColaboracion());
				}
			}

			plantillaTramiteHechoDetalle.setDireccionDestColaboracion(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo destino
			// de la colaboracin
			cpMunicipio = new StringBuffer();

			if (plantillaTramiteHechoDetalle.getNombreCpDestColaboracion() != null
					&& !plantillaTramiteHechoDetalle.getNombreCpDestColaboracion().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreCpDestColaboracion());

				if (plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion() != null
						&& !plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion());
				}
			} else if (plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion() != null
					&& !plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion().equals("")) {
				cpMunicipio.append(plantillaTramiteHechoDetalle.getNombreMunicipioDestColaboracion());
			}

			plantillaTramiteHechoDetalle.setCpMunicipioDestColaboracion(cpMunicipio.toString());

			// FIRMA
			// Director
			CensoMonitor censoMonitorDirector = new CensoMonitor();

			try {
				censoMonitorDirector = this.censoMonitorDao.findDirectorSolicitudes();
				if (censoMonitorDirector.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorDirector = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}

			plantillaTramiteHechoDetalle.setDirector(censoMonitorDirector.getMonombre());
			// recuperar texto de properties
			plantillaTramiteHechoDetalle.setTextoPuestoDirectorCas(appMessageSource
					.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
			plantillaTramiteHechoDetalle.setTextoPuestoDirectorEus(
					appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {
				Organismo organismo = new Organismo();
				organismo.setCodOrg(plantillaTramiteHechoDetalle.getCodOrg());
				censoMonitorCoordinador.setOrganismo(organismo);

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorSolicitudes(censoMonitorCoordinador);
				if (censoMonitorCoordinador.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
			}

			plantillaTramiteHechoDetalle.setCoordinador(censoMonitorCoordinador.getMonombre());

			if (censoMonitorCoordinador.getOrganismo() != null
					&& censoMonitorCoordinador.getOrganismo().getCodOrg() != null) {
				String strTerritorio = censoMonitorCoordinador.getOrganismo().getCodOrg();

				strTerritorio = strTerritorio.substring(0, 2);

				if (censoMonitorCoordinador.getOrganismo().getCodOrg()
						.equalsIgnoreCase(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					// recuperar texto de properties
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorCas(appMessageSource.getMessage(
							"plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.EUSKERA)));
				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
					// recuperar texto de properties
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					// recuperar texto de properties
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
					// recuperar texto de properties
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteHechoDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.EUSKERA)));
				}
			}

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer();

			piepagina_linea1.append(plantillaTramiteHechoDetalle.getDireccionOrganismo()).append(" - ")
					.append(plantillaTramiteHechoDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(plantillaTramiteHechoDetalle.getTelefonoOrganismo());

			plantillaTramiteHechoDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(plantillaTramiteHechoDetalle.getEmailOrganismo()).append(" / ")
					.append(plantillaTramiteHechoDetalle.getWebOrganismo());

			plantillaTramiteHechoDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

			// creamos el organismo traslado red ciac
			plantillaTramiteHechoDetalle.setCpMunicipioTraslado(plantillaTramiteHechoDetalle.getNombreCpTraslado()
					+ " - " + plantillaTramiteHechoDetalle.getNombreMunicipioTraslado());

			// 0154940: Actualizacin de datos explcitos en plantillas a uso de
			// campos combinados
			// OFICINA CENTRAL

			Organismo organismo = new Organismo();
			organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
			organismo = this.organismoDao.findOrganismo(organismo);

			if (organismo != null && organismo.getEntidadId() != null) {

				// Creamos el campo central pie pagina linea1
				StringBuffer centralpiepagina_linea1 = new StringBuffer();

				centralpiepagina_linea1.append(organismo.getNombreCalle()).append(" ")
						.append(organismo.getNombrePortal()).append(" - ").append(organismo.getNombreCp()).append(" / ")
						.append(" Tl. ").append(organismo.getTelefono());

				plantillaTramiteHechoDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

				// Creamos el campo central pie pagina linea2
				StringBuffer centralpiepagina_linea2 = new StringBuffer();

				centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
						.append(organismo.getUrl());

				plantillaTramiteHechoDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

				plantillaTramiteHechoDetalle.setCentralMail(organismo.getEmail());

				plantillaTramiteHechoDetalle.setCentralTelefono(organismo.getTelefono());
			}

			// 0154940

			return plantillaTramiteHechoDetalle;

		} catch (ParseException e) {
			throw new Y41bUDAException("error.solicitud.alta.tramite", true, e);
		}
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHecho> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		// obtener el numero de expediente del documento
		this.obtenerNumExpedienteDocumento(listDocumentoHecho);

		return listDocumentoHecho;
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoExpedientesRelacionados(TramiteComun tramiteComun,
			Pagination pagination) {

		if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
			pagination.setSort("Q5FECHA");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
			pagination.setSort("Q5TEDESFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
			pagination.setSort("Q5NOFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
			pagination.setSort("Q5ORIGEN");
		}

		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosHechoExpedientesRelacionados(tramiteComun, pagination);

		// obtener el tipo de documento
		this.obtenerTipoDocumento(listDocumentoExpediente);

		return listDocumentoExpediente;
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoExpedientesRelacionadosCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosHechoExpedientesRelacionadosCount(tramiteComun);
	}

	/**
	 * Tratamiento para obtener el tipo de documento
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 */
	private void obtenerTipoDocumento(List<DocumentoExpediente> listDocumentoExpediente) {
		if (listDocumentoExpediente != null) {
			for (DocumentoExpediente documentoExpedienteAux : listDocumentoExpediente) {
				if (documentoExpedienteAux != null && documentoExpedienteAux.getPcodigo() != null
						&& documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					TipoDocumento tipodocumento = new TipoDocumento();
					tipodocumento.setIdTipodoc(documentoExpedienteAux.getIdTipodoc());
					tipodocumento = this.tipoDocumentoDao.find(tipodocumento);

					documentoExpedienteAux.setTdnombre(tipodocumento.getTdnombre());
					documentoExpedienteAux.setTdnombree(tipodocumento.getTdnombree());

				} else if (documentoExpedienteAux != null && documentoExpedienteAux.getPcodigo() != null
						&& documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Santipdoc santipdoc = new Santipdoc();
					santipdoc.setTdid(documentoExpedienteAux.getIdTipodoc());
					santipdoc = this.santipdocDao.find(santipdoc);

					documentoExpedienteAux.setTdnombre(santipdoc.getTdnombre());
					documentoExpedienteAux.setTdnombree(santipdoc.getTdnombree());

				} else if (documentoExpedienteAux != null && documentoExpedienteAux.getPcodigo() != null
						&& documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoExpedienteAux.getIdTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);

					documentoExpedienteAux.setTdnombre(arbtipdoc.getTdnombre());
					documentoExpedienteAux.setTdnombree(arbtipdoc.getTdnombree());
				} else if (documentoExpedienteAux != null && documentoExpedienteAux.getPcodigo() != null
						&& (documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| documentoExpedienteAux.getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(documentoExpedienteAux.getIdTipodoc());
					arbtipdoc = this.arbtipdocDao.find(arbtipdoc);

					documentoExpedienteAux.setTdnombre(arbtipdoc.getTdnombre());
					documentoExpedienteAux.setTdnombree(arbtipdoc.getTdnombree());
				} else if (documentoExpedienteAux != null && documentoExpedienteAux.getPcodigo() != null
						&& documentoExpedienteAux.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					InspeccionesTipoDocumento inspeccionestipodocumento = new InspeccionesTipoDocumento();
					inspeccionestipodocumento.setIdTipodoc(documentoExpedienteAux.getIdTipodoc());

					inspeccionestipodocumento = this.inspeccionesTipoDocumentoDao.find(inspeccionestipodocumento);

					if (inspeccionestipodocumento != null) {
						documentoExpedienteAux.setTdnombre(inspeccionestipodocumento.getTdnombre());
						documentoExpedienteAux.setTdnombree(inspeccionestipodocumento.getTdnombree());
					}
				}
			}
		}
	}

	/**
	 * Tratamiento para obtener el nmero de expediente
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 */
	private void obtenerNumExpedienteDocumento(List<DocumentoHecho> listDocumentoHecho) {
		if (listDocumentoHecho != null) {
			for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
				if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle.setHdcodigo(documentoHechoAux.getQ5hdcodigo());
					solicitudDetalle = this.findNumExpedienteSolicitud(solicitudDetalle);
					documentoHechoAux.setQ5numExpediente(solicitudDetalle.getNumExpediente());
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(documentoHechoAux.getQ5hdcodigo());
					String numExp = actuacionService.findNumExpedienteInspeccion(actuacion);
					documentoHechoAux.setQ5numExpediente(numExp);

				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					Expedien expediente = new Expedien();
					expediente.setExcodigo(documentoHechoAux.getQ5hdcodigo());
					expediente = this.expedienService.find(expediente);
					documentoHechoAux.setQ5numExpediente(expediente.getCodCompletoConPrefijo());
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					Solarb solarb = new Solarb();
					solarb.setSacodigo(documentoHechoAux.getQ5hdcodigo());
					solarb = this.solarbService.find(solarb);
					documentoHechoAux.setQ5numExpediente(solarb.getCodCompletoConPrefijo());
				} else if (documentoHechoAux != null && documentoHechoAux.getQ5pcodigo() != null
						&& (documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| documentoHechoAux.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					Arbadhsol arbadhsol = new Arbadhsol();
					arbadhsol.setAdhid(documentoHechoAux.getQ5hdcodigo());
					arbadhsol = this.arbadhsolService.find(arbadhsol);
					documentoHechoAux.setQ5numExpediente(arbadhsol.getNumExpediente());
				}
			}
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosTramiteCount(tramiteComun);
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("fecha")) {
				pagination.setSort("Q5FECHA");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("origen")) {
				pagination.setSort("Q5ORIGEN");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("Q5TEDESFILE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombre")) {
				pagination.setSort("FNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombree")) {
				pagination.setSort("FNOMBREE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombre")) {
				pagination.setSort("TRNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombree")) {
				pagination.setSort("TRNOMBREE");
			}
		}

		return this.documentoHechoDao.findAllDocumentosHecho(tramiteComun, pagination);
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param ids
	 *            List<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoByIds(TramiteComun tramiteComun, List<String> ids,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("fecha")) {
				pagination.setSort("Q5FECHA");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("origen")) {
				pagination.setSort("Q5ORIGEN");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("Q5TEDESFILE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombre")) {
				pagination.setSort("FNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombree")) {
				pagination.setSort("FNOMBREE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombre")) {
				pagination.setSort("TRNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombree")) {
				pagination.setSort("TRNOMBREE");
			}
		}

		return this.documentoHechoDao.findAllDocumentosHechoByIds(tramiteComun, ids, pagination);
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosHechoCount(tramiteComun);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes findInterviniente(Intervinientes intervinientes) {
		Intervinientes intervinientesAux = this.intervinientesDao.find(intervinientes);

		StringBuffer direccionCompleta = new StringBuffer();

		if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
			direccionCompleta.append(intervinientesAux.getNombreCalle());

			if (intervinientesAux.getNombrePortal() != null && !intervinientesAux.getNombrePortal().equals("")) {
				direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
			}

			if (intervinientesAux.getNombrePiso() != null && !intervinientesAux.getNombrePiso().equals("")) {
				direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
			}

			if (intervinientesAux.getNombreMunicipio() != null && !intervinientesAux.getNombreMunicipio().equals("")) {
				direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
			}

		} else if (intervinientesAux.getDireccionNocapv() != null
				&& !intervinientesAux.getDireccionNocapv().equals("")) {
			direccionCompleta.append(intervinientesAux.getDireccionNocapv());
			if (intervinientesAux.getNombreMunicipio() != null && !intervinientesAux.getNombreMunicipio().equals("")) {
				direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
			}
			if (intervinientesAux.getNombrePais() != null && !intervinientesAux.getNombrePais().equals("")) {
				direccionCompleta.append(" ").append(intervinientesAux.getNombrePais());
			}
		}

		intervinientesAux.setDireccionCompleta(direccionCompleta.toString());

		// tiene direccion completa (como esta en el js)
		// 0193046: FAC. Direccin de notificacin completa

		boolean varTieneDireccionCompleta = true;

		if (intervinientesAux.getExtranjero() != null
				&& intervinientesAux.getExtranjero().equalsIgnoreCase(Y41bConstantes.SI)) {
			// 0204978: Error en la valiacin de datos postales al notificar a
			// direcciones de extranjeros
			if (intervinientesAux.getNombrePais() != null && !(intervinientesAux.getNombrePais().equalsIgnoreCase(""))
					&& intervinientesAux.getDireccionNocapv() != null
					&& !(intervinientesAux.getDireccionNocapv().equalsIgnoreCase(""))) {
				varTieneDireccionCompleta = true;
			} else {
				varTieneDireccionCompleta = false;
			}
		} else {
			if (intervinientesAux.getNombreProvincia() != null
					&& !(intervinientesAux.getNombreProvincia().equalsIgnoreCase(""))
					&& intervinientesAux.getNombreMunicipio() != null
					&& !(intervinientesAux.getNombreMunicipio().equalsIgnoreCase(""))
					&& intervinientesAux.getNombreCalle() != null
					&& !(intervinientesAux.getNombreCalle().equalsIgnoreCase(""))) {
				// && intervinientesAux.getNombrePortal()!=null &&
				// !(intervinientesAux.getNombrePortal().equalsIgnoreCase(""))
				varTieneDireccionCompleta = true;
				// si NO es de capv
			} else if (intervinientesAux.getDireccionNocapv() != null
					&& !(intervinientesAux.getDireccionNocapv().equalsIgnoreCase(""))) {
				varTieneDireccionCompleta = true;
			} else {
				varTieneDireccionCompleta = false;
			}
		}
		intervinientesAux.setTieneDireccionCompleta(varTieneDireccionCompleta);

		if (intervinientesAux.getCoem() == null) {
			intervinientesAux.setCoem("");
		}

		return intervinientesAux;
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("nombre")) {
				pagination.setSort("NOMBRE");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("tipoInterviniente")) {
				pagination.setSort("TIPOINTERVINIENTE");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("nif")) {
				pagination.setSort("NIF");
			}
		}

		// // Control para poder paginar por un campo calculado -
		// numeroExpediente
		// // //ASCENDENTE
		// if (pagination.getSort() != null
		// && pagination.getAscDsc().equals("asc")
		// && pagination.getSort().equals("numExpediente")) {
		// pagination.setSort("decoor, denror, denran");
		// }
		//

		//
		// if (pagination.getSort() != null
		// && pagination.getSort().equals("dtnombreMunicipio")) {
		// pagination.setSort("DTNOMBRE_MUNICIPIO");
		// }

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, pagination);

		for (Intervinientes intervinientesAux : listIntervinientes) {
			StringBuffer direccionCompleta = new StringBuffer();

			if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
				direccionCompleta.append(intervinientesAux.getNombreCalle());

				if (intervinientesAux.getNombrePortal() != null && !intervinientesAux.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
				}

				if (intervinientesAux.getNombreMunicipio() != null
						&& !intervinientesAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
				}

			} else if (intervinientesAux.getDireccionNocapv() != null
					&& !intervinientesAux.getDireccionNocapv().equals("")) {
				direccionCompleta.append(intervinientesAux.getDireccionNocapv());
				if (intervinientesAux.getNombreMunicipio() != null
						&& !intervinientesAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombreMunicipio());
				}
				if (intervinientesAux.getNombrePais() != null && !intervinientesAux.getNombrePais().equals("")) {
					direccionCompleta.append(" ").append(intervinientesAux.getNombrePais());
				}
			}

			intervinientesAux.setDireccionCompleta(direccionCompleta.toString());
		}

		return listIntervinientes;
	}

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllIntervinientesCount(Intervinientes intervinientes) {
		return this.intervinientesDao.findAllCount(intervinientes);
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Intervinientes addInterviniente(Intervinientes intervinientes) {

		Intervinientes intervinientesAux = null;
		if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_CONSUMIDOR)) {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(intervinientes.getIdinterviniente());

			// Alta de interviniente consumidor
			consumidor = this.consumidorDao.find(consumidor);

			Intervinientes intervinien = new Intervinientes();
			intervinien.setDtcodigo(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());

			try {
				intervinien = this.intervinientesDao.findIntervinienteConsumidor(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), consumidor.getDtcodigo(),
						null, null, consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(),
						null, consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
						consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
						consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
						consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
						consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
						consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
						consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
						consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
						consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
						consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
						Y41bConstantes.TIPO_INTERVINIENTESOL_CONSUMIDOR, intervinientes.getIdExpediente(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), consumidor.getDtcodigo(), null,
						null, consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
						consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
						consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
						consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
						consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
						consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
						consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
						consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
						consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
						consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
						consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
						intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_ESTABLECIMIENTO)) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(intervinientes.getIdinterviniente());

			// Alta interviniente establecimiento
			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimiento = this.tratamientoAnyadirIntervinienteDemandado(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			Intervinientes intervinien = new Intervinientes();
			intervinien.setEscodigo(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());
			intervinien.setTipoInterviniente(intervinientes.getTipoInterviniente());// J
																					// 19/12

			try {
				intervinien = this.intervinientesDao.findIntervinienteEstablecimiento(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
						establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						Y41bConstantes.TIPO_INTERVINIENTESOL_ESTABLECIMIENTO, intervinientes.getIdExpediente(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), null,
						establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_OTROS)) {
			Organismo organismo = new Organismo();
			organismo.setEntidadId(intervinientes.getIdinterviniente());

			// Alta de interviniente consumidor
			organismo = this.organismoDao.findOrganismoById(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			Intervinientes intervinien = new Intervinientes();
			intervinien.setEntidadId(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());

			try {
				intervinien = this.intervinientesDao.findIntervinienteEntidad(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
						organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
						null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
						organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(),
						organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
						organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
						organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
						organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getCompleDirec(),
						organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNombreCalle(), null, null,
						null, null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS, intervinientes.getIdExpediente(),
						null, null, null, null);

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), null, null,
						organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
						null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
						organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(),
						organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
						organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
						organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
						organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getCompleDirec(),
						organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNombreCalle(), null, null,
						null, null, null, intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						null, null, null);

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

			intervinientes.setIdinterviniente(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			if (intervinientes.getExtranjero().equalsIgnoreCase(Y41bConstantes.NO)) {
				intervinientes.setNoraPaisId(null);
				intervinientes.setNombrePais(null);

				if (intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
						|| intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
						|| intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					intervinientes.setDireccionNocapv(null);
				} else {
					intervinientes.setNombreCalle(null);
					intervinientes.setNoraCalleId(null);
					intervinientes.setNoraPortalId(null);
					intervinientes.setNombrePortal(null);
					intervinientes.setNombrePiso(null);
				}
			} else {
				intervinientes.setNoraProvinciaId(null);
				intervinientes.setNombreProvincia(null);
				intervinientes.setNoraMunicipioId(null);
				intervinientes.setNombreMunicipio(null);
				intervinientes.setNoraLocalidadId(null);
				intervinientes.setNombreLocalidad(null);
				intervinientes.setNoraCalleId(null);
				intervinientes.setNombreCalle(null);
				intervinientes.setNoraPortalId(null);
				intervinientes.setNombrePortal(null);
				intervinientes.setNombrePiso(null);
			}

			intervinientesAux = this.intervinientesDao.add(intervinientes);
		}

		return intervinientesAux;
	}

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInterviniente(Intervinientes intervinientes) {

		try {
			intervinientes = this.intervinientesDao.find(intervinientes);

			// No se puede eliminar a un denunciante/demandante ni a un
			// denunciado/demandado.
			if (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
					|| intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
				throw new Y41bUDAException("error.interviniente.DeleteException", true, new Exception());
			}

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(intervinientes.getIdExpediente());
			documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());

			Long numdocumentosAportadosInterviniente = this.documentoHechoDao
					.findAllDocumentosAportadosIntervinienteCount(documentoHecho);

			if (numdocumentosAportadosInterviniente > 0) {
				throw new Y41bUDAException("error.interviniente.DeleteAportacionException", true, new Exception());
			}

			this.intervinientesDao.remove(intervinientes);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
					.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)) {

				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
				tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

				tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
				try {
					tramiteHechoDetalle = this.tramiteHechoDao
							.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
				} catch (Exception e) {
				}

				// si est el tramite de registro de solicitud tramitado
				if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
					this.soltramexpService.actualizarParticipacionReclamante(tramiteComun);
				}

			} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
					.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)) {

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

				SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

				if (solDetalle.getHdparticipacionreclamado() != null
						&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
					this.soltramexpService.actualizarParticipacionReclamado(tramiteComun);
				}
			}

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.interviniente.DataIntegrityViolationException", true, e);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Generara Tramite de Registro Solicitud Genera Tramite Automatico de
	 * Asignacion de Instructor. Devuelve el DocumentoHecho
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteHecho tramitarAddTramiteRegistroSolicitud(SolicitudDetalle solicitudDetalle,
			HechoDenunciado hechoDenunciado) throws Exception {
		// Creacion de tramite de registro de solicitud tramitado
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramitehecho.setEhcohd(hechoDenunciado.getHdcodigo());
		tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

		// Evita problemas con las fechas desde hasta
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		tramitehecho.setEhfecha(todayWithZeroTime);

		// como calcular la hora
		String ehhora = null;

		try {
			ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
		} catch (ParseException e) {
			ehhora = null;
		}

		tramitehecho.setEhhora(ehhora);
		tramitehecho.setEhfechainicio(todayWithZeroTime);
		tramitehecho.setEhcomoasignado(solicitudDetalle.getMocodigo());
		tramitehecho.setEhcomo(solicitudDetalle.getMocodigo());
		tramitehecho.setEhtexto("");

		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteHechoService.addTramiteHecho(tramitehecho);

		//////////////////
		// si viene de asiento registral
		if (solicitudDetalle.getIdAsiento() != null) {
			// documentos - DOKUSI

			// Recuperar documentos del asiento registral
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(solicitudDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralService.findAsientoRegistral(asientoRegistral);

			AsientoRegistralDetalle asientoRegistralDetalle = new AsientoRegistralDetalle();
			asientoRegistralDetalle.setIdAsiento(solicitudDetalle.getIdAsiento());
			asientoRegistralDetalle.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
			asientoRegistralDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());
			this.asientoRegistralService.tramitarDocumentosAsientoRegistral(asientoRegistralDetalle);

			DocumentoAsientoRegistral docAsientoRegistral = new DocumentoAsientoRegistral();
			docAsientoRegistral.setAsientoRegistral(asientoRegistral);

			// Recuperar docs asociados
			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = null;

			listaDocumentoAsientoRegistral = this.documentosAsientoRegistralService
					.findAllDocumentosAR(docAsientoRegistral, null);

			for (DocumentoAsientoRegistral documentoAsientoRegistralAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAsientoRegistralAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAsientoRegistralAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);

					// insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());
					documentoHecho.setQ5nofile(docDokusi.getNombre());

					documentoHecho.setQ5tedesfile(documentoAsientoRegistralAux.getDescDoc());
					documentoHecho.setQ5idTipodoc(documentoAsientoRegistralAux.getTipoDoc());

					/* tipo y desc del doc asiento a documento hecho */
					// if (docDokusi.getDescripcion() != null) {
					// documentoHecho.setQ5tedesfile(docDokusi.getDescripcion());
					// } else {
					// documentoHecho.setQ5tedesfile(
					// docDokusi.getNombre().substring(0,
					// docDokusi.getNombre().lastIndexOf(".")));
					// }
					// documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_SOLICITUD);

					documentoHecho.setQ5iddocumentum(documentoAsientoRegistralAux.getOidDokusi());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());

					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setQ5datafile(blob);
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

					SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
							Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

					documentoHecho.setQ5fecha(dateFechaRegistro);
					documentoHecho.setQ5fechaaportacion(dateFechaRegistro);
					documentoHecho.setQ5tramite(tramitehecho.getEhcodigo());

					documentoHecho.setQ5fechaentrada(dateFechaRegistro);
					documentoHecho.setQ5numregistroentrada(asientoRegistral.getNumRegistro());
					// mensajeAportacionDoc.getRegistro().getRegistryNumber());

					this.documentoHechoDao.add(documentoHecho);

					// insertar en la tabla de relacion
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

					// retramitar - registro solicitud
					// documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_SOLICITUD);
					/* tipo y desc del doc asiento a documento */
					documento.setTipoDocumental(documentoAsientoRegistralAux.getTipoDoc());
					documento.setDescripcion(documentoAsientoRegistralAux.getDescDoc());

					y41bDokusiAdapterService.retramitarDocumentoDokusi(documento); // OID
																					// y
																					// Tipo
																					// documental

				}
			}
			// borrar docs asiento
			this.documentosAsientoRegistralService.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralService.removeAsientoRegistral(asientoRegistral);
		}
		/////////////////

		return tramitehecho;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return TramiteHechoDetalle
	 */
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet) {
		tramiteHechoDetalleKnet = this.tramiteHechoDao.findTramiteHecho(tramiteHechoDetalleKnet);

		TramiteHechoDetalleKnet tramiteHechoDetalleKnetAux = this.tramiteHechoDao
				.findLobTablaTemporal(tramiteHechoDetalleKnet);

		tramiteHechoDetalleKnet.setEhtexto(tramiteHechoDetalleKnetAux.getEhtexto());
		return tramiteHechoDetalleKnet;
	}

	/**
	 * Finds a List of rows in the HechoDenunciadoDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle, Pagination pagination) {
		return (List<Descriptor>) this.hechoDenunciadoDao.findAllHechoDenunciadoDescriptor(solicitudDetalle,
				pagination);
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados, Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {

			pagination.setSort("decoor ASC, denran ASC, LPAD(denror, 12) ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {

			pagination.setSort("decoor DESC, denran DESC, LPAD(denror,12) ");

		}

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<SolicitudBusqueda> listSolicitudesBusqueda = this.hechoDenunciadoDao
					.findAllSolicitudesRelacionar(solicitudesBusqueda, hdcodigo, relacionados, pagination);

			for (SolicitudBusqueda sol : listSolicitudesBusqueda) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(sol.getDecoor()).append("-").append(sol.getDenror()).append("-")
						.append(sol.getDenran()).append("-").append(sol.getHdnror());

				sol.setNumExpediente(numeroExpediente.toString());
			}

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados) {
		return this.hechoDenunciadoDao.findAllCountSolicitudesRelacionar(solicitudesBusqueda, hdcodigo, relacionados);
	}

	/**
	 * Finds a List of rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda,
			String hdcodigo, String relacionados, Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {

			pagination.setSort("decoor ASC, denran ASC, LPAD(denror, 12) ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {

			pagination.setSort("decoor DESC, denran DESC, LPAD(denror,12) ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<SolicitudBusqueda> listSolicitudesBusqueda = this.hechoDenunciadoDao
					.findAllSolicitudesRelacionarNuevaSancion(solicitudesBusqueda, hdcodigo, relacionados, pagination);

			for (SolicitudBusqueda sol : listSolicitudesBusqueda) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(sol.getDecoor()).append("-").append(sol.getDenror()).append("-")
						.append(sol.getDenran()).append("-").append(sol.getHdnror());

				sol.setNumExpediente(numeroExpediente.toString());
			}

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados) {
		return this.hechoDenunciadoDao.findAllCountSolicitudesRelacionarNuevaSancion(solicitudesBusqueda, hdcodigo,
				relacionados);
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudEnvios> findAllSolicitudEnvios(HechoDenunciado hechoDenunciado, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("fechaenvio")) {
				pagination.setSort("FECHAENVIO");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("fechaacuse")) {
				pagination.setSort("FECHAACUSE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("nombretramite")) {
				pagination.setSort("TIPONOTIFICACIONPLATEA");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("nombretramitee")) {
				pagination.setSort("TIPONOTIFICACIONPLATEA");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("estado")) {
				pagination.setSort("ESTADO");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("destinatario")) {
				pagination.setSort("DESTINATARIO");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("tipoenvio")) {
				pagination.setSort("TIPOENVIO");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("rmestado")) {
				pagination.setSort("ESTADOREMESA");
			}

		}
		List<SolicitudEnvios> listSolicitudEnvios = this.denunciaDao.findAllSolicitudEnvios(hechoDenunciado,
				pagination);

		if (listSolicitudEnvios != null && listSolicitudEnvios.size() > 0) {
			ListIterator iter = listSolicitudEnvios.listIterator(listSolicitudEnvios.size());

			SolicitudEnvios solicitudEnviosAux = null;

			while (iter.hasPrevious()) {
				solicitudEnviosAux = (SolicitudEnvios) iter.previous();

				// buscar los documentos del tramite
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(solicitudEnviosAux.getEhcodigo());

				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					solicitudEnviosAux.setIndVariosDocumentos(Y41bConstantes.NO);

					solicitudEnviosAux.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
					solicitudEnviosAux.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
					solicitudEnviosAux.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
					solicitudEnviosAux.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
					solicitudEnviosAux.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						solicitudEnviosAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}
			}
		}

		return listSolicitudEnvios;
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllSolicitudEnviosCount(HechoDenunciado hechoDenunciado) {
		return this.denunciaDao.findAllSolicitudEnviosCount(hechoDenunciado);
	}

	/**
	 * Finds registro entrada document
	 * 
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada() throws Exception {

		RegistroEntrada registroEntrada = new RegistroEntrada();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

		registroEntrada.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(Y41bConstantes.COD_APLICACION);
		datosPersona.setNombre(Y41bConstantes.COD_APLICACION);

		registroEntrada.setSolicitante(datosPersona);

		registroEntrada.setIdioma(Y41bConstantes.CASTELLANO);

		registroEntrada = y41bPlateaAdapterService.obtenerRegistroEntrada(registroEntrada);

		registroEntrada.setRegistryDate(Y41bUtils.parseRegistrytimestamp(registroEntrada.getRegistryTimestamp()));

		return registroEntrada;
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		// this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		// this.documentoHechoDao.addAdjuntarDocs(tramiteComun);

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());

		String plantilla = this.findPlantilla(plantillaTramite, tramiteComun);

		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		adjuntardocs.setThcodocumento(this.getNewPKDocumentoHecho().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		// buscar la solicitud
		SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
		solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		adjuntardocs.setThnofile(
				numeroExpediente.append("-").append(plantillaTramite.getPtnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		adjuntardocs.setThfecha(new Date());

		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
		}

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantillaDecision(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		// this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		// this.documentoHechoDao.addAdjuntarDocs(tramiteComun);

		// this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);
		// this.infraccHechoDenDao.addAdjuntarInfracciones(tramiteComun);

		PlantillaDecision plantillaDecision = new PlantillaDecision();
		plantillaDecision.setPdcodigo(adjuntardocs.getPdcodigo());

		String plantilla = this.findPlantillaDecision(plantillaDecision, tramiteComun);

		plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);

		adjuntardocs.setThcodocumento(this.getNewPKDocumentoHecho().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		// buscar la solicitud
		SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
		solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalleAux);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
				.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran()).append("-")
				.append(solDetalle.getHdnror());

		adjuntardocs.setThnofile(
				numeroExpediente.append("-").append(plantillaDecision.getPdnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
		adjuntardocs.setThfecha(new Date());

		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
		}

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle copiarSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor) {
		try {

			// buscar el interviniente demandado
			Intervinientes intervinientesAux = new Intervinientes();
			intervinientesAux.setIdExpediente(solicitudDetalle.getHdcodigo());
			intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

			if (listIntervinientes == null || (listIntervinientes != null && listIntervinientes.size() == 0)) {
				throw new Y41bUDAException("error.solicitud.noCompletaSolicitudCopiaException", true, new Exception());
			}

			// 1.- Buscar la solicitud
			SolicitudDetalle solDetalle = this.findSolicitud(solicitudDetalle, censoMonitor);
			solDetalle.setDecoor(censoMonitor.getOrganismo().getCodOrg());

			// 2.- Alta de la denuncia

			FormaPresentacion formaPresentacion = new FormaPresentacion();

			if (solDetalle.getTfpcodigo() != null
					&& solDetalle.getTfpcodigo().equals(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB)) {
				formaPresentacion.setTfpcodigo(Y41bConstantes.FORMA_PRESENTACION_PERSONAL);
			} else if (solDetalle.getTfpcodigo() != null
					&& solDetalle.getTfpcodigo().equals(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO)) {
				formaPresentacion.setTfpcodigo(Y41bConstantes.FORMA_PRESENTACION_PERSONAL);
			} else {
				formaPresentacion.setTfpcodigo(solDetalle.getTfpcodigo());
			}

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(solDetalle.getDtcodigo());

			Calendar now = Calendar.getInstance();
			int year = now.get(Calendar.YEAR);

			solDetalle.setDenran(year);

			Denuncia denuncia = new Denuncia(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					solDetalle.getDecoor(), solDetalle.getDenran(), solDetalle.getDenror(), solDetalle.getDefede(),
					solDetalle.getDefere(), null, null, Y41bConstantes.VALOR_NO, null, formaPresentacion, consumidor);

			Denuncia denunciaAux = this.numSolicitudDao.findNumSolicitud(denuncia);

			denuncia.setDenror(denunciaAux.getDenror());

			this.numSolicitudDao.add(denuncia);

			solDetalle.setDecodigo(denuncia.getDecodigo());

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			denuncia.setDefere(todayWithZeroTime);
			denuncia.setDefede(todayWithZeroTime);

			// Da de alta denuncia
			this.denunciaDao.addDenuncia(denuncia);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(solDetalle.getEscodigo());

			censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(solDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(solDetalle.getPscodigo());

			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setTsrcodigo(solDetalle.getTsrcodigo());

			Motivo motivo = new Motivo();
			motivo.setTircodigo(solDetalle.getTircodigo());

			HechoDenunciado hechoDenunciado = new HechoDenunciado(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), solDetalle.getHdnror(),
					solDetalle.getHdte(), null, null, solDetalle.getHdnops(), solDetalle.getHdnomaps(),
					solDetalle.getHdnomops(), solDetalle.getHdnrlops(), solDetalle.getHdcodigobarras(),
					solDetalle.getHdfedmps(), null, Y41bConstantes.SOLICITUD_MEDIACION, solDetalle.getHdcaptso(),
					solDetalle.getHdteso(), null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					solDetalle.getHdcosc(), null, null, null, null, null, null, solDetalle.getHdfehd(), null, null,
					null, null, null, null, null, null, null, Y41bConstantes.SI, solDetalle.getHdformanotificacion(),
					solDetalle.getHdformanotificacionestablecimiento(), solDetalle.getHdcodexpedienteorigen(), null,
					null, null, solDetalle.getHdinteresado(), denuncia, establecimiento, null, censoMonitor, producto,
					tipoReclamacion, motivo);

			solDetalle.setHdcodigo(hechoDenunciado.getHdcodigo());

			hechoDenunciado.setHdidioma(solDetalle.getHdidioma());
			hechoDenunciado.setHdidiomareclamado(solDetalle.getHdidiomareclamado());

			hechoDenunciado.setHdnumregistroentradaorigen(solDetalle.getHdnumregistroentradaorigen());
			hechoDenunciado.setHdfecharegistroorigen(solDetalle.getHdfecharegistroorigen());
			hechoDenunciado.setHdformaventa(solDetalle.getFvcodigo());

			hechoDenunciado.setHddenunciaaaccempresas(solDetalle.getHddenunciaaaccempresas());
			hechoDenunciado.setHdcodigobarras(solDetalle.getHdcodigobarras());
			hechoDenunciado.setHdtipodenunciante(solDetalle.getHdtipodenunciante());
			hechoDenunciado.setHdinteresado(solDetalle.getHdinteresado());

			hechoDenunciado.setHddestnotificareclamante(solDetalle.getHddestnotificareclamante());
			hechoDenunciado.setHddestnotificareclamado(solDetalle.getHddestnotificareclamado());

			// Da de alta hecho denuncia
			this.hechoDenunciadoDao.addHechoDenunciado(hechoDenunciado);

			// descriptores
			String idsDescriptores = solDetalle.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}

			solDetalle.setDescriptores(descriptores);

			this.hechoDenunciadoDao.addHechoDenunciadoDescriptor(solDetalle);

			// Dependiendo del tipo denunciante...
			Intervinientes intervinientes = null;
			if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_AACC.equals(solDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OOEE.equals(solDetalle.getHdtipodenunciante())
					|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OTRAS.equals(solDetalle.getHdtipodenunciante())) {

				// Alta interviniente organismo
				Organismo organismo = new Organismo();
				organismo.setEntidadId(solDetalle.getDtcodigo());

				organismo = this.organismoDao.findOrganismoById(organismo);

				intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						solDetalle.getDtcodigo(), null, organismo.getEntidadId(), organismo.getNombreEs(), null, null,
						null, null, organismo.getCif(), null, null, null, organismo.getUrl(), null, null,
						organismo.getTelefono(), null, organismo.getEmail(), null, organismo.getNoraProvinciaId(),
						organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
						organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
						organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
						organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getCompleDirec(),
						organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNombreCalle(), null, null,
						null, null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, solDetalle.getHdcodigo(),
						null, null, null, null);

				this.intervinientesDao.add(intervinientes);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientes);

			} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS.equals(solDetalle.getHdtipodenunciante())) {

				// Alta interviniente establecimiento
				Establecimiento establecimientoAux = new Establecimiento();
				establecimientoAux.setEscodigo(solDetalle.getDtcodigo());
				establecimientoAux = this.establecimientoDao.find(establecimientoAux);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimientoAux);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						solDetalle.getDtcodigo(), establecimientoAux.getEscodigo(), null,
						establecimientoAux.getEsnombre(), null, null, establecimientoAux.getEsnoco(), null,
						establecimientoAux.getEsnif(), null, null, establecimientoAux.getEscoidco(),
						establecimientoAux.getEsteurl(), establecimientoAux.getEsnopeco(),
						establecimientoAux.getEsfeba(), establecimientoAux.getEsnrtel(),
						establecimientoAux.getEsnrtel2(), establecimientoAux.getEscoem(),
						establecimientoAux.getEsextranjero(), establecimientoAux.getEsnoraProvinciaId(),
						establecimientoAux.getEsnombreProvincia(), establecimientoAux.getEsnoraMunicipioId(),
						establecimientoAux.getEsnombreMunicipio(), establecimientoAux.getEsnoraLocalidadId(),
						establecimientoAux.getEsnombreLocalidad(), establecimientoAux.getEsnoraCalleId(),
						establecimientoAux.getEsnombreCalle(), establecimientoAux.getEsnoraCpId(),
						establecimientoAux.getEsnombreCp(), establecimientoAux.getEsnoraPortalId(),
						establecimientoAux.getEsnombrePortal(), establecimientoAux.getEsnombrePiso(),
						establecimientoAux.getEsnoraPaisId(), establecimientoAux.getEsnoraPaisNombre(),
						establecimientoAux.getEsdireccion_nocapv(), null, establecimientoAux.getEsinadar(),
						establecSector.getSector().getSecodigo(), establecSector.getSector().getSenombre(),
						establecSector.getSector().getSenombree(), Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
						hechoDenunciado.getHdcodigo(), null, establecimientoAux.getEsfemod(),
						establecimientoAux.getCensoMonitor().getMocodigo(),
						establecimientoAux.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientes);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientes);

			} else {

				// Alta de interviniente consumidor
				consumidor = this.consumidorDao.find(consumidor);

				intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
						consumidor.getDtcodigo(), null, null, consumidor.getDtnombre(), consumidor.getDtapellido1(),
						consumidor.getDtapellido2(), null, consumidor.getDtintipid(), consumidor.getDtnif(),
						consumidor.getRangoEdad().getRancod(), consumidor.getDtcosx(), consumidor.getDtcoidco(), null,
						null, null, consumidor.getDtnrtel(), consumidor.getDtnrtel2(), consumidor.getDttecoem(),
						consumidor.getDtextranjero(), consumidor.getDtnoraProvinciaId(),
						consumidor.getDtnombreProvincia(), consumidor.getDtnoraMunicipioId(),
						consumidor.getDtnombreMunicipio(), consumidor.getDtnoraLocalidadId(),
						consumidor.getDtnombreLocalidad(), consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(),
						consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(),
						consumidor.getDtnombrePortal(), consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(),
						consumidor.getDtnoraPaisNombre(), consumidor.getDtdireccion_nocapv(), null, null, null, null,
						null, Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, hechoDenunciado.getHdcodigo(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientes);
				this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMANTE(intervinientes);
			}

			// Alta interviniente establecimiento
			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimiento = this.tratamientoAnyadirIntervinienteDemandado(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
					establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
					establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
					establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
					establecimiento.getEscoem(), establecimiento.getEsextranjero(),
					establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
					establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
					establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
					establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
					establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
					establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
					establecimiento.getEsnombrePiso(), establecimiento.getEsnombrePiso(),
					establecimiento.getEsnoraPaisId(), establecimiento.getEsdireccion_nocapv(), null,
					establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO, hechoDenunciado.getHdcodigo(), null,
					establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
					establecimiento.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.add(intervinientes);
			this.hechoDenunciadoDao.updateHDIDPARTICIPACIONRECLAMADO(intervinientes);

			// Alta interviniente administrador
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solDetalle.getDecoor());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					null, organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
					null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
					organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, intervinientes.getIdExpediente(), null, null,
					null, null);

			this.intervinientesDao.add(intervinientes);

			// Creacion de tramite de registro de solicitud pendiente de
			// tramitacion
			// Se devuelve el documentoHecho de la SOLICITUD
			this.tramitarAddTramiteRegistroSolicitud(solDetalle, hechoDenunciado);

			DecisionHecho decisionHecho = new DecisionHecho(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), solDetalle.getDecoor(), null,
					null, null, hechoDenunciado, null);

			// Da de alta una decision vacia
			this.decisionHechoDao.add(decisionHecho);

			// Actualizo la fase del expediente
			Historicofases historicoejecutadotr = new Historicofases();
			historicoejecutadotr.setHfhdcodigo(hechoDenunciado.getHdcodigo());
			historicoejecutadotr.setHffcodigo(Y41bConstantes.FASE_REGISTRO);
			historicoejecutadotr.setHffinicio(new Date());
			historicoejecutadotr.setHfffin(null);
			this.historicofasesService.add(historicoejecutadotr);

			// Actualizar ultimo tramite
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(hechoDenunciado.getHdcodigo());
			hechodenunciadoAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
			hechodenunciadoAux.setTrcodigoactual(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			hechodenunciadoAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

			this.hechoDenunciadoDao.updateUltimoTramiteConFase(hechodenunciadoAux);

			// Tratar la bandeja
			this.tratamientoBandejaSolicitudes(hechoDenunciado);

			return solDetalle;
		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41bUDAException("error.solicitud.consumidor", true, e);
			} else if (j != -1) {
				throw new Y41bUDAException("error.solicitud.establecimiento", true, e);
			}
			return null;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	public Long findAllExpedientesAbiertosCount(HechoDenunciado hechodenunciado) {
		return this.hechoDenunciadoDao.findAllExpedientesAbiertosCount(hechodenunciado);
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun, Pagination pagination) {

		List<DatosMailOrigen> listDatosMailOrigen = new ArrayList<DatosMailOrigen>();

		// Obtener el numero de expediente
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// Buscar el monitor
		CensoMonitor remitente = new CensoMonitor();
		remitente.setMocodigo(solDetalle.getMocodigo());

		remitente = this.censoMonitorDao.find(remitente);

		DatosMailOrigen datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
		datosMailOrigen.setEmail(remitente.getMocoem());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		// Buscar el organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg(solDetalle.getHccoor());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
		datosMailOrigen.setEmail(organismo.getEmail());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		return listDatosMailOrigen;
	}

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(TramiteComun tramiteComun, DatosMailOrigen datosMailOrigen) {

		SolicitudDetalle solDetalle = new SolicitudDetalle();

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(tramiteComun.getIdTramite());
		// Si es un tramite de comunicacion, relacionada con un traslado
		// obtenemos el organismo origen y el responsable del expediente
		TramiteHecho tramitehechoAux = this.tramiteHechoDao.find(tramitehecho);

		if (tramitehechoAux != null && tramitehechoAux.getTramiteHecho() != null
				&& tramitehechoAux.getTramiteHecho().getEhcodigo() != null) {
			TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
			tramiteHechoDet.setEhcodigo(tramitehechoAux.getTramiteHecho().getEhcodigo());
			TrasladoBusqueda trasladoBusqueda = this.trasladoDao.findTrasladoTramite(tramiteHechoDet);

			if (trasladoBusqueda != null && trasladoBusqueda.getIhcodigo() != null
					&& !trasladoBusqueda.getIhcodigo().equals("")) {
				solDetalle.setHccoor(trasladoBusqueda.getIhcooror());

				TramiteHechoDetalle tramiteHechoDetalleAux = new TramiteHechoDetalle();
				tramiteHechoDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
				tramiteHechoDetalleAux.setHdcodigo(solicitudDetalle.getHdcodigo());

				tramiteHechoDetalleAux = this.tramiteHechoDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalleAux);
				if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getMocodigo() != null
						&& !tramiteHechoDetalleAux.getMocodigo().equals("")) {
					solDetalle.setMocodigo(tramiteHechoDetalleAux.getMocodigo());
				} else {
					// buscar el coordinador
					// Coordinador
					CensoMonitor censoMonitorCoordinador = new CensoMonitor();
					try {
						Organismo organismo = new Organismo();
						organismo.setCodOrg(solDetalle.getHccoor());

						censoMonitorCoordinador.setOrganismo(organismo);

						censoMonitorCoordinador = this.censoMonitorDao
								.findCoordinadorSolicitudes(censoMonitorCoordinador);
					} catch (Exception e) {
						censoMonitorCoordinador = new CensoMonitor();
					}
					solDetalle.setMocodigo(censoMonitorCoordinador.getMocodigo());
				}
			} else {
				solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
			}
		} else {
			solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);
		}

		DatosMailOrigen datosMailOrigenAux = new DatosMailOrigen();

		if (Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el monitor
			CensoMonitor remitente = new CensoMonitor();
			remitente.setMocodigo(solDetalle.getMocodigo());

			remitente = this.censoMonitorDao.find(remitente);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
			datosMailOrigenAux.setEmail(remitente.getMocoem());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);
		} else if (Y41bConstantes.ID_MAIL_ORIGEN_GENERICO.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg(solDetalle.getHccoor());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
			datosMailOrigenAux.setEmail(organismo.getEmail());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);
		}

		return datosMailOrigenAux;
	}

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun,
			Intervinientes intervinientes, Pagination pagination) {

		List<DatosMailEstablecimiento> listDatosMailEstablecimiento = new ArrayList<DatosMailEstablecimiento>();

		intervinientes = this.intervinientesDao.find(intervinientes);

		DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();

		datosMailEstablecimiento.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailEstablecimiento.setEmail(intervinientes.getCoem());
		datosMailEstablecimiento.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailEstablecimiento.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailEstablecimiento.add(datosMailEstablecimiento);

		// buscar todos los mails del establecimiento
		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();
		datosMailEstablecimientoAux.setEscodigo(intervinientes.getEscodigo());

		List<DatosMailEstablecimiento> listDatosMailEstablecimientoAux = this.datosMailEstablecimientoDao
				.findAll(datosMailEstablecimientoAux, null);

		for (DatosMailEstablecimiento datosMailEstablecimientoAux2 : listDatosMailEstablecimientoAux) {
			// aadirlo a la lista
			listDatosMailEstablecimiento.add(datosMailEstablecimientoAux2);
		}

		return listDatosMailEstablecimiento;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento) {

		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailEstablecimiento.getIdDatomail())) {
			// buscar el interviniente demandado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setIdinterviniente(idDestinatario);
			// intervinientes
			// .setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes.size() > 0) {
				datosMailEstablecimientoAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
				datosMailEstablecimientoAux.setEmail(listIntervinientes.get(0).getCoem());
				datosMailEstablecimientoAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
				datosMailEstablecimientoAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

			}

		} else {
			datosMailEstablecimientoAux = this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
		}

		return datosMailEstablecimientoAux;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Intervinientes intervinientes,
			Pagination pagination) {

		List<DatosMailSede> listDatosMailSede = new ArrayList<DatosMailSede>();

		Sede sede = new Sede();
		sede.setEscodigo(intervinientes.getEscodigo());
		sede.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

		sede = this.establecimientoService.findEstablecimientoSede(sede);

		DatosMailSede datosMailSede = new DatosMailSede();

		datosMailSede.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailSede.setEmail(sede.getEmail());
		datosMailSede.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailSede.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailSede.add(datosMailSede);

		// buscar todos los mails del establecimiento
		DatosMailSede datosMailSedeAux = new DatosMailSede();
		datosMailSedeAux.setEscodigo(intervinientes.getEscodigo());
		datosMailSedeAux.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<DatosMailSede> listDatosMailSedeAux = this.datosMailSedeDao.findAll(datosMailSedeAux, null);

		for (DatosMailSede datosMailSedeAux2 : listDatosMailSedeAux) {
			// aadirlo a la lista
			listDatosMailSede.add(datosMailSedeAux2);
		}

		return listDatosMailSede;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede) {

		DatosMailSede datosMailSedeAux = new DatosMailSede();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailSede.getIdDatomail())) {

			Sede sede = new Sede();
			sede.setEscodigo(datosMailSede.getEscodigo());
			sede.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			datosMailSedeAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			datosMailSedeAux.setEmail(sede.getEmail());
			datosMailSedeAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailSedeAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailSedeAux = this.datosMailSedeDao.find(datosMailSede);
		}

		return datosMailSedeAux;
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de sancion con la
	 * informacion del hechoDenunciado recibido por parametro
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 */
	public void tratamientoBandejaPropuestaSancion(HechoDenunciado hechoDenunciado) {

		logger.info("DenunciaserviceImpl - tratamientoBandejaPropuestaSancion Ini");
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();

		// Codigo del hecho denunciado
		sanpropbandeja.setBaprsanexcodigo(hechoDenunciado.getHdcodigo());

		// Recupera el reg
		List<Sanpropbandeja> listSanpropbandeja = sanpropbandejaService.findAllLike(sanpropbandeja, null, false);

		if (listSanpropbandeja != null && listSanpropbandeja.size() > 0) {
			sanpropbandeja = listSanpropbandeja.get(0);
		} else {
			sanpropbandeja = null;
		}

		// Actualiza
		if (sanpropbandeja != null) {

			// fecha hecho
			sanpropbandeja.setBaprsanfec(hechoDenunciado.getHdfehd());

			// Datos del establecimiento sancionado Ini
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(hechoDenunciado.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());
				sanpropbandeja.setBaprsanmunic(listIntervinientes.get(0).getNoraMunicipioId());
				sanpropbandeja.setBaprsanprov(listIntervinientes.get(0).getNoraProvinciaId());
			}
			// Datos del establecimiento sancionado Fin

			// Resp. exp
			// sanpropbandeja.setBaprsanrespexp(hechoDenunciado.getCensoMonitor().getMocodigo());

			sanpropbandejaService.update(sanpropbandeja);
		}
		logger.info("DenunciaserviceImpl - tratamientoBandejaPropuestaSancion Fin");
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByNumeroExpedienteAltaArb(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor) {
		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitudByNumeroExpediente(solicitudDetalle);

		if (solDetalle != null && solDetalle.getDecodigo() == null) {
			throw new Y41bUDAException("error.solicitud.numExpedienteException", true, new Exception());
		}

		if (solDetalle != null && solDetalle.getSecodigo() == null) {
			solDetalle.setSecodigo("");
			solDetalle.setSenombre("");
			solDetalle.setSenombree("");
		}

		SolicitudDetalle solDetalleAux = this.hechoDenunciadoDao.findLobTablaTemporal(solDetalle);
		solDetalle.setHdte(solDetalleAux.getHdte());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror()).append("-")
				.append(solDetalle.getDenran()).append("-").append(solDetalle.getHdnror());

		solDetalle.setNumExpediente(numeroExpediente.toString());

		// SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new
		// SolicitudArbitrajeDetalle();
		// solicitudArbitrajeDetalle.setHdcodigo(solDetalle.getHdcodigo());
		// solicitudArbitrajeDetalle = this.solicitudArbitrajeDao
		// .findSolicitudArbitraje(solicitudArbitrajeDetalle);
		//
		// if (solicitudArbitrajeDetalle.getHdcodigo() == null
		// || solicitudArbitrajeDetalle.getHdcodigo().equals("")) {
		// solDetalle.setHdinsoma(Y41bConstantes.SOLICITUD_MEDIACION);
		// }

		if (tratamientoSeguridad(solDetalle, censoMonitor)) {
			solDetalle.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			solDetalle.setPermisoModificacion(Y41bConstantes.NO);
		}

		// descriptores
		List<Descriptor> listDescriptor = this.hechoDenunciadoDao.findAllHechoDenunciadoDescriptor(solDetalle, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		solDetalle.setIdsDescriptores(strIdsDescriptores.toString());
		solDetalle.setDescsDescriptores(strDescsDescriptores.toString());

		// Expediente antiguo
		if (solDetalle.getFcodigo() == null) {
			solDetalle.setPermisoModificacion(Y41bConstantes.NO);

			if (solDetalle.getDtcodigo() != null && solDetalle.getEscodigo() != null) {
				// if (solDetalle.getFcodigo() == null) {
				// buscar consumidor
				Consumidor consumidor = new Consumidor();
				consumidor.setDtcodigo(solDetalle.getDtcodigo());
				consumidor = this.consumidorDao.find(consumidor);

				solDetalle.setDtnombre(consumidor.getDtnombre());
				solDetalle.setDtapellido1(consumidor.getDtapellido1());
				solDetalle.setDtapellido2(consumidor.getDtapellido2());
				solDetalle.setDtnif(consumidor.getDtnif());
				solDetalle.setDttecoem(consumidor.getDttecoem());
				solDetalle.setDtnrtel(consumidor.getDtnrtel());
				solDetalle.setDtnombreProvincia(consumidor.getDtnombreProvincia());
				solDetalle.setDtnombreMunicipio(consumidor.getDtnombreMunicipio());
				solDetalle.setDtnombreLocalidad(consumidor.getDtnombreLocalidad());
				solDetalle.setDtextranjero(consumidor.getDtextranjero());
				solDetalle.setDtnoraPaisNombre(consumidor.getDtnoraPaisNombre());
				solDetalle.setDtdireccion_nocapv(consumidor.getDtdireccion_nocapv());

				// buscar establecimiento
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(solDetalle.getEscodigo());
				// Alta interviniente establecimiento
				establecimiento = this.establecimientoDao.find(establecimiento);

				solDetalle.setEsnombre(establecimiento.getEsnombre());
				solDetalle.setEsnoco(establecimiento.getEsnoco());
				solDetalle.setEsnif(establecimiento.getEsnif());
				solDetalle.setEscoem(establecimiento.getEscoem());

				solDetalle.setEsinadar(establecimiento.getEsinadar());

				solDetalle.setEsnombreProvincia(establecimiento.getEsnombreProvincia());
				solDetalle.setEsnombreMunicipio(establecimiento.getEsnombreMunicipio());
				solDetalle.setEsnombreLocalidad(establecimiento.getEsnombreLocalidad());
				solDetalle.setEsextranjero(establecimiento.getEsextranjero());
				solDetalle.setEsnoraPaisNombre(establecimiento.getEsnoraPaisNombre());
				solDetalle.setEsdireccion_nocapv(establecimiento.getEsdireccion_nocapv());

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				solDetalle.setSecodigo(establecSector.getSector().getSecodigo());
				solDetalle.setSenombre(establecSector.getSector().getSenombre());
				solDetalle.setSenombree(establecSector.getSector().getSenombree());
			}

		}

		// buscamos si la solicitud ya tiene una solicitud de arbitraje
		// relacionada.
		Sanexprel sanexprelFiltro = new Sanexprel();
		sanexprelFiltro.setRlhdcodrel(solDetalle.getHdcodigo());
		Long solicitudArbitrajeRel = this.sanexprelDao.findArbitrajeRelacionadoCount(sanexprelFiltro);
		if (solicitudArbitrajeRel.longValue() > 0) {
			solDetalle.setExisteArbRel(true);
		} else {
			solDetalle.setExisteArbRel(false);
		}

		// miramos si tiene decision y si es la correcta.

		if (solDetalle.getHcfede() != null && solDetalle.getHccottd() != null) {
			solDetalle.setExisteDecisionCorrecta(this.esTipoDecisionCorrectaAltaArb(solDetalle.getHccottd()));
		} else {
			solDetalle.setExisteDecisionCorrecta(false);
		}

		return solDetalle;
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de Arbitraje con la
	 * informacion del hechoDenunciado recibido por parametro
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 */
	public void tratamientoBandejaPropuestaArbitraje(HechoDenunciado hechoDenunciado) {

		logger.info("DenunciaserviceImpl - tratamientoBandejaPropuestaArbitraje Ini");
		Arbpropbandeja arbpropbandeja = new Arbpropbandeja();

		// Codigo del hecho denunciado
		arbpropbandeja.setBaprarbexcodigo(hechoDenunciado.getHdcodigo());

		// Recupera el reg
		List<Arbpropbandeja> listArbpropbandeja = arbpropbandejaService.findAllLike(arbpropbandeja, null, false);

		if (listArbpropbandeja != null && listArbpropbandeja.size() > 0) {
			arbpropbandeja = listArbpropbandeja.get(0);
		} else {
			arbpropbandeja = null;
		}

		// Actualiza
		if (arbpropbandeja != null) {

			// fecha hecho
			arbpropbandeja.setBaprarbfec(hechoDenunciado.getHdfehd());

			// Datos del establecimiento sancionado Ini
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(hechoDenunciado.getHdcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				arbpropbandeja.setEstablecimiento(new Establecimiento(listIntervinientes.get(0).getEscodigo()));
				arbpropbandeja.setBaprarbmunic(listIntervinientes.get(0).getNoraMunicipioId());
				arbpropbandeja.setBaprarbprov(listIntervinientes.get(0).getNoraProvinciaId());
			}

			arbpropbandejaService.update(arbpropbandeja);
		}
		logger.info("DenunciaserviceImpl - tratamientoBandejaPropuestaArbitraje Fin");
	}

	/**
	 * 
	 * @param hcdottd
	 *            String
	 * @return boolean
	 */
	private boolean esTipoDecisionCorrectaAltaArb(String hcdottd) {

		for (int i = 0; i < Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length; i++) {

			if (hcdottd.equals(Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS[i])) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarRepresentacion(Intervinientes intervinientes) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_ANTERIOR);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			// si est el tramite de registro de solicitud tramitado
			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
				this.soltramexpService.actualizarParticipacionReclamante(tramiteComun);
			}

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_ANTERIOR);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHdparticipacionreclamado() != null
					&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
				this.soltramexpService.actualizarParticipacionReclamado(tramiteComun);
			}
		}
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacion(Intervinientes intervinientes) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {

			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			tramiteHechoDetalle.setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
			try {
				tramiteHechoDetalle = this.tramiteHechoDao.findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
			} catch (Exception e) {
			}

			// si est el tramite de registro de solicitud tramitado
			if (tramiteHechoDetalle != null && tramiteHechoDetalle.getEhfechafin() != null) {
				this.soltramexpService.actualizarParticipacionReclamante(tramiteComun);
			} else {
				throw new Y41bUDAException("error.representante.validarRepresentacionException", true, new Exception());
			}

		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO_NO_VALIDADO))) {

			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());

			SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

			if (solDetalle.getHdparticipacionreclamado() != null
					&& solDetalle.getHdparticipacionreclamado().equals(Y41bConstantes.VALOR_SI)) {
				this.soltramexpService.actualizarParticipacionReclamado(tramiteComun);
			} else {
				throw new Y41bUDAException("error.representante.validarRepresentacionException", true, new Exception());
			}
		}
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllDocumentosByRegistryNumberCount(DocumentoHecho documentoHecho) {
		return this.documentoHechoDao.findAllCount(documentoHecho);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle updateSolicitudDenunciaAACC(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor)
			throws Exception {

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// Poner el campo HDDENUNCIAAACCEMPRESAS a S del expediente (HDCODIGO)
		// en la tabla L2124T00.
		// Poner el campo HDTIPODENUNCIANTE a E del expediente (HDCODIGO) en la
		// tabla L2124T00.
		// Poner el campo HDCOSC a D del expediente (HDCODIGO) en la tabla
		// L2124T00.
		this.hechoDenunciadoDao.updateDenunciaAACC(solDetalle);

		// Buscar consumidor
		Consumidor consumidor = new Consumidor();
		consumidor.setDtcodigo(solDetalle.getDtcodigo());
		consumidor = this.consumidorDao.find(consumidor);

		// Insertar el solicitante en el censo de empresas.
		Establecimiento establecimiento = new Establecimiento();

		establecimiento.setEscodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		StringBuffer sbNombreApes = new StringBuffer();
		sbNombreApes.append(consumidor.getDtnombre()).append(" ").append(consumidor.getDtapellido1()).append(" ")
				.append(consumidor.getDtapellido2());
		establecimiento.setEsnoco(sbNombreApes.toString());
		establecimiento.setEsnombre(sbNombreApes.toString());
		establecimiento.setEscolo("0");
		establecimiento.setEsnif(consumidor.getDtnif());
		establecimiento.setEsnrtel(consumidor.getDtnrtel());
		establecimiento.setEscoem(consumidor.getDttecoem());
		establecimiento.setEsextranjero(consumidor.getDtextranjero());
		establecimiento.setEsnoraProvinciaId(consumidor.getDtnoraProvinciaId());
		establecimiento.setEsnombreProvincia(consumidor.getDtnombreProvincia());
		establecimiento.setEsnoraMunicipioId(consumidor.getDtnoraMunicipioId());
		establecimiento.setEsnombreMunicipio(consumidor.getDtnombreMunicipio());
		establecimiento.setEsnoraLocalidadId(consumidor.getDtnoraLocalidadId());
		establecimiento.setEsnombreLocalidad(consumidor.getDtnombreLocalidad());
		establecimiento.setEsnoraCalleId(consumidor.getDtnoraCalleId());
		establecimiento.setEsnombreCalle(consumidor.getDtnombreCalle());
		establecimiento.setEsnoraCpId(consumidor.getDtnoraCpId());
		establecimiento.setEsnombreCp(consumidor.getDtnombreCp());
		establecimiento.setEsnoraPortalId(consumidor.getDtnoraPortalId());
		establecimiento.setEsnombrePortal(consumidor.getDtnombrePortal());
		establecimiento.setEsnombrePiso(consumidor.getDtnombrePiso());
		establecimiento.setEsnoraPaisId(consumidor.getDtnoraPaisId());
		establecimiento.setEsnoraPaisNombre(consumidor.getDtnoraPaisNombre());
		establecimiento.setEsdireccion_nocapv(consumidor.getDtdireccion_nocapv());

		this.establecimientoDao.add(establecimiento);

		// Actualizar en la tabla L2114T00, el campo DECODT (clave del censo de
		// empresas).
		Denuncia denuncia = new Denuncia();
		denuncia.setDecodigo(solDetalle.getDecodigo());

		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtcodigo(establecimiento.getEscodigo());
		denuncia.setConsumidor(consumidorAux);
		this.denunciaDao.updateConsumidor(denuncia);

		// Actualizar el intervinient

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(solDetalle.getHdcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		Establecimiento establecimientoAux = new Establecimiento();
		establecimientoAux.setEscodigo(establecimiento.getEscodigo());
		establecimientoAux = this.establecimientoDao.find(establecimientoAux);

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(establecimientoAux);

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

		if (listIntervinientes.size() > 0) {
			Intervinientes intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(), null,
					establecimientoAux.getEscodigo(), null, establecimientoAux.getEsnombre(), null, null,
					establecimientoAux.getEsnoco(), null, establecimientoAux.getEsnif(), null, null,
					establecimientoAux.getEscoidco(), establecimientoAux.getEsteurl(), establecimientoAux.getEsnopeco(),
					establecimientoAux.getEsfeba(), establecimientoAux.getEsnrtel(), establecimientoAux.getEsnrtel2(),
					establecimientoAux.getEscoem(), establecimientoAux.getEsextranjero(),
					establecimientoAux.getEsnoraProvinciaId(), establecimientoAux.getEsnombreProvincia(),
					establecimientoAux.getEsnoraMunicipioId(), establecimientoAux.getEsnombreMunicipio(),
					establecimientoAux.getEsnoraLocalidadId(), establecimientoAux.getEsnombreLocalidad(),
					establecimientoAux.getEsnoraCalleId(), establecimientoAux.getEsnombreCalle(),
					establecimientoAux.getEsnoraCpId(), establecimientoAux.getEsnombreCp(),
					establecimientoAux.getEsnoraPortalId(), establecimientoAux.getEsnombrePortal(),
					establecimientoAux.getEsnombrePiso(), establecimientoAux.getEsnoraPaisId(),
					establecimientoAux.getEsnoraPaisNombre(), establecimientoAux.getEsdireccion_nocapv(), null,
					establecimientoAux.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO, solDetalle.getHdcodigo(), null,
					establecimientoAux.getEsfemod(), establecimientoAux.getCensoMonitor().getMocodigo(),
					establecimientoAux.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.update(intervinientesAux);

		}

		SolicitudCambioInstructor solicitudCambioInstructor = new SolicitudCambioInstructor();
		solicitudCambioInstructor.setIdExpediente(solDetalle.getHdcodigo());

		solicitudCambioInstructor.setInstructorActual(censoMonitor);

		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
		solicitudCambioInstructor.setOrganismo(organismo);
		this.updateTrasladoOrganismoCambioInstructor(solicitudCambioInstructor, null, false);

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
		tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return solDetalle;
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudDetalle updateDenunciaAACCEnSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor)
			throws Exception {

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		//  Poner a null el campo HDDENUNCIAAACCEMPRESAS, HDTIPODENUNCIANTE del
		// expediente (HDCODIGO) en la tabla L2124T00.
		this.hechoDenunciadoDao.updateDenunciaAACCEnSolicitud(solDetalle);

		//  Insertar el solicitante en el censo de consumidores

		// Parte1//////////////////////////////////////////////

		Consumidor consumidor = new Consumidor();

		if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_AACC.equals(solDetalle.getHdtipodenunciante())
				|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OOEE.equals(solDetalle.getHdtipodenunciante())
				|| Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_OTRAS.equals(solDetalle.getHdtipodenunciante())) {

			// Modificacion interviniente organismo
			Organismo organismo = new Organismo();
			organismo.setEntidadId(solDetalle.getDtcodigo());
			organismo = this.organismoDao.findOrganismoById(organismo);

			// transformar organismo a consumidor
			consumidor.setDtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			if (organismo.getNombreEs() != null && organismo.getNombreEs().length() > Y41bConstantes.NUM_50) {
				consumidor.setDtnombre(
						organismo.getNombreEs().substring(Y41bConstantes.NUM_0, Y41bConstantes.NUM_50 - 1));
			} else {
				consumidor.setDtnombre(organismo.getNombreEs());
			}

			consumidor.setDtnif(organismo.getCif());
			consumidor.setDtnrtel(organismo.getTelefono());
			consumidor.setDttecoem(organismo.getEmail());
			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";
			consumidor.setDtextranjero(esExtranjero);
			consumidor.setDtnoraProvinciaId(organismo.getNoraProvinciaId());
			consumidor.setDtnombreProvincia(organismo.getNombreProvincia());
			consumidor.setDtnoraMunicipioId(organismo.getNoraMunicipioId());
			consumidor.setDtnombreMunicipio(organismo.getNombreMunicipio());
			consumidor.setDtnoraLocalidadId(organismo.getNoraLocalidadId());
			consumidor.setDtnombreLocalidad(organismo.getNombreLocalidad());
			consumidor.setDtnoraCalleId(organismo.getNoraCalleId());
			consumidor.setDtnombreCalle(organismo.getNombreCalle());
			consumidor.setDtnoraCpId(organismo.getNoraCpId());
			consumidor.setDtnombreCp(organismo.getNombreCp());
			consumidor.setDtnoraPortalId(organismo.getNoraPortalId());
			consumidor.setDtnombrePortal(organismo.getNombrePortal());
			consumidor.setDtnombrePiso(organismo.getCompleDirec());
			consumidor.setDtnoraPaisId(organismo.getNoraPaisId());
			consumidor.setDtnoraPaisNombre(organismo.getNombrePais());

			this.consumidorDao.add(consumidor);

		} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS.equals(solDetalle.getHdtipodenunciante())) {

			// Modificacion interviniente establecimiento
			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEscodigo(solDetalle.getDtcodigo());
			establecimientoAux = this.establecimientoDao.find(establecimientoAux);

			// transformar establecimiento a consumidor

			consumidor.setDtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			if (establecimientoAux.getEsnoco() != null
					&& establecimientoAux.getEsnoco().length() > Y41bConstantes.NUM_50) {
				consumidor.setDtnombre(
						establecimientoAux.getEsnoco().substring(Y41bConstantes.NUM_0, Y41bConstantes.NUM_50 - 1));
			} else {
				consumidor.setDtnombre(establecimientoAux.getEsnoco());
			}

			consumidor.setDtcolo(establecimientoAux.getEscolo());
			consumidor.setDtnif(establecimientoAux.getEsnif());
			consumidor.setDtnrtel(establecimientoAux.getEsnrtel());
			consumidor.setDttecoem(establecimientoAux.getEscoem());
			consumidor.setDtextranjero(establecimientoAux.getEsextranjero());
			consumidor.setDtnoraProvinciaId(establecimientoAux.getEsnoraProvinciaId());
			consumidor.setDtnombreProvincia(establecimientoAux.getEsnombreProvincia());
			consumidor.setDtnoraMunicipioId(establecimientoAux.getEsnoraMunicipioId());
			consumidor.setDtnombreMunicipio(establecimientoAux.getEsnombreMunicipio());
			consumidor.setDtnoraLocalidadId(establecimientoAux.getEsnoraLocalidadId());
			consumidor.setDtnombreLocalidad(establecimientoAux.getEsnombreLocalidad());
			consumidor.setDtnoraCalleId(establecimientoAux.getEsnoraCalleId());
			consumidor.setDtnombreCalle(establecimientoAux.getEsnombreCalle());
			consumidor.setDtnoraCpId(establecimientoAux.getEsnoraCpId());
			consumidor.setDtnombreCp(establecimientoAux.getEsnombreCp());
			consumidor.setDtnoraPortalId(establecimientoAux.getEsnoraPortalId());
			consumidor.setDtnombrePortal(establecimientoAux.getEsnombrePortal());
			consumidor.setDtnombrePiso(establecimientoAux.getEsnombrePiso());
			consumidor.setDtnoraPaisId(establecimientoAux.getEsnoraPaisId());
			consumidor.setDtnoraPaisNombre(establecimientoAux.getEsnoraPaisNombre());
			consumidor.setDtdireccion_nocapv(establecimientoAux.getEsdireccion_nocapv());

			this.consumidorDao.add(consumidor);
		}

		// Fin Parte1 ////////////////////////////////////////////////

		// Actualizar en la tabla L2114T00, el campo DECODT (clave del censo de
		// empresas).
		Denuncia denuncia = new Denuncia();
		denuncia.setDecodigo(solDetalle.getDecodigo());

		Consumidor consumidorAux = new Consumidor();
		consumidorAux.setDtcodigo(consumidor.getDtcodigo());
		denuncia.setConsumidor(consumidorAux);
		this.denunciaDao.updateConsumidor(denuncia);

		// Actualizar el intervinient

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(solDetalle.getHdcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		// Modificacion de interviniente consumidor
		consumidor = this.consumidorDao.find(consumidor);

		if (listIntervinientes.size() > 0) {
			Intervinientes intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(),
					consumidor.getDtcodigo(), null, null, consumidor.getDtnombre(), consumidor.getDtapellido1(),
					consumidor.getDtapellido2(), null, consumidor.getDtintipid(), consumidor.getDtnif(),
					consumidor.getRangoEdad().getRancod(), consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null,
					null, consumidor.getDtnrtel(), consumidor.getDtnrtel2(), consumidor.getDttecoem(),
					consumidor.getDtextranjero(), consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
					consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
					consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(), consumidor.getDtnoraCalleId(),
					consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(),
					consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(), consumidor.getDtnombrePiso(),
					consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(), consumidor.getDtdireccion_nocapv(),
					null, null, null, null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO,
					solDetalle.getHdcodigo(), null, consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
					consumidor.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.update(intervinientesAux);
		}

		SolicitudCambioInstructor solicitudCambioInstructor = new SolicitudCambioInstructor();
		solicitudCambioInstructor.setIdExpediente(solDetalle.getHdcodigo());

		solicitudCambioInstructor.setInstructorActual(censoMonitor);

		Organismo organismo = new Organismo();
		// organismo.setCodOrg(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);

		// Oficina encargada dependiendo del origen del reclamante.
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String idProvincia = consumidor.getDtnoraProvinciaId();
		String esExtranjero = consumidor.getDtextranjero();

		if (esExtranjero.equals(Y41bConstantes.NO)) {
			if (Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(idProvincia)) {
				organismo.setCodOrg(prop.getProperty("oficina.territorio.bizkaia"));
			} else if (Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(idProvincia)) {
				organismo.setCodOrg(prop.getProperty("oficina.territorio.gipuzkoa"));
			} else if (Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(idProvincia)) {
				organismo.setCodOrg(prop.getProperty("oficina.territorio.araba"));
			} else {
				organismo.setCodOrg(prop.getProperty("oficina.territorio.fueracapv"));
			}
		} else if (Y41bConstantes.SI.equals(esExtranjero)) {
			organismo.setCodOrg(prop.getProperty("oficina.territorio.extranjero"));
		}

		solicitudCambioInstructor.setOrganismo(organismo);
		this.updateTrasladoOrganismoCambioInstructor(solicitudCambioInstructor, null, false);

		// Tratar la bandeja
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(solicitudCambioInstructor.getIdExpediente());
		tratamientoBandejaSolicitudes(hechodenunciadoAux);

		return solDetalle;
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void actualizarDocumentosLocalizados(SolicitudDetalle solicitudDetalle) throws Exception {

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5hdcodigo(solicitudDetalle.getHdcodigo());

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		DocumentoHecho documentoHechoLocalizado = new DocumentoHecho();
		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {

			if (documentoHechoAux != null && documentoHechoAux.getQ5fechasollocalizador() != null
					&& documentoHechoAux.getQ5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
							.getExtensionFile(documentoHechoAux.getQ5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {
				documentoHechoLocalizado = new DocumentoHecho();
				documentoHechoLocalizado.setQ5iddocumentum(documentoHechoAux.getQ5iddocumentum());
				this.tratamientoDokusiJMS.actualizarDocumentoLocalizadorBBDD(documentoHechoLocalizado);
			}
		}
	}

}
