package com.ejie.y41b.service;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.rowset.serial.SerialException;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DecisionHechoDetalle;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteHechoDetalle;
import com.ejie.y41b.model.SolicitudArbitrajeDetalle;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.SolicitudEnvios;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.ContextSubmission;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.RegistroEntrada;

/**
 * * DenunciaService  
 * 
 *  
 */

public interface DenunciaService {

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia add(Denuncia denuncia);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle addSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param solicitudID
	 *            String
	 * @param listDocumento
	 *            List<Documento>
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	public SolicitudDetalle enviarSolicitudTelematica(SolicitudDetalle solicitudDetalle,
			ContextSubmission contextSubmission, String solicitudID, List<Documento> listDocumento) throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia update(Denuncia denuncia);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle updateSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	public SolicitudDetalle updateSolicitudDenunciaAACC(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	public SolicitudDetalle updateDenunciaAACCEnSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia find(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findNumExpedienteSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByRegistryNumber(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor);

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return ConsumidorDetalle
	 */
	public ConsumidorDetalle findIntervinienteConsumidor(Intervinientes intervinientes);

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimiento(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByNumeroExpediente(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Denuncia> findAll(Denuncia denuncia, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	Long findAllCount(Denuncia denuncia);

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudes(SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return DecisionHechoDetalle
	 */
	DecisionHechoDetalle findDecisionHecho(DecisionHechoDetalle decisionHechoDetalle);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public DocumentoHechoDetalle findDocumentoHecho(DocumentoHechoDetalle documentoHechoDetalle)
			throws SerialException, SQLException, Exception;

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return DocumentoHechoDetalle
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public DocumentoHechoDetalle findDocumentoHechoSinDocumento(DocumentoHechoDetalle documentoHechoDetalle)
			throws SerialException, SQLException, Exception;

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudArbitrajeDetalle
	 *            SolicitudArbitrajeDetalle
	 * @return SolicitudArbitrajeDetalle
	 */
	SolicitudArbitrajeDetalle findSolicitudArbitraje(SolicitudArbitrajeDetalle solicitudArbitrajeDetalle);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return
	 */
	void remove(Denuncia denuncia);

	/**
	 * Deletes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */

	void removeSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes multiple rows in the Denuncia table.
	 * 
	 * @param denunciaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Denuncia> denunciaList);

	/**
	 * Get a New PK DocumentoHecho.
	 * 
	 * @return Long
	 */
	public Long getNewPKDocumentoHecho();

	/**
	 * Tratamiento para gestionar la bandeja de solicitudes.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 */
	public void tratamientoBandejaSolicitudes(HechoDenunciado hechodenunciado);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantilla(PlantillaTramite plantillaTramite, TramiteComun tramiteComun) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantillaDecision(PlantillaDecision plantillaDecision, TramiteComun tramiteComun)
			throws Exception;

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoDetalle> findAllTramiteHecho(TramiteHechoDetalle tramiteHechoDetalle,
			Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Long
	 */
	public Long findAllTramiteHechoCount(TramiteHechoDetalle tramiteHechoDetalle);

	/**
	 * Finds registro entrada document
	 * 
	 * @param dni
	 *            String
	 * @param nombre
	 *            String
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntradaAlta(String dni, String nombre) throws Exception;

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoHecho> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param ids
	 *            List<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoByIds(TramiteComun tramiteComun, List<String> ids,
			Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoCount(TramiteComun tramiteComun);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes findInterviniente(Intervinientes intervinientes);

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes, Pagination pagination);

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	public Long findAllIntervinientesCount(Intervinientes intervinientes);

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes addInterviniente(Intervinientes intervinientes);

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	public void removeInterviniente(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TtramiteHechoDetalleKnet
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet);

	/**
	 * Finds a List of rows in the HechoDenunciadoDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle, Pagination pagination);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados, Pagination pagination);

	/**
	 * Finds a List of rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda,
			String hdcodigo, String relacionados, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados);

	/**
	 * Counts rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados);

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudEnvios> findAllSolicitudEnvios(HechoDenunciado hechoDenunciado, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param HechoDenunciado
	 *            hechoDenunciado
	 * @return Long
	 */
	public Long findAllSolicitudEnviosCount(HechoDenunciado hechoDenunciado);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	public void generarTramiteAportacionDocumentacion(SolicitudDetalle solicitudDetalle,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception;

	/**
	 * Finds registro entrada document
	 * 
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada() throws Exception;

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception;

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void addPlantillaDecision(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception;

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle copiarSolicitud(SolicitudDetalle solicitudDetalle, CensoMonitor censoMonitor);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	public Long findAllExpedientesAbiertosCount(HechoDenunciado hechodenunciado);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(TramiteComun tramiteComun, DatosMailOrigen datosMailOrigen);

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun,
			Intervinientes intervinientes, Pagination pagination);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento);

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede);

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesAportaciondocumentacion(TramiteHecho tramitehecho,
			List<DocumentoHecho> listDocumentoHecho) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByNumeroExpedienteAltaArb(SolicitudDetalle solicitudDetalle,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * 
	 * @return Denuncia
	 */
	public Denuncia findDenunciaPropARB(Denuncia denuncia);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoExpedientesRelacionados(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoExpedientesRelacionadosCount(TramiteComun tramiteComun);

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	public void eliminarRepresentacion(Intervinientes intervinientes) throws Exception;

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	public void validarRepresentacion(Intervinientes intervinientes) throws Exception;

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return Long
	 */
	public Long findAllDocumentosByRegistryNumberCount(DocumentoHecho documentoHecho);

	/**
	 * Finds PlantillaTramiteHechoDetalle.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public PlantillaTramiteHechoDetalle findPlantillaTramiteHechoDetalle(TramiteComun tramiteComun) throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarDocumentosLocalizados(SolicitudDetalle solicitudDetalle) throws Exception;

	/**
	 * Complete information of the object PlantillaTramiteHechoDetalle.
	 * 
	 * @param plantillaTramiteHechoDetalle
	 *            PlantillaTramiteHechoDetalle
	 * @return PlantillaTramiteHechoDetalle
	 */
	public PlantillaTramiteHechoDetalle completeInfoPlantillaTramiteHechoDetalle(
			PlantillaTramiteHechoDetalle plantillaTramiteHechoDetalle);

}
