package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.model.Decision;

/**
 * * DecisionServiceImpl  
 * 
 *  
 */

@Service(value = "decisionService")
public class DecisionServiceImpl implements DecisionService {

	private static final Logger logger = LoggerFactory.getLogger(DecisionServiceImpl.class);
	@Autowired
	private DecisionDao decisionDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision add(Decision decision) {
		return this.decisionDao.add(decision);
	}

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision addDecision(Decision decision) {
		decision.setDecodigo(this.decisionDao.getNewPK().toString());
		this.decisionDao.add(decision);

		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision update(Decision decision) {
		return this.decisionDao.update(decision);
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Decision updateFecha(Decision decision) {
		return this.decisionDao.updateFecha(decision);
	}

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	public Decision find(Decision decision) {
		return (Decision) this.decisionDao.find(decision);
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAll(Decision decision, Pagination pagination) {
		return (List<Decision>) this.decisionDao.findAll(decision, pagination);
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllDecisionBusquedaSolicitud(Decision decision, Pagination pagination) {
		List<Decision> listDecision = (List<Decision>) this.decisionDao.findAllDecisionBusquedaSolicitud(decision,
				pagination);
		Decision decisionAux = new Decision();
		for (int i = 0; i < listDecision.size(); i++) {
			decisionAux = listDecision.get(i);
			if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(decisionAux.getDecodigo())) {
				listDecision.remove(i);
				break;
			}
		}

		return listDecision;
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivos(Decision decision, Pagination pagination) {
		return (List<Decision>) this.decisionDao.findAllActivos(decision, pagination);
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosNoTraslado(Decision decision, Pagination pagination) {
		List<Decision> listaDecisiones = this.decisionDao.findAllActivos(decision, pagination);
		Decision decisionAux = new Decision();
		for (int i = 0; i < listaDecisiones.size(); i++) {
			decisionAux = listaDecisiones.get(i);
			if (Y41bConstantes.DECISION_INSPECCIONES_TRASLADO.equals(decisionAux.getDecodigo())) {
				listaDecisiones.remove(i);
				break;
			}
		}

		for (int i = 0; i < listaDecisiones.size(); i++) {
			decisionAux = listaDecisiones.get(i);
			if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(decisionAux.getDecodigo())) {
				listaDecisiones.remove(i);
				break;
			}
		}

		return listaDecisiones;
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosNoAIP(Decision decision, Pagination pagination) {
		List<Decision> listaDecisiones = this.decisionDao.findAllActivos(decision, pagination);
		Decision decisionAux = new Decision();
		for (int i = 0; i < listaDecisiones.size(); i++) {
			decisionAux = listaDecisiones.get(i);
			if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(decisionAux.getDecodigo())) {
				listaDecisiones.remove(i);
				break;
			}
		}
		return listaDecisiones;
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosArchivoAIP(Decision decision, Pagination pagination) {
		List<Decision> listaDecisiones = this.decisionDao.findAllActivos(decision, pagination);
		List<Decision> listaDecisionesAIP = new ArrayList<Decision>();
		Decision decisionAux = new Decision();
		for (int i = 0; i < listaDecisiones.size(); i++) {
			decisionAux = listaDecisiones.get(i);
			if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(decisionAux.getDecodigo())) {
				listaDecisionesAIP.add(decisionAux);
			}
		}
		return listaDecisionesAIP;
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosNoLaudo(Decision decision, Pagination pagination) {
		List<Decision> listaDecisiones = (List<Decision>) this.decisionDao.findAllActivosNoLaudo(decision, pagination);
		Decision decisionAux = new Decision();
		for (int i = 0; i < listaDecisiones.size(); i++) {
			decisionAux = listaDecisiones.get(i);
			if (Y41bConstantes.DECISION_ARBITRAJE_LAUDO.equals(decisionAux.getDecodigo())) {
				listaDecisiones.remove(i);
				break;
			}
		}
		return listaDecisiones;

	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	public Long findAllCount(Decision decision) {
		return this.decisionDao.findAllCount(decision);
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Decision> findAllLike(Decision decision, Pagination pagination, Boolean startsWith) {
		return (List<Decision>) this.decisionDao.findAllLike(decision, pagination, startsWith);
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Decision> findAllLikeDecision(Decision decision, Pagination pagination, Boolean startsWith) {
		List<Decision> listDecision = (List<Decision>) this.decisionDao.findAllLikeDecision(decision, pagination,
				startsWith);
		for (Decision decisionAux : listDecision) {
			if (decisionAux != null && decisionAux.getDetiposolicitud() != null) {
				if (decisionAux.getDetiposolicitud().equals(Y41bConstantes.TIPO_SOLICITUD_DENUNCIA)) {
					decisionAux.setPnombre(new StringBuffer(decisionAux.getPnombre()).append(" (").append(
							appMessageSource.getMessage("comun.denuncia", null, new Locale(Y41bConstantes.CASTELLANO)))
							.append(")").toString());
					decisionAux.setPnombree(new StringBuffer(decisionAux.getPnombre()).append(" (").append(
							appMessageSource.getMessage("comun.denuncia", null, new Locale(Y41bConstantes.EUSKERA)))
							.append(")").toString());
				} else if (decisionAux.getDetiposolicitud().equals(Y41bConstantes.TIPO_SOLICITUD_QUEJA)) {
					decisionAux.setPnombre(new StringBuffer(decisionAux.getPnombre()).append(" (").append(
							appMessageSource.getMessage("comun.queja", null, new Locale(Y41bConstantes.CASTELLANO)))
							.append(")").toString());
					decisionAux.setPnombree(new StringBuffer(decisionAux.getPnombre()).append(" (").append(
							appMessageSource.getMessage("comun.queja", null, new Locale(Y41bConstantes.EUSKERA)))
							.append(")").toString());
				} else if (decisionAux.getDetiposolicitud().equals(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION)) {
					decisionAux.setPnombre(new StringBuffer(decisionAux.getPnombre()).append(" (")
							.append(appMessageSource.getMessage("comun.reclamacion", null,
									new Locale(Y41bConstantes.CASTELLANO)))
							.append(")").toString());
					decisionAux.setPnombree(new StringBuffer(decisionAux.getPnombre()).append(" (").append(
							appMessageSource.getMessage("comun.reclamacion", null, new Locale(Y41bConstantes.EUSKERA)))
							.append(")").toString());
				}
			}
		}
		return listDecision;
	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDecisionCount(Decision decision, Boolean startsWith) {
		return this.decisionDao.findAllLikeDecisionCount(decision, startsWith);
	}

	/**
	 * Deletes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Decision decision) {
		this.decisionDao.remove(decision);
	}

	/**
	 * Deletes multiple rows in the Decision table.
	 * 
	 * @param decisionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Decision> decisionList) {
		for (Decision decisionAux : decisionList) {
			this.decisionDao.remove(decisionAux);
		}
	}

	/**
	 * Getter method for DecisionDao
	 * 
	 * @return DecisionDao
	 */
	public DecisionDao getDecisionDao() {
		return this.decisionDao;
	}

	/**
	 * Setter method for DecisionDao.
	 * 
	 * @param decisionDao
	 *            DecisionDao
	 * @return
	 */
	public void setDecisionDao(DecisionDao decisionDao) {
		logger.info("Setting Dependency " + decisionDao);
		this.decisionDao = decisionDao;
	}
}
