package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Decision;

/**
 * * DecisionService  
 * 
 *  
 */

public interface DecisionService {

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision add(Decision decision);

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision addDecision(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision update(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision updateFecha(Decision decision);

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision find(Decision decision);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAll(Decision decision, Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllDecisionBusquedaSolicitud(Decision decision,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAllActivos(Decision decision, Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosNoTraslado(Decision decision,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosNoAIP(Decision decision,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Decision> findAllActivosArchivoAIP(Decision decision, Pagination pagination);

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Decision> findAllActivosNoLaudo(Decision decision, Pagination pagination);

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	Long findAllCount(Decision decision);

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Decision> findAllLike(Decision decision, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Decision> findAllLikeDecision(Decision decision,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDecisionCount(Decision decision, Boolean startsWith);

	/**
	 * Deletes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return
	 */
	void remove(Decision decision);

	/**
	 * Deletes multiple rows in the Decision table.
	 * 
	 * @param decisionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Decision> decisionList);

}
