package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DecisionL21Dao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DecisionL21;

/**
 * DecisionL21ServiceImpl  
 *  
 */

@Service(value = "decisionL21Service")
public class DecisionL21ServiceImpl implements DecisionL21Service {

	@Autowired
	private DecisionL21Dao decisionL21Dao;

	/**
	 * Inserts a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DecisionL21 add(DecisionL21 decisionL21) {
		return this.decisionL21Dao.add(decisionL21);
	}

	/**
	 * Updates a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DecisionL21 update(DecisionL21 decisionL21) {
		return this.decisionL21Dao.update(decisionL21);
	 }

	/**
	 * Finds a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
	public DecisionL21 find(DecisionL21 decisionL21) {
		return (DecisionL21) this.decisionL21Dao.find(decisionL21);
	}

	/**
	 * Finds a List of rows in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @param pagination Pagination
	 * @return List
	 */
	public List<DecisionL21> findAll(DecisionL21 decisionL21, Pagination pagination) {
		return (List<DecisionL21>) this.decisionL21Dao.findAll(decisionL21, pagination);
	}
    
	/**
	 * Counts rows in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return Long
	 */
	public Long findAllCount(DecisionL21 decisionL21) {        
		return  this.decisionL21Dao.findAllCount(decisionL21);
	}

	/**
	 * Finds rows in the DecisionL21 table using like.
	 *
	 * @param decisionL21 DecisionL21
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<DecisionL21> findAllLike(DecisionL21 decisionL21, Pagination pagination, Boolean startsWith) {
		return (List<DecisionL21>) this.decisionL21Dao.findAllLike(decisionL21, pagination, startsWith);
	}

	/**
	 * Counts rows in the DecisionL21 table using like.
	 *
	 * @param decisionL21 DecisionL21
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DecisionL21 decisionL21, Boolean startsWith) {
		return this.decisionL21Dao.findAllLikeCount(decisionL21, startsWith);
	}
	    
	/**
	 * Deletes a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DecisionL21 decisionL21) {
		this.decisionL21Dao.remove(decisionL21);
	}
	
	/**
	 * Deletes multiple rows in the DecisionL21 table.
	 *
	 * @param decisionL21List List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<DecisionL21> decisionL21List) {
		for (DecisionL21  decisionL21Aux:decisionL21List) {
			this.decisionL21Dao.remove(decisionL21Aux);
		}
	}
	
}

