package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DecisionL21;

/**
 * DecisionL21Service  
 *  
 */

public interface DecisionL21Service {

	/**
	 * Inserts a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
    DecisionL21 add(DecisionL21 decisionL21);

	/**
	 * Updates a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
	DecisionL21 update(DecisionL21 decisionL21);

	/**
	 * Finds a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return DecisionL21
	 */
	DecisionL21 find(DecisionL21 decisionL21);

	/**
	 * Finds a List of rows in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @param pagination Pagination
	 * @return List
	 */
	List<DecisionL21> findAll(DecisionL21 decisionL21, Pagination pagination);

	/**
	 * Counts rows in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return Long
	 */
	Long findAllCount(DecisionL21 decisionL21);
	
	/**
	 * Finds rows in the DecisionL21 table using like.
	 *
	 * @param decisionL21 DecisionL21
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<DecisionL21> findAllLike(DecisionL21 decisionL21, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the DecisionL21 table using like.
	 *
	 * @param decisionL21 DecisionL21
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(DecisionL21 decisionL21, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the DecisionL21 table.
	 *
	 * @param decisionL21 DecisionL21
	 * @return 
	 */
	void remove(DecisionL21 decisionL21);
	
	/**
	 * Deletes multiple rows in the DecisionL21 table.
	 *
	 * @param decisionL21List List
	 * @return 
	 */	
	void removeMultiple(List<DecisionL21> decisionL21List);
    
}


