package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DatosMailSedeDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DatosMailSede;

/**
 * DatosMailSedeServiceImpl  
 *  
 */

@Service(value = "datosMailSedeService")
public class DatosMailSedeServiceImpl implements DatosMailSedeService {

	@Autowired
	private DatosMailSedeDao datosMailSedeDao;

	/**
	 * Inserts a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosMailSede add(DatosMailSede datosMailSede) {
		return this.datosMailSedeDao.add(datosMailSede);
	}

	/**
	 * Updates a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosMailSede update(DatosMailSede datosMailSede) {
		return this.datosMailSedeDao.update(datosMailSede);
	 }

	/**
	 * Finds a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede find(DatosMailSede datosMailSede) {
		return (DatosMailSede) this.datosMailSedeDao.find(datosMailSede);
	}

	/**
	 * Finds a List of rows in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @param pagination Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAll(DatosMailSede datosMailSede, Pagination pagination) {
		return (List<DatosMailSede>) this.datosMailSedeDao.findAll(datosMailSede, pagination);
	}
    
	/**
	 * Counts rows in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return Long
	 */
	public Long findAllCount(DatosMailSede datosMailSede) {        
		return  this.datosMailSedeDao.findAllCount(datosMailSede);
	}

	/**
	 * Finds rows in the DatosMailSede table using like.
	 *
	 * @param datosMailSede DatosMailSede
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<DatosMailSede> findAllLike(DatosMailSede datosMailSede, Pagination pagination, Boolean startsWith) {
		return (List<DatosMailSede>) this.datosMailSedeDao.findAllLike(datosMailSede, pagination, startsWith);
	}

	/**
	 * Counts rows in the DatosMailSede table using like.
	 *
	 * @param datosMailSede DatosMailSede
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DatosMailSede datosMailSede, Boolean startsWith) {
		return this.datosMailSedeDao.findAllLikeCount(datosMailSede, startsWith);
	}
	    
	/**
	 * Deletes a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosMailSede datosMailSede) {
		this.datosMailSedeDao.remove(datosMailSede);
	}
	
	/**
	 * Deletes multiple rows in the DatosMailSede table.
	 *
	 * @param datosMailSedeList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<DatosMailSede> datosMailSedeList) {
		for (DatosMailSede  datosMailSedeAux:datosMailSedeList) {
			this.datosMailSedeDao.remove(datosMailSedeAux);
		}
	}
	
}

