package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.DatosMailSede;

/**
 * DatosMailSedeService  
 *  
 */

public interface DatosMailSedeService {

	/**
	 * Inserts a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
    DatosMailSede add(DatosMailSede datosMailSede);

	/**
	 * Updates a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede update(DatosMailSede datosMailSede);

	/**
	 * Finds a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede find(DatosMailSede datosMailSede);

	/**
	 * Finds a List of rows in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @param pagination Pagination
	 * @return List
	 */
	List<DatosMailSede> findAll(DatosMailSede datosMailSede, Pagination pagination);

	/**
	 * Counts rows in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return Long
	 */
	Long findAllCount(DatosMailSede datosMailSede);
	
	/**
	 * Finds rows in the DatosMailSede table using like.
	 *
	 * @param datosMailSede DatosMailSede
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<DatosMailSede> findAllLike(DatosMailSede datosMailSede, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the DatosMailSede table using like.
	 *
	 * @param datosMailSede DatosMailSede
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(DatosMailSede datosMailSede, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the DatosMailSede table.
	 *
	 * @param datosMailSede DatosMailSede
	 * @return 
	 */
	void remove(DatosMailSede datosMailSede);
	
	/**
	 * Deletes multiple rows in the DatosMailSede table.
	 *
	 * @param datosMailSedeList List
	 * @return 
	 */	
	void removeMultiple(List<DatosMailSede> datosMailSedeList);
    
}


