package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DatosMailEstablecimiento;

/**
 * DatosMailEstablecimientoServiceImpl  
 *  
 */

@Service(value = "datosMailEstablecimientoService")
public class DatosMailEstablecimientoServiceImpl implements DatosMailEstablecimientoService {

	@Autowired
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;

	/**
	 * Inserts a single row in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosMailEstablecimiento add(DatosMailEstablecimiento datosMailEstablecimiento) {
		return this.datosMailEstablecimientoDao.add(datosMailEstablecimiento);
	}

	/**
	 * Updates a single row in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosMailEstablecimiento update(DatosMailEstablecimiento datosMailEstablecimiento) {
		return this.datosMailEstablecimientoDao.update(datosMailEstablecimiento);
	 }

	/**
	 * Finds a single row in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento find(DatosMailEstablecimiento datosMailEstablecimiento) {
		return (DatosMailEstablecimiento) this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
	}

	/**
	 * Finds a List of rows in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @param pagination Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAll(DatosMailEstablecimiento datosMailEstablecimiento, Pagination pagination) {
		return (List<DatosMailEstablecimiento>) this.datosMailEstablecimientoDao.findAll(datosMailEstablecimiento, pagination);
	}
    
	/**
	 * Counts rows in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @return Long
	 */
	public Long findAllCount(DatosMailEstablecimiento datosMailEstablecimiento) {        
		return  this.datosMailEstablecimientoDao.findAllCount(datosMailEstablecimiento);
	}

	/**
	 * Finds rows in the DatosMailEstablecimiento table using like.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllLike(DatosMailEstablecimiento datosMailEstablecimiento, Pagination pagination, Boolean startsWith) {
		return (List<DatosMailEstablecimiento>) this.datosMailEstablecimientoDao.findAllLike(datosMailEstablecimiento, pagination, startsWith);
	}

	/**
	 * Counts rows in the DatosMailEstablecimiento table using like.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(DatosMailEstablecimiento datosMailEstablecimiento, Boolean startsWith) {
		return this.datosMailEstablecimientoDao.findAllLikeCount(datosMailEstablecimiento, startsWith);
	}
	    
	/**
	 * Deletes a single row in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimiento DatosMailEstablecimiento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosMailEstablecimiento datosMailEstablecimiento) {
		this.datosMailEstablecimientoDao.remove(datosMailEstablecimiento);
	}
	
	/**
	 * Deletes multiple rows in the DatosMailEstablecimiento table.
	 *
	 * @param datosMailEstablecimientoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<DatosMailEstablecimiento> datosMailEstablecimientoList) {
		for (DatosMailEstablecimiento  datosMailEstablecimientoAux:datosMailEstablecimientoList) {
			this.datosMailEstablecimientoDao.remove(datosMailEstablecimientoAux);
		}
	}
	
}

