package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.CorrespondenciaDecisionL21Dao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.CorrespondenciaDecisionL21;

/**
 * CorrespondenciaDecisionL21ServiceImpl  
 *  
 */

@Service(value = "correspondenciaDecisionL21Service")
public class CorrespondenciaDecisionL21ServiceImpl implements CorrespondenciaDecisionL21Service {

	@Autowired
	private CorrespondenciaDecisionL21Dao correspondenciaDecisionL21Dao;

	/**
	 * Inserts a single row in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @return CorrespondenciaDecisionL21
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CorrespondenciaDecisionL21 add(CorrespondenciaDecisionL21 correspondenciaDecisionL21) {
		return this.correspondenciaDecisionL21Dao.add(correspondenciaDecisionL21);
	}

	/**
	 * Updates a single row in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @return CorrespondenciaDecisionL21
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CorrespondenciaDecisionL21 update(CorrespondenciaDecisionL21 correspondenciaDecisionL21) {
		return this.correspondenciaDecisionL21Dao.update(correspondenciaDecisionL21);
	 }

	/**
	 * Finds a single row in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @return CorrespondenciaDecisionL21
	 */
	public CorrespondenciaDecisionL21 find(CorrespondenciaDecisionL21 correspondenciaDecisionL21) {
		return (CorrespondenciaDecisionL21) this.correspondenciaDecisionL21Dao.find(correspondenciaDecisionL21);
	}

	/**
	 * Finds a List of rows in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @param pagination Pagination
	 * @return List
	 */
	public List<CorrespondenciaDecisionL21> findAll(CorrespondenciaDecisionL21 correspondenciaDecisionL21, Pagination pagination) {
		return (List<CorrespondenciaDecisionL21>) this.correspondenciaDecisionL21Dao.findAll(correspondenciaDecisionL21, pagination);
	}
    
	/**
	 * Counts rows in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @return Long
	 */
	public Long findAllCount(CorrespondenciaDecisionL21 correspondenciaDecisionL21) {        
		return  this.correspondenciaDecisionL21Dao.findAllCount(correspondenciaDecisionL21);
	}

	/**
	 * Finds rows in the CorrespondenciaDecisionL21 table using like.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<CorrespondenciaDecisionL21> findAllLike(CorrespondenciaDecisionL21 correspondenciaDecisionL21, Pagination pagination, Boolean startsWith) {
		return (List<CorrespondenciaDecisionL21>) this.correspondenciaDecisionL21Dao.findAllLike(correspondenciaDecisionL21, pagination, startsWith);
	}

	/**
	 * Counts rows in the CorrespondenciaDecisionL21 table using like.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(CorrespondenciaDecisionL21 correspondenciaDecisionL21, Boolean startsWith) {
		return this.correspondenciaDecisionL21Dao.findAllLikeCount(correspondenciaDecisionL21, startsWith);
	}
	    
	/**
	 * Deletes a single row in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21 CorrespondenciaDecisionL21
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CorrespondenciaDecisionL21 correspondenciaDecisionL21) {
		this.correspondenciaDecisionL21Dao.remove(correspondenciaDecisionL21);
	}
	
	/**
	 * Deletes multiple rows in the CorrespondenciaDecisionL21 table.
	 *
	 * @param correspondenciaDecisionL21List List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<CorrespondenciaDecisionL21> correspondenciaDecisionL21List) {
		for (CorrespondenciaDecisionL21  correspondenciaDecisionL21Aux:correspondenciaDecisionL21List) {
			this.correspondenciaDecisionL21Dao.remove(correspondenciaDecisionL21Aux);
		}
	}
	
}

