package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ContactoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Contacto;

/**
 * ContactoServiceImpl  
 *  
 */

@Service(value = "contactoService")
public class ContactoServiceImpl implements ContactoService {

	@Autowired
	private ContactoDao contactoDao;

	/**
	 * Inserts a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Contacto add(Contacto contacto) {
		return this.contactoDao.add(contacto);
	}

	/**
	 * Updates a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Contacto update(Contacto contacto) {
		return this.contactoDao.update(contacto);
	 }

	/**
	 * Finds a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
	public Contacto find(Contacto contacto) {
		return (Contacto) this.contactoDao.find(contacto);
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Contacto> findAll(Contacto contacto, Pagination pagination) {
		return (List<Contacto>) this.contactoDao.findAll(contacto, pagination);
	}
    
	/**
	 * Counts rows in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Long
	 */
	public Long findAllCount(Contacto contacto) {        
		return  this.contactoDao.findAllCount(contacto);
	}

	/**
	 * Finds rows in the Contacto table using like.
	 *
	 * @param contacto Contacto
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Contacto> findAllLike(Contacto contacto, Pagination pagination, Boolean startsWith) {
		return (List<Contacto>) this.contactoDao.findAllLike(contacto, pagination, startsWith);
	}

	/**
	 * Counts rows in the Contacto table using like.
	 *
	 * @param contacto Contacto
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Contacto contacto, Boolean startsWith) {
		return this.contactoDao.findAllLikeCount(contacto, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Contacto contacto) {
		this.contactoDao.remove(contacto);
	}
	
	/**
	 * Deletes multiple rows in the Contacto table.
	 *
	 * @param contactoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Contacto> contactoList) {
		for (Contacto  contactoAux:contactoList) {
			this.contactoDao.remove(contactoAux);
		}
	}
	
}

