package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Contacto;

/**
 * ContactoService  
 *  
 */

public interface ContactoService {

	/**
	 * Inserts a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
    Contacto add(Contacto contacto);

	/**
	 * Updates a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
	Contacto update(Contacto contacto);

	/**
	 * Finds a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Contacto
	 */
	Contacto find(Contacto contacto);

	/**
	 * Finds a List of rows in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @param pagination Pagination
	 * @return List
	 */
	List<Contacto> findAll(Contacto contacto, Pagination pagination);

	/**
	 * Counts rows in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return Long
	 */
	Long findAllCount(Contacto contacto);
	
	/**
	 * Finds rows in the Contacto table using like.
	 *
	 * @param contacto Contacto
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Contacto> findAllLike(Contacto contacto, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Contacto table using like.
	 *
	 * @param contacto Contacto
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Contacto contacto, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Contacto table.
	 *
	 * @param contacto Contacto
	 * @return 
	 */
	void remove(Contacto contacto);
	
	/**
	 * Deletes multiple rows in the Contacto table.
	 *
	 * @param contactoList List
	 * @return 
	 */	
	void removeMultiple(List<Contacto> contactoList);
    
}


