package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.ConsumidorReclamaciones;

/**
 * * ConsumidorService  
 * 
 *  
 */

public interface ConsumidorService {

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor add(Consumidor consumidor);

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor addConsumidor(Consumidor consumidor);

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor update(Consumidor consumidor);

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor updateConsumidor(Consumidor consumidor);

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor find(Consumidor consumidor);

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	ConsumidorDetalle findConsumidor(Consumidor consumidor);

	/**
	 * Finds a List of rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Consumidor> findAll(Consumidor consumidor, Pagination pagination);

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	Long findAllCount(Consumidor consumidor);

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consumidor> findAllLike(Consumidor consumidor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consumidor> findAllLikeConsumidor(Consumidor consumidor,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	Long findAllLikeConsumidorCount(Consumidor consumidor, Boolean startsWith);

	/**
	 * Deletes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return
	 */
	void remove(Consumidor consumidor);

	/**
	 * Deletes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return
	 */
	void removeConsumidor(Consumidor consumidor);

	/**
	 * Deletes multiple rows in the Consumidor table.
	 * 
	 * @param consumidorList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Consumidor> consumidorList);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsumidorReclamaciones> findAllConsumidorReclamaciones(
			Consumidor consumidor, Pagination pagination);

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	Long findAllConsumidorReclamacionesCount(Consumidor consumidor);

	/**
	 * Fusiona consumidores duplicados.
	 * 
	 * @param consumidorBueno
	 *            Consumidor
	 * @param consumidoresListABorrar
	 *            ArrayList
	 * @return
	 */
	public void fusionConsumidor(Consumidor consumidorBueno,
			ArrayList<Consumidor> consumidoresListABorrar);
}
