package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ConsumidorArbitraDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ConsumidorArbitra;

/**
 * ConsumidorArbitraServiceImpl  
 *  
 */

@Service(value = "consumidorArbitraService")
public class ConsumidorArbitraServiceImpl implements ConsumidorArbitraService {

	@Autowired
	private ConsumidorArbitraDao consumidorArbitraDao;

	/**
	 * Inserts a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConsumidorArbitra add(ConsumidorArbitra consumidorArbitra) {
		return this.consumidorArbitraDao.add(consumidorArbitra);
	}

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConsumidorArbitra update(ConsumidorArbitra consumidorArbitra) {
		return this.consumidorArbitraDao.update(consumidorArbitra);
	 }

	/**
	 * Finds a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	public ConsumidorArbitra find(ConsumidorArbitra consumidorArbitra) {
		return (ConsumidorArbitra) this.consumidorArbitraDao.find(consumidorArbitra);
	}

	/**
	 * Finds a List of rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @param pagination Pagination
	 * @return List
	 */
	public List<ConsumidorArbitra> findAll(ConsumidorArbitra consumidorArbitra, Pagination pagination) {
		return (List<ConsumidorArbitra>) this.consumidorArbitraDao.findAll(consumidorArbitra, pagination);
	}
    
	/**
	 * Counts rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return Long
	 */
	public Long findAllCount(ConsumidorArbitra consumidorArbitra) {        
		return  this.consumidorArbitraDao.findAllCount(consumidorArbitra);
	}

	/**
	 * Finds rows in the ConsumidorArbitra table using like.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<ConsumidorArbitra> findAllLike(ConsumidorArbitra consumidorArbitra, Pagination pagination, Boolean startsWith) {
		return (List<ConsumidorArbitra>) this.consumidorArbitraDao.findAllLike(consumidorArbitra, pagination, startsWith);
	}

	/**
	 * Counts rows in the ConsumidorArbitra table using like.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ConsumidorArbitra consumidorArbitra, Boolean startsWith) {
		return this.consumidorArbitraDao.findAllLikeCount(consumidorArbitra, startsWith);
	}
	    
	/**
	 * Deletes a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ConsumidorArbitra consumidorArbitra) {
		this.consumidorArbitraDao.remove(consumidorArbitra);
	}
	
	/**
	 * Deletes multiple rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitraList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ConsumidorArbitra> consumidorArbitraList) {
		for (ConsumidorArbitra  consumidorArbitraAux:consumidorArbitraList) {
			this.consumidorArbitraDao.remove(consumidorArbitraAux);
		}
	}
	
}

