package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ConsumidorArbitra;

/**
 * ConsumidorArbitraService  
 *  
 */

public interface ConsumidorArbitraService {

	/**
	 * Inserts a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
    ConsumidorArbitra add(ConsumidorArbitra consumidorArbitra);

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	ConsumidorArbitra update(ConsumidorArbitra consumidorArbitra);

	/**
	 * Finds a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	ConsumidorArbitra find(ConsumidorArbitra consumidorArbitra);

	/**
	 * Finds a List of rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @param pagination Pagination
	 * @return List
	 */
	List<ConsumidorArbitra> findAll(ConsumidorArbitra consumidorArbitra, Pagination pagination);

	/**
	 * Counts rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return Long
	 */
	Long findAllCount(ConsumidorArbitra consumidorArbitra);
	
	/**
	 * Finds rows in the ConsumidorArbitra table using like.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<ConsumidorArbitra> findAllLike(ConsumidorArbitra consumidorArbitra, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the ConsumidorArbitra table using like.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(ConsumidorArbitra consumidorArbitra, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitra ConsumidorArbitra
	 * @return 
	 */
	void remove(ConsumidorArbitra consumidorArbitra);
	
	/**
	 * Deletes multiple rows in the ConsumidorArbitra table.
	 *
	 * @param consumidorArbitraList List
	 * @return 
	 */	
	void removeMultiple(List<ConsumidorArbitra> consumidorArbitraList);
    
}


