package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.ConsultaBusqueda;
import com.ejie.y41b.model.ConsultaDetalle;
import com.ejie.y41b.model.ConsultaFile;
import com.ejie.y41b.model.DocumentoConsultaDetalle;
import com.ejie.y41b.model.EstadisticasConsultasResultado;
import com.ejie.y41b.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41b.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41b.model.EstadisticasKontsumonetResultado;
import com.ejie.y41b.model.ListadoConsultaResultado;
import com.ejie.y41b.model.Respuesta;
import com.ejie.y41b.model.RespuestaFile;

/**
 * * ConsultaService  
 * 
 *  
 */

public interface ConsultaService {

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta add(Consulta consulta);

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param respuesta
	 *            Respuesta
	 * @return Consulta
	 */
	Consulta addConsulta(Consulta consulta, Respuesta respuesta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta update(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta updateConsulta(Consulta consulta, Respuesta respuesta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	Respuesta responderConsulta(Respuesta respuesta);

	/**
	 * Responde por email a una consulta.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param respuesta
	 *            Respuesta
	 * @return Consulta
	 */
	Respuesta emailConsulta(Consulta consulta, Respuesta respuesta);

	/**
	 * Finds a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta find(Consulta consulta);

	/**
	 * Finds a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return ConsultaDetalle
	 */
	ConsultaDetalle findConsulta(Consulta consulta);

	/**
	 * Finds a List of rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Consulta> findAll(Consulta consulta, Pagination pagination);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	Long findAllCount(Consulta consulta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consulta> findAllLike(Consulta consulta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ConsultaBusqueda> findAllLikeConsulta(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde,
			Date fechaHasta);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeConsultaCount(Consulta consulta, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds all files of the Consulta.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoConsultaDetalle> findAllFileConsulta(Consulta consulta,
			Pagination pagination);

	/**
	 * Counts rows in the Consulta File table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	Long findAllFileConsultaCount(Consulta consulta);

	/**
	 * Deletes a document of the Consulta.
	 * 
	 * @param documentoConsultaDetalle
	 *            DocumentoConsultaDetalle
	 * @return
	 */
	void removeFileConsulta(DocumentoConsultaDetalle documentoConsultaDetalle);

	/**
	 * Deletes a document of the Consulta.
	 * 
	 * @param documentoConsultaDetalle
	 *            DocumentoConsultaDetalle
	 * @return
	 */
	void removeLobTablaTemporal(
			DocumentoConsultaDetalle documentoConsultaDetalle);

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile addFileConsulta(ConsultaFile consultaFile);

	/**
	 * Inserts a single row in the Respuesta File table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile addFileRespuesta(RespuestaFile respuestaFile);

	/**
	 * Deletes a document of the Consulta.
	 * 
	 * @param documentoConsultaDetalle
	 *            DocumentoConsultaDetalle
	 * @return
	 */
	void removeFileRespuesta(DocumentoConsultaDetalle documentoConsultaDetalle);

	/**
	 * Finds a single row in the File Consulta table.
	 * 
	 * @param documentoConsultaDetalle
	 *            DocumentoConsultaDetalle
	 * @return DocumentoConsultaDetalle
	 */
	DocumentoConsultaDetalle findFileConsulta(
			DocumentoConsultaDetalle documentoConsultaDetalle);

	/**
	 * Deletes a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void remove(Consulta consulta);

	/**
	 * Deletes a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void removeConsulta(Consulta consulta);

	/**
	 * Deletes multiple rows in the Consulta table.
	 * 
	 * @param consultaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Consulta> consultaList);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstadisticasKontsumonetResultado> findAllConsultaEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaFormaPresentacion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaMotivosProductos(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaProductoServicio(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaSexoEdad(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultas(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasAbreviada(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);
}
