package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ConsultaFileDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ConsultaFile;

/**
 * * ConsultaFileServiceImpl  
 * 
 *  
 */

@Service(value = "consultaFileService")
public class ConsultaFileServiceImpl implements ConsultaFileService {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsultaFileServiceImpl.class);
	@Autowired
	private ConsultaFileDao consultaFileDao;

	/**
	 * Inserts a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConsultaFile add(ConsultaFile consultaFile) {
		return this.consultaFileDao.add(consultaFile);
	}

	/**
	 * Updates a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConsultaFile update(ConsultaFile consultaFile) {
		return this.consultaFileDao.update(consultaFile);
	}

	/**
	 * Finds a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	public ConsultaFile find(ConsultaFile consultaFile) {
		return (ConsultaFile) this.consultaFileDao.find(consultaFile);
	}

	/**
	 * Finds a List of rows in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ConsultaFile> findAll(ConsultaFile consultaFile,
			Pagination pagination) {
		return (List<ConsultaFile>) this.consultaFileDao.findAll(consultaFile,
				pagination);
	}

	/**
	 * Counts rows in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return Long
	 */
	public Long findAllCount(ConsultaFile consultaFile) {
		return this.consultaFileDao.findAllCount(consultaFile);
	}

	/**
	 * Finds rows in the ConsultaFile table using like.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ConsultaFile> findAllLike(ConsultaFile consultaFile,
			Pagination pagination, Boolean startsWith) {
		return (List<ConsultaFile>) this.consultaFileDao.findAllLike(
				consultaFile, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ConsultaFile consultaFile) {
		this.consultaFileDao.remove(consultaFile);
	}

	/**
	 * Deletes multiple rows in the ConsultaFile table.
	 * 
	 * @param consultaFileList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ConsultaFile> consultaFileList) {
		for (ConsultaFile consultaFileAux : consultaFileList) {
			this.consultaFileDao.remove(consultaFileAux);
		}
	}

	/**
	 * Getter method for ConsultaFileDao
	 * 
	 * @return ConsultaFileDao
	 */
	public ConsultaFileDao getConsultaFileDao() {
		return this.consultaFileDao;
	}

	/**
	 * Setter method for ConsultaFileDao.
	 * 
	 * @param consultaFileDao
	 *            ConsultaFileDao
	 * @return
	 */
	public void setConsultaFileDao(ConsultaFileDao consultaFileDao) {
		logger.info("Setting Dependency " + consultaFileDao);
		this.consultaFileDao = consultaFileDao;
	}
}
