package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.ConsultaFile;

/**
 * * ConsultaFileService  
 * 
 *  
 */

public interface ConsultaFileService {

	/**
	 * Inserts a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile add(ConsultaFile consultaFile);

	/**
	 * Updates a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile update(ConsultaFile consultaFile);

	/**
	 * Finds a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile find(ConsultaFile consultaFile);

	/**
	 * Finds a List of rows in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsultaFile> findAll(ConsultaFile consultaFile, Pagination pagination);

	/**
	 * Counts rows in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return Long
	 */
	Long findAllCount(ConsultaFile consultaFile);

	/**
	 * Finds rows in the ConsultaFile table using like.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ConsultaFile> findAllLike(ConsultaFile consultaFile,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the ConsultaFile table.
	 * 
	 * @param consultaFile
	 *            ConsultaFile
	 * @return
	 */
	void remove(ConsultaFile consultaFile);

	/**
	 * Deletes multiple rows in the ConsultaFile table.
	 * 
	 * @param consultaFileList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<ConsultaFile> consultaFileList);

}
