package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ConceptopagoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ConceptopagoServiceImpl  
 * 
 *  
 */

@Service(value = "conceptopagoService")
public class ConceptopagoServiceImpl implements ConceptopagoService {

	@Autowired()
	private ConceptopagoDao conceptopagoDao;

	/**
	 * Inserts a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Conceptopago add(Conceptopago conceptopago) {
		return this.conceptopagoDao.add(conceptopago);
	}

	/**
	 * Updates a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Conceptopago update(Conceptopago conceptopago) {
		return this.conceptopagoDao.update(conceptopago);
	}

	/**
	 * Finds a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	public Conceptopago find(Conceptopago conceptopago) {
		return (Conceptopago) this.conceptopagoDao.find(conceptopago);
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Conceptopago> findAll(Conceptopago conceptopago,
			Pagination pagination) {

		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("tipoconceptopago.scdesces")) {
			pagination.setSort("tipoconceptopagoscdesces");
		}
		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("tipoconceptopago.scdesceu")) {
			pagination.setSort("tipoconceptopagoscdesces");
		}
		return (List<Conceptopago>) this.conceptopagoDao.findAll(conceptopago,
				pagination);
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Conceptopago> findAllEjerciciosVigentes(
			Conceptopago conceptopago, Pagination pagination) {

		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("tipoconceptopago.scdesces")) {
			pagination.setSort("tipoconceptopagoscdesces");
		}
		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("tipoconceptopago.scdesceu")) {
			pagination.setSort("tipoconceptopagoscdesces");
		}
		return (List<Conceptopago>) this.conceptopagoDao
				.findAllEjerciciosVigentes(conceptopago, pagination);
	}

	/**
	 * Counts rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Long
	 */
	public Long findAllCount(Conceptopago conceptopago) {
		return this.conceptopagoDao.findAllCount(conceptopago);
	}

	/**
	 * Finds rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Conceptopago> findAllLike(Conceptopago conceptopago,
			Pagination pagination, Boolean startsWith) {
		return (List<Conceptopago>) this.conceptopagoDao.findAllLike(
				conceptopago, pagination, startsWith);
	}

	/**
	 * Counts rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Conceptopago conceptopago, Boolean startsWith) {
		return this.conceptopagoDao.findAllLikeCount(conceptopago, startsWith);
	}

	/**
	 * Deletes a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Conceptopago conceptopago) {
		try {
			this.conceptopagoDao.remove(conceptopago);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.conceptopago.DataIntegrityViolationException", true,
					e);
		}
	}

	/**
	 * Deletes multiple rows in the Conceptopago table.
	 * 
	 * @param conceptopagoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Conceptopago> conceptopagoList) {
		for (Conceptopago conceptopagoAux : conceptopagoList) {
			this.conceptopagoDao.remove(conceptopagoAux);
		}
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Conceptopago> findAllVigentes(Conceptopago conceptopago,
			Pagination pagination) {
		return (List<Conceptopago>) this.conceptopagoDao.findAllVigentes(
				conceptopago, pagination);
	}

	/**
	 * @param conceptopago
	 *            Conceptopago
	 * @param vigente
	 *            boolean
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Conceptopago> findAllEjercicio(Conceptopago conceptopago,
			Pagination pagination, boolean vigente) {
		return (List<Conceptopago>) this.conceptopagoDao.findAllEjercicio(
				conceptopago, pagination, vigente);
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	public Long getNewPK() {
		return this.conceptopagoDao.getNewPK();
	}

	/**
	 * @param conceptopago
	 * @return
	 */
	public void baja(Conceptopago conceptopago) {
		this.conceptopagoDao.baja(conceptopago);
	}
}
