package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Conceptopago;

/**
 * ConceptopagoService  
 * 
 *  
 */

public interface ConceptopagoService {

	/**
	 * Inserts a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	Conceptopago add(Conceptopago conceptopago);

	/**
	 * Updates a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	Conceptopago update(Conceptopago conceptopago);

	/**
	 * Finds a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Conceptopago
	 */
	Conceptopago find(Conceptopago conceptopago);

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Conceptopago> findAll(Conceptopago conceptopago, Pagination pagination);

	/**
	 * Counts rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Long
	 */
	Long findAllCount(Conceptopago conceptopago);

	/**
	 * Finds rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Conceptopago> findAllLike(Conceptopago conceptopago,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Conceptopago conceptopago, Boolean startsWith);

	/**
	 * Deletes a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return
	 */
	void remove(Conceptopago conceptopago);

	/**
	 * Deletes multiple rows in the Conceptopago table.
	 * 
	 * @param conceptopagoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Conceptopago> conceptopagoList);

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Conceptopago> findAllVigentes(Conceptopago conceptopago,
			Pagination pagination);

	/**
	 * @param conceptopago
	 *            Conceptopago
	 * @param vigente
	 *            boolean
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Conceptopago> findAllEjercicio(Conceptopago conceptopago,
			Pagination pagination, boolean vigente);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param conceptopago
	 */
	void baja(Conceptopago conceptopago);

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Conceptopago> findAllEjerciciosVigentes(Conceptopago conceptopago,
			Pagination pagination);
}
