package com.ejie.y41b.service;

import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.AdjunInfraccHechoDenunDao;
import com.ejie.y41b.dao.AdjuntarComusoivrerelDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ComunicacionSoivreDao;
import com.ejie.y41b.dao.ComunicacionSoivreRelDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.HistorialAlertaDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.ComunicacionSoivreRel;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteINSDetalle;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ComunicacionSoivreServiceImpl  
 * 
 *  
 */

@Service(value = "comunicacionSoivreService")
public class ComunicacionSoivreServiceImpl implements ComunicacionSoivreService {

	@Autowired
	private ComunicacionSoivreDao comunicacionSoivreDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired
	private InfraccHechoDenDao infraccHechoDenDao;
	@Autowired
	private ActaInfraccionDao actaInfraccionDao;
	@Autowired
	private AdjunInfraccHechoDenunDao adjunInfraccHechoDenunDao;
	@Autowired
	private ComunicacionSoivreRelDao comunicacionSoivreRelDao;
	@Autowired
	private AdjuntarComusoivrerelDao adjuntarComusoivrerelDao;
	@Autowired
	private IntervinientesDao intervinientesDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private EstablecimientoService establecimientoService;
	@Autowired
	private EstablecimSectorDao establecimSectorDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired
	private HistorialAlertaDao historialAlertaDao;
	@Autowired
	private InspeccionService inspeccionService;
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;
	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private CensoMonitorDao censoMonitorDao;
	@Autowired
	private OrganismoDao organismoDao;
	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre add(ComunicacionSoivre comunicacionSoivre) {
		return this.comunicacionSoivreDao.add(comunicacionSoivre);
	}

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre addComunicacionSoivre(ComunicacionSoivre comunicacionSoivre) {
		try {
			this.comunicacionSoivreDao.add(comunicacionSoivre);

			HistorialAlerta historialAlerta = new HistorialAlerta();
			historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			historialAlerta.setCodigo(comunicacionSoivre.getIdcomunicacionsoivre());
			historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
			historialAlerta.setOrganismodestino(null);
			historialAlerta.setDescripcion(Y41bConstantes.FECHA_ENTRADA_COMUNICACION_SOIVRE);
			historialAlerta.setGenerado(Y41bConstantes.SI);
			historialAlerta.setFecha(comunicacionSoivre.getV6fechaentrada());

			this.historialAlertaDao.add(historialAlerta);

			if (comunicacionSoivre.getV6fecharespuesta() != null) {
				historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(comunicacionSoivre.getIdcomunicacionsoivre());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.FECHA_RESPUESTA_INSPECCION_COMUNICACION_SOIVRE);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(comunicacionSoivre.getV6fecharespuesta());

				this.historialAlertaDao.add(historialAlerta);
			}

			// Interviniente importador
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(comunicacionSoivre.getV6importador());

			establecimiento = this.establecimientoDao.find(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			Intervinientes intervinientes = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
					establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
					establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
					establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
					establecimiento.getEscoem(), establecimiento.getEsextranjero(),
					establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
					establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
					establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
					establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
					establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
					establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
					establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
					establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
					establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_IMPORTADOR, comunicacionSoivre.getIdcomunicacionsoivre(), null,
					establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
					establecimiento.getCensoMonitor().getUsuarioxlnet());

			// por cada uno insertar el interviniente
			this.intervinientesDao.add(intervinientes);

			// Interviniente establecimiento visitado
			establecimiento = new Establecimiento();
			establecimiento.setEscodigo(comunicacionSoivre.getV6establecimientovisita());

			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			establecSector = new EstablecimSector();
			actividad = new Actividad();
			sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
					establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
					establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
					establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
					establecimiento.getEscoem(), establecimiento.getEsextranjero(),
					establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
					establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
					establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
					establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
					establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
					establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
					establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
					establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
					establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO,
					comunicacionSoivre.getIdcomunicacionsoivre(), null, establecimiento.getEsfemod(),
					establecimiento.getCensoMonitor().getMocodigo(),
					establecimiento.getCensoMonitor().getUsuarioxlnet());

			// por cada uno insertar el interviniente
			this.intervinientesDao.add(intervinientes);

			if (comunicacionSoivre.getAnyadirPlantilla() == null) {
				this.documentoHechoDao.addAllDocumentosAdjuntarDocs(comunicacionSoivre.getIdcomunicacionsoivre(),
						comunicacionSoivre.getIdcomunicacionsoivre());

				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());

				int infraccionesGuardadas = this.infraccHechoDenDao
						.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComun);

				if (infraccionesGuardadas == 0) {
					throw new Y41bUDAException("error.comunicacionsoivre.InfraccionesException", true, new Exception());
				}

				this.comunicacionSoivreRelDao.addAllComunicacionesSoivreRelAdjuntarComsoivreRel(comunicacionSoivre);

				// buscar las comunicaciones relacionadas

				ComunicacionSoivreRel comunicacionSoivreRel = new ComunicacionSoivreRel();
				ComunicacionSoivre comunicacionSoivreAux = new ComunicacionSoivre();
				comunicacionSoivreAux.setIdcomunicacionsoivre(comunicacionSoivre.getIdcomunicacionsoivre());
				comunicacionSoivreRel.setComunicacionSoivreByIdcomunicacionsoivre(comunicacionSoivreAux);

				List<ComunicacionSoivreRel> listComunicacionSoivreRel = this.comunicacionSoivreRelDao
						.findAll(comunicacionSoivreRel, null);

				ComunicacionSoivreRel comunicacionSoivreRelAux2 = null;
				for (ComunicacionSoivreRel comunicacionSoivreRelAux : listComunicacionSoivreRel) {
					// por cada una insertar la relacion inversa

					comunicacionSoivreRelAux2 = new ComunicacionSoivreRel();
					comunicacionSoivreRelAux2.setComunicacionSoivreByIdcomunicacionsoivre(
							comunicacionSoivreRelAux.getComunicacionSoivreByIdcomunicacionsoivrerel());
					comunicacionSoivreRelAux2.setComunicacionSoivreByIdcomunicacionsoivrerel(
							comunicacionSoivreRelAux.getComunicacionSoivreByIdcomunicacionsoivre());

					List<ComunicacionSoivreRel> listComunicacionSoivreRel2 = this.comunicacionSoivreRelDao
							.findAll(comunicacionSoivreRelAux2, null);

					if (listComunicacionSoivreRel2 == null || listComunicacionSoivreRel2.size() == 0) {
						comunicacionSoivreRelAux2
								.setV7codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						this.comunicacionSoivreRelDao.add(comunicacionSoivreRelAux2);
					}
				}

				this.adjuntarComusoivrerelDao.removeAllComuSoivreRel(comunicacionSoivre);

				this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);

				this.adjuntardocsDao.removeAllDocsTableTemporal(comunicacionSoivre.getIdcomunicacionsoivre());
			}

			return comunicacionSoivre;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.comunicacionsoivre.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivreOrigen
	 *            ComunicacionSoivre
	 * @param comunicacionSoivreDestino
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre copiarComunicacionSoivre(ComunicacionSoivre comunicacionSoivreOrigen,
			ComunicacionSoivre comunicacionSoivreDestino) {
		try {
			// 1.- Buscar la comunicacin soivre
			ComunicacionSoivre comunicacionSoivreAux = this.comunicacionSoivreDao
					.findByV6Codigo(comunicacionSoivreOrigen);

			String idcomunicacionsoivreOrigen = comunicacionSoivreAux.getIdcomunicacionsoivre();

			comunicacionSoivreAux
					.setIdcomunicacionsoivre(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			comunicacionSoivreAux.setV6codigo(comunicacionSoivreDestino.getV6codigo());

			comunicacionSoivreAux.setV6coactua(null);
			comunicacionSoivreAux.setV6fechasolinspeccion(null);
			comunicacionSoivreAux.setV6fechafininspeccion(null);
			comunicacionSoivreAux.setV6fecharespuesta(null);
			comunicacionSoivreAux.setV6fechaentrada(new Date());

			this.comunicacionSoivreDao.add(comunicacionSoivreAux);

			HistorialAlerta historialAlerta = new HistorialAlerta();
			historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			historialAlerta.setCodigo(comunicacionSoivreAux.getIdcomunicacionsoivre());
			historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
			historialAlerta.setOrganismodestino(null);
			historialAlerta.setDescripcion(Y41bConstantes.FECHA_ENTRADA_COMUNICACION_SOIVRE);
			historialAlerta.setGenerado(Y41bConstantes.SI);
			historialAlerta.setFecha(comunicacionSoivreAux.getV6fechaentrada());

			this.historialAlertaDao.add(historialAlerta);

			// Interviniente importador
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(comunicacionSoivreAux.getV6importador());

			establecimiento = this.establecimientoDao.find(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			Intervinientes intervinientes = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
					establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
					establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
					establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
					establecimiento.getEscoem(), establecimiento.getEsextranjero(),
					establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
					establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
					establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
					establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
					establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
					establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
					establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
					establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
					establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_IMPORTADOR, comunicacionSoivreAux.getIdcomunicacionsoivre(), null,
					establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
					establecimiento.getCensoMonitor().getUsuarioxlnet());

			// por cada uno insertar el interviniente
			this.intervinientesDao.add(intervinientes);

			// Interviniente establecimiento visitado
			establecimiento = new Establecimiento();
			establecimiento.setEscodigo(comunicacionSoivreAux.getV6establecimientovisita());

			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			establecSector = new EstablecimSector();
			actividad = new Actividad();
			sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
					establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
					establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
					establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
					establecimiento.getEscoem(), establecimiento.getEsextranjero(),
					establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
					establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
					establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
					establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
					establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
					establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
					establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
					establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
					establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO,
					comunicacionSoivreAux.getIdcomunicacionsoivre(), null, establecimiento.getEsfemod(),
					establecimiento.getCensoMonitor().getMocodigo(),
					establecimiento.getCensoMonitor().getUsuarioxlnet());

			// por cada uno insertar el interviniente
			this.intervinientesDao.add(intervinientes);

			/*
			 * this.documentoHechoDao.addAllDocumentosAdjuntarDocs(
			 * comunicacionSoivreAux.getIdcomunicacionsoivre(),
			 * comunicacionSoivre.getIdcomunicacionsoivre());
			 */
			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(idcomunicacionsoivreOrigen);

			List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunDao
					.findAll(adjunInfraccHechoDenunFilter, null);

			ActaInfraccion actaInfraccion = null;
			for (AdjunInfraccHechoDenun adjunInfraccHechoDenunAux : listAdjunInfraccHechoDenun) {

				actaInfraccion = new ActaInfraccion();
				actaInfraccion.setAicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				actaInfraccion.setAicoat(comunicacionSoivreAux.getIdcomunicacionsoivre());
				actaInfraccion.setAicotti(adjunInfraccHechoDenunAux.getHicotti());
				actaInfraccion.setAiinexii(adjunInfraccHechoDenunAux.getHiinexii());

				this.actaInfraccionDao.add(actaInfraccion);
			}

			this.adjuntarComusoivrerelDao.removeAllComuSoivreRel(comunicacionSoivreOrigen);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(idcomunicacionsoivreOrigen);

			this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);

			this.adjuntardocsDao.removeAllDocsTableTemporal(idcomunicacionsoivreOrigen);

			return comunicacionSoivreAux;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.comunicacionsoivre.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre update(ComunicacionSoivre comunicacionSoivre) {
		return this.comunicacionSoivreDao.update(comunicacionSoivre);
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre updateComunicacionSoivre(ComunicacionSoivre comunicacionSoivre) {
		try {
			// Buscar comunicacion soivre
			ComunicacionSoivre comunicacionSoivreBBDD = this.comunicacionSoivreDao.find(comunicacionSoivre);

			if (comunicacionSoivreBBDD.getV6fecharespuesta() == null
					&& comunicacionSoivre.getV6fecharespuesta() != null) {
				HistorialAlerta historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(comunicacionSoivre.getIdcomunicacionsoivre());
				historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setOrganismodestino(null);
				historialAlerta.setDescripcion(Y41bConstantes.FECHA_RESPUESTA_INSPECCION_COMUNICACION_SOIVRE);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(comunicacionSoivre.getV6fecharespuesta());

				this.historialAlertaDao.add(historialAlerta);
			}

			this.comunicacionSoivreDao.update(comunicacionSoivre);

			if (Y41bConstantes.VALOR_SI.equals(comunicacionSoivre.getImportadorCambio())) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_IMPORTADOR);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);
				}

				// Interviniente importador
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(comunicacionSoivre.getV6importador());

				establecimiento = this.establecimientoDao.find(establecimiento);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				if (listIntervinientes.size() > 0) {
					intervinientes = new Intervinientes(intervinientes.getIdinterviniente(), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_IMPORTADOR, comunicacionSoivre.getIdcomunicacionsoivre(),
							null, establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.update(intervinientes);
				} else {
					intervinientes = new Intervinientes(
							Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_IMPORTADOR, comunicacionSoivre.getIdcomunicacionsoivre(),
							null, establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.add(intervinientes);
				}
			}

			if (Y41bConstantes.VALOR_SI.equals(comunicacionSoivre.getEstablecimientoVisitadoCambio())) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);
				}

				// Interviniente establecimiento visitado
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(comunicacionSoivre.getV6establecimientovisita());

				establecimiento = this.establecimientoDao.find(establecimiento);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				if (listIntervinientes.size() > 0) {
					intervinientes = new Intervinientes(intervinientes.getIdinterviniente(), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO,
							comunicacionSoivre.getIdcomunicacionsoivre(), null, establecimiento.getEsfemod(),
							establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.update(intervinientes);
				} else {
					intervinientes = new Intervinientes(
							Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO,
							comunicacionSoivre.getIdcomunicacionsoivre(), null, establecimiento.getEsfemod(),
							establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.add(intervinientes);
				}
			}

			if (comunicacionSoivre.getAnyadirPlantilla() == null) {
				DocumentoHecho documentoHecho = new DocumentoHecho();
				documentoHecho.setQ5hdcodigo(comunicacionSoivre.getIdcomunicacionsoivre());
				this.documentoHechoDao.removeDocsExpediente(documentoHecho);

				this.documentoHechoDao.addAllDocumentosAdjuntarDocs(comunicacionSoivre.getIdcomunicacionsoivre(),
						comunicacionSoivre.getIdcomunicacionsoivre());

				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());

				this.actaInfraccionDao.removeAllInfracciones(tramiteComun);

				int infraccionesGuardadas = this.infraccHechoDenDao
						.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComun);

				if (infraccionesGuardadas == 0) {
					throw new Y41bUDAException("error.comunicacionsoivre.InfraccionesException", true, new Exception());
				}

				this.comunicacionSoivreRelDao.removeAllComunicacionesSoivreRel(comunicacionSoivre);

				this.comunicacionSoivreRelDao.addAllComunicacionesSoivreRelAdjuntarComsoivreRel(comunicacionSoivre);

				// buscar las comunicaciones relacionadas

				ComunicacionSoivreRel comunicacionSoivreRel = new ComunicacionSoivreRel();
				ComunicacionSoivre comunicacionSoivreAux = new ComunicacionSoivre();
				comunicacionSoivreAux.setIdcomunicacionsoivre(comunicacionSoivre.getIdcomunicacionsoivre());
				comunicacionSoivreRel.setComunicacionSoivreByIdcomunicacionsoivre(comunicacionSoivreAux);

				List<ComunicacionSoivreRel> listComunicacionSoivreRel = this.comunicacionSoivreRelDao
						.findAll(comunicacionSoivreRel, null);

				ComunicacionSoivreRel comunicacionSoivreRelAux2 = null;
				for (ComunicacionSoivreRel comunicacionSoivreRelAux : listComunicacionSoivreRel) {
					// por cada una insertar la relacion inversa

					comunicacionSoivreRelAux2 = new ComunicacionSoivreRel();
					comunicacionSoivreRelAux2.setComunicacionSoivreByIdcomunicacionsoivre(
							comunicacionSoivreRelAux.getComunicacionSoivreByIdcomunicacionsoivrerel());
					comunicacionSoivreRelAux2.setComunicacionSoivreByIdcomunicacionsoivrerel(
							comunicacionSoivreRelAux.getComunicacionSoivreByIdcomunicacionsoivre());

					List<ComunicacionSoivreRel> listComunicacionSoivreRel2 = this.comunicacionSoivreRelDao
							.findAll(comunicacionSoivreRelAux2, null);

					if (listComunicacionSoivreRel2 == null || listComunicacionSoivreRel2.size() == 0) {
						comunicacionSoivreRelAux2
								.setV7codigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						this.comunicacionSoivreRelDao.add(comunicacionSoivreRelAux2);
					}
				}

				this.adjuntarComusoivrerelDao.removeAllComuSoivreRel(comunicacionSoivre);

				this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);

				this.adjuntardocsDao.removeAllDocsTableTemporal(comunicacionSoivre.getIdcomunicacionsoivre());
			}

			return comunicacionSoivre;
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.comunicacionsoivre.DataIntegrityViolationExceptionMod", true, e);
		}
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre iniciarComunicacionSoivre(ComunicacionSoivre comunicacionSoivre) throws Exception {
		// Insertar historial
		HistorialAlerta historialAlerta = new HistorialAlerta();
		historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		historialAlerta.setCodigo(comunicacionSoivre.getIdcomunicacionsoivre());
		historialAlerta.setOrganismoorigen(Y41bConstantes.ORGANISMO_SSCC);
		historialAlerta.setOrganismodestino(comunicacionSoivre.getV6coor());
		historialAlerta.setDescripcion(Y41bConstantes.FECHA_ENVIO_SSTT_COMUNICACION_SOIVRE);
		historialAlerta.setGenerado(Y41bConstantes.SI);
		historialAlerta.setFecha(new Date());

		this.historialAlertaDao.add(historialAlerta);

		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
		inspeccionDetalle.setAcfere(todayWithZeroTime);
		inspeccionDetalle.setAtidcomunicacionsoivre(comunicacionSoivre.getIdcomunicacionsoivre());

		inspeccionDetalle.setAccoor(comunicacionSoivre.getV6coor());
		inspeccionDetalle.setAdcoor(comunicacionSoivre.getV6coor());

		inspeccionDetalle.setAccoes(comunicacionSoivre.getV6establecimientovisita());
		inspeccionDetalle.setAtcoes(comunicacionSoivre.getV6importador());

		inspeccionDetalle.setAtformanotifestablecimientore(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
		inspeccionDetalle.setAtformanotifestablecimientovi(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
		inspeccionDetalle.setAtidiomaestablecimientovi(Y41bConstantes.CASTELLANO);
		inspeccionDetalle.setAtdestnotificavisitado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);

		inspeccionDetalle.setAtcops(comunicacionSoivre.getV6cops());
		inspeccionDetalle.setAtnoprse(comunicacionSoivre.getV6nomps());
		inspeccionDetalle.setAtnomaps(comunicacionSoivre.getV6marcaps());
		inspeccionDetalle.setAtnomops(comunicacionSoivre.getV6modelops());
		inspeccionDetalle.setAtnrlops(comunicacionSoivre.getV6loteps());
		inspeccionDetalle.setAtcodigobarras(comunicacionSoivre.getV6codigobarras());
		inspeccionDetalle.setAtfedumi(comunicacionSoivre.getV6fedumi());

		// Comprobar si la comunicacion soivre es de tipo acuerdo de inicio de
		// procedimiento.
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_AIP);
		documentoHecho.setQ5hdcodigo(comunicacionSoivre.getIdcomunicacionsoivre());

		Long numAcuerdoInicioProcedimiento = this.documentoHechoDao.findAllCount(documentoHecho);

		if (numAcuerdoInicioProcedimiento > 0) {
			inspeccionDetalle.setAtacuerdoinicio(Y41bConstantes.VALOR_SI);
			inspeccionDetalle.setAtformanotifestablecimientovi(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA);
		}

		inspeccionDetalle = this.inspeccionService.addInspeccion(inspeccionDetalle);

		// actualizar fecha solicitud inspeccion
		comunicacionSoivre.setV6coactua(inspeccionDetalle.getAtcodigo());
		comunicacionSoivre.setV6fechasolinspeccion(new Date());
		this.comunicacionSoivreDao.updateFechaSolInspeccion(comunicacionSoivre);

		return comunicacionSoivre;
	}

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre find(ComunicacionSoivre comunicacionSoivre) {
		ComunicacionSoivre resultado = (ComunicacionSoivre) this.comunicacionSoivreDao.find(comunicacionSoivre);
		// Obtener el valor de estado de adhesion del censo
		resultado.setV6establecimientovisitaesinadar(
				this.establecimientoService.estadoAdhesionEstablecimientoCenso(resultado.getV6establecimientovisita()));
		resultado.setV6importadoresinadar(
				this.establecimientoService.estadoAdhesionEstablecimientoCenso(resultado.getV6importador()));

		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes

		String cerrado = "";

		if (!Y41bUtils.esNullOCadenaVacia(resultado.getV6importador())) {
			cerrado = this.establecimientoService.estadoCerradoEstablecimientoCenso(resultado.getV6importador());
			resultado.setImportadorCerrado(cerrado);
		}

		cerrado = "";

		if (!Y41bUtils.esNullOCadenaVacia(resultado.getV6establecimientovisita())) {
			cerrado = this.establecimientoService
					.estadoCerradoEstablecimientoCenso(resultado.getV6establecimientovisita());
			resultado.setEstablecimientoVisitadoCerrado(cerrado);
		}

		// 0157454: Incluir literal Establecimiento cerrado en la
		// pestaa hecho de los expedientes

		return resultado;
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAll(ComunicacionSoivre comunicacionSoivre, Pagination pagination) {
		return (List<ComunicacionSoivre>) this.comunicacionSoivreDao.findAll(comunicacionSoivre, pagination);
	}

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return Long
	 */
	public Long findAllCount(ComunicacionSoivre comunicacionSoivre) {
		return this.comunicacionSoivreDao.findAllCount(comunicacionSoivre);
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAllBandejaComunicacionSoivre(ComunicacionSoivre comunicacionSoivre,
			CensoMonitor censoMonitor, Pagination pagination) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("v6codexpediente")) {
			pagination.setSort("ACCOOR ASC, ACNRAN ASC, LPAD(ACNROR, 12) ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("v6codexpediente")) {
			pagination.setSort("ACCOOR DESC, ACNRAN DESC, LPAD(ACNROR, 12) ");
		}

		return (List<ComunicacionSoivre>) this.comunicacionSoivreDao
				.findAllBandejaComunicacionSoivre(comunicacionSoivre, censoMonitor, pagination);
	}

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaComunicacionSoivreCount(ComunicacionSoivre comunicacionSoivre,
			CensoMonitor censoMonitor) {
		return this.comunicacionSoivreDao.findAllBandejaComunicacionSoivreCount(comunicacionSoivre, censoMonitor);
	}

	/**
	 * Finds rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ComunicacionSoivre> findAllLike(ComunicacionSoivre comunicacionSoivre, Pagination pagination,
			Boolean startsWith) {
		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("v6importadoresnombre")) {
				pagination.setSidx("IMPESNOMBRE");
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("v6psnombre")) {
				pagination.setSidx("PSNOMBRE");
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("v6psnombree")) {
				pagination.setSidx("PSNOMBREE");
			}
		}

		return (List<ComunicacionSoivre>) this.comunicacionSoivreDao.findAllLike(comunicacionSoivre, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ComunicacionSoivre comunicacionSoivre, Boolean startsWith) {
		return this.comunicacionSoivreDao.findAllLikeCount(comunicacionSoivre, startsWith);
	}

	/**
	 * Deletes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ComunicacionSoivre comunicacionSoivre) {
		this.comunicacionSoivreDao.remove(comunicacionSoivre);
	}

	/**
	 * Deletes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeComunicacionSoivre(ComunicacionSoivre comunicacionSoivre) {
		try {
			// buscar la comunicacin soivre
			ComunicacionSoivre comunicacionSoivreBBDD = this.comunicacionSoivreDao.find(comunicacionSoivre);

			// buscar la inspeccion de la comunicacion soivre
			Actuacion actuacion = new Actuacion();

			if (Y41bUtils.isFilled(comunicacionSoivreBBDD.getV6coactua())) {
				actuacion.setAtcodigo(comunicacionSoivreBBDD.getV6coactua());

				Long numInspeccionesIniciada = this.tramiteInspeccionDao
						.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

				// Si tiene expedientes abiertos se lanza error
				if (numInspeccionesIniciada > 0) {
					throw new Y41bUDAException(
							"error.comunicacionsoivre.ComunicacionSoivreInspeccionesAbiertasException", true,
							new Exception());
				}
			}

			// eliminar las inspeccion si no est iniciada
			this.comunicacionSoivreDao.updateCodInspeccion(comunicacionSoivre);

			if (Y41bUtils.isFilled(comunicacionSoivreBBDD.getV6coactua())) {
				InspeccionDetalle inspeccionDetalleAux = new InspeccionDetalle();
				inspeccionDetalleAux.setAtcodigo(actuacion.getAtcodigo());

				this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
			}

			// eliminar los intervinientes de la comunicacion
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());
			this.intervinientesDao.removeIntervinientesExpediente(intervinientes);

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(comunicacionSoivre.getIdcomunicacionsoivre());

			this.actaInfraccionDao.removeAllInfracciones(tramiteComun);

			this.comunicacionSoivreRelDao.removeAllComunicacionesSoivreRel(comunicacionSoivre);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(comunicacionSoivre.getIdcomunicacionsoivre());
			this.documentoHechoDao.removeDocsExpediente(documentoHecho);

			// eliminar historial
			HistorialAlerta historialalerta = new HistorialAlerta();
			historialalerta.setCodigo(comunicacionSoivre.getIdcomunicacionsoivre());
			this.historialAlertaDao.removeAllExpediente(historialalerta);

			this.comunicacionSoivreDao.remove(comunicacionSoivre);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.comunicacionsoivre.DataIntegrityViolationException", true, e);
		}

	}

	/**
	 * Deletes multiple rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivreList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ComunicacionSoivre> comunicacionSoivreList) {
		for (ComunicacionSoivre comunicacionSoivreAux : comunicacionSoivreList) {
			this.comunicacionSoivreDao.remove(comunicacionSoivreAux);
		}
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, ComunicacionSoivre comunicacionSoivre, String tipodocumento)
			throws Exception {

		// En la lista de documentos asociados solo podr haber un mximo de 1
		// documento de tipo acuerdo de inicio de procedimiento.
		Adjuntardocs adjuntardocsAux = new Adjuntardocs();
		TipoDocumento tipoDocumentoAux = new TipoDocumento();
		tipoDocumentoAux.setIdTipodoc(tipodocumento);

		adjuntardocsAux.setTipoDocumento(tipoDocumentoAux);
		adjuntardocsAux.setThidExpediente(comunicacionSoivre.getIdcomunicacionsoivre());

		Long numAcuerdoInicioProcedimiento = this.adjuntardocsDao.findAllCount(adjuntardocsAux);

		if (numAcuerdoInicioProcedimiento > 0) {
			throw new Y41bUDAException("error.comunicacionsoivre.AcuerdoInicioProcedimientoException", true, null);
		}

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());

		String plantilla = this.findPlantilla(plantillaTramite, comunicacionSoivre);

		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		adjuntardocs.setThcodocumento(this.documentoHechoDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		// buscar la solicitud
		SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
		solicitudDetalleAux.setHdcodigo(comunicacionSoivre.getIdcomunicacionsoivre());

		adjuntardocs.setThnofile(new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(comunicacionSoivre.getIdcomunicacionsoivre());
		adjuntardocs.setThidTramite(comunicacionSoivre.getIdcomunicacionsoivre());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		adjuntardocs.setTipoProcedimiento(tipoProcedimiento);

		adjuntardocs.setThfecha(new Date());

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	public String findPlantilla(PlantillaTramite plantillaTramite, ComunicacionSoivre comunicacionSoivre)
			throws Exception {

		// Obtener la plantilla del tramite
		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		// Obtener los datos de la comunicacion soivre
		comunicacionSoivre = (ComunicacionSoivre) this.comunicacionSoivreDao.find(comunicacionSoivre);

		PlantillaTramiteINSDetalle plantillaTramiteINSDetalle = new PlantillaTramiteINSDetalle();

		// Producto
		plantillaTramiteINSDetalle.setNombreProducto(comunicacionSoivre.getV6nomps());
		plantillaTramiteINSDetalle.setMarcaProducto(comunicacionSoivre.getV6marcaps());
		plantillaTramiteINSDetalle.setModeloProducto(comunicacionSoivre.getV6modelops());
		plantillaTramiteINSDetalle.setLoteProducto(comunicacionSoivre.getV6loteps());
		plantillaTramiteINSDetalle.setCodigoBarrasProducto(comunicacionSoivre.getV6codigobarras());

		// ResponsableProducto
		plantillaTramiteINSDetalle.setEsnombreResponsableProducto(comunicacionSoivre.getV6importadoresnombre());
		plantillaTramiteINSDetalle
				.setEsnombreMunicipioResponsableProducto(comunicacionSoivre.getV6importadoresnombreMunicipio());

		// buscar el interviniente
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdinterviniente(comunicacionSoivre.getV6importadoresid());
		intervinientesAux = this.intervinientesDao.find(intervinientesAux);

		// Creamos el campo direccion del establecimiento
		StringBuffer direccionCompleta = new StringBuffer();

		if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
				&& !intervinientesAux.getNombreCalle().equals("")) {
			direccionCompleta.append(intervinientesAux.getNombreCalle());

			if (intervinientesAux.getNombrePortal() != null && !intervinientesAux.getNombrePortal().equals("")) {
				direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
			}
			if (intervinientesAux.getNombrePiso() != null && !intervinientesAux.getNombrePiso().equals("")) {
				direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
			}
		} else {
			if (intervinientesAux.getDireccionNocapv() != null && !intervinientesAux.getDireccionNocapv().equals("")) {
				direccionCompleta.append(intervinientesAux.getDireccionNocapv());
			} else {
				direccionCompleta.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
			}
		}

		plantillaTramiteINSDetalle.setEsdireccionResponsableProducto(Y41bUtils.trataNull(direccionCompleta.toString()));

		// fecha de hoy
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		// Formateamos las fecha a castellano e euskera
		// fecha de hoy texto
		plantillaTramiteINSDetalle.setFechaHoyCas(Y41bUtils.formatearDateToString(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteINSDetalle.setFechaHoyEus(Y41bUtils.formatearDateToStringEuskera(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// Director
		CensoMonitor censoMonitorDirector = new CensoMonitor();

		try {
			censoMonitorDirector = this.censoMonitorDao.findDirectorInspecciones();
			if (censoMonitorDirector.getMonombre() == null) {
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}
		} catch (Exception e) {
			censoMonitorDirector = new CensoMonitor();
			throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
		}

		plantillaTramiteINSDetalle.setDirector(censoMonitorDirector.getMonombre());
		// recuperar texto de properties
		plantillaTramiteINSDetalle.setTextoPuestoDirectorCas(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteINSDetalle.setTextoPuestoDirectorEus(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
		plantillaTramiteINSDetalle.setCodOrg(organismo.getCodOrg());
		plantillaTramiteINSDetalle.setNombreEu(organismo.getNombreEu());
		plantillaTramiteINSDetalle.setNombreEs(organismo.getNombreEs());
		plantillaTramiteINSDetalle.setNombreCalle(organismo.getNombreCalle());
		plantillaTramiteINSDetalle.setNoraCpId(organismo.getNoraCpId());
		plantillaTramiteINSDetalle.setNombreMunicipio(organismo.getNombreMunicipio());
		plantillaTramiteINSDetalle.setNombrePortal(organismo.getNombrePortal());
		plantillaTramiteINSDetalle.setNombrePiso(organismo.getCompleDirec());

		plantillaTramiteINSDetalle.setTelefonoOrganismo(organismo.getTelefono());
		plantillaTramiteINSDetalle.setFaxOrganismo(organismo.getFax());
		plantillaTramiteINSDetalle.setEmailOrganismo(organismo.getEmail());
		plantillaTramiteINSDetalle.setWebOrganismo(organismo.getUrl());

		// Creamos el campo direccion del organismo conectado
		direccionCompleta = new StringBuffer();

		if (plantillaTramiteINSDetalle.getNombreCalle() != null
				&& !plantillaTramiteINSDetalle.getNombreCalle().equals("")) {
			direccionCompleta.append(plantillaTramiteINSDetalle.getNombreCalle());

			if (plantillaTramiteINSDetalle.getNombrePortal() != null
					&& !plantillaTramiteINSDetalle.getNombrePortal().equals("")) {
				direccionCompleta.append(", ").append(plantillaTramiteINSDetalle.getNombrePortal());
			}
		}

		plantillaTramiteINSDetalle.setDireccionOrganismo(Y41bUtils.trataNull(direccionCompleta.toString()));

		// Creamos el campo codigo postal y municipio del organismo
		// conectado
		StringBuffer cpMunicipio = new StringBuffer();

		if (plantillaTramiteINSDetalle.getNombreCp() != null && !plantillaTramiteINSDetalle.getNombreCp().equals("")) {
			cpMunicipio.append(plantillaTramiteINSDetalle.getNombreCp());

			if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(" ").append(plantillaTramiteINSDetalle.getNombreMunicipio());
			}
		} else if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
				&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
			cpMunicipio.append(plantillaTramiteINSDetalle.getNombreMunicipio());
		}

		plantillaTramiteINSDetalle.setCpMunicipioOrganismo(Y41bUtils.trataNull(cpMunicipio.toString()));

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea1 = new StringBuffer();

		piepagina_linea1.append(plantillaTramiteINSDetalle.getDireccionOrganismo()).append(" - ")
				.append(plantillaTramiteINSDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
				.append(plantillaTramiteINSDetalle.getTelefonoOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea2 = new StringBuffer();

		piepagina_linea2.append("e-mail: ").append(plantillaTramiteINSDetalle.getEmailOrganismo()).append(" / ")
				.append(plantillaTramiteINSDetalle.getWebOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

		// Transformar el documento en castellano
		String plantilla = Y41bUtils.blobToString(plantillaTramite.getPtplantilla());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		StringBuffer rutaPlantilla = new StringBuffer(prop.getProperty("y41bVistaWar.rutaxml.plantillas.word"));

		rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_XML_TRAMITE_CASTELLANO);

		String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
				plantillaTramiteINSDetalle, plantilla);

		return ficheroGenerado;
	}

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(ComunicacionSoivre comunicacionSoivre) {

		comunicacionSoivre = this.comunicacionSoivreDao.find(comunicacionSoivre);

		PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = new PlantillaControlMercadoDetalle();

		plantillaControlMercadoDetalle.setTipoOrigen(
				this.appMessageSource.getMessage("excel.inspecciones.soivre", null, LocaleContextHolder.getLocale()));

		plantillaControlMercadoDetalle.setCodigoOrigen(comunicacionSoivre.getV6codigo());

		// Establecimiento
		plantillaControlMercadoDetalle.setEsnombreVisitado(comunicacionSoivre.getV6establecimientovisitaesnombre());
		plantillaControlMercadoDetalle
				.setEsnombreMunicipioVisitado(comunicacionSoivre.getV6establecimientovisitaesnombreMunicipio());

		// Producto/Servicio
		plantillaControlMercadoDetalle.setNombreProducto(comunicacionSoivre.getV6nomps());
		plantillaControlMercadoDetalle.setMarcaProducto(comunicacionSoivre.getV6marcaps());
		plantillaControlMercadoDetalle.setModeloProducto(comunicacionSoivre.getV6modelops());
		plantillaControlMercadoDetalle.setCodigoBarrasProducto(comunicacionSoivre.getV6codigobarras());

		// Devolvemos el objeto
		return plantillaControlMercadoDetalle;

	}
}
