package com.ejie.y41b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;

/**
 * ComunicacionSoivreService  
 * 
 *  
 */

public interface ComunicacionSoivreService {

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre add(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre addComunicacionSoivre(
			ComunicacionSoivre comunicacionSoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre update(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateComunicacionSoivre(
			ComunicacionSoivre comunicacionSoivre);

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivreOrigen
	 *            ComunicacionSoivre
	 * @param comunicacionSoivreDestino
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivre copiarComunicacionSoivre(
			ComunicacionSoivre comunicacionSoivreOrigen,
			ComunicacionSoivre comunicacionSoivreDestino);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 * @throws Exception
	 *             Exception
	 */
	public ComunicacionSoivre iniciarComunicacionSoivre(
			ComunicacionSoivre comunicacionSoivre) throws Exception;

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre find(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ComunicacionSoivre> findAll(ComunicacionSoivre comunicacionSoivre,
			Pagination pagination);

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return Long
	 */
	Long findAllCount(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAllBandejaComunicacionSoivre(
			ComunicacionSoivre comunicacionSoivre, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaComunicacionSoivreCount(
			ComunicacionSoivre comunicacionSoivre, CensoMonitor censoMonitor);

	/**
	 * Finds rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ComunicacionSoivre> findAllLike(ComunicacionSoivre comunicacionSoivre,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ComunicacionSoivre comunicacionSoivre,
			Boolean startsWith);

	/**
	 * Deletes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	void remove(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Deletes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	public void removeComunicacionSoivre(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Deletes multiple rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivreList
	 *            List
	 * @return
	 */
	void removeMultiple(List<ComunicacionSoivre> comunicacionSoivreList);

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void addPlantilla(Adjuntardocs adjuntardocs,
			ComunicacionSoivre comunicacionSoivre, String tipodocumento)
			throws Exception;

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(
			ComunicacionSoivre comunicacionSoivre);
}
