package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ComunicacionSoivreRelDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ComunicacionSoivreRel;

/**
 * ComunicacionSoivreRelServiceImpl  
 *  
 */

@Service(value = "comunicacionSoivreRelService")
public class ComunicacionSoivreRelServiceImpl implements ComunicacionSoivreRelService {

	@Autowired
	private ComunicacionSoivreRelDao comunicacionSoivreRelDao;

	/**
	 * Inserts a single row in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @return ComunicacionSoivreRel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivreRel add(ComunicacionSoivreRel comunicacionSoivreRel) {
		return this.comunicacionSoivreRelDao.add(comunicacionSoivreRel);
	}

	/**
	 * Updates a single row in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @return ComunicacionSoivreRel
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionSoivreRel update(ComunicacionSoivreRel comunicacionSoivreRel) {
		return this.comunicacionSoivreRelDao.update(comunicacionSoivreRel);
	 }

	/**
	 * Finds a single row in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @return ComunicacionSoivreRel
	 */
	public ComunicacionSoivreRel find(ComunicacionSoivreRel comunicacionSoivreRel) {
		return (ComunicacionSoivreRel) this.comunicacionSoivreRelDao.find(comunicacionSoivreRel);
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @param pagination Pagination
	 * @return List
	 */
	public List<ComunicacionSoivreRel> findAll(ComunicacionSoivreRel comunicacionSoivreRel, Pagination pagination) {
		return (List<ComunicacionSoivreRel>) this.comunicacionSoivreRelDao.findAll(comunicacionSoivreRel, pagination);
	}
    
	/**
	 * Counts rows in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @return Long
	 */
	public Long findAllCount(ComunicacionSoivreRel comunicacionSoivreRel) {        
		return  this.comunicacionSoivreRelDao.findAllCount(comunicacionSoivreRel);
	}

	/**
	 * Finds rows in the ComunicacionSoivreRel table using like.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<ComunicacionSoivreRel> findAllLike(ComunicacionSoivreRel comunicacionSoivreRel, Pagination pagination, Boolean startsWith) {
		return (List<ComunicacionSoivreRel>) this.comunicacionSoivreRelDao.findAllLike(comunicacionSoivreRel, pagination, startsWith);
	}

	/**
	 * Counts rows in the ComunicacionSoivreRel table using like.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ComunicacionSoivreRel comunicacionSoivreRel, Boolean startsWith) {
		return this.comunicacionSoivreRelDao.findAllLikeCount(comunicacionSoivreRel, startsWith);
	}
	    
	/**
	 * Deletes a single row in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRel ComunicacionSoivreRel
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ComunicacionSoivreRel comunicacionSoivreRel) {
		this.comunicacionSoivreRelDao.remove(comunicacionSoivreRel);
	}
	
	/**
	 * Deletes multiple rows in the ComunicacionSoivreRel table.
	 *
	 * @param comunicacionSoivreRelList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ComunicacionSoivreRel> comunicacionSoivreRelList) {
		for (ComunicacionSoivreRel  comunicacionSoivreRelAux:comunicacionSoivreRelList) {
			this.comunicacionSoivreRelDao.remove(comunicacionSoivreRelAux);
		}
	}
	
}

