package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ClaseingresoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ClaseingresoServiceImpl  
 * 
 *  
 */

@Service(value = "claseingresoService")
public class ClaseingresoServiceImpl implements ClaseingresoService {

	@Autowired()
	private ClaseingresoDao claseingresoDao;

	/**
	 * Inserts a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Claseingreso add(Claseingreso claseingreso) {
		return this.claseingresoDao.add(claseingreso);
	}

	/**
	 * Updates a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Claseingreso update(Claseingreso claseingreso) {
		return this.claseingresoDao.update(claseingreso);
	}

	/**
	 * Finds a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	public Claseingreso find(Claseingreso claseingreso) {
		return (Claseingreso) this.claseingresoDao.find(claseingreso);
	}

	/**
	 * Finds a List of rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Claseingreso> findAll(Claseingreso claseingreso,
			Pagination pagination) {
		return (List<Claseingreso>) this.claseingresoDao.findAll(claseingreso,
				pagination);
	}

	/**
	 * Counts rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Long
	 */
	public Long findAllCount(Claseingreso claseingreso) {
		return this.claseingresoDao.findAllCount(claseingreso);
	}

	/**
	 * Finds rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Claseingreso> findAllLike(Claseingreso claseingreso,
			Pagination pagination, Boolean startsWith) {
		return (List<Claseingreso>) this.claseingresoDao.findAllLike(
				claseingreso, pagination, startsWith);
	}

	/**
	 * Counts rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Claseingreso claseingreso, Boolean startsWith) {
		return this.claseingresoDao.findAllLikeCount(claseingreso, startsWith);
	}

	/**
	 * Deletes a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Claseingreso claseingreso) {
		try {
			this.claseingresoDao.remove(claseingreso);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.claseingreso.DataIntegrityViolationException", true,
					e);
		}

	}

	/**
	 * Deletes multiple rows in the Claseingreso table.
	 * 
	 * @param claseingresoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Claseingreso> claseingresoList) {
		for (Claseingreso claseingresoAux : claseingresoList) {
			this.claseingresoDao.remove(claseingresoAux);
		}
	}

	/**
	 * getNewPK .
	 * 
	 * @return long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public long getNewPK() {
		return this.claseingresoDao.getNewPK();
	}
}
