package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Claseingreso;

/**
 * ClaseingresoService  
 * 
 *  
 */

public interface ClaseingresoService {

	/**
	 * Inserts a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	Claseingreso add(Claseingreso claseingreso);

	/**
	 * Updates a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	Claseingreso update(Claseingreso claseingreso);

	/**
	 * Finds a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Claseingreso
	 */
	Claseingreso find(Claseingreso claseingreso);

	/**
	 * Finds a List of rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Claseingreso> findAll(Claseingreso claseingreso, Pagination pagination);

	/**
	 * Counts rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Long
	 */
	Long findAllCount(Claseingreso claseingreso);

	/**
	 * Finds rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Claseingreso> findAllLike(Claseingreso claseingreso,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Claseingreso claseingreso, Boolean startsWith);

	/**
	 * Deletes a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return
	 */
	void remove(Claseingreso claseingreso);

	/**
	 * Deletes multiple rows in the Claseingreso table.
	 * 
	 * @param claseingresoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Claseingreso> claseingresoList);

	/**
	 * getNewPK .
	 * 
	 * @return long
	 */
	long getNewPK();
}
