package com.ejie.y41b.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.jms.Y41bRemesasClientJMSService;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * * CensoMonitorServiceImpl  
 * 
 *  
 */

@Service(value = "censoMonitorService")
public class CensoMonitorServiceImpl implements CensoMonitorService {
	private static final Logger logger = LoggerFactory.getLogger(CensoMonitorServiceImpl.class);
	@Autowired
	private CensoMonitorDao censoMonitorDao;

	@Autowired
	private Y41bRemesasClientJMSService remesasClientJMSService;

	@Autowired
	private RemesaService remesaService;

	@Autowired
	private ParametrosDao parametrosDao;

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CensoMonitor add(CensoMonitor censoMonitor) {

		this.censoMonitorDao.add(censoMonitor);

		this.validarBandejaDefecto(censoMonitor);

		if (this.censoMonitorDao.findAllCensoMonitorAltaCount(censoMonitor) > 1) {
			throw new Y41bUDAException("error.censomonitor.CreateException", true, new Exception());
		}

		if (censoMonitor.getOrganismo() != null && censoMonitor.getOrganismo().getCodOrg() != null
				&& !censoMonitor.getOrganismo().equals("")) {
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorSolicitudesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorSolicitudesException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorSancionesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorSancionesException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorInspeccionesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorInspeccionesException", true,
						new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorArbitrajeCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorArbitrajeException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaDirectorCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.directorException", true, new Exception());
			}
		}

		return censoMonitor;
	}

	/**
	 * Valida la bandeja por defecto del monitor
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public void validarBandejaDefecto(CensoMonitor censoMonitor) {
		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_SOLICITUDES_ADMINISTRATIVOS)))) {
			if (censoMonitor != null && ((censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO))
					&& (censoMonitor.getMobopvboe() == null
							|| !censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_EXPNUEVOS_PENDDECISION)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_TRAMITES_PENDIENTES)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_TRAMITES_PENDIENTES_OTROS)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null && censoMonitor.getMobandejadefecto()
				.equals(Y41bConstantes.BANDEJA_ESTADOOFICINA_NUEVOS_PENDDECISION)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null && censoMonitor.getMobandejadefecto()
				.equals(Y41bConstantes.BANDEJA_ESTADOOFICINA_TRAMITES_PENDIENTES)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_CONSULTAS_PENDIENTES)))) {
			if (censoMonitor != null && censoMonitor.getPerfilConsultas() != null
					&& censoMonitor.getPerfilConsultas().getIdPerfil() != null
					&& (censoMonitor.getPerfilConsultas().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
							|| censoMonitor.getPerfilConsultas().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_PROPUESTAS_SANCIONADOR)))) {
			if (censoMonitor.getPerfilSanciones() != null && censoMonitor.getPerfilSanciones().getIdPerfil() != null
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_SANCIONADORES))
				|| (censoMonitor.getMobandejadefecto() != null
						&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_PROPUESTAS_SANCIONADOR)))) {
			if (censoMonitor != null && censoMonitor.getPerfilSanciones() != null
					&& censoMonitor.getPerfilSanciones().getIdPerfil() != null
					&& (censoMonitor.getPerfilSanciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
							|| censoMonitor.getPerfilSanciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)
							|| censoMonitor.getPerfilSanciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_CONSULTAS))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_ARBITRAJES))
				|| (censoMonitor.getMobandejadefecto() != null
						&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_ADHESIONES))
				|| (censoMonitor.getMobandejadefecto() != null
						&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_PROPUESTAS_ARBITRAJE)))) {
			if (censoMonitor != null && censoMonitor.getPerfilArbitraje() != null
					&& censoMonitor.getPerfilArbitraje().getIdPerfil() != null
					&& (censoMonitor.getPerfilArbitraje().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_CONSULTAS))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_FIRMA)))) {
			if ((censoMonitor.getPerfilSanciones() != null && censoMonitor.getPerfilSanciones().getIdPerfil() != null
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilSanciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR))
					&& (censoMonitor.getPerfilSolicitudes() != null
							&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
							&& !censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
							&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SUPERVISOR)
							&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilSolicitudes().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_INSTRUCTOR))
					&& (censoMonitor.getPerfilArbitraje() != null
							&& censoMonitor.getPerfilArbitraje().getIdPerfil() != null
							&& !censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_DIRECTOR)
							&& !censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)
							&& !censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_INSTRUCTOR))
					&& (censoMonitor.getPerfilInspecciones() != null
							&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_DIRECTOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SUPERVISOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_INSTRUCTOR))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_CAMPANASSSCC)))) {
			if (censoMonitor != null && censoMonitor.getPerfilOrganizacion() != null
					&& censoMonitor.getPerfilOrganizacion().getIdPerfil() != null
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_CAMPANAS)))) {
			if ((censoMonitor.getPerfilOrganizacion() != null
					&& censoMonitor.getPerfilOrganizacion().getIdPerfil() != null
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO))
					|| (censoMonitor != null && censoMonitor.getPerfilInspecciones() != null
							&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_REDESALERTA)))) {
			if ((censoMonitor.getPerfilOrganizacion() != null
					&& censoMonitor.getPerfilOrganizacion().getIdPerfil() != null
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO))
					|| (censoMonitor.getPerfilInspecciones() != null
							&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_COMUNICACIONESSOIVRE)))) {
			if ((censoMonitor.getPerfilOrganizacion() != null
					&& censoMonitor.getPerfilOrganizacion().getIdPerfil() != null
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)
					&& !censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_CONSULTA_MANTENIMIENTO))
					|| (censoMonitor.getPerfilInspecciones() != null
							&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null

							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_COORDINADOR)
							&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_PROPUESTAINSPECCION)))) {
			if ((censoMonitor.getPerfilInspecciones() != null
					&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}

		if (censoMonitor != null && ((censoMonitor.getMobandejadefecto() != null
				&& censoMonitor.getMobandejadefecto().equals(Y41bConstantes.BANDEJA_INSPECCIONES)))) {
			if ((censoMonitor.getPerfilInspecciones() != null
					&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
					&& !censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR))) {
				throw new Y41bUDAException("error.censomonitor.BandejaDefectoException", true, new Exception());
			}
		}
	}

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CensoMonitor update(CensoMonitor censoMonitor) {
		this.censoMonitorDao.update(censoMonitor);

		this.validarBandejaDefecto(censoMonitor);

		if (this.censoMonitorDao.findAllCensoMonitorAltaCount(censoMonitor) > 1) {
			throw new Y41bUDAException("error.censomonitor.ActiveException", true, new Exception());
		}

		if (censoMonitor.getOrganismo() != null && censoMonitor.getOrganismo().getCodOrg() != null
				&& !censoMonitor.getOrganismo().equals("")) {
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorSolicitudesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorSolicitudesException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorSancionesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorSancionesException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorInspeccionesCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorInspeccionesException", true,
						new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaCoordinadorArbitrajeCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.coordinadorArbitrajeException", true, new Exception());
			}
			if (this.censoMonitorDao.findAllCensoMonitorAltaDirectorCount(censoMonitor) > 1) {
				throw new Y41bUDAException("error.censomonitor.directorException", true, new Exception());
			}
		}

		return censoMonitor;
	}

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CensoMonitor getAutorizacionKonbide(CensoMonitor censoMonitor) {

		// Se localiza el código, y el DNI coincide -> Se accede a la
		// aplicación
		List<CensoMonitor> listCensoMonitor = this.censoMonitorDao.findCensoMonitorUser(censoMonitor);
		if (listCensoMonitor != null && listCensoMonitor.size() > 0) {
			for (CensoMonitor censoMonitorAux : listCensoMonitor) {
				if (censoMonitorAux.getMofecbaja() == null) {
					// Actualizar el puesto del monitor, con el de XLNETS
					if (censoMonitor != null && !censoMonitor.getPuestoxlnet().equals("")) {
						censoMonitorAux.setPuestoxlnet(censoMonitor.getPuestoxlnet());
						this.censoMonitorDao.update(censoMonitorAux);
					}
					return censoMonitorAux;
				}
			}
		}

		// Se localiza el código, y el DNI no coincide -> Esto quiere decir
		// que ya existe un usuario con el mismo código ej en la aplicación.
		// Primero se comprueba que el usuario existente está inactivo:
		listCensoMonitor = this.censoMonitorDao.findCensoMonitorUsuarioXLNET(censoMonitor);

		boolean usuarioInactivo = true;
		if (listCensoMonitor != null && listCensoMonitor.size() > 0) {
			for (CensoMonitor censoMonitorAux : listCensoMonitor) {
				if (censoMonitorAux.getMofecbaja() == null) {
					usuarioInactivo = false;
				}
			}
		}

		if (listCensoMonitor != null && listCensoMonitor.size() > 0) {
			if (usuarioInactivo) {

				// Si el usuario existente está inactivo, se crea un nuevo
				// usuario, se le configuran los permisos sin darle acceso a
				// nada en la aplicación y se le permite el acceso,
				// posteriormente el administrador tendrá que configurarle los
				// permisos de acceso.
				// se le configuran los permisos sin darle acceso a nada en la
				// aplicación
				Perfil perfilSolicitudes = new Perfil();
				perfilSolicitudes.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
				censoMonitor.setPerfilSolicitudes(perfilSolicitudes);

				Perfil perfilSanciones = new Perfil();
				perfilSanciones.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
				censoMonitor.setPerfilSanciones(perfilSanciones);

				Perfil perfilInspecciones = new Perfil();
				perfilInspecciones.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
				censoMonitor.setPerfilInspecciones(perfilInspecciones);

				Perfil perfilArbitraje = new Perfil();
				perfilArbitraje.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
				censoMonitor.setPerfilArbitraje(perfilArbitraje);

				Perfil perfilOrganizacion = new Perfil();
				perfilOrganizacion.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
				censoMonitor.setPerfilOrganizacion(perfilOrganizacion);

				Perfil perfilMaestros = new Perfil();
				perfilMaestros.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
				censoMonitor.setPerfilMaestros(perfilMaestros);

				Perfil perfilEconomico = new Perfil();
				perfilEconomico.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
				censoMonitor.setPerfilEconomico(perfilEconomico);

				Perfil perfilConsultas = new Perfil();
				perfilConsultas.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
				censoMonitor.setPerfilConsultas(perfilConsultas);

				return this.censoMonitorDao.add(censoMonitor);
			} else {
				// Si el usuario existente está activo, se manda un mensaje que
				// dice (Ya existe un usuario con ese código en la aplicación,
				// para acceder es necesario que el usuario existente este
				// inactivo previamente). El administrador tendrá que acceder a
				// la aplicación y poner inactivo al usuario con ese código
				// ej.
				// En ese momento el usuario nuevo podrá acceder
				throw new Y41bUDAException("error.censomonitor.errorUsuarioActivo", true, new Exception());
			}
		}

		// No se localiza el código –> se crea un nuevo usuario, se le
		// configuran los permisos sin darle acceso a nada en la aplicación y
		// se
		// le permite el acceso, posteriormente el administrador tendrá que
		// configurarle los permisos de acceso.
		// se le configuran los permisos sin darle acceso a nada en la
		// aplicación
		Perfil perfilSolicitudes = new Perfil();
		perfilSolicitudes.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
		censoMonitor.setPerfilSolicitudes(perfilSolicitudes);

		Perfil perfilSanciones = new Perfil();
		perfilSanciones.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
		censoMonitor.setPerfilSanciones(perfilSanciones);

		Perfil perfilInspecciones = new Perfil();
		perfilInspecciones.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
		censoMonitor.setPerfilInspecciones(perfilInspecciones);

		Perfil perfilArbitraje = new Perfil();
		perfilArbitraje.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO);
		censoMonitor.setPerfilArbitraje(perfilArbitraje);

		Perfil perfilOrganizacion = new Perfil();
		perfilOrganizacion.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
		censoMonitor.setPerfilOrganizacion(perfilOrganizacion);

		Perfil perfilMaestros = new Perfil();
		perfilMaestros.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
		censoMonitor.setPerfilMaestros(perfilMaestros);

		Perfil perfilEconomico = new Perfil();
		perfilEconomico.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
		censoMonitor.setPerfilEconomico(perfilEconomico);

		Perfil perfilConsultas = new Perfil();
		perfilConsultas.setIdPerfil(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO);
		censoMonitor.setPerfilConsultas(perfilConsultas);

		return this.censoMonitorDao.add(censoMonitor);
	}

	/**
	 * Se comprueba si se han comprobado los estados de Aa66
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void comprobarActualizacionAa66() {

		try {
			logger.info("comprobarActualizacionAa66 - Inicio");

			Parametros parametros = new Parametros();

			parametros.setParametro(Y41bConstantes.PARAMETRO_AA66_ULTIMA_EJECUCION_JMS);
			parametros = this.parametrosDao.find(parametros);

			if (Y41bConstantes.NO.equals(parametros.getValor())) {
				logger.info("comprobarActualizacionAa66 - COLA INACTIVA. PARAMETRO AA66_ULTIMA_EJECUCION_JMS = N.");
				return;
			}

			Calendar c = Calendar.getInstance();
			c.add(Calendar.DATE, -1);
			Date ultimaEjecucionAa66 = c.getTime();

			try {
				ultimaEjecucionAa66 = Y41bUtils.parseDateTime(parametros.getValor(),
						new Locale(Y41bConstantes.CASTELLANO));
			} catch (Exception e_comprobarActualizacionAa66) {
				ultimaEjecucionAa66 = c.getTime();
			}

			Date ultimaEjecucionAa66WithZeroTime = Y41bUtils.parseDate(ultimaEjecucionAa66,
					new Locale(Y41bConstantes.CASTELLANO));

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			if (todayWithZeroTime.after(ultimaEjecucionAa66WithZeroTime)) {
				logger.debug(this.enviarMensajeAColaPorCadaRemesa());
			}
		} catch (Y41bUDAException e) {
			logger.error("comprobarActualizacionAa66 ERROR ***** ", e);
			throw e;
		} catch (Exception e_comprobarActualizacionAa66) {
			logger.error("comprobarActualizacionAa66 ERROR ***** ", e_comprobarActualizacionAa66);
			throw new Y41bUDAException("error.generico", true, e_comprobarActualizacionAa66);
		} finally {
			logger.info("comprobarActualizacionAa66 - Final");
		}
	}

	private void actualizaFechaActualizacionAA66() throws ParseException {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_AA66_ULTIMA_EJECUCION_JMS);
		parametros = this.parametrosDao.find(parametros);

		parametros.setValor(Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		this.parametrosDao.update(parametros);
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor find(CensoMonitor censoMonitor) {
		return (CensoMonitor) this.censoMonitorDao.find(censoMonitor);
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor findCensoMonitorUser(CensoMonitor censoMonitor) {
		return (CensoMonitor) this.censoMonitorDao.findCensoMonitorUser(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CensoMonitor> findAll(CensoMonitor censoMonitor, Pagination pagination) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAll(censoMonitor, pagination);
	}

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(CensoMonitor censoMonitor) {
		return this.censoMonitorDao.findAllCount(censoMonitor);
	}

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllLike(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllLike(censoMonitor, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CensoMonitor censoMonitor) {
		try {
			this.censoMonitorDao.remove(censoMonitor);

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.censomonitor.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the CensoMonitor table.
	 * 
	 * @param censoMonitorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<CensoMonitor> censoMonitorList) {
		for (CensoMonitor censoMonitorAux : censoMonitorList) {
			this.censoMonitorDao.remove(censoMonitorAux);
		}
	}

	/**
	 * Getter method for CensoMonitorDao
	 * 
	 * @return CensoMonitorDao
	 */
	public CensoMonitorDao getCensoMonitorDao() {
		return this.censoMonitorDao;
	}

	/**
	 * Setter method for CensoMonitorDao.
	 * 
	 * @param censoMonitorDao
	 *            CensoMonitorDao
	 * @return
	 */
	public void setCensoMonitorDao(CensoMonitorDao censoMonitorDao) {
		logger.info("Setting Dependency " + censoMonitorDao);
		this.censoMonitorDao = censoMonitorDao;
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllLikeFilter(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.codOrg")) {
				pagination.setSort("ORGANISMOCODORG");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEs")) {
				pagination.setSort("ORGANISMONOMBREES");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEu")) {
				pagination.setSort("ORGANISMONOMBREEU");
			}
		}

		return (List<CensoMonitor>) this.censoMonitorDao.findAllLikeFilter(censoMonitor, pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllFilterModif(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.codOrg")) {
				pagination.setSort("ORGANISMOCODORG");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEs")) {
				pagination.setSort("ORGANISMONOMBREES");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEu")) {
				pagination.setSort("ORGANISMONOMBREEU");
			}
		}

		return (List<CensoMonitor>) this.censoMonitorDao.findAllFilterModif(censoMonitor, pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllFilterModifArb(CensoMonitor censoMonitor, Pagination pagination,
			Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.codOrg")) {
				pagination.setSort("ORGANISMOCODORG");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEs")) {
				pagination.setSort("ORGANISMONOMBREES");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("organismo.nombreEu")) {
				pagination.setSort("ORGANISMONOMBREEU");
			}
		}

		return (List<CensoMonitor>) this.censoMonitorDao.findAllFilterModifArb(censoMonitor, pagination, startsWith);
	}

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountFilter(CensoMonitor censoMonitor, Boolean startsWith) {
		return this.censoMonitorDao.findAllLikeCountFilter(censoMonitor, startsWith);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAlta(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultas(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaConsultas(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultasEmpresas(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaConsultasEmpresas(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaAsignacionInstructor(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaAsignacionInstructor(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaSolicitudInspeccion(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaSolicitudInspeccion(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSolicitudInspeccion(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorSolicitudInspeccion(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSanciones(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorSanciones(censoMonitor);
	}

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param responsableExpediente
	 *            boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorArbitrajes(CensoMonitor censomonitor, boolean responsableExpediente) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorArbitrajes(censomonitor,
				responsableExpediente);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultas(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaBusquedaConsultas(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultasEmpresas(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaBusquedaConsultasEmpresas(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSolicitudes(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaBusquedaSolicitudes(censoMonitor);
	}

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSanciones(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaBusquedaSanciones(censoMonitor);
	}

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaInspecciones(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorAltaBusquedaInspecciones(censoMonitor);
	}

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorDenunciaEmpresas(CensoMonitor censoMonitor) {
		return (List<CensoMonitor>) this.censoMonitorDao.findAllCensoMonitorDenunciaEmpresas(censoMonitor);
	}

	/**
	 * Se envia un mensaje a la cola JMS de remesas por cada una de las remesas
	 * con envios pendientes de responder por AA66
	 * 
	 * @return String
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public String enviarMensajeAColaPorCadaRemesa() {

		logger.info("enviarMensajeAColaPorCadaRmesa - Inicio");

		StringBuffer strBfResultado = new StringBuffer(
				"\nLISTA DE REMESAS CON ENVIOS PENDIENTES QUE SE HAN ENVIADO ACTUALIZAR A LA COLA JMS DE REMESAS (UN MENSAJE DIFERENTE POR CADA REMESA):");
		try {
			actualizaFechaActualizacionAA66();

			List<Remesa> listRemesa = remesaService.findAllRemesasPendientes(new RemesaBusqueda(), null);

			// "Mapa con el mensaje de actualizacion de cada remesa. Se reusa el
			// mapa cambiando el codigo de remesa"
			Map<String, String> message = new HashMap<String, String>();
			message.put(Y41bConstantes.OPERACION_REMESA,
					Y41bUtilsWS.encodeString(Y41bConstantes.OPERACION_REMESA_ACTUALIZAR_ESTADO_UNA_REMESA));

			for (Remesa remesaAux : listRemesa) {
				try {

					// "Se va sobreescribiendo el codigo de remesa para reusar
					// el mapa."
					message.put(Y41bConstantes.CODIGO_REMESA, Y41bUtilsWS.encodeString(remesaAux.getRmcodigo()));

					remesasClientJMSService.sendMessage(message);

					strBfResultado.append("\n   REMESA ");
					strBfResultado.append(remesaAux.getRmcodigo());

				} catch (Throwable e_actualizarEnvios) {
					logger.error("CensoMonitorServiceImpl.enviarMensajeAColaPorCadaRmesa", e_actualizarEnvios);

					strBfResultado.append("\n   REMESA ");
					strBfResultado.append(remesaAux.getRmcodigo());
					strBfResultado.append("; EXCEPCION: ");
					strBfResultado.append(e_actualizarEnvios.getMessage());
				}
			}

		} catch (Throwable t) {
			logger.error("enviarMensajeAColaPorCadaRmesa ERROR ***** ", t);
			strBfResultado.append("\n\nERROR GRAVE: ");
			strBfResultado.append(t);
		} finally {
			logger.info("enviarMensajeAColaPorCadaRmesa - Final");
		}
		strBfResultado.append("\n");
		return strBfResultado.toString();
	}

}
