package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;

/**
 * * CensoMonitorService  
 * 
 *  
 */

public interface CensoMonitorService {

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor add(CensoMonitor censoMonitor);

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor update(CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor find(CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor findCensoMonitorUser(CensoMonitor censoMonitor);

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor getAutorizacionKonbide(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CensoMonitor> findAll(CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	Long findAllCount(CensoMonitor censoMonitor);

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLike(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the CensoMonitor table.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return
	 */
	void remove(CensoMonitor censoMonitor);

	/**
	 * Deletes multiple rows in the CensoMonitor table.
	 * 
	 * @param censoMonitorList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<CensoMonitor> censoMonitorList);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllFilterModif(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllFilterModifArb(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLikeFilter(CensoMonitor censoMonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountFilter(CensoMonitor censoMonitor, Boolean startsWith);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultas(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultasEmpresas(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaAsignacionInstructor(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaSolicitudInspeccion(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSolicitudInspeccion(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSanciones(CensoMonitor censoMonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param responsableExpediente
	 *            boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorArbitrajes(CensoMonitor censomonitor, boolean responsableExpediente);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultas(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultasEmpresas(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSolicitudes(CensoMonitor censoMonitor);

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSanciones(CensoMonitor censoMonitor);

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaInspecciones(CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table using like in the filter
	 * of CensoMonitor.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorDenunciaEmpresas(CensoMonitor censoMonitor);

	/**
	 * Se comprueba si se han comprobado los estados de Aa66
	 * 
	 */
	public void comprobarActualizacionAa66();

	/**
	 * Se envia un mensaje a la cola JMS de remesas por cada una de las remesas
	 * con envios pendientes de responder por AA66.
	 * 
	 * @return String
	 */
	public String enviarMensajeAColaPorCadaRemesa();
}
